/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.state.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.client.servicebinding.ActionProxyFactory;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.hraux.util.HRTreeUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.context.IMultiOrgSupport;
import com.kingdee.eas.hr.base.OutputExcelUtil;
import com.kingdee.eas.hr.base.client.PlugInUIDecorator;
import com.kingdee.eas.hr.emp.client.HRCellTreeRenderer;
import com.kingdee.eas.hr.emp.client.HRCellUserObject;
import com.kingdee.eas.hr.emp.client.HRTreeTable;
import com.kingdee.eas.hr.state.IInjuryRate;
import com.kingdee.eas.hr.state.IInjuryTypes;
import com.kingdee.eas.hr.state.InjuryRateFactory;
import com.kingdee.eas.hr.state.InjuryTypesFactory;
import com.kingdee.eas.hr.state.client.AbstractInjuryStatListUI;
import com.kingdee.eas.hr.state.client.HRStateTWOClientUtils;
import com.kingdee.eas.hr.state.client.InjuryStatFilterUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.Action;
import org.apache.log4j.Logger;

public class InjuryStatListUI
extends AbstractInjuryStatListUI {
    private static final Logger logger = CoreUIObject.getLogger(InjuryStatListUI.class);
    private HashMap statusMap;
    private HashMap latitudeIDMap;
    private HashMap[] conditionIDMap;
    private int latitudeType;
    private int rowHead;
    private boolean isIncludeChild;
    private boolean isMixLatitude;
    private FilterInfo typesInfo;
    private FilterInfo ratesInfo;
    protected PlugInUIDecorator plugin;
    private static final String RES2 = "com.kingdee.eas.hr.state.client.StateTWOResource";
    private static final String MRES = "com.kingdee.eas.hr.state.MessageTWOResource";
    private static final String RES = "com.kingdee.eas.hr.state.JobInjuryResource";
    private static final String PANEL_CLASSNAME = "com.kingdee.eas.hr.state.client.InjuryStatFilterUI";
    private DefaultKingdeeTreeNode childNode = null;

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected String getEditUIName() {
        return null;
    }

    protected IMultiOrgSupport getMainCustomerQueryPanel() {
        try {
            return new InjuryStatFilterUI();
        }
        catch (Exception e) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"FilterUIInitError"));
            SysUtil.abort();
            return null;
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.menuItemExportData.setAction((Action)((IItemAction)ActionProxyFactory.getProxy((Object)this.actionExport, (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
        this.btnExportData.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.btnExportData.setText("");
        this.btnExportData.setToolTipText(this.resHelper.getString("btnExportData.toolTipText"));
    }

    protected void afterOnLoad() throws Exception {
        super.afterOnLoad();
        HRTreeTable.setHRTreeTable((KDTable)this.tblMain, (String)"treeColumn");
        this.tblMain.checkParsed();
        this.tblMain.setEditable(false);
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.setAutoscrolls(true);
        this.enableExportExcel(this.tblMain);
        this.loadData();
        this.tHelper.getDisabledTables().add(this.tblMain);
    }

    protected void initListener() {
    }

    public void initTableListner(KDTable table) {
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.refreshData();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        if (this.getDialog() != null) {
            this.statusMap = ((InjuryStatFilterUI)this.getDialog().getUserPanel(PANEL_CLASSNAME)).getStatusMap();
            this.loadData();
        } else {
            IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
            InjuryStatFilterUI filterUI = new InjuryStatFilterUI();
            QuerySolutionInfo solution = iQuery.getDefaultSolution(this.getMetaDataPK().getFullName(), "com.kingdee.eas.hr.state.app.InjuryStatFilterQuery");
            CustomerParams params = CustomerParams.getCustomerParams2((String)this.getCustomerParamsStr(solution));
            if (params != null) {
                filterUI.setCustomerParams(params);
                this.statusMap = filterUI.getStatusMap();
                this.loadData();
            }
        }
    }

    protected void handleQueryDialog(CommonQueryDialog dialog) throws Exception {
        super.handleQueryDialog(dialog);
        dialog.setUiObject(null);
    }

    private void refreshData() {
        this.loadData();
    }

    private void loadData() {
        this.resetTable();
        IColumn column = this.tblMain.addColumn();
        this.typesInfo = this.baseinfo((HashSet)this.statusMap.get("types"), "types");
        this.ratesInfo = this.baseinfo((HashSet)this.statusMap.get("rates"), "rates");
        this.latitudeType = (Integer)this.statusMap.get("latitudeType");
        this.isIncludeChild = (Boolean)this.statusMap.get("isIncludeChild");
        IColumn extCol = null;
        if ((Integer)this.statusMap.get("latitudeType") == 1) {
            extCol = this.tblMain.addColumn();
        }
        if ((Integer)this.statusMap.get("latitudeType") == 0 && this.isIncludeChild) {
            this.tblMain.getColumn(0).setKey("treeColumn");
        } else if (extCol != null) {
            extCol.setKey("latitude");
            if (this.statusMap.get("positionID") == null) {
                column.setKey("treeColumn");
            } else if (this.statusMap.get("positionID") != null) {
                column.setKey("adminInfo");
            }
        } else {
            this.tblMain.getColumn(0).setKey("latitude");
        }
        this.initLatitude(this.latitudeType);
        this.initTableHead();
        this.tblMain.getHeadRow(0).getCell(0).setValue((Object)"\u884c\u653f\u7ec4\u7ec7");
        if (extCol != null) {
            this.tblMain.getHeadRow(0).getCell(1).setValue((Object)"\u804c\u4f4d");
        }
        this.initData((Integer)this.statusMap.get("latitudeType"));
        this.initSumData((Integer)this.statusMap.get("latitudeType"));
        try {
            this.scanTable();
        }
        catch (Exception e) {
            MsgBox.showError((String)EASResource.getString((String)RES2, (String)"scanTableError"));
            this.resetTable();
            SysUtil.abort();
        }
    }

    private void resetTable() {
        this.tblMain.removeRows();
        int count = this.tblMain.getColumnCount();
        for (int i = count - 1; i > -1; --i) {
            this.tblMain.removeColumn(i);
        }
        this.tblMain.getHead().removeRows();
    }

    private void initLatitude(int latitudeType) {
        this.latitudeIDMap = new HashMap();
        this.isMixLatitude = (Integer)this.statusMap.get("latitudeType") == 1 && this.statusMap.get("positionID") == null;
        try {
            switch (latitudeType) {
                case 0: {
                    this.initDepartmentLatitude();
                    break;
                }
                case 1: {
                    this.initPositionLatitude();
                }
            }
        }
        catch (Exception e) {
            MsgBox.showError((String)EASResource.getString((String)RES2, (String)"initLatitudeError"));
            this.resetTable();
            SysUtil.abort();
        }
    }

    private void initPositionLatitude() throws Exception {
        List positionList = this.findPosition(this.isMixLatitude);
        PositionInfo positionInfo = null;
        IRow row = null;
        if (this.isMixLatitude) {
            HRCellUserObject orgCellObj = null;
            HRCellUserObject tempOrgCell = null;
            HRCellTreeRenderer orgCellRen = new HRCellTreeRenderer();
            int initLevel = 0;
            AdminOrgUnitInfo adminInfo = null;
            for (int i = 0; i < positionList.size(); ++i) {
                row = this.tblMain.addRow(i);
                if (positionList.get(i) instanceof AdminOrgUnitInfo) {
                    adminInfo = (AdminOrgUnitInfo)positionList.get(i);
                    if (i == 0) {
                        initLevel = adminInfo.getLevel();
                    }
                    if (!Boolean.valueOf(adminInfo.get("isEnable").toString()).booleanValue()) {
                        row.getStyleAttributes().setBackground(Color.LIGHT_GRAY);
                    }
                    orgCellObj = new HRCellUserObject();
                    orgCellObj.setCompanyId(adminInfo.getId().toString());
                    orgCellObj.setName(adminInfo.getName());
                    orgCellObj.setLongNumber(adminInfo.getLongNumber());
                    orgCellObj.setIsLeaf(adminInfo.isIsLeaf());
                    orgCellObj.setLevel(adminInfo.getLevel() - initLevel);
                    orgCellObj.setExpanded(true);
                    this.latitudeIDMap.put(adminInfo.getId().toString(), row.getRowIndex());
                    row.getCell("treeColumn").setValue((Object)orgCellObj);
                    row.getCell("treeColumn").setRenderer((IBasicRender)orgCellRen);
                    continue;
                }
                if (!(positionList.get(i) instanceof PositionInfo)) continue;
                positionInfo = (PositionInfo)positionList.get(i);
                row.getCell("latitude").setValue((Object)positionInfo);
                tempOrgCell = new HRCellUserObject();
                tempOrgCell.setCompanyId(orgCellObj.getCompanyId());
                tempOrgCell.setName("");
                if (orgCellObj.isLeaf()) {
                    tempOrgCell.setLevel(orgCellObj.getLevel());
                } else {
                    tempOrgCell.setLevel(orgCellObj.getLevel() + 1);
                }
                tempOrgCell.setIsLeaf(true);
                tempOrgCell.setExpanded(true);
                row.getCell("treeColumn").setValue((Object)tempOrgCell);
                row.getCell("treeColumn").setRenderer((IBasicRender)orgCellRen);
                this.latitudeIDMap.put(positionInfo.getId().toString(), row.getRowIndex());
            }
            this.tblMain.getColumn("treeColumn").getStyleAttributes().setBackground(Color.LIGHT_GRAY);
            this.tblMain.getColumn("treeColumn").setWidth(200);
            this.tblMain.getColumn("latitude").getStyleAttributes().setBackground(Color.LIGHT_GRAY);
        } else {
            List treeList = this.findPosition(true);
            for (int i = 0; i < positionList.size(); ++i) {
                row = this.tblMain.addRow();
                positionInfo = (PositionInfo)positionList.get(i);
                this.latitudeIDMap.put(positionInfo.getId().toString(), row.getRowIndex());
                row.getCell("adminInfo").setValue((Object)this.searchAdminInTreeForPos(treeList, positionInfo.getId().toString()));
                row.getCell("latitude").setValue((Object)positionInfo);
            }
        }
    }

    private List findPosition(boolean isMixLatitude) throws Exception {
        Vector<Object> positionList = new Vector<Object>();
        if (isMixLatitude) {
            DefaultKingdeeTreeNode rootNode = this.getOrgUnitTreeNode(true);
            if (rootNode == null) {
                return null;
            }
            AdminOrgUnitInfo rootInfo = (AdminOrgUnitInfo)rootNode.getUserObject();
            if (HRTreeUtil.isTreeNodeDisable((DefaultKingdeeTreeNode)rootNode)) {
                rootInfo.put("isEnable", (Object)false);
            } else {
                rootInfo.put("isEnable", (Object)true);
            }
            rootInfo.setLevel(rootNode.getLevel());
            positionList.add(rootInfo);
            this.getCellUserObjects(rootNode, positionList, true);
        } else {
            IRowSet dataRows = null;
            PositionInfo position = null;
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(HRStateTWOClientUtils.getDefaultFilterForQuery("adminOrgUnit.id"));
            if (this.statusMap.get("positionID") != null) {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)((String)this.statusMap.get("positionID")), CompareType.EQUALS));
            }
            view.setFilter(filter);
            dataRows = HRStateTWOClientUtils.query(view, "com.kingdee.eas.hr.state.app", "HRStatFindPositionQuery");
            while (dataRows.next()) {
                position = new PositionInfo();
                position.setId(BOSUuid.read((String)dataRows.getString("ID")));
                position.setName(dataRows.getString("NAME"));
                positionList.add(position);
            }
        }
        return positionList;
    }

    private AdminOrgUnitInfo searchAdminInTreeForPos(List treeList, String positionID) {
        AdminOrgUnitInfo admin = null;
        PositionInfo position = null;
        if (treeList == null) {
            return null;
        }
        for (int i = 0; i < treeList.size(); ++i) {
            if (treeList.get(i) instanceof AdminOrgUnitInfo) {
                admin = (AdminOrgUnitInfo)treeList.get(i);
                continue;
            }
            if (!(treeList.get(i) instanceof PositionInfo) || !(position = (PositionInfo)treeList.get(i)).getId().toString().equals(positionID)) continue;
            return admin;
        }
        return null;
    }

    private void initDepartmentLatitude() throws Exception {
        String isIncludeChild = this.statusMap.get("isIncludeChild").toString();
        IRow row = null;
        AdminOrgUnitInfo info = null;
        if ("true".equals(isIncludeChild)) {
            Vector<AdminOrgUnitInfo> vec = new Vector<AdminOrgUnitInfo>();
            DefaultKingdeeTreeNode rootNode = this.getOrgUnitTreeNode(false);
            if (rootNode == null) {
                return;
            }
            AdminOrgUnitInfo rootInfo = (AdminOrgUnitInfo)rootNode.getUserObject();
            if (HRTreeUtil.isTreeNodeDisable((DefaultKingdeeTreeNode)rootNode)) {
                rootInfo.put("isEnable", (Object)false);
            } else {
                rootInfo.put("isEnable", (Object)true);
            }
            rootInfo.setLevel(rootNode.getLevel());
            vec.add(rootInfo);
            this.getCellUserObjects(rootNode, vec, false);
            HRCellTreeRenderer orgCellRen = new HRCellTreeRenderer();
            int initLevel = 0;
            int size = vec.size();
            for (int i = 0; i < size; ++i) {
                info = (AdminOrgUnitInfo)vec.get(i);
                if (i == 0) {
                    initLevel = info.getLevel();
                }
                row = this.tblMain.addRow(i);
                if (!Boolean.valueOf(info.get("isEnable").toString()).booleanValue()) {
                    row.getStyleAttributes().setBackground(Color.LIGHT_GRAY);
                }
                HRCellUserObject orgCellObj = new HRCellUserObject();
                orgCellObj.setCompanyId(info.getId().toString());
                orgCellObj.setName(info.getName());
                orgCellObj.setLongNumber(info.getLongNumber());
                orgCellObj.setIsLeaf(info.isIsLeaf());
                orgCellObj.setLevel(info.getLevel() - initLevel);
                orgCellObj.setExpanded(true);
                this.latitudeIDMap.put(info.getId().toString(), row.getRowIndex());
                row.getCell("treeColumn").setValue((Object)orgCellObj);
                row.getCell("treeColumn").setRenderer((IBasicRender)orgCellRen);
            }
            this.tblMain.getColumn("treeColumn").setWidth(200);
        } else {
            List adminOrgList = this.findDepartment();
            for (int i = 0; i < adminOrgList.size(); ++i) {
                row = this.tblMain.addRow();
                info = (AdminOrgUnitInfo)adminOrgList.get(i);
                this.latitudeIDMap.put(info.getId().toString(), row.getRowIndex());
                row.getCell("latitude").setValue((Object)info);
            }
            this.tblMain.getColumn("latitude").setWidth(160);
        }
    }

    private DefaultKingdeeTreeNode getOrgUnitTreeNode(boolean isIncludePosition) throws Exception {
        String adminId = (String)this.statusMap.get("adminID");
        DefaultKingdeeTreeNode orgRoot = HRTreeUtil.createAdminTreeNodeByUserRange((boolean)isIncludePosition, (boolean)false, (boolean)true, (boolean)false, null);
        if (orgRoot == null) {
            return null;
        }
        if (adminId != null) {
            HashMap<String, DefaultKingdeeTreeNode> map = new HashMap<String, DefaultKingdeeTreeNode>();
            map.put(this.getAdminIdByAdminNode(orgRoot), orgRoot);
            this.overTreeNodeSimple(orgRoot, map);
            orgRoot = (DefaultKingdeeTreeNode)map.get(adminId);
        }
        return orgRoot;
    }

    private void overTreeNodeSimple(DefaultKingdeeTreeNode root, HashMap nodeMap) throws Exception {
        DefaultKingdeeTreeNode node = null;
        int count = root.getChildCount();
        for (int i = 0; i < count; ++i) {
            node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            nodeMap.put(this.getAdminIdByAdminNode(node), node);
            this.overTreeNodeSimple(node, nodeMap);
        }
    }

    private String getAdminIdByAdminNode(DefaultKingdeeTreeNode node) {
        AdminOrgUnitInfo adminInfo = null;
        if (node.getUserObject() instanceof AdminOrgUnitInfo) {
            adminInfo = (AdminOrgUnitInfo)node.getUserObject();
        }
        if (adminInfo != null) {
            return adminInfo.getId().toString();
        }
        return null;
    }

    private void getCellUserObjects(DefaultKingdeeTreeNode treeNode, Vector vec, boolean isIncludePosition) {
        AdminOrgUnitInfo adminInfo = null;
        if (treeNode != null && treeNode.getUserObject() != null && treeNode.getUserObject() instanceof AdminOrgUnitInfo) {
            for (int i = 0; i < treeNode.getChildCount(); ++i) {
                this.childNode = (DefaultKingdeeTreeNode)treeNode.getChildAt(i);
                if (this.childNode.getUserObject() instanceof AdminOrgUnitInfo) {
                    adminInfo = (AdminOrgUnitInfo)this.childNode.getUserObject();
                    adminInfo.setLevel(this.childNode.getLevel());
                    if (HRTreeUtil.isTreeNodeDisable((DefaultKingdeeTreeNode)this.childNode)) {
                        adminInfo.put("isEnable", (Object)false);
                    } else {
                        adminInfo.put("isEnable", (Object)true);
                    }
                    vec.add(adminInfo);
                } else if (isIncludePosition && this.childNode.getUserObject() instanceof PositionInfo) {
                    vec.add(this.childNode.getUserObject());
                }
                if (this.childNode.getChildCount() <= 0) continue;
                this.getCellUserObjects(this.childNode, vec, isIncludePosition);
            }
        }
    }

    private List findDepartment() throws Exception {
        Vector<AdminOrgUnitInfo> adminOrgList = new Vector<AdminOrgUnitInfo>();
        if (this.statusMap.get("adminID") == null) {
            Object value = this.getOrgUnitTreeNode(false).getUserObject();
            if (value instanceof AdminOrgUnitInfo) {
                adminOrgList.add((AdminOrgUnitInfo)value);
            }
        } else {
            AdminOrgUnitInfo adminOrg = null;
            IRowSet dataRows = null;
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)((String)this.statusMap.get("adminID")), CompareType.EQUALS));
            if (((Boolean)this.statusMap.get("isIncludeChild")).booleanValue()) {
                filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)((String)this.statusMap.get("longNumber") + "%"), CompareType.LIKE));
                filter.setMaskString("#0 OR #1");
            }
            view.setFilter(filter);
            dataRows = HRStateTWOClientUtils.query(view, "com.kingdee.eas.hr.state.app", "HRStatFindDepartmentQuery");
            while (dataRows.next()) {
                adminOrg = new AdminOrgUnitInfo();
                adminOrg.setId(BOSUuid.read((String)dataRows.getString("ID")));
                adminOrg.setName(dataRows.getString("NAME"));
                adminOrgList.add(adminOrg);
            }
        }
        return adminOrgList;
    }

    private void initTableHead() {
        this.conditionIDMap = new HashMap[4];
        int baseColSum = 0;
        int ColSum = 0;
        this.rowHead = 0;
        int y = 0;
        y = this.latitudeType == 0 && this.isIncludeChild ? this.tblMain.getColumnIndex("treeColumn") : this.tblMain.getColumnIndex("latitude");
        this.tblMain.addHeadRow(0);
        this.tblMain.addHeadRow(1);
        if (((HashSet)this.statusMap.get("rates")).size() > 0 || ((HashSet)this.statusMap.get("types")).size() > 0) {
            this.tblMain.addHeadRow(2);
            this.tblMain.getHeadMergeManager().mergeBlock(0, 0, 2, 0);
            if (y == 1) {
                this.tblMain.getHeadMergeManager().mergeBlock(0, 1, 2, 1);
            }
        } else {
            this.tblMain.getHeadMergeManager().mergeBlock(0, 0, 1, 0);
            if (y == 1) {
                this.tblMain.getHeadMergeManager().mergeBlock(0, 1, 1, 1);
            }
        }
        for (int i = 0; i < 4; ++i) {
            this.conditionIDMap[i] = new HashMap();
            baseColSum = this.tblMain.getColumnCount();
            try {
                this.initTableHead(i);
            }
            catch (Exception e) {
                MsgBox.showError((String)EASResource.getString((String)RES2, (String)"initTableHeadError"));
                this.resetTable();
                SysUtil.abort();
            }
            ColSum = this.tblMain.getColumnCount();
            this.tblMain.getHeadMergeManager().mergeBlock(0, baseColSum, 0, ColSum - 1);
            this.tblMain.getHead().getRow(0).getCell(baseColSum).setValue((Object)this.headName(i));
        }
    }

    private void initTableHead(int headName) throws Exception {
        List typeList = this.findTypes();
        List rateList = this.findRate();
        if (typeList.size() > 0 || rateList.size() > 0) {
            this.rowHead = 2;
            this.initBaseDataHead(typeList, headName, 0);
            this.initBaseDataHead(rateList, headName, 1);
        } else {
            this.rowHead = 1;
            int baseColSum = this.tblMain.getColumnCount();
            this.tblMain.addColumn();
            this.tblMain.getHeadMergeManager().mergeBlock(1, baseColSum, 1, baseColSum);
            this.tblMain.getHead().getRow(1).getCell(baseColSum).setValue((Object)EASResource.getString((String)MRES, (String)"sum"));
            this.conditionIDMap[headName].put(this.headName(headName) + "SUM", baseColSum);
        }
    }

    private void initBaseDataHead(List dataList, int headName, int dataBaseName) throws BOSException {
        int baseColSum = this.tblMain.getColumnCount();
        DataBaseInfo dataBase = null;
        int HeadCount = dataList.size();
        int i = 0;
        for (i = 0; i < HeadCount; ++i) {
            this.tblMain.addColumn();
            dataBase = (DataBaseInfo)dataList.get(i);
            this.tblMain.getHeadMergeManager().mergeBlock(2, baseColSum + i, 2, baseColSum + i);
            this.tblMain.getHead().getRow(2).getCell(baseColSum + i).setValue((Object)dataBase.toString());
            this.conditionIDMap[headName].put(dataBase.getId().toString(), baseColSum + i);
            if (i != HeadCount - 1) continue;
            this.tblMain.addColumn();
            this.tblMain.getHeadMergeManager().mergeBlock(2, baseColSum + HeadCount, 2, baseColSum + HeadCount);
            this.tblMain.getHead().getRow(2).getCell(baseColSum + HeadCount).setValue((Object)EASResource.getString((String)MRES, (String)"sum"));
            this.conditionIDMap[headName].put(this.headName(headName) + this.dataBaseName(dataBaseName) + "SUM", baseColSum + HeadCount);
            this.tblMain.getHeadMergeManager().mergeBlock(1, baseColSum, 1, baseColSum + HeadCount);
            this.tblMain.getHead().getRow(1).getCell(baseColSum).setValue((Object)this.dataBaseName(dataBaseName));
        }
    }

    private String headName(int head) {
        switch (head) {
            case 0: {
                return EASResource.getString((String)MRES, (String)"InjuryPersonCount");
            }
            case 1: {
                return EASResource.getString((String)MRES, (String)"InjuryTimeCount");
            }
            case 2: {
                return EASResource.getString((String)MRES, (String)"ApplyCost");
            }
            case 3: {
                return EASResource.getString((String)MRES, (String)"RealCost");
            }
        }
        return null;
    }

    private String dataBaseName(int head) {
        switch (head) {
            case 0: {
                return EASResource.getString((String)RES, (String)"types");
            }
            case 1: {
                return EASResource.getString((String)RES, (String)"rates");
            }
        }
        return null;
    }

    private List findTypes() throws BOSException {
        Vector<CoreBaseInfo> typeList = new Vector<CoreBaseInfo>();
        IInjuryTypes ijdt = null;
        CoreBaseCollection coll = null;
        HashSet typeIDSet = (HashSet)this.statusMap.get("types");
        if (typeIDSet != null && typeIDSet.size() != 0) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)typeIDSet, CompareType.INCLUDE));
            ijdt = InjuryTypesFactory.getRemoteInstance();
            coll = ijdt.getCollection(view);
        }
        if (coll != null && coll.size() > 0) {
            for (int i = 0; i < coll.size(); ++i) {
                typeList.add(coll.get(i));
            }
        }
        return typeList;
    }

    private List findRate() throws BOSException {
        Vector<CoreBaseInfo> rateList = new Vector<CoreBaseInfo>();
        IInjuryRate ijdt = null;
        CoreBaseCollection coll = null;
        HashSet rateIDSet = (HashSet)this.statusMap.get("rates");
        if (rateIDSet != null && rateIDSet.size() != 0) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)rateIDSet, CompareType.INCLUDE));
            ijdt = InjuryRateFactory.getRemoteInstance();
            coll = ijdt.getCollection(view);
        }
        if (coll != null && coll.size() > 0) {
            for (int i = 0; i < coll.size(); ++i) {
                rateList.add(coll.get(i));
            }
        }
        return rateList;
    }

    private void initData(int latitudeType) {
        try {
            switch (latitudeType) {
                case 0: {
                    this.initDataOnDepartment();
                    break;
                }
                case 1: {
                    this.initDataOnPosition();
                }
            }
        }
        catch (Exception e) {
            MsgBox.showError((String)EASResource.getString((String)RES2, (String)"initTableDataError"));
            this.resetTable();
            logger.error((Object)e.getMessage());
            SysUtil.abort();
        }
    }

    private void initDataOnDepartment() throws BOSException, SQLException {
        IRowSet dataRows = null;
        if (this.statusMap.get("types") != null) {
            dataRows = this.getPersonsData("ADMINORG.ID", "INJURYTYPES.ID", "InjuryStatTypes2Query");
            this.initDataOnTable("ADMINORGID", "INJURYTYPESID", dataRows, "COUNTPERSONS", 0, 0);
            dataRows = HRStateTWOClientUtils.query(this.mainQuery, "com.kingdee.eas.hr.state.app", "InjuryStatTypes1Query");
            this.initDataOnTable("ADMINORG.ID", "INJURYTYPES.ID", dataRows, "COUNTTIMES", 1, 0);
            dataRows = HRStateTWOClientUtils.query(this.mainQuery, "com.kingdee.eas.hr.state.app", "InjuryStatTypes1Query");
            this.initDataOnTable("ADMINORG.ID", "INJURYTYPES.ID", dataRows, "SUMAPPLY", 2, 0);
            dataRows = HRStateTWOClientUtils.query(this.mainQuery, "com.kingdee.eas.hr.state.app", "InjuryStatTypes1Query");
            this.initDataOnTable("ADMINORG.ID", "INJURYTYPES.ID", dataRows, "SUMREAL", 3, 0);
        }
        if (this.statusMap.get("rates") != null) {
            dataRows = this.getPersonsData("ADMINORG.ID", "INJURYRATE.ID", "InjuryStatRate2Query");
            this.initDataOnTable("ADMINORGID", "INJURYRATEID", dataRows, "COUNTPERSONS", 0, 1);
            dataRows = HRStateTWOClientUtils.query(this.mainQuery, "com.kingdee.eas.hr.state.app", "InjuryStatRate1Query");
            this.initDataOnTable("ADMINORG.ID", "INJURYRATE.ID", dataRows, "COUNTTIMES", 1, 1);
            dataRows = HRStateTWOClientUtils.query(this.mainQuery, "com.kingdee.eas.hr.state.app", "InjuryStatRate1Query");
            this.initDataOnTable("ADMINORG.ID", "INJURYRATE.ID", dataRows, "SUMAPPLY", 2, 1);
            dataRows = HRStateTWOClientUtils.query(this.mainQuery, "com.kingdee.eas.hr.state.app", "InjuryStatRate1Query");
            this.initDataOnTable("ADMINORG.ID", "INJURYRATE.ID", dataRows, "SUMREAL", 3, 1);
        }
    }

    private void initDataOnPosition() throws BOSException, SQLException {
        IRowSet dataRows = null;
        if (this.isMixLatitude) {
            this.initDataOnDepartment();
        }
        if (this.statusMap.get("types") != null) {
            dataRows = this.getPersonsData("POSITION.ID", "INJURYTYPES.ID", "InjuryStatTypePosition2Query");
            this.initDataOnTable("POSITIONID", "INJURYTYPESID", dataRows, "COUNTPERSONS", 0, 0);
            dataRows = HRStateTWOClientUtils.query(this.mainQuery, "com.kingdee.eas.hr.state.app", "InjuryStatTypePosition1Query");
            this.initDataOnTable("POSITION.ID", "INJURYTYPES.ID", dataRows, "COUNTTIMES", 1, 0);
            dataRows = HRStateTWOClientUtils.query(this.mainQuery, "com.kingdee.eas.hr.state.app", "InjuryStatTypePosition1Query");
            this.initDataOnTable("POSITION.ID", "INJURYTYPES.ID", dataRows, "SUMAPPLY", 2, 0);
            dataRows = HRStateTWOClientUtils.query(this.mainQuery, "com.kingdee.eas.hr.state.app", "InjuryStatTypePosition1Query");
            this.initDataOnTable("POSITION.ID", "INJURYTYPES.ID", dataRows, "SUMREAL", 3, 0);
        }
        if (this.statusMap.get("rates") != null) {
            dataRows = this.getPersonsData("POSITION.ID", "INJURYRATE.ID", "InjuryStatRatePosition2Query");
            this.initDataOnTable("POSITIONID", "INJURYRATEID", dataRows, "COUNTPERSONS", 0, 1);
            dataRows = HRStateTWOClientUtils.query(this.mainQuery, "com.kingdee.eas.hr.state.app", "InjuryStatRatePosition1Query");
            this.initDataOnTable("POSITION.ID", "INJURYRATE.ID", dataRows, "COUNTTIMES", 1, 1);
            dataRows = HRStateTWOClientUtils.query(this.mainQuery, "com.kingdee.eas.hr.state.app", "InjuryStatRatePosition1Query");
            this.initDataOnTable("POSITION.ID", "INJURYRATE.ID", dataRows, "SUMAPPLY", 2, 1);
            dataRows = HRStateTWOClientUtils.query(this.mainQuery, "com.kingdee.eas.hr.state.app", "InjuryStatRatePosition1Query");
            this.initDataOnTable("POSITION.ID", "INJURYRATE.ID", dataRows, "SUMREAL", 3, 1);
        }
    }

    private void initSumData(int latitudeType) {
        try {
            switch (latitudeType) {
                case 0: {
                    this.initSumDataOnDep();
                    break;
                }
                case 1: {
                    this.initSumDataOnPosition();
                }
            }
        }
        catch (Exception e) {
            MsgBox.showError((String)EASResource.getString((String)RES2, (String)"initTableDataError"));
            this.resetTable();
            SysUtil.abort();
        }
    }

    private void initSumDataOnPosition() throws Exception {
        if (this.isMixLatitude) {
            this.initSumDataOnDep();
        }
        IRowSet dataRows = null;
        EntityViewInfo view = (EntityViewInfo)this.mainQuery.clone();
        if (((HashSet)this.statusMap.get("types")).size() > 0) {
            view.getFilter().mergeFilter(this.typesInfo, "and");
            dataRows = this.getPersonsSumData(view, "POSITION.ID", "InjuryStatTypePositionSum2Query");
            this.initDataOnTable("POSITIONID", "SUM", dataRows, "COUNTPERSONS", 0, 0);
            dataRows = HRStateTWOClientUtils.query(view, "com.kingdee.eas.hr.state.app", "InjuryStatTypePositionSum1Query");
            this.initDataOnTable("POSITION.ID", "SUM", dataRows, "COUNTTIMES", 1, 0);
            dataRows = HRStateTWOClientUtils.query(view, "com.kingdee.eas.hr.state.app", "InjuryStatTypePositionSum1Query");
            this.initDataOnTable("POSITION.ID", "SUM", dataRows, "SUMAPPLY", 2, 0);
            dataRows = HRStateTWOClientUtils.query(view, "com.kingdee.eas.hr.state.app", "InjuryStatTypePositionSum1Query");
            this.initDataOnTable("POSITION.ID", "SUM", dataRows, "SUMREAL", 3, 0);
        }
        if (((HashSet)this.statusMap.get("rates")).size() > 0 || ((HashSet)this.statusMap.get("types")).size() == 0) {
            view = (EntityViewInfo)this.mainQuery.clone();
            view.getFilter().mergeFilter(this.ratesInfo, "and");
            dataRows = this.getPersonsSumData(view, "POSITION.ID", "InjuryStatRatePositionSum2Query");
            this.initDataOnTable("POSITIONID", "SUM", dataRows, "COUNTPERSONS", 0, 1);
            dataRows = HRStateTWOClientUtils.query(view, "com.kingdee.eas.hr.state.app", "InjuryStatRatePositionSum1Query");
            this.initDataOnTable("POSITION.ID", "SUM", dataRows, "COUNTTIMES", 1, 1);
            dataRows = HRStateTWOClientUtils.query(view, "com.kingdee.eas.hr.state.app", "InjuryStatRatePositionSum1Query");
            this.initDataOnTable("POSITION.ID", "SUM", dataRows, "SUMAPPLY", 2, 1);
            dataRows = HRStateTWOClientUtils.query(view, "com.kingdee.eas.hr.state.app", "InjuryStatRatePositionSum1Query");
            this.initDataOnTable("POSITION.ID", "SUM", dataRows, "SUMREAL", 3, 1);
        }
    }

    private void initSumDataOnDep() throws Exception {
        IRowSet dataRows = null;
        EntityViewInfo view = (EntityViewInfo)this.mainQuery.clone();
        if (((HashSet)this.statusMap.get("types")).size() > 0) {
            view.getFilter().mergeFilter(this.typesInfo, "and");
            dataRows = this.getPersonsSumData(view, "ADMINORG.ID", "InjuryStatTypesSum2Query");
            this.initDataOnTable("ADMINORGID", "SUM", dataRows, "COUNTPERSONS", 0, 0);
            dataRows = HRStateTWOClientUtils.query(view, "com.kingdee.eas.hr.state.app", "InjuryStatTypesSum1Query");
            this.initDataOnTable("ADMINORG.ID", "SUM", dataRows, "COUNTTIMES", 1, 0);
            dataRows = HRStateTWOClientUtils.query(view, "com.kingdee.eas.hr.state.app", "InjuryStatTypesSum1Query");
            this.initDataOnTable("ADMINORG.ID", "SUM", dataRows, "SUMAPPLY", 2, 0);
            dataRows = HRStateTWOClientUtils.query(view, "com.kingdee.eas.hr.state.app", "InjuryStatTypesSum1Query");
            this.initDataOnTable("ADMINORG.ID", "SUM", dataRows, "SUMREAL", 3, 0);
        }
        if (((HashSet)this.statusMap.get("rates")).size() > 0 || ((HashSet)this.statusMap.get("types")).size() == 0) {
            view = (EntityViewInfo)this.mainQuery.clone();
            view.getFilter().mergeFilter(this.ratesInfo, "and");
            dataRows = this.getPersonsSumData(view, "ADMINORG.ID", "InjuryStatRateSum2Query");
            this.initDataOnTable("ADMINORGID", "SUM", dataRows, "COUNTPERSONS", 0, 1);
            dataRows = HRStateTWOClientUtils.query(view, "com.kingdee.eas.hr.state.app", "InjuryStatRateSum1Query");
            this.initDataOnTable("ADMINORG.ID", "SUM", dataRows, "COUNTTIMES", 1, 1);
            dataRows = HRStateTWOClientUtils.query(view, "com.kingdee.eas.hr.state.app", "InjuryStatRateSum1Query");
            this.initDataOnTable("ADMINORG.ID", "SUM", dataRows, "SUMAPPLY", 2, 1);
            dataRows = HRStateTWOClientUtils.query(view, "com.kingdee.eas.hr.state.app", "InjuryStatRateSum1Query");
            this.initDataOnTable("ADMINORG.ID", "SUM", dataRows, "SUMREAL", 3, 1);
        }
    }

    public FilterInfo baseinfo(HashSet set, String dataBaseName) {
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo itemInfo = null;
        if (set.size() > 0 && dataBaseName.equals("rates")) {
            itemInfo = new FilterItemInfo("injuryRate.id", (Object)set, CompareType.INCLUDE);
            filterInfo.getFilterItems().add(itemInfo);
        }
        if (set.size() > 0 && dataBaseName.equals("types")) {
            itemInfo = new FilterItemInfo("injuryTypes.id", (Object)set, CompareType.INCLUDE);
            filterInfo.getFilterItems().add(itemInfo);
        }
        if (filterInfo.getFilterItems().size() == 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", null, CompareType.ISNOT));
        }
        return filterInfo;
    }

    private IRowSet getPersonsData(String latitudeFieldName, String condFieldName, String queryName) throws BOSException {
        String subSQL = HRStateTWOClientUtils.metaQueryToSQL(this.mainQuery, "com.kingdee.eas.hr.state.app", queryName);
        StringBuffer queryStr = new StringBuffer();
        subSQL = subSQL.replaceAll(latitudeFieldName, latitudeFieldName.replaceAll("\\.", "")).replaceAll(condFieldName, condFieldName.replaceAll("\\.", ""));
        queryStr.append("SELECT " + latitudeFieldName.replaceAll("\\.", "") + "," + condFieldName.replaceAll("\\.", "") + ",COUNT(*) AS COUNTPERSONS FROM (\n");
        queryStr.append(subSQL);
        queryStr.append("\n )AS T GROUP BY " + latitudeFieldName.replaceAll("\\.", "") + "," + condFieldName.replaceAll("\\.", "") + "");
        return HRStateTWOClientUtils.query(queryStr.toString());
    }

    private IRowSet getPersonsSumData(EntityViewInfo view, String latitudeFieldName, String queryName) throws BOSException {
        String subSQL = HRStateTWOClientUtils.metaQueryToSQL(view, "com.kingdee.eas.hr.state.app", queryName);
        StringBuffer queryStr = new StringBuffer();
        subSQL = subSQL.replaceAll(latitudeFieldName, latitudeFieldName.replaceAll("\\.", "")).replaceAll("PERSON.ID", "PERSONID");
        queryStr.append("SELECT " + latitudeFieldName.replaceAll("\\.", "") + ",COUNT(*) AS COUNTPERSONS FROM (\n");
        queryStr.append(subSQL);
        queryStr.append("\n )AS T GROUP BY " + latitudeFieldName.replaceAll("\\.", ""));
        return HRStateTWOClientUtils.query(queryStr.toString());
    }

    public String getPropertyOfBizOrg(OrgType orgType) {
        return null;
    }

    private void initDataOnTable(String latitudeFieldName, String condFieldName, IRowSet dataRows, String countFieldName, int countType, int dataBase) throws SQLException {
        if (dataRows != null) {
            int indexY = 0;
            int indexX = 0;
            while (dataRows.next()) {
                if (dataRows.getString(latitudeFieldName) == null || !"SUM".equals(condFieldName) && dataRows.getString(condFieldName) == null || this.latitudeIDMap.get(dataRows.getString(latitudeFieldName)) == null || !"SUM".equals(condFieldName) && this.conditionIDMap[countType].get(dataRows.getString(condFieldName)) == null) continue;
                indexY = (Integer)this.latitudeIDMap.get(dataRows.getString(latitudeFieldName));
                indexX = condFieldName.equals("SUM") ? (((HashSet)this.statusMap.get("rates")).size() == 0 && ((HashSet)this.statusMap.get("types")).size() == 0 ? ((Integer)this.conditionIDMap[countType].get(this.headName(countType) + "SUM")).intValue() : ((Integer)this.conditionIDMap[countType].get(this.headName(countType) + this.dataBaseName(dataBase) + "SUM")).intValue()) : (Integer)this.conditionIDMap[countType].get(dataRows.getString(condFieldName));
                BigDecimal bd = new BigDecimal(0);
                if (!(dataRows.getObject(countFieldName) instanceof BigDecimal)) {
                    this.tblMain.getCell(indexY, indexX).setValue(dataRows.getObject(countFieldName));
                    continue;
                }
                if (dataRows.getBigDecimal(countFieldName).compareTo(bd) <= 0) continue;
                if ("COUNTPERSONS".equals(countFieldName)) {
                    this.tblMain.getCell(indexY, indexX).setValue((Object)dataRows.getBigDecimal(countFieldName).intValue());
                    continue;
                }
                this.tblMain.getCell(indexY, indexX).setValue((Object)dataRows.getBigDecimal(countFieldName).setScale(2, 4));
            }
        }
    }

    private String getCustomerParamsStr(QuerySolutionInfo solution) {
        if (null != solution && null != solution.getQueryPanelInfo() && solution.getQueryPanelInfo().size() > 0) {
            int len = solution.getQueryPanelInfo().size();
            for (int i = 0; i < len; ++i) {
                if (null == solution.getQueryPanelInfo().get(i) || !PANEL_CLASSNAME.equals(solution.getQueryPanelInfo().get(i).getPanelClassName())) continue;
                return solution.getQueryPanelInfo().get(i).getCustomerParams();
            }
        }
        return null;
    }

    private void scanTable() throws Exception {
        int lengthX = this.tblMain.getColumnCount();
        int lengthY = this.tblMain.getRowCount();
        Object value = null;
        for (int y = 0; y < lengthY; ++y) {
            for (int x = this.tblMain.getColumnIndex("latitude") + 1; x < lengthX; ++x) {
                value = null;
                value = this.tblMain.getRow(y).getCell(x).getValue();
                if (value != null) continue;
                this.tblMain.getRow(y).getCell(x).setValue((Object)0);
            }
        }
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().print();
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().printPreview();
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        OutputExcelUtil excelUtil = new OutputExcelUtil();
        if (excelUtil.appendToExcel(this.tblMain, true, true, this.getUITitle()) != null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.state.client.StateResource", (String)"EXPORT_SUCCESS"));
        }
    }

    protected boolean isUseStandardPermission() {
        return true;
    }
}

