/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.state.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.hr.base.client.FilterUIUtil;
import com.kingdee.eas.hr.base.client.IHRF7CommonRegister;
import com.kingdee.eas.hr.state.client.AbstractInspectBillFilterUI;
import com.kingdee.eas.hr.state.client.HRStateTWOClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.AbstractButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class InspectBillFilterUI
extends AbstractInspectBillFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(InspectBillFilterUI.class);
    private final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private static final String RES = "com.kingdee.eas.hr.state.InspectorResource";

    protected void beforeOnLoad() throws Exception {
        this.chkIsSearch.setEnabled(true);
        this.chkIsIncludeOrg.setEnabled(false);
        this.kdRadioApplier.setSelected(true);
        this.prmtAdminOrg.setData(null);
        this.prmtAdminOrg.setEnabled(false);
        this.prmtPosition.setData(null);
        this.prmtPosition.setEnabled(false);
    }

    public void clear() {
        super.clear();
        this.prmtApplier.setValue(null);
        this.prmtAdminOrg.setValue(null);
        this.prmtPosition.setValue(null);
        this.chkIsIncludeOrg.setSelected(false);
        this.chkIsIncludeOrg.setEnabled(false);
        this.chkIsSearch.setSelected(false);
        this.chkIsSearch.setEnabled(true);
        this.txtApplier.setEditable(false);
        this.txtApplier.setEnabled(false);
        this.txtApplier.setVisible(false);
        this.kdRadioApplier.setSelected(true);
        this.kdRadioAdminOrg.setSelected(false);
        this.kdRadioPosition.setSelected(false);
        this.pkStartDateStart.setValue(null);
        this.pkStartDateEnd.setValue(null);
        this.pkEndDateStart.setValue(null);
        this.pkEndDateEnd.setValue(null);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initAllEditor();
    }

    private void initAllEditor() throws Exception {
        this.kdbGroup.add((AbstractButton)this.kdRadioApplier);
        this.kdbGroup.add((AbstractButton)this.kdRadioAdminOrg);
        this.kdbGroup.add((AbstractButton)this.kdRadioPosition);
        this.kdRadioApplier.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                InspectBillFilterUI.this.setSelect("applier");
            }
        });
        this.kdRadioAdminOrg.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                InspectBillFilterUI.this.setSelect("adminOrg");
            }
        });
        this.kdRadioPosition.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeevent) {
                InspectBillFilterUI.this.setSelect("position");
            }
        });
        this.chkIsSearch.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeevent) {
                InspectBillFilterUI.this.setSearchType();
            }
        });
    }

    protected void initF7Context(IHRF7CommonRegister register) {
        super.initF7Context(register);
        register.registerAdminByOrgRangePromptBox(this.prmtAdminOrg);
        register.registerPositionPromptBox2(this.prmtPosition);
        register.registerEmployeeMultiF7PromptBox(this.prmtApplier, true);
    }

    private void setSelect(String selectType) {
        if ("applier".equals(selectType) && this.kdRadioApplier.isSelected()) {
            this.prmtApplier.setEnabled(true);
            this.prmtApplier.setVisible(true);
            this.chkIsSearch.setSelected(false);
            this.chkIsSearch.setEnabled(true);
            this.prmtAdminOrg.setData(null);
            this.prmtAdminOrg.setEnabled(false);
            this.chkIsIncludeOrg.setSelected(false);
            this.chkIsIncludeOrg.setEnabled(false);
            this.prmtPosition.setData(null);
            this.prmtPosition.setEnabled(false);
            this.txtApplier.setText(null);
            this.txtApplier.setEnabled(false);
            this.txtApplier.setVisible(false);
        }
        if ("adminOrg".equals(selectType) && this.kdRadioAdminOrg.isSelected()) {
            this.prmtAdminOrg.setEnabled(true);
            this.chkIsIncludeOrg.setEnabled(true);
            this.prmtApplier.setData(null);
            this.prmtApplier.setEnabled(false);
            this.prmtApplier.setVisible(true);
            this.chkIsSearch.setSelected(false);
            this.chkIsSearch.setEnabled(false);
            this.prmtPosition.setEnabled(false);
            this.prmtPosition.setData(null);
            this.txtApplier.setText(null);
            this.txtApplier.setEnabled(false);
            this.txtApplier.setVisible(false);
        }
        if ("position".equals(selectType) && this.kdRadioPosition.isSelected()) {
            this.prmtPosition.setEnabled(true);
            this.prmtApplier.setData(null);
            this.prmtApplier.setEnabled(false);
            this.prmtApplier.setVisible(true);
            this.chkIsSearch.setSelected(false);
            this.chkIsSearch.setEnabled(false);
            this.prmtAdminOrg.setData(null);
            this.prmtAdminOrg.setEnabled(false);
            this.chkIsIncludeOrg.setSelected(false);
            this.chkIsIncludeOrg.setEnabled(false);
            this.txtApplier.setText(null);
            this.txtApplier.setEnabled(false);
            this.txtApplier.setVisible(false);
        }
    }

    private void setSearchType() {
        if (this.kdRadioApplier.isSelected()) {
            if (this.chkIsSearch.isSelected()) {
                this.prmtApplier.setValue(null);
                this.prmtApplier.setEnabled(false);
                this.prmtApplier.setVisible(false);
                this.txtApplier.setEnabled(true);
                this.txtApplier.setEditable(true);
                this.txtApplier.setVisible(true);
            } else {
                this.prmtApplier.setEnabled(true);
                this.prmtApplier.setVisible(true);
                this.txtApplier.setEditable(false);
                this.txtApplier.setText(null);
                this.txtApplier.setEnabled(false);
                this.txtApplier.setVisible(false);
            }
        }
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.getMainOrg();
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = super.getCustomerParams();
        String[] ctrls = new String[]{this.prmtHROrg.getName()};
        FilterUIUtil.saveAllData((CustomerParams)cp, (CustomerQueryPanel)this, (String[])ctrls, (boolean)false);
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        String[] ctrls = new String[]{this.prmtHROrg.getName()};
        FilterUIUtil.retriveAllData((CustomerParams)cp, (CustomerQueryPanel)this, (String[])ctrls, (boolean)false);
    }

    public FilterInfo getFilterInfo() {
        PositionInfo positionInfo;
        AdminOrgUnitInfo orgUnit;
        FilterInfo orgFilter;
        FilterInfo filter = new FilterInfo();
        this.setStartDateFilter(filter);
        this.setEndDateFilter(filter);
        if (this.kdRadioApplier.isSelected()) {
            if (this.chkIsSearch.isSelected()) {
                String applierNumberOrName = this.txtApplier.getText();
                if (applierNumberOrName != null) {
                    if (filter.getFilterItems().size() > 0) {
                        orgFilter = new FilterInfo();
                        orgFilter.getFilterItems().add(new FilterItemInfo("entrys.person.number", (Object)("%" + applierNumberOrName + "%"), CompareType.LIKE));
                        orgFilter.getFilterItems().add(new FilterItemInfo("entrys.person.name", (Object)("%" + applierNumberOrName + "%"), CompareType.LIKE));
                        orgFilter.setMaskString("#0 or #1");
                        try {
                            filter.mergeFilter(orgFilter, "and");
                        }
                        catch (BOSException e) {
                            ExceptionHandler.handle((Throwable)e);
                        }
                    } else {
                        filter.getFilterItems().add(new FilterItemInfo("entrys.person.number", (Object)("%" + applierNumberOrName + "%"), CompareType.LIKE));
                        filter.getFilterItems().add(new FilterItemInfo("entrys.person.name", (Object)("%" + applierNumberOrName + "%"), CompareType.LIKE));
                        filter.setMaskString("#0 or #1");
                    }
                }
            } else {
                PersonInfo pInfo = (PersonInfo)this.prmtApplier.getData();
                if (pInfo != null) {
                    filter.getFilterItems().add(new FilterItemInfo("entrys.person.id", (Object)pInfo.getId().toString(), CompareType.EQUALS));
                }
            }
        }
        if (this.kdRadioAdminOrg.isSelected() && (orgUnit = (AdminOrgUnitInfo)this.prmtAdminOrg.getData()) != null) {
            if (this.chkIsIncludeOrg.isSelected()) {
                if (filter.getFilterItems().size() > 0) {
                    orgFilter = new FilterInfo();
                    orgFilter.getFilterItems().add(new FilterItemInfo("entrys.adminOrg.number", (Object)orgUnit.getNumber(), CompareType.EQUALS));
                    orgFilter.getFilterItems().add(new FilterItemInfo("entrys.adminOrg.LongNumber", (Object)(orgUnit.getLongNumber() + "!%"), CompareType.LIKE));
                    orgFilter.setMaskString("#0 or #1");
                    try {
                        filter.mergeFilter(orgFilter, "and");
                    }
                    catch (BOSException e) {
                        ExceptionHandler.handle((Throwable)e);
                    }
                } else {
                    filter.getFilterItems().add(new FilterItemInfo("entrys.adminOrg.number", (Object)orgUnit.getNumber(), CompareType.EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("entrys.adminOrg.LongNumber", (Object)(orgUnit.getLongNumber() + "!%"), CompareType.LIKE));
                    filter.setMaskString(" #0 or #1 ");
                }
            } else {
                filter.getFilterItems().add(new FilterItemInfo("entrys.adminOrg.number", (Object)orgUnit.getNumber(), CompareType.EQUALS));
            }
        }
        if (this.kdRadioPosition.isSelected() && (positionInfo = (PositionInfo)this.prmtPosition.getData()) != null) {
            filter.getFilterItems().add(new FilterItemInfo("entrys.position.id", (Object)positionInfo.getId().toString(), CompareType.EQUALS));
        }
        return filter;
    }

    private void setStartDateFilter(FilterInfo filter) {
        if (filter == null) {
            return;
        }
        Date startDateStart = (Date)this.pkStartDateStart.getValue();
        Date startDateEnd = (Date)this.pkStartDateEnd.getValue();
        if (startDateStart != null) {
            filter.getFilterItems().add(new FilterItemInfo("entrys.timeStart", (Object)this.simpleDateFormat.format(startDateStart), CompareType.GREATER_EQUALS));
        }
        if (startDateEnd != null) {
            filter.getFilterItems().add(new FilterItemInfo("entrys.timeStart", (Object)this.simpleDateFormat.format(startDateEnd), CompareType.LESS_EQUALS));
        }
    }

    private void setEndDateFilter(FilterInfo filter) {
        if (filter == null) {
            return;
        }
        Date endDateStart = (Date)this.pkEndDateStart.getValue();
        Date endDateEnd = (Date)this.pkEndDateEnd.getValue();
        if (endDateStart != null) {
            filter.getFilterItems().add(new FilterItemInfo("entrys.timeEnd", (Object)this.simpleDateFormat.format(endDateStart), CompareType.GREATER_EQUALS));
        }
        if (endDateEnd != null) {
            filter.getFilterItems().add(new FilterItemInfo("entrys.timeEnd", (Object)this.simpleDateFormat.format(endDateEnd), CompareType.LESS_EQUALS));
        }
    }

    public boolean verify() {
        Date startDateStart = (Date)this.pkStartDateStart.getValue();
        Date startDateEnd = (Date)this.pkStartDateEnd.getValue();
        if (startDateStart != null && startDateEnd != null && startDateStart.getTime() > startDateEnd.getTime()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"startendMustAfterBegin"));
            this.pkStartDateEnd.requestFocus();
            SysUtil.abort();
        }
        Date endDateStart = (Date)this.pkEndDateStart.getValue();
        Date endDateEnd = (Date)this.pkEndDateEnd.getValue();
        if (endDateStart != null && endDateEnd != null && endDateStart.getTime() > endDateEnd.getTime()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"endendMustAfterBegin"));
            this.pkEndDateEnd.requestFocus();
            SysUtil.abort();
        }
        HRStateTWOClientUtils.verifyEmpty((CoreUIObject)this, this.prmtHROrg);
        return super.verify();
    }

    private void initPromtByHR() throws Exception {
    }
}

