/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.state.client;

import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox;
import com.kingdee.eas.hr.state.JobDiseaseInfo;
import com.kingdee.eas.hr.state.client.AbstractJobDiseaseEditUI;
import com.kingdee.eas.hr.state.client.HRStateTWOClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public class JobDiseaseEditUI
extends AbstractJobDiseaseEditUI {
    private static final Logger logger = CoreUIObject.getLogger(JobDiseaseEditUI.class);
    private EmployeeMultiF7PromptBox employeeF7;
    private static final String RES = "com.kingdee.eas.hr.state.JobDiseaseResource";

    protected void afterOnLoad() throws Exception {
        super.afterOnLoad();
        this.initEmployeeF7();
        this.prmtapplier.setSelector((KDPromptSelector)this.employeeF7);
        this.prmtapplier.setEnabledMultiSelection(false);
        this.prmtapplier.setEditable(false);
        this.prmtapplier.setDisplayFormat("$name$");
        this.prmtapplier.setEditFormat("$number$");
        this.prmtapplier.setCommitFormat("$number$");
    }

    @Override
    protected IObjectValue createNewData() {
        JobDiseaseInfo objectValue = this.getNewData();
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        return objectValue;
    }

    public void actionCopy_actionPerformed(ActionEvent arg0) throws Exception {
        super.actionCopy_actionPerformed(arg0);
        JobDiseaseInfo info = this.getNewData();
        this.editData.setAdminOrg(info.getAdminOrg());
        this.editData.setPerson(info.getPerson());
        this.editData.setAge(info.getAge());
        this.editData.setPosition(info.getPosition());
    }

    private int compareYear(Date before, Date after) {
        int result = 0;
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        String beforeStr = formatter.format(before);
        String afterStr = formatter.format(after);
        int beforeYear = 0;
        int afterYear = 0;
        if (beforeStr != null && !beforeStr.equals("")) {
            beforeYear = Integer.parseInt(beforeStr.substring(0, 4));
        }
        if (afterStr != null && !afterStr.equals("")) {
            afterYear = Integer.parseInt(afterStr.substring(0, 4));
        }
        result = afterYear < beforeYear ? beforeYear - afterYear : afterYear - beforeYear;
        return result;
    }

    private JobDiseaseInfo getNewData() {
        JobDiseaseInfo info = new JobDiseaseInfo();
        String recordId = null;
        if (this.getUIContext().get("PersonID") != null) {
            recordId = this.getUIContext().get("PersonID").toString();
        }
        PersonInfo pInfo = null;
        PersonPositionInfo ppInfo = null;
        PositionInfo psInfo = null;
        AdminOrgUnitInfo adminOrg = null;
        try {
            pInfo = HRStateTWOClientUtils.getPersonInfo(BOSUuid.read((String)recordId));
            ppInfo = HRStateTWOClientUtils.getPersonPositionInfo(BOSUuid.read((String)recordId));
            psInfo = ppInfo.getPrimaryPosition();
            adminOrg = ppInfo.getPersonDep();
        }
        catch (Exception e) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.state.JobInjuryResource", (String)"initPersonError"));
            SysUtil.abort();
        }
        info.setPerson(pInfo);
        info.setPosition(psInfo);
        info.setAdminOrg(adminOrg);
        return info;
    }

    private void initEmployeeF7() {
        if (this.employeeF7 == null) {
            this.employeeF7 = new EmployeeMultiF7PromptBox();
            this.employeeF7.setIsSingleSelect(true);
            this.employeeF7.setUserOrgRangeFilter(true);
            this.employeeF7.setEnabledMultiSelection(false);
            this.employeeF7.showNoPositionPerson(true);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.actionAddNew.setVisible(false);
            this.actionEdit.setVisible(false);
            this.actionCopy.setVisible(false);
            this.actionSubmit.setVisible(false);
            this.actionRemove.setVisible(false);
        } else {
            this.actionAddNew.setVisible(true);
            this.actionEdit.setVisible(true);
            this.actionCopy.setVisible(true);
            this.actionSubmit.setVisible(true);
            this.actionRemove.setVisible(true);
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        HRStateTWOClientUtils.verifyEmpty((CoreUIObject)this, RES, this.pkoccurDate, "occurDateNotNull");
        HRStateTWOClientUtils.verifyEmpty((CoreUIObject)this, RES, this.prmttype, "diseaseTypeNotNull");
    }

    @Override
    public void onShow() throws Exception {
        super.onShow();
        this.pkoccurDate.requestFocusInWindow();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        PersonInfo pInfo = null;
        if (this.getUIContext().get("PersonID") != null) {
            pInfo = PersonFactory.getRemoteInstance().getPersonInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.getUIContext().get("PersonID").toString())));
        }
        if (pInfo != null && this.pkoccurDate.getValue() != null && pInfo.getBirthday() != null) {
            this.editData.setAge(this.compareYear(pInfo.getBirthday(), (Date)this.pkoccurDate.getValue()));
        }
        super.actionSubmit_actionPerformed(e);
    }
}

