/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.state.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.client.PositionPromptBox2;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.hr.base.client.FilterUIUtil;
import com.kingdee.eas.hr.base.client.IHRF7CommonRegister;
import com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox;
import com.kingdee.eas.hr.org.client.AdminByOrgRangePromptBox;
import com.kingdee.eas.hr.state.client.AbstractJobDiseaseGeneralViewFilterUI;
import com.kingdee.eas.hr.state.client.JobInjuryFormsFilterUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.AbstractButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class JobDiseaseGeneralViewFilterUI
extends AbstractJobDiseaseGeneralViewFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(JobInjuryFormsFilterUI.class);
    private final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private final SimpleDateFormat simpleDateFormat1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final String RES = "com.kingdee.eas.hr.state.JobDiseaseResource";

    protected void beforeOnLoad() throws Exception {
        super.beforeOnLoad();
        this.kdRadioAdminOrg.setSelected(true);
        this.kdRadioPosition.setSelected(false);
        this.chkIncludeChild.setEnabled(true);
        this.prmtAdminOrg.setEditable(false);
        this.prmtAdminOrg.setData(null);
        this.prmtPosition.setEditable(false);
        this.prmtPosition.setData(null);
        this.prmtPerson.setEditable(false);
        this.prmtPerson.setData(null);
        this.initForAdminOrg();
    }

    public void clear() {
        super.clear();
        this.pkOcurStartDate.setValue(null);
        this.pkOcurEndDate.setValue(null);
        this.pkDetermineStartDate.setValue(null);
        this.pkDetermineEndDate.setValue(null);
        this.kdRadioAdminOrg.setSelected(false);
        this.kdRadioPosition.setSelected(false);
        this.prmtAdminOrg.setValue(null);
        this.prmtPosition.setValue(null);
        this.prmtPerson.setValue(null);
        this.chkIncludeChild.setSelected(false);
        this.chkIncludeChild.setEnabled(true);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initAllEditor();
    }

    private void initAllEditor() {
        this.kDButtonGroup1.add((AbstractButton)this.kdRadioAdminOrg);
        this.kDButtonGroup1.add((AbstractButton)this.kdRadioPosition);
        this.kDButtonGroup1.add((AbstractButton)this.kDRadioPerson);
        this.kdRadioAdminOrg.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                JobDiseaseGeneralViewFilterUI.this.setSelect("adminOrg");
            }
        });
        this.kdRadioPosition.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                JobDiseaseGeneralViewFilterUI.this.setSelect("position");
            }
        });
        this.kDRadioPerson.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                JobDiseaseGeneralViewFilterUI.this.setSelect("person");
            }
        });
    }

    protected void initF7Context(IHRF7CommonRegister register) {
        super.initF7Context(register);
        AdminByOrgRangePromptBox adminOrgF7 = new AdminByOrgRangePromptBox();
        this.prmtAdminOrg.setEditFormat("$number$");
        this.prmtAdminOrg.setDisplayFormat("$name$");
        this.prmtAdminOrg.setCommitFormat("$number$");
        this.prmtAdminOrg.setSelector((KDPromptSelector)adminOrgF7);
        PositionPromptBox2 positionF7 = new PositionPromptBox2();
        this.prmtPosition.setEditFormat("$number$");
        this.prmtPosition.setDisplayFormat("$name$");
        this.prmtPosition.setCommitFormat("$number$");
        this.prmtPosition.setSelector((KDPromptSelector)positionF7);
        EmployeeMultiF7PromptBox empF7 = new EmployeeMultiF7PromptBox();
        empF7.setUserOrgRangeFilter(true);
        empF7.showNoPositionPerson(true);
        this.prmtPerson.setEditFormat("$number$");
        this.prmtPerson.setDisplayFormat("$name$");
        this.prmtPerson.setCommitFormat("$number$");
        this.prmtPerson.setSelector((KDPromptSelector)empF7);
    }

    public boolean verify() {
        Date ocurStartDate = (Date)this.pkOcurStartDate.getValue();
        Date ocurEndDate = (Date)this.pkOcurEndDate.getValue();
        if (ocurStartDate != null && ocurEndDate != null && ocurStartDate.getTime() > ocurEndDate.getTime()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"OccurrenceTime"));
            this.pkOcurStartDate.requestFocus();
            SysUtil.abort();
        }
        Date determineStartDate = (Date)this.pkDetermineStartDate.getValue();
        Date determineEndDate = (Date)this.pkDetermineEndDate.getValue();
        if (determineStartDate != null && determineEndDate != null && determineStartDate.getTime() > determineEndDate.getTime()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"DetermineDate"));
            this.pkDetermineStartDate.requestFocus();
            SysUtil.abort();
        }
        return true;
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.getMainOrg();
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        String[] ctrls = new String[]{this.prmtHROrg.getName()};
        FilterUIUtil.saveAllData((CustomerParams)cp, (CustomerQueryPanel)this, (String[])ctrls, (boolean)false);
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        String[] ctrls = new String[]{this.prmtHROrg.getName()};
        FilterUIUtil.retriveAllData((CustomerParams)cp, (CustomerQueryPanel)this, (String[])ctrls, (boolean)false);
    }

    public FilterInfo getFilterInfo() {
        PersonInfo perInfo;
        PositionInfo pInfo;
        AdminOrgUnitInfo orgUnit;
        FilterInfo filter = new FilterInfo();
        this.setStartDateFilter(filter);
        this.setEndDateFilter(filter);
        if (this.kdRadioAdminOrg.isSelected() && (orgUnit = (AdminOrgUnitInfo)this.prmtAdminOrg.getData()) != null) {
            if (this.chkIncludeChild.isSelected()) {
                if (filter.getFilterItems().size() > 0) {
                    FilterInfo orgFilter = new FilterInfo();
                    orgFilter.getFilterItems().add(new FilterItemInfo("adminOrg.number", (Object)orgUnit.getNumber(), CompareType.EQUALS));
                    orgFilter.getFilterItems().add(new FilterItemInfo("adminOrg.longNumber", (Object)(orgUnit.getLongNumber() + "!%"), CompareType.LIKE));
                    orgFilter.setMaskString("#0 or #1");
                    try {
                        filter.mergeFilter(orgFilter, "and");
                    }
                    catch (BOSException e) {
                        ExceptionHandler.handle((Throwable)e);
                    }
                } else {
                    filter.getFilterItems().add(new FilterItemInfo("adminOrg.number", (Object)orgUnit.getNumber(), CompareType.EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("adminOrg.longNumber", (Object)(orgUnit.getLongNumber() + "!%"), CompareType.LIKE));
                    filter.setMaskString(" #0 or #1 ");
                }
            } else {
                filter.getFilterItems().add(new FilterItemInfo("adminOrg.number", (Object)orgUnit.getNumber(), CompareType.EQUALS));
            }
        }
        if (this.kdRadioPosition.isSelected() && (pInfo = (PositionInfo)this.prmtPosition.getData()) != null) {
            filter.getFilterItems().add(new FilterItemInfo("position.id", (Object)pInfo.getId().toString(), CompareType.EQUALS));
        }
        if (this.kDRadioPerson.isSelected() && (perInfo = (PersonInfo)this.prmtPerson.getData()) != null) {
            filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)perInfo.getId().toString(), CompareType.EQUALS));
        }
        return filter;
    }

    private void setStartDateFilter(FilterInfo filter) {
        Date ocurStartDate = (Date)this.pkOcurStartDate.getValue();
        Date determineStartDate = (Date)this.pkDetermineStartDate.getValue();
        if (ocurStartDate != null) {
            filter.getFilterItems().add(new FilterItemInfo("occurDate", (Object)this.simpleDateFormat1.format(ocurStartDate), CompareType.GREATER_EQUALS));
        }
        if (determineStartDate != null) {
            filter.getFilterItems().add(new FilterItemInfo("diagnoseDate", (Object)this.simpleDateFormat.format(determineStartDate), CompareType.GREATER_EQUALS));
        }
    }

    private void setEndDateFilter(FilterInfo filter) {
        Date ocurEndDate = (Date)this.pkOcurEndDate.getValue();
        Date determineEndDate = (Date)this.pkDetermineEndDate.getValue();
        if (ocurEndDate != null) {
            filter.getFilterItems().add(new FilterItemInfo("occurDate", (Object)this.simpleDateFormat1.format(ocurEndDate), CompareType.LESS_EQUALS));
        }
        if (determineEndDate != null) {
            filter.getFilterItems().add(new FilterItemInfo("diagnoseDate", (Object)this.simpleDateFormat.format(determineEndDate), CompareType.LESS_EQUALS));
        }
    }

    private void setSelect(String selectType) {
        if ("adminOrg".equals(selectType) && this.kdRadioAdminOrg.isSelected()) {
            this.initForAdminOrg();
        } else if ("position".equals(selectType) && this.kdRadioPosition.isSelected()) {
            this.initForPosition();
        } else if ("person".equals(selectType) && this.kDRadioPerson.isSelected()) {
            this.initForPerson();
        }
    }

    private void initForAdminOrg() {
        this.prmtAdminOrg.setEnabled(true);
        this.chkIncludeChild.setEnabled(true);
        this.prmtPosition.setData(null);
        this.prmtPosition.setEnabled(false);
        this.prmtPosition.setVisible(true);
        this.prmtPerson.setData(null);
        this.prmtPerson.setEnabled(false);
        this.prmtPerson.setVisible(true);
    }

    private void initForPosition() {
        this.prmtPosition.setEnabled(true);
        this.chkIncludeChild.setSelected(false);
        this.chkIncludeChild.setEnabled(false);
        this.prmtAdminOrg.setData(null);
        this.prmtAdminOrg.setEnabled(false);
        this.prmtAdminOrg.setVisible(true);
        this.prmtPerson.setData(null);
        this.prmtPerson.setEnabled(false);
        this.prmtPerson.setVisible(true);
    }

    private void initForPerson() {
        this.prmtPerson.setEnabled(true);
        this.chkIncludeChild.setSelected(false);
        this.chkIncludeChild.setEnabled(false);
        this.prmtAdminOrg.setData(null);
        this.prmtAdminOrg.setEnabled(false);
        this.prmtAdminOrg.setVisible(true);
        this.prmtPosition.setData(null);
        this.prmtPosition.setEnabled(false);
        this.prmtPosition.setVisible(true);
    }
}

