/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.state.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.client.PositionPromptBox2;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.client.IHRF7CommonRegister;
import com.kingdee.eas.hr.org.client.AdminByOrgRangePromptBox;
import com.kingdee.eas.hr.state.JobDiseaseTypeFactory;
import com.kingdee.eas.hr.state.JobDiseaseTypeInfo;
import com.kingdee.eas.hr.state.client.AbstractJobDiseaseStatFilterUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class JobDiseaseStatFilterUI
extends AbstractJobDiseaseStatFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(JobDiseaseStatFilterUI.class);
    private static final String RES = "com.kingdee.eas.hr.state.JobDiseaseResource";
    private int latitudeType;

    public void clear() {
        super.clear();
        this.btnAdminOrg.setSelected(true);
        this.dpkStartOccur.setValue(null);
        this.dpkEndOccur.setValue(null);
        this.dpkStartDiagnose.setValue(null);
        this.dpkEndDiagnose.setValue(null);
        this.prmtAdminOrg.setValue(null);
        this.prmtType.setValue(null);
        this.combGender.setSelectedIndex(0);
    }

    public boolean verify() {
        Date startDate = null;
        Date endDate = null;
        if (this.dpkStartOccur.getValue() != null && this.dpkEndOccur.getValue() != null && (startDate = (Date)this.dpkStartOccur.getValue()).after(endDate = (Date)this.dpkEndOccur.getValue())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"StartEndTimeError"));
            this.dpkStartOccur.requestFocus();
            SysUtil.abort();
        }
        if (this.dpkStartDiagnose.getValue() != null && this.dpkEndDiagnose.getValue() != null && (startDate = (Date)this.dpkStartDiagnose.getValue()).after(endDate = (Date)this.dpkEndDiagnose.getValue())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"StartEndTimeError"));
            this.dpkStartDiagnose.requestFocus();
            SysUtil.abort();
        }
        return true;
    }

    protected void initF7Context(IHRF7CommonRegister register) {
        super.initF7Context(register);
        AdminByOrgRangePromptBox adminOrgF7 = new AdminByOrgRangePromptBox();
        this.prmtAdminOrg.setEditFormat("$number$");
        this.prmtAdminOrg.setDisplayFormat("$name$");
        this.prmtAdminOrg.setCommitFormat("$number$");
        this.prmtAdminOrg.setSelector((KDPromptSelector)adminOrgF7);
        PositionPromptBox2 positionF7 = new PositionPromptBox2();
        this.prmtPosition.setEditFormat("$number$");
        this.prmtPosition.setDisplayFormat("$name$");
        this.prmtPosition.setCommitFormat("$number$");
        this.prmtPosition.setSelector((KDPromptSelector)positionF7);
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.getMainOrg();
    }

    public FilterInfo getFilterInfo() {
        String maskStr;
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection itemCollection = filterInfo.getFilterItems();
        int countLatitudeItem = 0;
        int countCondItem = 0;
        if (this.btnAdminOrg.isSelected()) {
            if (this.prmtAdminOrg.getValue() != null) {
                if (this.chkIncludeChild.isSelected()) {
                    itemCollection.add(new FilterItemInfo("adminOrg.number", (Object)((AdminOrgUnitInfo)this.prmtAdminOrg.getValue()).getNumber(), CompareType.EQUALS));
                    itemCollection.add(new FilterItemInfo("adminOrg.longNumber", (Object)(((AdminOrgUnitInfo)this.prmtAdminOrg.getValue()).getLongNumber() + "!%"), CompareType.LIKE));
                    countLatitudeItem += 2;
                } else {
                    itemCollection.add(new FilterItemInfo("adminOrg.id", (Object)((AdminOrgUnitInfo)this.prmtAdminOrg.getValue()).getId().toString(), CompareType.EQUALS));
                    ++countLatitudeItem;
                }
            }
        } else if (this.btnPosition.isSelected() && this.prmtPosition.getValue() != null) {
            itemCollection.add(new FilterItemInfo("position.id", (Object)((PositionInfo)this.prmtPosition.getValue()).getId().toString(), CompareType.EQUALS));
            ++countLatitudeItem;
        }
        if (this.dpkStartOccur.getValue() != null) {
            itemCollection.add(new FilterItemInfo("occurDate", (Object)((Date)this.dpkStartOccur.getValue()), CompareType.GREATER_EQUALS));
            ++countCondItem;
        }
        if (this.dpkEndOccur.getValue() != null) {
            itemCollection.add(new FilterItemInfo("occurDate", (Object)((Date)this.dpkEndOccur.getValue()), CompareType.LESS_EQUALS));
            ++countCondItem;
        }
        if (this.dpkStartDiagnose.getValue() != null) {
            itemCollection.add(new FilterItemInfo("diagnoseDate", (Object)((Date)this.dpkStartDiagnose.getValue()), CompareType.GREATER_EQUALS));
            ++countCondItem;
        }
        if (this.dpkEndDiagnose.getValue() != null) {
            itemCollection.add(new FilterItemInfo("diagnoseDate", (Object)((Date)this.dpkEndDiagnose.getValue()), CompareType.LESS_EQUALS));
            ++countCondItem;
        }
        if ((maskStr = this.createMaskStr(countLatitudeItem, countCondItem)) != null) {
            filterInfo.setMaskString(maskStr);
        }
        if (itemCollection.size() == 0) {
            itemCollection.add(new FilterItemInfo("id", null, CompareType.ISNOT));
        }
        return filterInfo;
    }

    private String createMaskStr(int countLatitudeItem, int countCondItem) {
        StringBuffer maskStr = null;
        int index = 0;
        if (countLatitudeItem == 0 || countLatitudeItem + countCondItem == 1) {
            return null;
        }
        if (countLatitudeItem == 2) {
            maskStr = new StringBuffer("(#0 or #1)");
            index = 1;
            for (int i = 0; i < countCondItem; ++i) {
                maskStr.append(" and #" + (index += i));
            }
        }
        if (maskStr == null) {
            return null;
        }
        return maskStr.toString();
    }

    public HashMap getStatusMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("latitudeType", this.latitudeType);
        map.put("isIncludeChild", this.chkIncludeChild.isSelected());
        if (this.prmtAdminOrg.getValue() != null) {
            map.put("adminID", ((AdminOrgUnitInfo)this.prmtAdminOrg.getValue()).getId().toString());
            map.put("longNumber", ((AdminOrgUnitInfo)this.prmtAdminOrg.getValue()).getLongNumber());
        }
        if (this.prmtPosition.getValue() != null) {
            map.put("positionID", ((PositionInfo)this.prmtPosition.getValue()).getId().toString());
        }
        map.put("gender", this.combGender.getSelectedIndex());
        if (this.prmtType.getValue() != null) {
            map.put("types", this.getTypeIDSet());
        }
        return map;
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        cp.putInt("latitudeType", this.latitudeType);
        cp.putBoolean("isIncludeChild", this.chkIncludeChild.isSelected());
        if (this.btnAdminOrg.isSelected()) {
            if (this.prmtAdminOrg.getValue() != null) {
                cp.addCustomerParam("adminOrg.id", ((AdminOrgUnitInfo)this.prmtAdminOrg.getValue()).getId().toString());
            }
        } else if (this.btnPosition.isSelected() && this.prmtPosition.getValue() != null) {
            cp.addCustomerParam("position.id", ((PositionInfo)this.prmtPosition.getValue()).getId().toString());
        }
        if (this.dpkStartOccur.getValue() != null) {
            cp.putDate("startOccur", (Date)this.dpkStartOccur.getValue());
        }
        if (this.dpkEndOccur.getValue() != null) {
            cp.putDate("endOccur", (Date)this.dpkEndOccur.getValue());
        }
        if (this.dpkStartDiagnose.getValue() != null) {
            cp.putDate("startDiagnose", (Date)this.dpkStartDiagnose.getValue());
        }
        if (this.dpkEndDiagnose.getValue() != null) {
            cp.putDate("endDiagnose", (Date)this.dpkEndDiagnose.getValue());
        }
        cp.putInt("gender", this.combGender.getSelectedIndex());
        if (this.prmtType.getValue() != null) {
            Object[] dataArray = (Object[])this.prmtType.getValue();
            cp.putInt("typeCount", dataArray.length);
            for (int i = 0; i < dataArray.length; ++i) {
                cp.addCustomerParam("type" + i, ((JobDiseaseTypeInfo)dataArray[i]).getId().toString());
            }
        }
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        try {
            this._setCustomerParams(cp);
        }
        catch (Exception e) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"FilterUIInitError"));
            SysUtil.abort();
        }
        this.setSelect();
    }

    private void _setCustomerParams(CustomerParams cp) throws EASBizException, BOSException {
        this.latitudeType = cp.getInt("latitudeType");
        this.chkIncludeChild.setSelected(cp.getBoolean("isIncludeChild"));
        ObjectUuidPK pk = null;
        if (this.latitudeType == 0) {
            this.btnAdminOrg.setSelected(true);
        } else if (this.latitudeType == 1) {
            this.btnPosition.setSelected(true);
        }
        if (cp.getCustomerParam("adminOrg.id") != null) {
            pk = new ObjectUuidPK(BOSUuid.read((String)cp.getCustomerParam("adminOrg.id")));
            this.prmtAdminOrg.setValue((Object)AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)pk));
        } else if (cp.getCustomerParam("position.id") != null) {
            pk = new ObjectUuidPK(BOSUuid.read((String)cp.getCustomerParam("position.id")));
            this.prmtPosition.setValue((Object)PositionFactory.getRemoteInstance().getPositionInfo((IObjectPK)pk));
        }
        this.dpkStartOccur.setValue((Object)cp.getDate("startOccur"));
        this.dpkEndOccur.setValue((Object)cp.getDate("endOccur"));
        this.dpkStartDiagnose.setValue((Object)cp.getDate("startDiagnose"));
        this.dpkEndDiagnose.setValue((Object)cp.getDate("endDiagnose"));
        this.combGender.setSelectedIndex(cp.getInt("gender"));
        if (cp.getInt("typeCount") > 0) {
            int typeCount = cp.getInt("typeCount");
            JobDiseaseTypeInfo[] types = new JobDiseaseTypeInfo[typeCount];
            for (int i = 0; i < typeCount; ++i) {
                pk = new ObjectUuidPK(BOSUuid.read((String)cp.getCustomerParam("type" + i)));
                types[i] = JobDiseaseTypeFactory.getRemoteInstance().getJobDiseaseTypeInfo((IObjectPK)pk);
            }
            this.prmtType.setValue((Object)types);
        }
    }

    @Override
    protected void btnAdminOrg_stateChanged(ChangeEvent e) throws Exception {
        this.setSelect();
    }

    @Override
    protected void btnPosition_actionPerformed(ActionEvent e) throws Exception {
        this.setSelect();
    }

    private void setSelect() {
        if (this.btnAdminOrg.isSelected()) {
            this.prmtAdminOrg.setEnabled(true);
            this.chkIncludeChild.setEnabled(true);
            this.prmtPosition.setValue(null);
            this.prmtPosition.setEnabled(false);
            this.latitudeType = 0;
        } else if (this.btnPosition.isSelected()) {
            this.prmtPosition.setEnabled(true);
            this.prmtAdminOrg.setValue(null);
            this.prmtAdminOrg.setEnabled(false);
            this.chkIncludeChild.setSelected(false);
            this.chkIncludeChild.setEnabled(false);
            this.latitudeType = 1;
        }
    }

    private HashSet getTypeIDSet() {
        if (this.prmtType.getValue() == null) {
            return null;
        }
        Object[] dataArray = (Object[])this.prmtType.getValue();
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < dataArray.length; ++i) {
            idSet.add(((JobDiseaseTypeInfo)dataArray[i]).getId().toString());
        }
        return idSet;
    }
}

