/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.state.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.client.servicebinding.ActionProxyFactory;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.hraux.util.HRTreeUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.context.IMultiOrgSupport;
import com.kingdee.eas.hr.base.OutputExcelUtil;
import com.kingdee.eas.hr.emp.client.HRCellTreeRenderer;
import com.kingdee.eas.hr.emp.client.HRCellUserObject;
import com.kingdee.eas.hr.emp.client.HRTreeTable;
import com.kingdee.eas.hr.state.IJobDiseaseType;
import com.kingdee.eas.hr.state.JobDiseaseTypeFactory;
import com.kingdee.eas.hr.state.JobDiseaseTypeInfo;
import com.kingdee.eas.hr.state.client.AbstractJobDiseaseStatListUI;
import com.kingdee.eas.hr.state.client.HRStateTWOClientUtils;
import com.kingdee.eas.hr.state.client.JobDiseaseStatFilterUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.Action;
import org.apache.log4j.Logger;

public class JobDiseaseStatListUI
extends AbstractJobDiseaseStatListUI {
    private static final Logger logger = CoreUIObject.getLogger(JobDiseaseStatListUI.class);
    private static final String PANEL_CLASSNAME = "com.kingdee.eas.hr.state.client.JobDiseaseStatFilterUI";
    private static final String RES = "com.kingdee.eas.hr.state.JobDiseaseResource";
    private static final String QUERY_PATH = "com.kingdee.eas.hr.state.app";
    private static final String[] COLUMN_NAME_SUM = new String[]{"genderpersons", "gendertimes", "typepersons", "typetimes"};
    private static final String[] COLUMN_NAME_BASE = new String[]{"basegenderpersons", "basegendertimes", "basetypepersons", "basetypetimes"};
    private static final String COLUMN_NAME_LATITUDE = "latitude";
    private static final String COLUMN_NAME_TREECOLUMN = "treeColumn";
    private static final String COLUMN_NAME_ADMININFO = "admininfo";
    private static final String COLUMN_NAME_SUMPERSONS = "sumpersons";
    private static final String COLUMN_NAME_SUMTIMES = "sumtimes";
    private static final int ADD_FILTER_GENDER = 0;
    private static final int ADD_FILTER_JOBDISEASETYPE = 1;
    private static final int COUNT_PERSONS_GENDER = 0;
    private static final int COUNT_TIMES_GENDER = 1;
    private static final int COUNT_PERSONS_TYPE = 2;
    private static final int COUNT_TIMES_TYPE = 3;
    private static final int COUNT_PERSONS = 4;
    private static final int COUNT_TIMES = 5;
    private HashMap statusMap;
    private HashMap latitudeIDMap;
    private HashMap headMap;
    private int latitudeColCount;
    private DefaultKingdeeTreeNode childNode = null;

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected String getEditUIName() {
        return null;
    }

    protected IMultiOrgSupport getMainCustomerQueryPanel() {
        try {
            return new JobDiseaseStatFilterUI();
        }
        catch (Exception e) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"FilterUIInitError"));
            SysUtil.abort();
            return null;
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.menuItemExportData.setAction((Action)((IItemAction)ActionProxyFactory.getProxy((Object)this.actionExport, (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
        this.menuItemExportData.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.btnExport.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.btnExport.setText("");
        this.btnExport.setToolTipText(EASResource.getString((String)RES, (String)"output"));
    }

    protected void afterOnLoad() throws Exception {
        super.afterOnLoad();
        this.menuItemExportData.setText(EASResource.getString((String)RES, (String)"output"));
        HRTreeTable.setHRTreeTable((KDTable)this.tblMain, (String)COLUMN_NAME_TREECOLUMN);
        this.tblMain.checkParsed();
        this.tblMain.setEditable(false);
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.setAutoscrolls(true);
        this.enableExportExcel(this.tblMain);
        this.tHelper.getDisabledTables().add(this.tblMain);
    }

    protected void initListener() {
    }

    public void initTableListner(KDTable table) {
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.refreshData();
    }

    private void resetTable() {
        this.tblMain.removeRows();
        this.tblMain.removeColumns();
        this.tblMain.getHead().removeRows();
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        OutputExcelUtil excelUtil = new OutputExcelUtil();
        if (excelUtil.appendToExcel(this.tblMain, true, true, this.getUITitle()) != null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.state.client.StateResource", (String)"EXPORT_SUCCESS"));
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        if (this.getDialog() != null) {
            this.statusMap = ((JobDiseaseStatFilterUI)this.getDialog().getUserPanel(PANEL_CLASSNAME)).getStatusMap();
            this.loadData();
        } else {
            IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
            JobDiseaseStatFilterUI filterUI = new JobDiseaseStatFilterUI();
            QuerySolutionInfo solution = iQuery.getDefaultSolution(this.getMetaDataPK().getFullName(), "com.kingdee.eas.hr.state.app.JobDiseaseStatFilterQuery");
            CustomerParams params = CustomerParams.getCustomerParams2((String)this.getCustomerParamsStr(solution));
            if (params != null) {
                filterUI.setCustomerParams(params);
                this.statusMap = filterUI.getStatusMap();
                this.loadData();
            }
        }
    }

    private void refreshData() {
        this.loadData();
    }

    private void loadData() {
        this.resetTable();
        boolean isIncludeChild = (Boolean)this.statusMap.get("isIncludeChild");
        int latitudeType = (Integer)this.statusMap.get("latitudeType");
        IColumn column = this.tblMain.addColumn();
        IColumn extCol = null;
        if ((Integer)this.statusMap.get("latitudeType") == 1) {
            extCol = this.tblMain.addColumn();
        }
        if ((Integer)this.statusMap.get("latitudeType") == 0 && isIncludeChild) {
            column.setKey(COLUMN_NAME_TREECOLUMN);
        } else if (extCol != null) {
            extCol.setKey(COLUMN_NAME_LATITUDE);
            if (this.statusMap.get("positionID") == null) {
                column.setKey(COLUMN_NAME_TREECOLUMN);
            } else if (this.statusMap.get("positionID") != null) {
                column.setKey(COLUMN_NAME_ADMININFO);
            }
        } else {
            column.setKey(COLUMN_NAME_LATITUDE);
        }
        this.initLatitude(latitudeType);
        this.initTableHead();
        this.tblMain.setRowCount(this.tblMain.getBody().size());
        this.initData(latitudeType);
        this.scanTable(latitudeType == 1 && this.statusMap.get("positionID") == null);
    }

    private void initTableHead() {
        this.headMap = new HashMap();
        Vector<String> headGenderData = new Vector<String>();
        List headTypeData = new Vector();
        int gender = (Integer)this.statusMap.get("gender");
        switch (gender) {
            case 1: {
                headGenderData.add(EASResource.getString((String)RES, (String)"male"));
                this.headMap.put("1", 0);
                break;
            }
            case 2: {
                headGenderData.add(EASResource.getString((String)RES, (String)"female"));
                this.headMap.put("2", 0);
                break;
            }
            case 3: {
                headGenderData.add(EASResource.getString((String)RES, (String)"male"));
                this.headMap.put("1", 0);
                headGenderData.add(EASResource.getString((String)RES, (String)"female"));
                this.headMap.put("2", 1);
            }
        }
        JobDiseaseTypeInfo type = null;
        try {
            headTypeData = this.findType();
        }
        catch (BOSException e) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"initTableHeadError"));
            SysUtil.abort();
        }
        for (int i = 0; i < headTypeData.size(); ++i) {
            type = (JobDiseaseTypeInfo)headTypeData.get(i);
            this.headMap.put(type.getId().toString(), i);
        }
        if ((Integer)this.statusMap.get("gender") == 0 && this.statusMap.get("types") == null) {
            IColumn col = null;
            this.tblMain.addHeadRow(0);
            this.tblMain.addHeadRow(1);
            col = this.tblMain.addColumn();
            this.tblMain.getHeadMergeManager().mergeBlock(0, this.latitudeColCount, 0, this.latitudeColCount);
            this.tblMain.getHead().getRow(0).getCell(this.latitudeColCount).setValue((Object)EASResource.getString((String)RES, (String)"HeadTitleCountPerson"));
            this.tblMain.getHeadMergeManager().mergeBlock(1, this.latitudeColCount, 1, this.latitudeColCount);
            this.tblMain.getHead().getRow(1).getCell(this.latitudeColCount).setValue((Object)EASResource.getString((String)RES, (String)"sum"));
            col.setWidth(200);
            col.setKey(COLUMN_NAME_SUMPERSONS);
            col = this.tblMain.addColumn();
            this.tblMain.getHeadMergeManager().mergeBlock(0, this.latitudeColCount + 1, 0, this.latitudeColCount + 1);
            this.tblMain.getHead().getRow(0).getCell(this.latitudeColCount + 1).setValue((Object)EASResource.getString((String)RES, (String)"HeadTitleCountTimes"));
            this.tblMain.getHeadMergeManager().mergeBlock(1, this.latitudeColCount + 1, 1, this.latitudeColCount + 1);
            this.tblMain.getHead().getRow(1).getCell(this.latitudeColCount + 1).setValue((Object)EASResource.getString((String)RES, (String)"sum"));
            col.setWidth(200);
            col.setKey(COLUMN_NAME_SUMTIMES);
        } else {
            this.tblMain.addHeadRow(0);
            this.tblMain.addHeadRow(1);
            this.tblMain.addHeadRow(2);
            int baseIndex = this.latitudeColCount;
            int groupGenderSize = 0;
            if (headGenderData.size() != 0) {
                groupGenderSize = headGenderData.size() + 1;
            }
            int groupTypeSize = 0;
            if (headTypeData.size() != 0) {
                groupTypeSize = headTypeData.size() + 1;
            }
            int groupTopSize = groupGenderSize + groupTypeSize;
            String[] topTitle = new String[]{"HeadTitleCountPerson", "HeadTitleCountTimes"};
            KDTMergeManager manager = this.tblMain.getHeadMergeManager();
            IColumn col = null;
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < groupGenderSize; ++j) {
                    col = this.tblMain.addColumn();
                    if (j == 0) {
                        switch (i) {
                            case 0: {
                                col.setKey(COLUMN_NAME_BASE[0]);
                                break;
                            }
                            case 1: {
                                col.setKey(COLUMN_NAME_BASE[1]);
                            }
                        }
                    }
                    manager.mergeBlock(0, baseIndex + groupTopSize * i, 0, baseIndex + groupTopSize * i + j);
                    manager.mergeBlock(1, baseIndex + groupTopSize * i, 1, baseIndex + groupTopSize * i + j);
                    manager.mergeBlock(2, baseIndex + groupTopSize * i + j, 2, baseIndex + groupTopSize * i + j);
                    if (j == headGenderData.size()) {
                        this.tblMain.getHead().getRow(2).getCell(baseIndex + groupTopSize * i + j).setValue((Object)EASResource.getString((String)RES, (String)"sum"));
                        this.tblMain.getColumn(baseIndex + groupTopSize * i + j).setKey(COLUMN_NAME_SUM[i]);
                        continue;
                    }
                    this.tblMain.getHead().getRow(2).getCell(baseIndex + groupTopSize * i + j).setValue(headGenderData.get(j));
                }
                if (this.tblMain.getHead().getRow(1).getCell(baseIndex + groupTopSize * i) != null) {
                    this.tblMain.getHead().getRow(1).getCell(baseIndex + groupTopSize * i).setValue((Object)EASResource.getString((String)RES, (String)"genderName"));
                }
                for (int k = 0; k < groupTypeSize; ++k) {
                    col = this.tblMain.addColumn();
                    if (k == 0) {
                        switch (i) {
                            case 0: {
                                col.setKey(COLUMN_NAME_BASE[2]);
                                break;
                            }
                            case 1: {
                                col.setKey(COLUMN_NAME_BASE[3]);
                            }
                        }
                    }
                    manager.mergeBlock(0, baseIndex + groupTopSize * i, 0, baseIndex + groupTopSize * i + groupGenderSize + k);
                    manager.mergeBlock(1, baseIndex + groupTopSize * i + groupGenderSize, 1, baseIndex + groupTopSize * i + groupGenderSize + k);
                    manager.mergeBlock(2, baseIndex + groupTopSize * i + groupGenderSize + k, 2, baseIndex + groupTopSize * i + groupGenderSize + k);
                    if (k == headTypeData.size()) {
                        this.tblMain.getHead().getRow(2).getCell(baseIndex + groupTopSize * i + groupGenderSize + k).setValue((Object)EASResource.getString((String)RES, (String)"sum"));
                        this.tblMain.getColumn(baseIndex + groupTopSize * i + groupGenderSize + k).setKey(COLUMN_NAME_SUM[i + 2]);
                        continue;
                    }
                    this.tblMain.getHead().getRow(2).getCell(baseIndex + groupTopSize * i + groupGenderSize + k).setValue(headTypeData.get(k));
                }
                if (this.tblMain.getHead().getRow(1).getCell(baseIndex + groupTopSize * i + groupGenderSize) != null) {
                    this.tblMain.getHead().getRow(1).getCell(baseIndex + groupTopSize * i + groupGenderSize).setValue((Object)EASResource.getString((String)RES, (String)"jobdiseaseTypeName"));
                }
                this.tblMain.getHead().getRow(0).getCell(baseIndex + groupTopSize * i).setValue((Object)EASResource.getString((String)RES, (String)topTitle[i]));
            }
        }
        int index = (Boolean)this.statusMap.get("isIncludeChild") != false && (Integer)this.statusMap.get("latitudeType") == 0 ? this.tblMain.getColumnIndex(COLUMN_NAME_TREECOLUMN) : this.tblMain.getColumnIndex(COLUMN_NAME_LATITUDE);
        this.tblMain.getHeadMergeManager().mergeBlock(0, 0, this.tblMain.getHeadRowCount() - 1, index);
        this.tblMain.getHead().getRow(0).getCell(0).setValue((Object)EASResource.getString((String)RES, (String)"HeadTitleLatitude"));
        int latitudeType = (Integer)this.statusMap.get("latitudeType");
        if (latitudeType == 0) {
            this.tblMain.getHeadRow(0).getCell(0).setValue((Object)"\u884c\u653f\u7ec4\u7ec7");
        } else if (latitudeType == 1) {
            this.tblMain.getHeadRow(0).getCell(0).setValue((Object)"\u884c\u653f\u7ec4\u7ec7-\u804c\u4f4d");
        }
    }

    private void initLatitude(int latitudeType) {
        this.latitudeIDMap = new HashMap();
        try {
            switch (latitudeType) {
                case 0: {
                    this.initDepartmentLatitude();
                    break;
                }
                case 1: {
                    this.initPositionLatitude();
                }
            }
        }
        catch (Exception e) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"initLatitudeError"));
            this.tblMain.removeRows();
            SysUtil.abort();
        }
        this.latitudeColCount = this.tblMain.getColumnCount();
        if (this.tblMain.getColumn(COLUMN_NAME_TREECOLUMN) != null) {
            this.tblMain.getColumn(COLUMN_NAME_TREECOLUMN).setWidth(200);
        }
    }

    private void initDepartmentLatitude() throws Exception {
        boolean isIncludeChild = (Boolean)this.statusMap.get("isIncludeChild");
        IRow row = null;
        AdminOrgUnitInfo info = null;
        if (isIncludeChild) {
            Vector<AdminOrgUnitInfo> vec = new Vector<AdminOrgUnitInfo>();
            DefaultKingdeeTreeNode rootNode = this.getOrgUnitTreeNode(false);
            if (rootNode == null) {
                return;
            }
            AdminOrgUnitInfo rootInfo = (AdminOrgUnitInfo)rootNode.getUserObject();
            if (HRTreeUtil.isTreeNodeDisable((DefaultKingdeeTreeNode)rootNode)) {
                rootInfo.put("isEnable", (Object)false);
            } else {
                rootInfo.put("isEnable", (Object)true);
            }
            rootInfo.setLevel(rootNode.getLevel());
            vec.add(rootInfo);
            this.getCellUserObjects(rootNode, vec, false);
            HRCellTreeRenderer orgCellRen = new HRCellTreeRenderer();
            int initLevel = 0;
            int size = vec.size();
            for (int i = 0; i < size; ++i) {
                info = (AdminOrgUnitInfo)vec.get(i);
                if (i == 0) {
                    initLevel = info.getLevel();
                }
                row = this.tblMain.addRow(i);
                if (!Boolean.valueOf(info.get("isEnable").toString()).booleanValue()) {
                    row.getStyleAttributes().setBackground(Color.LIGHT_GRAY);
                }
                HRCellUserObject orgCellObj = new HRCellUserObject();
                orgCellObj.setCompanyId(info.getId().toString());
                orgCellObj.setName(info.getName());
                orgCellObj.setLongNumber(info.getLongNumber());
                orgCellObj.setIsLeaf(info.isIsLeaf());
                orgCellObj.setLevel(info.getLevel() - initLevel);
                orgCellObj.setExpanded(true);
                this.latitudeIDMap.put(info.getId().toString(), row.getRowIndex());
                row.getCell(COLUMN_NAME_TREECOLUMN).setValue((Object)orgCellObj);
                row.getCell(COLUMN_NAME_TREECOLUMN).setRenderer((IBasicRender)orgCellRen);
            }
        } else if (this.statusMap.get("adminID") == null) {
            AdminOrgUnitInfo topOrg = (AdminOrgUnitInfo)this.getOrgUnitTreeNode(false).getUserObject();
            IRow r = this.tblMain.addRow();
            r.getCell(COLUMN_NAME_LATITUDE).setValue((Object)topOrg);
            this.latitudeIDMap.put(topOrg.getId().toString(), r.getRowIndex());
        } else {
            List adminOrgList = this.findDepartment();
            for (int i = 0; i < adminOrgList.size(); ++i) {
                row = this.tblMain.addRow();
                info = (AdminOrgUnitInfo)adminOrgList.get(i);
                this.latitudeIDMap.put(info.getId().toString(), row.getRowIndex());
                row.getCell(COLUMN_NAME_LATITUDE).setValue((Object)info);
            }
        }
    }

    private DefaultKingdeeTreeNode getOrgUnitTreeNode(boolean isIncludePosition) throws Exception {
        String adminId = (String)this.statusMap.get("adminID");
        DefaultKingdeeTreeNode root = HRTreeUtil.createAdminTreeNodeByUserRange((boolean)isIncludePosition, (boolean)false, (boolean)true, (boolean)false, null);
        if (root == null) {
            return null;
        }
        if (adminId != null) {
            HashMap<String, DefaultKingdeeTreeNode> map = new HashMap<String, DefaultKingdeeTreeNode>();
            map.put(this.getAdminIdByAdminNode(root), root);
            this.overTreeNodeSimple(root, map);
            root = (DefaultKingdeeTreeNode)map.get(adminId);
        }
        return root;
    }

    private void overTreeNodeSimple(DefaultKingdeeTreeNode root, HashMap nodeMap) throws Exception {
        DefaultKingdeeTreeNode node = null;
        int count = root.getChildCount();
        for (int i = 0; i < count; ++i) {
            node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            nodeMap.put(this.getAdminIdByAdminNode(node), node);
            this.overTreeNodeSimple(node, nodeMap);
        }
    }

    private String getAdminIdByAdminNode(DefaultKingdeeTreeNode node) {
        AdminOrgUnitInfo adminInfo = null;
        if (node.getUserObject() instanceof AdminOrgUnitInfo) {
            adminInfo = (AdminOrgUnitInfo)node.getUserObject();
        }
        if (adminInfo != null) {
            return adminInfo.getId().toString();
        }
        return null;
    }

    private void getCellUserObjects(DefaultKingdeeTreeNode treeNode, Vector vec, boolean isIncludePosition) {
        AdminOrgUnitInfo adminInfo = null;
        if (treeNode != null && treeNode.getUserObject() != null && treeNode.getUserObject() instanceof AdminOrgUnitInfo) {
            for (int i = 0; i < treeNode.getChildCount(); ++i) {
                this.childNode = (DefaultKingdeeTreeNode)treeNode.getChildAt(i);
                if (this.childNode.getUserObject() instanceof AdminOrgUnitInfo) {
                    adminInfo = (AdminOrgUnitInfo)this.childNode.getUserObject();
                    adminInfo.setLevel(this.childNode.getLevel());
                    if (HRTreeUtil.isTreeNodeDisable((DefaultKingdeeTreeNode)this.childNode)) {
                        adminInfo.put("isEnable", (Object)false);
                    } else {
                        adminInfo.put("isEnable", (Object)true);
                    }
                    vec.add(adminInfo);
                } else if (isIncludePosition && this.childNode.getUserObject() instanceof PositionInfo) {
                    vec.add(this.childNode.getUserObject());
                }
                if (this.childNode.getChildCount() <= 0) continue;
                this.getCellUserObjects(this.childNode, vec, isIncludePosition);
            }
        }
    }

    private List findDepartment() throws BOSException, SQLException {
        IRowSet dataRows = null;
        AdminOrgUnitInfo adminOrg = null;
        Vector<AdminOrgUnitInfo> adminOrgList = new Vector<AdminOrgUnitInfo>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(HRStateTWOClientUtils.getDefaultFilterForQuery("id"));
        if ((String)this.statusMap.get("adminID") != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)((String)this.statusMap.get("adminID")), CompareType.EQUALS));
            if (((Boolean)this.statusMap.get("isIncludeChild")).booleanValue()) {
                filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)((String)this.statusMap.get("longNumber") + "%"), CompareType.LIKE));
                filter.setMaskString("#0 OR #1");
            }
        }
        view.setFilter(filter);
        dataRows = HRStateTWOClientUtils.query(view, QUERY_PATH, "HRStatFindDepartmentQuery");
        while (dataRows.next()) {
            adminOrg = new AdminOrgUnitInfo();
            adminOrg.setId(BOSUuid.read((String)dataRows.getString("ID")));
            adminOrg.setName(dataRows.getString("NAME"));
            adminOrgList.add(adminOrg);
        }
        return adminOrgList;
    }

    private void initPositionLatitude() throws Exception {
        boolean isMixLatitude = (Integer)this.statusMap.get("latitudeType") == 1 && this.statusMap.get("positionID") == null;
        List positionList = this.findPosition(isMixLatitude);
        PositionInfo positionInfo = null;
        IRow row = null;
        if (isMixLatitude) {
            HRCellUserObject orgCellObj = null;
            HRCellUserObject tempOrgCell = null;
            HRCellTreeRenderer orgCellRen = new HRCellTreeRenderer();
            int initLevel = 0;
            AdminOrgUnitInfo adminInfo = null;
            for (int i = 0; i < positionList.size(); ++i) {
                row = this.tblMain.addRow(i);
                if (positionList.get(i) instanceof AdminOrgUnitInfo) {
                    adminInfo = (AdminOrgUnitInfo)positionList.get(i);
                    if (i == 0) {
                        initLevel = adminInfo.getLevel();
                    }
                    if (!Boolean.valueOf(adminInfo.get("isEnable").toString()).booleanValue()) {
                        row.getStyleAttributes().setBackground(Color.LIGHT_GRAY);
                    }
                    orgCellObj = new HRCellUserObject();
                    orgCellObj.setCompanyId(adminInfo.getId().toString());
                    orgCellObj.setName(adminInfo.getName());
                    orgCellObj.setLongNumber(adminInfo.getLongNumber());
                    orgCellObj.setIsLeaf(adminInfo.isIsLeaf());
                    orgCellObj.setLevel(adminInfo.getLevel() - initLevel);
                    orgCellObj.setExpanded(true);
                    this.latitudeIDMap.put(adminInfo.getId().toString(), row.getRowIndex());
                    row.getCell(COLUMN_NAME_TREECOLUMN).setValue((Object)orgCellObj);
                    row.getCell(COLUMN_NAME_TREECOLUMN).setRenderer((IBasicRender)orgCellRen);
                    continue;
                }
                if (!(positionList.get(i) instanceof PositionInfo)) continue;
                positionInfo = (PositionInfo)positionList.get(i);
                row.getCell(COLUMN_NAME_LATITUDE).setValue((Object)positionInfo);
                tempOrgCell = new HRCellUserObject();
                tempOrgCell.setCompanyId(orgCellObj.getCompanyId());
                tempOrgCell.setName("");
                if (orgCellObj.isLeaf()) {
                    tempOrgCell.setLevel(orgCellObj.getLevel());
                } else {
                    tempOrgCell.setLevel(orgCellObj.getLevel() + 1);
                }
                tempOrgCell.setIsLeaf(true);
                tempOrgCell.setExpanded(true);
                row.getCell(COLUMN_NAME_TREECOLUMN).setValue((Object)tempOrgCell);
                row.getCell(COLUMN_NAME_TREECOLUMN).setRenderer((IBasicRender)orgCellRen);
                this.latitudeIDMap.put(positionInfo.getId().toString(), row.getRowIndex());
            }
            this.tblMain.getColumn(COLUMN_NAME_TREECOLUMN).getStyleAttributes().setBackground(Color.LIGHT_GRAY);
            this.tblMain.getColumn(COLUMN_NAME_LATITUDE).getStyleAttributes().setBackground(Color.LIGHT_GRAY);
        } else {
            List treeList = this.findPosition(true);
            for (int i = 0; i < positionList.size(); ++i) {
                row = this.tblMain.addRow();
                positionInfo = (PositionInfo)positionList.get(i);
                this.latitudeIDMap.put(positionInfo.getId().toString(), row.getRowIndex());
                row.getCell(COLUMN_NAME_ADMININFO).setValue((Object)this.searchAdminInTreeForPos(treeList, positionInfo.getId().toString()));
                row.getCell(COLUMN_NAME_LATITUDE).setValue((Object)positionInfo);
            }
        }
    }

    private List findPosition(boolean isMixLatitude) throws Exception {
        Vector<Object> positionList = new Vector<Object>();
        if (isMixLatitude) {
            DefaultKingdeeTreeNode rootNode = this.getOrgUnitTreeNode(true);
            if (rootNode == null) {
                return null;
            }
            AdminOrgUnitInfo rootInfo = (AdminOrgUnitInfo)rootNode.getUserObject();
            if (HRTreeUtil.isTreeNodeDisable((DefaultKingdeeTreeNode)rootNode)) {
                rootInfo.put("isEnable", (Object)false);
            } else {
                rootInfo.put("isEnable", (Object)true);
            }
            rootInfo.setLevel(rootNode.getLevel());
            positionList.add(rootInfo);
            this.getCellUserObjects(rootNode, positionList, true);
        } else {
            IRowSet dataRows = null;
            PositionInfo position = null;
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(HRStateTWOClientUtils.getDefaultFilterForQuery("adminOrgUnit.id"));
            if (this.statusMap.get("positionID") != null) {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)((String)this.statusMap.get("positionID")), CompareType.EQUALS));
            }
            view.setFilter(filter);
            dataRows = HRStateTWOClientUtils.query(view, QUERY_PATH, "HRStatFindPositionQuery");
            while (dataRows.next()) {
                position = new PositionInfo();
                position.setId(BOSUuid.read((String)dataRows.getString("ID")));
                position.setName(dataRows.getString("NAME"));
                positionList.add(position);
            }
        }
        return positionList;
    }

    private AdminOrgUnitInfo searchAdminInTreeForPos(List treeList, String positionID) {
        AdminOrgUnitInfo admin = null;
        PositionInfo position = null;
        if (treeList == null) {
            return null;
        }
        for (int i = 0; i < treeList.size(); ++i) {
            if (treeList.get(i) instanceof AdminOrgUnitInfo) {
                admin = (AdminOrgUnitInfo)treeList.get(i);
                continue;
            }
            if (!(treeList.get(i) instanceof PositionInfo) || !(position = (PositionInfo)treeList.get(i)).getId().toString().equals(positionID)) continue;
            return admin;
        }
        return null;
    }

    private List findType() throws BOSException {
        Vector<CoreBaseInfo> typeList = new Vector<CoreBaseInfo>();
        if (this.statusMap.get("types") != null) {
            IJobDiseaseType ijdt = JobDiseaseTypeFactory.getRemoteInstance();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)((HashSet)this.statusMap.get("types")), CompareType.INCLUDE));
            view.setFilter(filter);
            CoreBaseCollection coll = ijdt.getCollection(view);
            if (coll != null) {
                for (int i = 0; i < coll.size(); ++i) {
                    typeList.add(coll.get(i));
                }
            }
        }
        return typeList;
    }

    private void initData(int latitudeType) {
        try {
            switch (latitudeType) {
                case 0: {
                    this.initDataOnDepartment();
                    break;
                }
                case 1: {
                    this.initDataOnPosition();
                }
            }
        }
        catch (Exception e) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"initDataError"));
            this.tblMain.removeRows();
            logger.error((Object)e.getMessage());
            SysUtil.abort();
        }
    }

    private void initDataOnDepartment() throws BOSException, SQLException {
        IRowSet dataRows = null;
        IRowSet sumRows = null;
        EntityViewInfo view = null;
        FilterInfo addFilter = null;
        view = (EntityViewInfo)this.mainQuery.clone();
        addFilter = this.createAddtionFilter(0);
        if (addFilter != null) {
            view.getFilter().mergeFilter(addFilter, "and");
            dataRows = HRStateTWOClientUtils.query(view, QUERY_PATH, "JobDiseaseStatDepartment1Query");
            sumRows = HRStateTWOClientUtils.query(view, QUERY_PATH, "JobDiseaseStatDepartment6Query");
            this.initDataOnTable("ADMINORG.ID", "PERSON.GENDER", dataRows, "COUNTTIMES", 1);
            this.initSumDataOnTable("ADMINORG.ID", "COUNTTIMES", sumRows, 1);
            dataRows = this.getPersonsData(view, "ADMINORG.ID", "PERSON.GENDER", "JobDiseaseStatDepartment2Query");
            sumRows = this.getPersonSumData(view, "ADMINORG.ID", "JobDiseaseStatDepartment5Query");
            this.initDataOnTable("ADMINORGID", "PERSONGENDER", dataRows, "COUNTPERSONS", 0);
            this.initSumDataOnTable("ADMINORGID", "COUNTPERSONS", sumRows, 0);
        }
        view = (EntityViewInfo)this.mainQuery.clone();
        addFilter = this.createAddtionFilter(1);
        if (addFilter != null) {
            view.getFilter().mergeFilter(addFilter, "and");
            dataRows = HRStateTWOClientUtils.query(view, QUERY_PATH, "JobDiseaseStatDepartment3Query");
            sumRows = HRStateTWOClientUtils.query(view, QUERY_PATH, "JobDiseaseStatDepartment8Query");
            this.initDataOnTable("ADMINORG.ID", "TYPE.ID", dataRows, "COUNTTIMES", 3);
            this.initSumDataOnTable("ADMINORG.ID", "COUNTTIMES", sumRows, 3);
            dataRows = this.getPersonsData(view, "ADMINORG.ID", "TYPE.ID", "JobDiseaseStatDepartment4Query");
            sumRows = this.getPersonSumData(view, "ADMINORG.ID", "JobDiseaseStatDepartment7Query");
            this.initDataOnTable("ADMINORGID", "TYPEID", dataRows, "COUNTPERSONS", 2);
            this.initSumDataOnTable("ADMINORGID", "COUNTPERSONS", sumRows, 2);
        }
        if ((Integer)this.statusMap.get("gender") == 0 && this.statusMap.get("types") == null) {
            sumRows = HRStateTWOClientUtils.query(this.mainQuery, QUERY_PATH, "JobDiseaseStatDepartment6Query");
            this.initSumDataOnTable("ADMINORG.ID", "COUNTTIMES", sumRows, 5);
            sumRows = this.getPersonSumData(this.mainQuery, "ADMINORG.ID", "JobDiseaseStatDepartment5Query");
            this.initSumDataOnTable("ADMINORGID", "COUNTPERSONS", sumRows, 4);
        }
    }

    private void initDataOnPosition() throws BOSException, SQLException {
        IRowSet dataRows = null;
        IRowSet sumRows = null;
        EntityViewInfo view = null;
        FilterInfo addFilter = null;
        view = (EntityViewInfo)this.mainQuery.clone();
        addFilter = this.createAddtionFilter(0);
        if (addFilter != null) {
            view.getFilter().mergeFilter(addFilter, "and");
            dataRows = HRStateTWOClientUtils.query(view, QUERY_PATH, "JobDiseaseStatPosition1Query");
            sumRows = HRStateTWOClientUtils.query(view, QUERY_PATH, "JobDiseaseStatPosition6Query");
            this.initDataOnTable("POSITION.ID", "PERSON.GENDER", dataRows, "COUNTTIMES", 1);
            this.initSumDataOnTable("POSITION.ID", "COUNTTIMES", sumRows, 1);
            dataRows = this.getPersonsData(view, "POSITION.ID", "PERSON.GENDER", "JobDiseaseStatPosition2Query");
            sumRows = this.getPersonSumData(view, "POSITION.ID", "JobDiseaseStatPosition5Query");
            this.initDataOnTable("POSITIONID", "PERSONGENDER", dataRows, "COUNTPERSONS", 0);
            this.initSumDataOnTable("POSITIONID", "COUNTPERSONS", sumRows, 0);
        }
        view = (EntityViewInfo)this.mainQuery.clone();
        addFilter = this.createAddtionFilter(1);
        if (addFilter != null) {
            view.getFilter().mergeFilter(addFilter, "and");
            dataRows = HRStateTWOClientUtils.query(view, QUERY_PATH, "JobDiseaseStatPosition3Query");
            sumRows = HRStateTWOClientUtils.query(view, QUERY_PATH, "JobDiseaseStatPosition8Query");
            this.initDataOnTable("POSITION.ID", "TYPE.ID", dataRows, "COUNTTIMES", 3);
            this.initSumDataOnTable("POSITION.ID", "COUNTTIMES", sumRows, 3);
            dataRows = this.getPersonsData(view, "POSITION.ID", "TYPE.ID", "JobDiseaseStatPosition4Query");
            sumRows = this.getPersonSumData(view, "POSITION.ID", "JobDiseaseStatPosition7Query");
            this.initDataOnTable("POSITIONID", "TYPEID", dataRows, "COUNTPERSONS", 2);
            this.initSumDataOnTable("POSITIONID", "COUNTPERSONS", sumRows, 2);
        }
        if ((Integer)this.statusMap.get("gender") == 0 && this.statusMap.get("types") == null) {
            sumRows = HRStateTWOClientUtils.query(this.mainQuery, QUERY_PATH, "JobDiseaseStatPosition6Query");
            this.initSumDataOnTable("POSITION.ID", "COUNTTIMES", sumRows, 5);
            sumRows = this.getPersonSumData(this.mainQuery, "POSITION.ID", "JobDiseaseStatPosition5Query");
            this.initSumDataOnTable("POSITIONID", "COUNTPERSONS", sumRows, 4);
        }
    }

    private IRowSet getPersonsData(EntityViewInfo view, String latitudeFieldName, String condFieldName, String queryName) throws BOSException {
        String subSQL = HRStateTWOClientUtils.metaQueryToSQL(view, QUERY_PATH, queryName);
        StringBuffer queryStr = new StringBuffer();
        subSQL = subSQL.replaceAll(latitudeFieldName, latitudeFieldName.replaceAll("\\.", "")).replaceAll(condFieldName, condFieldName.replaceAll("\\.", ""));
        queryStr.append("SELECT " + latitudeFieldName.replaceAll("\\.", "") + "," + condFieldName.replaceAll("\\.", "") + ",COUNT(*) AS COUNTPERSONS FROM (\n");
        queryStr.append(subSQL);
        queryStr.append("\n )AS T GROUP BY " + latitudeFieldName.replaceAll("\\.", "") + "," + condFieldName.replaceAll("\\.", "") + "");
        return HRStateTWOClientUtils.query(queryStr.toString());
    }

    private IRowSet getPersonSumData(EntityViewInfo view, String latitudeFieldName, String queryName) throws BOSException {
        String subSQL = HRStateTWOClientUtils.metaQueryToSQL(view, QUERY_PATH, queryName);
        StringBuffer queryStr = new StringBuffer();
        subSQL = subSQL.replaceAll(latitudeFieldName, latitudeFieldName.replaceAll("\\.", "")).replaceAll("PERSON.ID", "PERSONID");
        queryStr.append("SELECT " + latitudeFieldName.replaceAll("\\.", "") + ",COUNT(*) AS COUNTPERSONS FROM (\n");
        queryStr.append(subSQL);
        queryStr.append("\n )AS T GROUP BY " + latitudeFieldName.replaceAll("\\.", ""));
        return HRStateTWOClientUtils.query(queryStr.toString());
    }

    private void initDataOnTable(String latitudeFieldName, String condFieldName, IRowSet dataRows, String countFieldName, int countType) throws SQLException {
        if (dataRows != null && dataRows.size() > 0) {
            int indexX = 0;
            int indexY = 0;
            int baseIndex = 0;
            switch (countType) {
                case 0: {
                    baseIndex = this.tblMain.getColumnIndex(COLUMN_NAME_BASE[0]);
                    break;
                }
                case 1: {
                    baseIndex = this.tblMain.getColumnIndex(COLUMN_NAME_BASE[1]);
                    break;
                }
                case 2: {
                    baseIndex = this.tblMain.getColumnIndex(COLUMN_NAME_BASE[2]);
                    break;
                }
                case 3: {
                    baseIndex = this.tblMain.getColumnIndex(COLUMN_NAME_BASE[3]);
                    break;
                }
                case 4: {
                    baseIndex = this.tblMain.getColumnIndex(COLUMN_NAME_SUMPERSONS);
                    break;
                }
                case 5: {
                    baseIndex = this.tblMain.getColumnIndex(COLUMN_NAME_SUMTIMES);
                }
            }
            while (dataRows.next()) {
                if (dataRows.getString(latitudeFieldName) == null || dataRows.getString(condFieldName) == null || this.latitudeIDMap.get(dataRows.getString(latitudeFieldName)) == null || this.headMap.get(dataRows.getString(condFieldName)) == null) continue;
                indexY = (Integer)this.latitudeIDMap.get(dataRows.getString(latitudeFieldName));
                indexX = baseIndex + (Integer)this.headMap.get(dataRows.getString(condFieldName));
                this.tblMain.getCell(indexY, indexX).setValue((Object)dataRows.getInt(countFieldName));
            }
        }
    }

    private void initSumDataOnTable(String latitudeFieldName, String sumFieldName, IRowSet dataRows, int countType) throws SQLException {
        if (dataRows != null && dataRows.size() > 0) {
            int indexX = 0;
            int indexY = 0;
            switch (countType) {
                case 0: {
                    indexX = this.tblMain.getColumnIndex(COLUMN_NAME_SUM[0]);
                    break;
                }
                case 1: {
                    indexX = this.tblMain.getColumnIndex(COLUMN_NAME_SUM[1]);
                    break;
                }
                case 2: {
                    indexX = this.tblMain.getColumnIndex(COLUMN_NAME_SUM[2]);
                    break;
                }
                case 3: {
                    indexX = this.tblMain.getColumnIndex(COLUMN_NAME_SUM[3]);
                    break;
                }
                case 4: {
                    indexX = this.tblMain.getColumnIndex(COLUMN_NAME_SUMPERSONS);
                    break;
                }
                case 5: {
                    indexX = this.tblMain.getColumnIndex(COLUMN_NAME_SUMTIMES);
                }
            }
            if (indexX >= 0) {
                while (dataRows.next()) {
                    if (dataRows.getString(latitudeFieldName) == null || this.latitudeIDMap.get(dataRows.getString(latitudeFieldName)) == null) continue;
                    indexY = (Integer)this.latitudeIDMap.get(dataRows.getString(latitudeFieldName));
                    this.tblMain.getCell(indexY, indexX).setValue((Object)dataRows.getInt(sumFieldName));
                }
            }
        }
    }

    private void scanTable(boolean isMixLatitude) {
        int indexX = 0;
        int indexY = 0;
        int sum = 0;
        int colRange = this.tblMain.getColumnCount() - this.latitudeColCount;
        if (isMixLatitude) {
            for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
                if (this.tblMain.getRow(i).getCell(COLUMN_NAME_LATITUDE).getValue() != null) continue;
                IRow r = this.tblMain.getRow(i);
                int stepColIndex = 0;
                int stepRowIndex = 0;
                for (stepColIndex = this.latitudeColCount; stepColIndex < this.latitudeColCount + colRange; ++stepColIndex) {
                    stepRowIndex = r.getRowIndex() + 1;
                    while (this.tblMain.getCell(stepRowIndex, COLUMN_NAME_LATITUDE) != null && this.tblMain.getCell(stepRowIndex, COLUMN_NAME_LATITUDE).getValue() != null) {
                        if (this.tblMain.getCell(stepRowIndex, stepColIndex).getValue() == null) {
                            this.tblMain.getCell(stepRowIndex, stepColIndex).setValue((Object)0);
                        } else {
                            sum += ((Integer)this.tblMain.getCell(stepRowIndex, stepColIndex).getValue()).intValue();
                        }
                        ++stepRowIndex;
                    }
                    r.getCell(stepColIndex).setValue((Object)sum);
                    sum = 0;
                }
            }
        } else {
            for (indexY = 0; indexY < this.tblMain.getRowCount(); ++indexY) {
                sum = 0;
                for (indexX = 1; indexX < this.tblMain.getColumnCount(); ++indexX) {
                    if (this.tblMain.getCell(indexY, indexX).getValue() != null) continue;
                    this.tblMain.getCell(indexY, indexX).setValue((Object)0);
                }
            }
        }
    }

    private String getCustomerParamsStr(QuerySolutionInfo solution) {
        if (null != solution && null != solution.getQueryPanelInfo() && solution.getQueryPanelInfo().size() > 0) {
            int len = solution.getQueryPanelInfo().size();
            for (int i = 0; i < len; ++i) {
                if (null == solution.getQueryPanelInfo().get(i) || !PANEL_CLASSNAME.equals(solution.getQueryPanelInfo().get(i).getPanelClassName())) continue;
                return solution.getQueryPanelInfo().get(i).getCustomerParams();
            }
        }
        return null;
    }

    private FilterInfo createAddtionFilter(int type) {
        FilterInfo filter = null;
        switch (type) {
            case 0: {
                if (this.statusMap.get("gender") == null || (Integer)this.statusMap.get("gender") == 0) break;
                filter = new FilterInfo();
                if ((Integer)this.statusMap.get("gender") != 3) {
                    filter.getFilterItems().add(new FilterItemInfo("person.gender", (Object)((Integer)this.statusMap.get("gender")), CompareType.EQUALS));
                    break;
                }
                filter.getFilterItems().add(new FilterItemInfo("person.gender", (Object)1, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("person.gender", (Object)2, CompareType.EQUALS));
                filter.setMaskString("#0 or #1");
                break;
            }
            case 1: {
                if (this.statusMap.get("types") == null) break;
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("type.id", (Object)((HashSet)this.statusMap.get("types")), CompareType.INCLUDE));
            }
        }
        return filter;
    }

    public String getPropertyOfBizOrg(OrgType orgType) {
        return null;
    }

    protected boolean isUseStandardPermission() {
        return true;
    }

    protected void handleQueryDialog(CommonQueryDialog dialog) throws Exception {
        dialog.setUiObject(null);
    }
}

