/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.state.client;

import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox;
import com.kingdee.eas.hr.state.JobInjuryInfo;
import com.kingdee.eas.hr.state.client.AbstractJobInjuryEditUI;
import com.kingdee.eas.hr.state.client.HRStateTWOClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class JobInjuryEditUI
extends AbstractJobInjuryEditUI {
    private static final Logger logger = CoreUIObject.getLogger(JobInjuryEditUI.class);
    public static final String RES = "com.kingdee.eas.hr.state.JobInjuryResource";
    protected EmployeeMultiF7PromptBox employeeF7 = null;

    protected void afterOnLoad() throws Exception {
        super.afterOnLoad();
        this.initEmployeeF7();
        this.prmtapplicant.setSelector((KDPromptSelector)this.employeeF7);
        this.prmtapplicant.setEnabledMultiSelection(false);
        this.prmtapplicant.setEditable(false);
        this.prmtapplicant.setDisplayFormat("$name$");
        this.prmtapplicant.setEditFormat("$number$");
        this.prmtapplicant.setCommitFormat("$number$");
    }

    protected void initEmployeeF7() {
        if (this.employeeF7 == null) {
            this.employeeF7 = new EmployeeMultiF7PromptBox();
            this.employeeF7.setIsSingleSelect(true);
            this.employeeF7.setUserOrgRangeFilter(true);
            this.employeeF7.setEnabledMultiSelection(false);
            this.employeeF7.showNoPositionPerson(true);
        }
    }

    protected void beforeOnLoad() throws Exception {
        super.beforeOnLoad();
        this.initControls();
    }

    protected void initControls() {
        this.txtapplyPayment.setHorizontalAlignment(4);
        this.txtrealAmountPaid.setHorizontalAlignment(4);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        HRStateTWOClientUtils.verifyEmpty((CoreUIObject)this, RES, this.prmtapplicant, "APPLICANT_NOT_NULL");
        HRStateTWOClientUtils.verifyEmpty((CoreUIObject)this, RES, this.pkapplyDate, "APPLYDATE_NOT_NULL");
        HRStateTWOClientUtils.verifyEmpty((CoreUIObject)this, RES, this.pkoccurrenceTime, "OCCURTIME_NOT_NULL");
        HRStateTWOClientUtils.verifyEmpty((CoreUIObject)this, RES, this.pkdetermineDate, "DETERMINEDATE_NOT_NULL");
        HRStateTWOClientUtils.verifyEmpty((CoreUIObject)this, RES, this.prmtinjuryTypes, "TYPE_NOT_NULL");
        HRStateTWOClientUtils.verifyEmpty((CoreUIObject)this, RES, this.prmtInjuryRate, "RATE_NOT_NULL");
    }

    protected void loadJobInjuryInfo(JobInjuryInfo objectValue) {
        String recordId = null;
        Object temp = this.getUIContext().get("PersonID");
        if (temp != null) {
            recordId = temp.toString();
        }
        PersonInfo pInfo = null;
        PersonPositionInfo ppInfo = null;
        PositionInfo psInfo = null;
        AdminOrgUnitInfo adminOrg = null;
        try {
            pInfo = HRStateTWOClientUtils.getPersonInfo(BOSUuid.read((String)recordId));
            ppInfo = HRStateTWOClientUtils.getPersonPositionInfo(BOSUuid.read((String)recordId));
            psInfo = ppInfo.getPrimaryPosition();
            adminOrg = ppInfo.getPersonDep();
        }
        catch (Exception e) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"noPerson"));
            SysUtil.abort();
        }
        objectValue.setPerson(pInfo);
        objectValue.setPosition(psInfo);
        objectValue.setAdminOrg(adminOrg);
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
        JobInjuryInfo jobInjuryInfo = new JobInjuryInfo();
        this.loadJobInjuryInfo(jobInjuryInfo);
        this.editData.setAdminOrg(jobInjuryInfo.getAdminOrg());
        this.editData.setPosition(jobInjuryInfo.getPosition());
        this.editData.setPerson(jobInjuryInfo.getPerson());
        this.editData.setHrOrgUnit(jobInjuryInfo.getHrOrgUnit());
    }

    protected void initWorkButton() {
        super.initWorkButton();
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.actionAddNew.setVisible(false);
            this.actionEdit.setVisible(false);
            this.actionCopy.setVisible(false);
            this.actionSubmit.setVisible(false);
            this.actionRemove.setVisible(false);
        } else {
            this.actionAddNew.setVisible(true);
            this.actionEdit.setVisible(true);
            this.actionCopy.setVisible(true);
            this.actionSubmit.setVisible(true);
            this.actionRemove.setVisible(true);
        }
    }

    @Override
    protected IObjectValue createNewData() {
        JobInjuryInfo objectValue = new JobInjuryInfo();
        this.loadJobInjuryInfo(objectValue);
        return objectValue;
    }
}

