/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.state.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.hr.base.RewardPunishTypeInfo;
import com.kingdee.eas.hr.base.client.FilterUIUtil;
import com.kingdee.eas.hr.base.client.IHRF7CommonRegister;
import com.kingdee.eas.hr.state.client.AbstractPersonRPApprovalBillFilterUI;
import com.kingdee.eas.hr.state.client.PersonRPRepealBillFilterUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.Date;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class PersonRPApprovalBillFilterUI
extends AbstractPersonRPApprovalBillFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(PersonRPRepealBillFilterUI.class);
    private static final String RES = "com.kingdee.eas.hr.state.client.StateResource";

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.chkIncludeChild.setEnabled(false);
        this.btnEmployee.setSelected(true);
        this.chkLike.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PersonRPApprovalBillFilterUI.this.setSearchType();
            }
        });
        this.prmtAdminOrg.setEditable(false);
        this.prmtEmployee.setEditable(false);
        this.prmtHROrg.setEditable(false);
        this.prmtPosition.setEditable(false);
        this.prmtRPType.setEditable(false);
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = super.getCustomerParams();
        FilterUIUtil.saveAllData((CustomerParams)cp, (CustomerQueryPanel)this, null, (boolean)false);
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        FilterUIUtil.retriveAllData((CustomerParams)cp, (CustomerQueryPanel)this, null, (boolean)false);
    }

    public void clear() {
        super.clear();
        this.prmtEmployee.setValue(null);
        this.prmtAdminOrg.setValue(null);
        this.prmtPosition.setValue(null);
        this.prmtRPType.setValue(null);
        this.datePickerRPBeginDate.setValue(null);
        this.datePickerRPEndDate.setValue(null);
        this.btnDepartment.setSelected(false);
        this.btnEmployee.setSelected(true);
        this.btnPosition.setSelected(false);
        this.chkIncludeChild.setSelected(false);
        this.chkLike.setSelected(false);
        this.txEmployee.setText("");
    }

    public FilterInfo getFilterInfo() {
        Object position;
        Object rpType;
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection itemCollection = filterInfo.getFilterItems();
        FilterItemInfo itemInfo = null;
        if (this.datePickerRPBeginDate.getValue() != null) {
            itemInfo = new FilterItemInfo("appBillEntry.date", (Object)((Date)this.datePickerRPBeginDate.getValue()), CompareType.GREATER_EQUALS);
            itemCollection.add(itemInfo);
        }
        if (this.datePickerRPEndDate.getValue() != null) {
            itemInfo = new FilterItemInfo("appBillEntry.date", (Object)((Date)this.datePickerRPEndDate.getValue()), CompareType.LESS_EQUALS);
            itemCollection.add(itemInfo);
        }
        if ((rpType = this.prmtRPType.getValue()) != null && rpType instanceof RewardPunishTypeInfo) {
            itemInfo = new FilterItemInfo("appBillEntry.type.id", (Object)((RewardPunishTypeInfo)rpType).getId().toString(), CompareType.EQUALS);
            itemCollection.add(itemInfo);
        }
        if (this.btnEmployee.isSelected()) {
            Object employee = this.prmtEmployee.getData();
            this.setEmployeeFilter(this.chkLike.isSelected(), employee, filterInfo);
        } else if (this.btnDepartment.isSelected()) {
            Object adminOrg = this.prmtAdminOrg.getData();
            if (adminOrg != null && adminOrg instanceof AdminOrgUnitInfo) {
                this.setAdminOrgFilter(this.chkIncludeChild.isSelected(), (AdminOrgUnitInfo)adminOrg, filterInfo);
            }
        } else if (this.btnPosition.isSelected() && (position = this.prmtPosition.getData()) != null && position instanceof PositionInfo) {
            itemInfo = new FilterItemInfo("appBillEntry.position.id", (Object)((PositionInfo)position).getId(), CompareType.EQUALS);
            itemCollection.add(itemInfo);
        }
        return filterInfo;
    }

    public boolean verify() {
        Date endTime;
        Date beginTime;
        if (this.prmtHROrg.getValue() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"mustInputBillHrOrg"));
            this.prmtHROrg.requestFocus();
            SysUtil.abort();
        }
        if (this.datePickerRPBeginDate.getValue() != null && this.datePickerRPEndDate.getValue() != null && (beginTime = (Date)this.datePickerRPBeginDate.getValue()).after(endTime = (Date)this.datePickerRPEndDate.getValue())) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"EndDateMustLateBeginDate"));
            this.datePickerRPEndDate.requestFocus();
            SysUtil.abort();
        }
        return super.verify();
    }

    @Override
    protected void btnAdminOrg_stateChanged(ChangeEvent e) throws Exception {
        if (this.btnDepartment.isSelected()) {
            this.setSelect("department");
        }
    }

    @Override
    protected void btnEmployee_stateChanged(ChangeEvent e) throws Exception {
        if (this.btnEmployee.isSelected()) {
            this.setSelect("employee");
        }
    }

    @Override
    protected void btnPosition_stateChanged(ChangeEvent e) throws Exception {
        if (this.btnPosition.isSelected()) {
            this.setSelect("position");
        }
    }

    protected void initF7Context(IHRF7CommonRegister register) {
        super.initF7Context(register);
        register.registerAdminByOrgRangePromptBox(this.prmtAdminOrg);
        register.registerEmployeeMultiF7PromptBox(this.prmtEmployee, true);
        register.registerPositionPromptBox2(this.prmtPosition);
        this.prmtAdminOrg.setEditable(true);
        this.prmtEmployee.setEditable(true);
        this.prmtPosition.setEditable(true);
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.getMainOrg();
    }

    private void setAdminOrgFilter(boolean isIncludeChild, AdminOrgUnitInfo org, FilterInfo filter) {
        if (isIncludeChild) {
            if (filter.getFilterItems().size() > 0) {
                FilterInfo orgFilter = new FilterInfo();
                orgFilter.getFilterItems().add(new FilterItemInfo("adminOrg.longNumber", (Object)(org.getLongNumber() + "!%"), CompareType.LIKE));
                orgFilter.getFilterItems().add(new FilterItemInfo("adminOrg.number", (Object)org.getNumber(), CompareType.EQUALS));
                orgFilter.setMaskString("#0 or #1");
                try {
                    filter.mergeFilter(orgFilter, "and");
                }
                catch (BOSException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            } else {
                filter.getFilterItems().add(new FilterItemInfo("adminOrg.longNumber", (Object)(org.getLongNumber() + "!%"), CompareType.LIKE));
                filter.getFilterItems().add(new FilterItemInfo("adminOrg.number", (Object)org.getNumber(), CompareType.EQUALS));
                filter.setMaskString("#0 or #1");
            }
        } else {
            filter.getFilterItems().add(new FilterItemInfo("adminOrg.id", (Object)org.getId(), CompareType.EQUALS));
        }
    }

    private void setEmployeeFilter(boolean isLikeStyle, Object employee, FilterInfo filter) {
        if (isLikeStyle) {
            String condStr = this.txEmployee.getText();
            if (filter.getFilterItems().size() > 0) {
                FilterInfo employeeFilter = new FilterInfo();
                employeeFilter.getFilterItems().add(new FilterItemInfo("appBillEntry.person.number", (Object)("%" + condStr + "%"), CompareType.LIKE));
                employeeFilter.getFilterItems().add(new FilterItemInfo("appBillEntry.person.name", (Object)("%" + condStr + "%"), CompareType.LIKE));
                employeeFilter.setMaskString("#0 or #1");
                try {
                    filter.mergeFilter(employeeFilter, "and");
                }
                catch (BOSException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            } else {
                filter.getFilterItems().add(new FilterItemInfo("appBillEntry.person.number", (Object)("%" + condStr + "%"), CompareType.LIKE));
                filter.getFilterItems().add(new FilterItemInfo("appBillEntry.person.name", (Object)("%" + condStr + "%"), CompareType.LIKE));
                filter.setMaskString("#0 or #1");
            }
        } else if (employee != null && employee instanceof PersonInfo) {
            filter.getFilterItems().add(new FilterItemInfo("appBillEntry.person.id", (Object)((PersonInfo)employee).getId(), CompareType.EQUALS));
        }
    }

    private void setSearchType() {
        boolean style = this.chkLike.isSelected();
        if (style) {
            this.prmtEmployee.setValue(null);
            this.prmtEmployee.setEnabled(false);
            this.prmtEmployee.setVisible(false);
            this.txEmployee.setEnabled(true);
            this.txEmployee.setVisible(true);
        } else {
            this.prmtEmployee.setEnabled(true);
            this.prmtEmployee.setVisible(true);
            this.txEmployee.setText("");
            this.txEmployee.setEnabled(false);
            this.txEmployee.setVisible(false);
        }
    }

    private void setSelect(String selectType) {
        if (selectType.equals("department") && this.btnDepartment.isSelected()) {
            this.prmtAdminOrg.setEnabled(true);
            this.chkIncludeChild.setEnabled(true);
            this.chkIncludeChild.setSelected(false);
            this.chkLike.setSelected(false);
            this.chkLike.setEnabled(false);
            this.setSearchType();
            this.prmtEmployee.setEnabled(false);
            this.prmtEmployee.setValue(null);
            this.prmtPosition.setEnabled(false);
            this.prmtPosition.setValue(null);
        } else if (selectType.equals("employee") && this.btnEmployee.isSelected()) {
            this.chkLike.setEnabled(true);
            this.chkLike.setSelected(false);
            this.setSearchType();
            this.prmtAdminOrg.setEnabled(false);
            this.prmtAdminOrg.setValue(null);
            this.prmtPosition.setEnabled(false);
            this.prmtPosition.setValue(null);
            this.chkIncludeChild.setSelected(false);
            this.chkIncludeChild.setEnabled(false);
        } else if (selectType.equals("position") && this.btnPosition.isSelected()) {
            this.prmtPosition.setEnabled(true);
            this.chkLike.setSelected(false);
            this.chkLike.setEnabled(false);
            this.setSearchType();
            this.chkIncludeChild.setSelected(false);
            this.prmtEmployee.setEnabled(false);
            this.prmtEmployee.setValue(null);
            this.chkIncludeChild.setEnabled(false);
            this.prmtAdminOrg.setEnabled(false);
            this.prmtAdminOrg.setValue(null);
        }
    }
}

