/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.state.client;

import com.kingdee.bos.appframework.databinding.DataBinder;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.multiDetail.DetailPanel;
import com.kingdee.eas.framework.client.multiDetail.HMDUtils;
import com.kingdee.eas.hr.base.client.IHRBillEditUIBiz;
import com.kingdee.eas.hr.state.PersonRPRepBillEntryCollection;
import com.kingdee.eas.hr.state.PersonRPRepBillEntryInfo;
import com.kingdee.eas.hr.state.PersonRPRepBillFactory;
import com.kingdee.eas.hr.state.PersonRPRepBillInfo;
import com.kingdee.eas.hr.state.client.AbstractPersonRPRepBillEditUI;
import com.kingdee.eas.hr.state.client.HRStateClientUtils;
import com.kingdee.eas.hr.state.client.PersonRPRepBillEditUIBiz;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import org.apache.log4j.Logger;

public class PersonRPRepBillEditUI
extends AbstractPersonRPRepBillEditUI {
    protected static final String MessageRES = "com.kingdee.eas.hr.state.MessageResource";
    private static final Logger logger = CoreUIObject.getLogger(PersonRPRepBillEditUI.class);
    private static final String RES = "com.kingdee.eas.hr.state.client.StateResource";
    protected DetailPanel kdtEntrys_detailPanel;

    public PersonRPRepBillEditUI() throws Exception {
        this.initPromptBoxApprovalBill();
    }

    private void initPromptBoxApprovalBill() {
        KDBizPromptBox kdtEntrys_approvalBill_PromptBox = new KDBizPromptBox();
        kdtEntrys_approvalBill_PromptBox.setQueryInfo("-");
        kdtEntrys_approvalBill_PromptBox.setVisible(true);
        kdtEntrys_approvalBill_PromptBox.setEditable(true);
        kdtEntrys_approvalBill_PromptBox.setDisplayFormat("$number$");
        kdtEntrys_approvalBill_PromptBox.setEditFormat("$number$");
        kdtEntrys_approvalBill_PromptBox.setCommitFormat("$number$");
        KDTDefaultCellEditor kdtEntrys_approvalBill_CellEditor = new KDTDefaultCellEditor((IKDEditor)kdtEntrys_approvalBill_PromptBox);
        this.kdtEntrys.getColumn("approvalBill").setEditor((ICellEditor)kdtEntrys_approvalBill_CellEditor);
        ObjectValueRender kdtEntrys_approvalBill_OVR = new ObjectValueRender();
        kdtEntrys_approvalBill_OVR.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.kdtEntrys.getColumn("approvalBill").setRenderer((IBasicRender)kdtEntrys_approvalBill_OVR);
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        this.kdtEntrys.checkParsed();
        HRStateClientUtils.verifyEmpty((CoreUIObject)this, this.prmtAdminOrg);
        this.checkIntegrality();
        ((PersonRPRepBillEditUIBiz)this.biz).checkUnique();
        super.beforeStoreFields(e);
    }

    protected void beforeOnLoad() throws Exception {
        super.beforeOnLoad();
        this.kdtEntrys.checkParsed();
        ((PersonRPRepBillEditUIBiz)this.biz).initkdtEntrys((IUIObject)this);
        this.initkdtEntrysDetailPanel();
    }

    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (this.confirmAudit()) {
            super.actionAudit_actionPerformed(e);
        }
    }

    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        ((PersonRPRepBillEditUIBiz)this.biz).addLineByPersonF7(false);
    }

    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        ((PersonRPRepBillEditUIBiz)this.biz).addLineByPersonF7(true);
    }

    @Override
    protected void kdtEntrys_activeCellChanged(KDTActiveCellEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        if (rowIndex < 0) {
            return;
        }
        int colIndex = e.getColumnIndex();
        String fieldName = this.kdtEntrys.getColumnKey(colIndex);
        if ("approvalBill".equals(fieldName)) {
            this.btnColumnCopySelect.setEnabled(false);
            this.btnColumnCopyAll.setEnabled(false);
            this.menuItemColumnCopySelect.setEnabled(false);
            this.menuItemColumnCopyAll.setEnabled(false);
            Object value = this.kdtEntrys.getRow(rowIndex).getCell("person").getValue();
            PersonInfo personInfo = (PersonInfo)value;
            if (personInfo != null) {
                BOSUuid personID = personInfo.getId();
                ((PersonRPRepBillEditUIBiz)this.biz).filterPersonApprovalBill(personID);
            } else {
                ((PersonRPRepBillEditUIBiz)this.biz).filterPersonApprovalBill(null);
            }
        } else {
            this.btnColumnCopySelect.setEnabled(true);
            this.btnColumnCopyAll.setEnabled(true);
            this.menuItemColumnCopySelect.setEnabled(true);
            this.menuItemColumnCopyAll.setEnabled(true);
        }
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
    }

    @Override
    protected void setFieldsNull(AbstractObjectValue arg0) {
        PersonRPRepBillInfo bill = (PersonRPRepBillInfo)arg0;
        PersonRPRepBillEntryCollection entries = bill.getEntry();
        if (entries == null) {
            return;
        }
        for (int i = 0; i < entries.size(); ++i) {
            entries.get(i).setApprovalBill(null);
        }
        super.setFieldsNull(arg0);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        this.checkFullWidthBlank();
    }

    protected void checkFullWidthBlank() {
        String number = this.editData.getNumber();
        boolean checked = false;
        if (number != null && (checked = HRStateClientUtils.checkFull_width(number))) {
            MsgBox.showInfo((String)EASResource.getString((String)MessageRES, (String)"BillNumber_Not_Null"));
            SysUtil.abort();
        }
    }

    protected boolean confirmAudit() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.state.client.StateResource.Confirm_Audit")));
    }

    protected IHRBillEditUIBiz getBillBiz() {
        return new PersonRPRepBillEditUIBiz();
    }

    protected DetailPanel getIgnoredDetailPanel() {
        return this.kdtEntrys_detailPanel;
    }

    @Override
    protected IObjectValue createNewData() {
        return ((PersonRPRepBillEditUIBiz)this.biz).createNewData();
    }

    @Override
    protected KDTable getDetailTable() {
        return this.kdtEntrys;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return PersonRPRepBillFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        return null;
    }

    private void initkdtEntrysDetailPanel() {
        this.kdtEntrys_detailPanel = (DetailPanel)HMDUtils.buildDetail((CoreUI)this, (DataBinder)this.dataBinder, (KDTable)this.kdtEntrys, (AbstractObjectValue)new PersonRPRepBillEntryInfo(), null, (boolean)false);
        this.add((Component)this.kdtEntrys_detailPanel, new KDLayout.Constraints(10, 76, 830, 495, 15));
        this.kdtEntrys_detailPanel.setTitle(EASResource.getString((String)MessageRES, (String)"list"));
        ActionListener[] addNewActionLis = this.kdtEntrys_detailPanel.getAddNewLineButton().getActionListeners();
        this.kdtEntrys_detailPanel.getAddNewLineButton().removeActionListener(addNewActionLis[0]);
        this.kdtEntrys_detailPanel.getAddNewLineButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
                try {
                    ((PersonRPRepBillEditUIBiz)PersonRPRepBillEditUI.this.biz).addLineByPersonF7(false);
                }
                catch (Exception e1) {
                    MsgBox.showError((String)EASResource.getString((String)PersonRPRepBillEditUI.MessageRES, (String)"InitUIFail"));
                    SysUtil.abort();
                }
            }
        });
        ActionListener[] insertLineActionLis = this.kdtEntrys_detailPanel.getInsertLineButton().getActionListeners();
        this.kdtEntrys_detailPanel.getInsertLineButton().removeActionListener(insertLineActionLis[0]);
        this.kdtEntrys_detailPanel.getInsertLineButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
                try {
                    ((PersonRPRepBillEditUIBiz)PersonRPRepBillEditUI.this.biz).addLineByPersonF7(true);
                }
                catch (Exception e1) {
                    MsgBox.showError((String)EASResource.getString((String)PersonRPRepBillEditUI.MessageRES, (String)"InitUIFail"));
                    SysUtil.abort();
                }
            }
        });
    }

    private void checkIntegrality() {
        if (this.prmtHROrg.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"mustInputBillHrOrg"));
            this.txtNumber.requestFocus();
            SysUtil.abort();
        } else if (this.prmtAdminOrg.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"mustInputBillAdminOrg"));
            this.txtNumber.requestFocus();
            SysUtil.abort();
        } else if (StringUtils.isEmpty((String)this.txtNumber.getText()) && !this.isExistRule()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"mustInputBillNumber"));
            this.txtNumber.requestFocus();
            SysUtil.abort();
        } else {
            int count = this.kdtEntrys.getRowCount();
            if (count == 0) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"noEntry"));
                SysUtil.abort();
            }
            for (int i = 0; i < count; ++i) {
                if (this.kdtEntrys.getRow(i).getCell("person").getValue() == null) {
                    MsgBox.showInfo((Component)((Object)this), (String)(EASResource.getString((String)RES, (String)"the") + (i + 1) + EASResource.getString((String)RES, (String)"mustInputPerson")));
                    this.kdtEntrys.getSelectManager().select(i, this.kdtEntrys.getColumn("person").getColumnIndex());
                    SysUtil.abort();
                }
                if (this.kdtEntrys.getRow(i).getCell("approvalBill").getValue() == null) {
                    MsgBox.showInfo((Component)((Object)this), (String)(EASResource.getString((String)RES, (String)"the") + (i + 1) + EASResource.getString((String)RES, (String)"mustInputApprovalBill")));
                    this.kdtEntrys.getSelectManager().select(i, this.kdtEntrys.getColumn("approvalBill").getColumnIndex());
                    SysUtil.abort();
                }
                if (this.kdtEntrys.getRow(i).getCell("repealDate").getValue() == null) {
                    MsgBox.showInfo((Component)((Object)this), (String)(EASResource.getString((String)RES, (String)"the") + (i + 1) + EASResource.getString((String)RES, (String)"mustInputRepealDate")));
                    this.kdtEntrys.getSelectManager().select(i, this.kdtEntrys.getColumn("repealDate").getColumnIndex());
                    SysUtil.abort();
                }
                this.checkValidity(i);
            }
        }
    }

    private void checkValidity(int rowIndex) {
        Date getDate = (Date)this.kdtEntrys.getRow(rowIndex).getCell("date").getValue();
        Date repealDate = (Date)this.kdtEntrys.getRow(rowIndex).getCell("repealDate").getValue();
        if (getDate != null && repealDate != null && getDate.after(repealDate)) {
            MsgBox.showInfo((Component)((Object)this), (String)(EASResource.getString((String)RES, (String)"the") + (rowIndex + 1) + EASResource.getString((String)RES, (String)"repealDateMustAfterGetDate")));
            this.kdtEntrys.getRow(rowIndex).getCell("repealDate").setValue(null);
            SysUtil.abort();
        }
    }

    public boolean isExistRule() {
        if (this.editData.getNumber() == null) {
            try {
                String companyID = null;
                if (!StringUtils.isEmpty((String)"HRO") && !"NONE".equalsIgnoreCase("HRO") && SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)"HRO")) != null) {
                    companyID = SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)"HRO")).getString("id");
                } else if (SysContext.getSysContext().getCurrentOrgUnit() != null) {
                    companyID = SysContext.getSysContext().getCurrentOrgUnit().getString("id");
                }
                ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
                if (iCodingRuleManager.isExist((IObjectValue)this.editData, companyID)) {
                    return true;
                }
            }
            catch (Exception e) {
                this.handUIException(e);
                SysUtil.abort();
            }
        }
        return false;
    }

    @Override
    protected String getTDFileName() {
        return "/HR/state/rewardPunishApprovalBill";
    }
}

