/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.state.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.hr.base.client.HRBillEditUIBiz;
import com.kingdee.eas.hr.emp.IPersonRewardPunish;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.hr.emp.PersonRewardPunishCollection;
import com.kingdee.eas.hr.emp.PersonRewardPunishFactory;
import com.kingdee.eas.hr.state.IPersonRPAppBillEntry;
import com.kingdee.eas.hr.state.PersonRPAppBillEntryCollection;
import com.kingdee.eas.hr.state.PersonRPAppBillEntryFactory;
import com.kingdee.eas.hr.state.PersonRPAppBillInfo;
import com.kingdee.eas.hr.state.PersonRPRepBillEntryInfo;
import com.kingdee.eas.hr.state.PersonRPRepBillInfo;
import com.kingdee.eas.hr.state.client.HRStateClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class PersonRPRepBillEditUIBiz
extends HRBillEditUIBiz {
    private static Logger logger = Logger.getLogger(PersonRPRepBillEditUIBiz.class);
    private DataChangeListener prmtApprovalBillListener;
    private static final String RES = "com.kingdee.eas.hr.state.client.StateResource";
    protected final String MessageRES = "com.kingdee.eas.hr.state.MessageResource";
    protected KDBizPromptBox prmtApprovalBill;
    protected KDBizPromptBox prmtPerson;

    public void beforeStoreField(ActionEvent actionevent) throws Exception {
        super.beforeStoreField(actionevent);
    }

    protected void initEmpF7() {
        super.initEmpF7();
        this.empF7.showNoPositionPerson(true);
    }

    public void afterOnLoad() throws Exception {
        super.afterOnLoad();
    }

    public boolean isAddPersonByF7() {
        return true;
    }

    public String[] getMethodsSupportPlugIn() {
        return null;
    }

    protected IObjectValue createNewDetailData(PersonInfo personInfo) {
        PersonRPRepBillEntryInfo info = new PersonRPRepBillEntryInfo();
        PersonPositionInfo PPinfo = null;
        info.setPerson(personInfo);
        BOSUuid personID = personInfo.getId();
        try {
            PPinfo = HRStateClientUtils.getPersonPositionInfo(personID);
        }
        catch (Exception e) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.state.MessageResource", (String)"notPosition"));
            SysUtil.abort();
        }
        if (PPinfo != null) {
            info.setPosition(PPinfo.getPrimaryPosition());
            info.setAdminOrg(PPinfo.getPersonDep());
        }
        return info;
    }

    protected void initkdtEntrys(IUIObject owner) {
        this.prmtApprovalBill = new KDBizPromptBox();
        this.prmtApprovalBill.setQueryInfo("com.kingdee.eas.hr.state.app.PersonRPAppBillF7Query");
        this.prmtApprovalBill.setEditFormat("$number$");
        this.prmtApprovalBill.setDisplayFormat("$number$");
        this.prmtApprovalBill.setCommitFormat("$number$");
        KDTDefaultCellEditor approvalBillItemEditor = new KDTDefaultCellEditor((IKDEditor)this.prmtApprovalBill);
        this.kdtEntrys.getColumn("approvalBill").setEditor((ICellEditor)approvalBillItemEditor);
        this.prmtApprovalBillListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                PersonRPRepBillEditUIBiz.this.entryDataChanged("approvalBill", e);
            }
        };
        this.prmtApprovalBill.addDataChangeListener(this.prmtApprovalBillListener);
        KDDatePicker repealDatePicker = new KDDatePicker();
        this.kdtEntrys.getColumn("repealDate").setEditor((ICellEditor)new KDTDefaultCellEditor(repealDatePicker));
        this.kdtEntrys.getColumn("repealDate").getStyleAttributes().setNumberFormat("yyyy-MM-dd");
    }

    private void entryDataChanged(String fieldName, DataChangeEvent e) {
        KDTable tb = this.kdtEntrys;
        KDTSelectBlock selected = tb.getSelectManager().get();
        Object oldValue = e.getOldValue();
        Object newValue = e.getNewValue();
        if (selected == null || newValue != null && oldValue != null && newValue.equals(oldValue)) {
            return;
        }
        int rowIndex = selected.getBeginRow();
        if ("approvalBill".equals(fieldName)) {
            this.getByApprovalBill(oldValue, newValue, rowIndex);
        }
    }

    protected IObjectValue createNewData() {
        PersonRPRepBillInfo personRPRepBillInfo = new PersonRPRepBillInfo();
        personRPRepBillInfo.setHrOrgUnit(SysContext.getSysContext().getCurrentHRUnit());
        personRPRepBillInfo.setAdminOrg(SysContext.getSysContext().getCurrentAdminUnit());
        personRPRepBillInfo.setFillPerson(SysContext.getSysContext().getCurrentUserInfo().getPerson());
        Date d = new Date();
        personRPRepBillInfo.setFillDate(d);
        return personRPRepBillInfo;
    }

    private void getByApprovalBill(Object oldValue, Object newValue, int rowIndex) {
        if (newValue != null) {
            int i;
            PersonRPAppBillInfo personRPAppBill = (PersonRPAppBillInfo)newValue;
            PersonInfo personInfo = (PersonInfo)this.kdtEntrys.getRow(rowIndex).getCell("person").getValue();
            IPersonRPAppBillEntry personRPAppBillEntry = null;
            try {
                personRPAppBillEntry = PersonRPAppBillEntryFactory.getRemoteInstance();
            }
            catch (BOSException e2) {
                logger.error((Object)e2.getMessage());
            }
            PersonRPAppBillEntryCollection coll = null;
            String oql = "select date,content,type.name where appBill.id = '" + personRPAppBill.getId() + "' and person.id='" + personInfo.getId() + "'";
            try {
                if (personRPAppBillEntry != null) {
                    coll = personRPAppBillEntry.getPersonRPAppBillEntryCollection(oql);
                }
            }
            catch (BOSException e2) {
                logger.error((Object)e2.getMessage());
            }
            if (coll != null && coll.size() > 0 && (i = 0) < coll.size()) {
                this.kdtEntrys.getRow(rowIndex).getCell("date").setValue((Object)coll.get(i).getDate());
                this.kdtEntrys.getRow(rowIndex).getCell("content").setValue((Object)coll.get(i).getContent());
                this.kdtEntrys.getRow(rowIndex).getCell("type").setValue((Object)coll.get(i).getType());
            }
        } else {
            this.kdtEntrys.getRow(rowIndex).getCell("date").setValue(null);
            this.kdtEntrys.getRow(rowIndex).getCell("content").setValue(null);
            this.kdtEntrys.getRow(rowIndex).getCell("type").setValue(null);
        }
    }

    protected void filterPersonApprovalBill(BOSUuid personID) throws Exception {
        EntityViewInfo personApprovalBillViewInfo = new EntityViewInfo();
        FilterInfo personApprovalBillFilter = new FilterInfo();
        if (personID != null) {
            EntityViewInfo personRewardPunishViewInfo = new EntityViewInfo();
            FilterInfo personRewardPunishFilter = new FilterInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            personRewardPunishFilter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personID.toString(), CompareType.EQUALS));
            personRewardPunishFilter.getFilterItems().add(new FilterItemInfo("personRPAppBill.id", null, CompareType.NOTEQUALS));
            personRewardPunishFilter.getFilterItems().add(new FilterItemInfo("isSelect", (Object)"0", CompareType.EQUALS));
            personRewardPunishFilter.getFilterItems().add(new FilterItemInfo("repealDate", null, CompareType.EQUALS));
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("personRPAppBill.id"));
            personRewardPunishViewInfo.setSelector(sic);
            personRewardPunishViewInfo.setFilter(personRewardPunishFilter);
            IPersonRewardPunish iDao = PersonRewardPunishFactory.getRemoteInstance();
            PersonRewardPunishCollection personRewardPunishCollection = iDao.getPersonRewardPunishCollection(personRewardPunishViewInfo);
            HashSet<String> personRPAppBillIdList = new HashSet<String>();
            if (personRewardPunishCollection != null) {
                for (int i = 0; i < personRewardPunishCollection.size(); ++i) {
                    personRPAppBillIdList.add(personRewardPunishCollection.get(i).getPersonRPAppBill().getId().toString());
                }
            }
            personApprovalBillFilter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personID.toString(), CompareType.EQUALS));
            personApprovalBillFilter.getFilterItems().add(new FilterItemInfo("billState", (Object)HRBillStateEnum.AUDITED.getValue(), CompareType.EQUALS));
            personApprovalBillFilter.getFilterItems().add(new FilterItemInfo("id", personRPAppBillIdList, CompareType.INCLUDE));
            personApprovalBillFilter.setMaskString("#0 and #1 and #2");
        } else {
            personApprovalBillFilter.getFilterItems().add(new FilterItemInfo("person.id", (Object)"", CompareType.EQUALS));
            personApprovalBillFilter.getFilterItems().add(new FilterItemInfo("billState", (Object)HRBillStateEnum.AUDITED.getValue(), CompareType.EQUALS));
            personApprovalBillFilter.setMaskString("#0 and #1 and #2");
        }
        personApprovalBillViewInfo.setFilter(personApprovalBillFilter);
        this.prmtApprovalBill.setEntityViewInfo(personApprovalBillViewInfo);
    }

    protected void checkUnique() {
        int count = this.kdtEntrys.getRowCount();
        PersonInfo personA = null;
        PersonInfo personB = null;
        PersonRPAppBillInfo personRPAppBillInfoA = null;
        PersonRPAppBillInfo personRPAppBillInfoB = null;
        if (this.kdtEntrys.getRowCount() > 1) {
            for (int i = 0; i < count; ++i) {
                personRPAppBillInfoA = (PersonRPAppBillInfo)this.kdtEntrys.getRow(i).getCell("approvalBill").getValue();
                personA = (PersonInfo)this.kdtEntrys.getRow(i).getCell("person").getValue();
                for (int j = i + 1; j < count; ++j) {
                    personB = (PersonInfo)this.kdtEntrys.getRow(j).getCell("person").getValue();
                    personRPAppBillInfoB = (PersonRPAppBillInfo)this.kdtEntrys.getRow(j).getCell("approvalBill").getValue();
                    if (!personA.getId().toString().equals(personB.getId().toString()) || !personRPAppBillInfoA.getId().toString().equals(personRPAppBillInfoB.getId().toString())) continue;
                    MsgBox.showInfo((Component)this.ctx.getUI(), (String)(EASResource.getString((String)RES, (String)"the") + (i + 1) + EASResource.getString((String)RES, (String)"row") + EASResource.getString((String)RES, (String)"and") + EASResource.getString((String)RES, (String)"the") + (j + 1) + EASResource.getString((String)RES, (String)"row") + EASResource.getString((String)RES, (String)"personAndAppBiilRepeat")));
                    SysUtil.abort();
                }
            }
        }
    }

    protected String[] getNotNullColumn() {
        String[] strCol = new String[]{this.getPersonCol(), this.getApprovalBillCol(), this.getRepealDateCol()};
        return strCol;
    }

    protected String[] getNotDupColumn() {
        String[] strCol = new String[]{this.getPersonCol()};
        return strCol;
    }

    protected String getPersonCol() {
        return "person";
    }

    protected String getApprovalBillCol() {
        return "approvalBill";
    }

    protected String getRepealDateCol() {
        return "repealDate";
    }
}

