/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.state.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitFactory;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.RewardPunishTypeFactory;
import com.kingdee.eas.hr.base.RewardPunishTypeInfo;
import com.kingdee.eas.hr.base.client.IHRF7CommonRegister;
import com.kingdee.eas.hr.state.client.AbstractPersonRPStatFilterUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class PersonRPStatFilterUI
extends AbstractPersonRPStatFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(PersonRPStatFilterUI.class);
    private static final String RES = "com.kingdee.eas.hr.state.client.StateResource";
    public static final String LATITUDE_TYPE_DEPARTMENT = "department";
    public static final String LATITUDE_TYPE_POSITION = "position";
    public static final String LATITUDE_TYPE_EMPLOYEE = "employee";
    private String latitudeType;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.chkIncludeChild.setEnabled(false);
        this.btnEmployee.setSelected(true);
        this.latitudeType = LATITUDE_TYPE_EMPLOYEE;
        this.chkLike.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PersonRPStatFilterUI.this.setSearchType();
            }
        });
        this.prmtDepartment.setEditable(false);
        this.prmtEmployee.setEditable(false);
        this.prmtHROrg.setEditable(false);
        this.prmtPosition.setEditable(false);
        this.prmtRPType.setEditable(false);
    }

    @Override
    protected void btnDepartment_stateChanged(ChangeEvent e) throws Exception {
        if (this.btnDepartment.isSelected()) {
            this.setSelect(LATITUDE_TYPE_DEPARTMENT);
        }
    }

    @Override
    protected void btnEmployee_stateChanged(ChangeEvent e) throws Exception {
        if (this.btnEmployee.isSelected()) {
            this.setSelect(LATITUDE_TYPE_EMPLOYEE);
        }
    }

    @Override
    protected void btnPosition_stateChanged(ChangeEvent e) throws Exception {
        if (this.btnPosition.isSelected()) {
            this.setSelect(LATITUDE_TYPE_POSITION);
        }
    }

    public void clear() {
        super.clear();
        this.prmtEmployee.setValue(null);
        this.prmtDepartment.setValue(null);
        this.prmtPosition.setValue(null);
        this.prmtRPType.setValue(null);
        this.dateBegin.setValue(null);
        this.dateEnd.setValue(null);
        this.btnDepartment.setSelected(false);
        this.btnEmployee.setSelected(true);
        this.btnPosition.setSelected(false);
        this.chkIncludeChild.setSelected(false);
        this.chkLike.setSelected(false);
        this.txEmployee.setText("");
    }

    public boolean verify() {
        Date endTime;
        Date beginTime;
        if (this.prmtHROrg.getValue() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"mustInputBillHrOrg"));
            this.prmtHROrg.requestFocus();
            SysUtil.abort();
        }
        if (this.dateBegin.getValue() != null && this.dateEnd.getValue() != null && (beginTime = (Date)this.dateBegin.getValue()).after(endTime = (Date)this.dateEnd.getValue())) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"EndDateMustLateBeginDate"));
            this.dateEnd.requestFocus();
            SysUtil.abort();
        }
        return super.verify();
    }

    protected void initF7Context(IHRF7CommonRegister register) {
        super.initF7Context(register);
        register.registerAdminByOrgRangePromptBox(this.prmtDepartment);
        register.registerEmployeeMultiF7PromptBox(this.prmtEmployee, true);
        register.registerPositionPromptBox2(this.prmtPosition);
        this.prmtDepartment.setEditable(true);
        this.prmtEmployee.setEditable(true);
        this.prmtPosition.setEditable(true);
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.getMainOrg();
    }

    private void setSearchType() {
        boolean style = this.chkLike.isSelected();
        if (style) {
            this.prmtEmployee.setValue(null);
            this.prmtEmployee.setEnabled(false);
            this.prmtEmployee.setVisible(false);
            this.txEmployee.setEnabled(true);
            this.txEmployee.setVisible(true);
        } else {
            this.prmtEmployee.setEnabled(true);
            this.prmtEmployee.setVisible(true);
            this.txEmployee.setText("");
            this.txEmployee.setEnabled(false);
            this.txEmployee.setVisible(false);
        }
    }

    private void setSelect(String selectType) {
        if (selectType.equals(LATITUDE_TYPE_DEPARTMENT) && this.btnDepartment.isSelected()) {
            this.prmtDepartment.setEnabled(true);
            this.chkIncludeChild.setEnabled(true);
            this.chkIncludeChild.setSelected(false);
            this.chkLike.setSelected(false);
            this.chkLike.setEnabled(false);
            this.setSearchType();
            this.prmtEmployee.setEnabled(false);
            this.prmtEmployee.setValue(null);
            this.prmtPosition.setEnabled(false);
            this.prmtPosition.setValue(null);
            this.latitudeType = LATITUDE_TYPE_DEPARTMENT;
        } else if (selectType.equals(LATITUDE_TYPE_EMPLOYEE) && this.btnEmployee.isSelected()) {
            this.chkLike.setEnabled(true);
            this.chkLike.setSelected(false);
            this.setSearchType();
            this.prmtDepartment.setEnabled(false);
            this.prmtDepartment.setValue(null);
            this.chkIncludeChild.setSelected(false);
            this.chkIncludeChild.setEnabled(false);
            this.prmtPosition.setEnabled(false);
            this.prmtPosition.setValue(null);
            this.latitudeType = LATITUDE_TYPE_EMPLOYEE;
        } else if (selectType.equals(LATITUDE_TYPE_POSITION) && this.btnPosition.isSelected()) {
            this.prmtPosition.setEnabled(true);
            this.chkLike.setSelected(false);
            this.chkLike.setEnabled(false);
            this.setSearchType();
            this.chkIncludeChild.setSelected(false);
            this.prmtEmployee.setEnabled(false);
            this.prmtEmployee.setValue(null);
            this.chkIncludeChild.setEnabled(false);
            this.prmtDepartment.setEnabled(false);
            this.prmtDepartment.setValue(null);
            this.latitudeType = LATITUDE_TYPE_POSITION;
        }
    }

    public Map getParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("latitudeType", this.latitudeType);
        if (this.btnDepartment.isSelected()) {
            params.put("isIncludeChild", this.chkIncludeChild.isSelected());
            if (this.prmtDepartment.getValue() != null) {
                AdminOrgUnitInfo org = (AdminOrgUnitInfo)this.prmtDepartment.getValue();
                params.put("adminOrg.id", org.getId().toString());
                params.put("adminOrg.longNumber", org.getLongNumber());
            }
        }
        if (this.btnEmployee.isSelected()) {
            boolean isLike = this.chkLike.isSelected();
            params.put("isLike", isLike);
            if (!isLike) {
                if (this.prmtEmployee.getValue() != null) {
                    PersonInfo person = (PersonInfo)this.prmtEmployee.getValue();
                    params.put("person.id", person.getId().toString());
                }
            } else {
                params.put("personText", this.txEmployee.getText());
            }
        }
        if (this.btnPosition.isSelected() && this.prmtPosition.getValue() != null) {
            PositionInfo position = (PositionInfo)this.prmtPosition.getValue();
            params.put("position.id", position.getId().toString());
        }
        if (this.prmtHROrg.getValue() != null) {
            HROrgUnitInfo hrOrg = (HROrgUnitInfo)this.prmtHROrg.getValue();
            params.put("hrOrgUnit.id", hrOrg.getId().toString());
        }
        if (this.prmtRPType.getValue() != null) {
            Object[] dataArray = (Object[])this.prmtRPType.getValue();
            HashSet<String> typeIDSet = new HashSet<String>();
            for (int i = 0; i < dataArray.length; ++i) {
                typeIDSet.add(((RewardPunishTypeInfo)dataArray[i]).getId().toString());
            }
            params.put("types", typeIDSet);
        }
        if (this.dateBegin.getValue() != null) {
            params.put("beginDate", (Date)this.dateBegin.getValue());
        }
        if (this.dateEnd.getValue() != null) {
            params.put("endDate", (Date)this.dateEnd.getValue());
        }
        return params;
    }

    public FilterInfo getFilterInfo() {
        Object position;
        Object value;
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection itemCollection = filterInfo.getFilterItems();
        FilterItemInfo itemInfo = null;
        if (this.dateBegin.getValue() != null) {
            itemInfo = new FilterItemInfo("occurDate", (Object)((Date)this.dateBegin.getValue()), CompareType.GREATER_EQUALS);
            itemCollection.add(itemInfo);
        }
        if (this.dateEnd.getValue() != null) {
            itemInfo = new FilterItemInfo("occurDate", (Object)((Date)this.dateEnd.getValue()), CompareType.LESS_EQUALS);
            itemCollection.add(itemInfo);
        }
        if ((value = this.prmtRPType.getValue()) != null) {
            Object[] dataArray = (Object[])value;
            HashSet<String> set = new HashSet<String>();
            if (dataArray.length > 0 && dataArray[0] != null && dataArray[0] instanceof RewardPunishTypeInfo) {
                for (int i = 0; i < dataArray.length; ++i) {
                    if (dataArray[i] == null || !(dataArray[i] instanceof RewardPunishTypeInfo)) continue;
                    set.add(((RewardPunishTypeInfo)dataArray[i]).getId().toString());
                }
                if (set.size() > 0) {
                    itemInfo = new FilterItemInfo("type.id", set, CompareType.INCLUDE);
                    itemCollection.add(itemInfo);
                }
            }
        }
        if (this.btnEmployee.isSelected()) {
            Object employee = this.prmtEmployee.getData();
            this.setEmployeeFilter(this.chkLike.isSelected(), employee, filterInfo);
        } else if (this.btnDepartment.isSelected()) {
            Object adminOrg = this.prmtDepartment.getData();
            if (adminOrg != null && adminOrg instanceof AdminOrgUnitInfo) {
                this.setAdminOrgFilter(this.chkIncludeChild.isSelected(), (AdminOrgUnitInfo)adminOrg, filterInfo);
            }
        } else if (this.btnPosition.isSelected() && (position = this.prmtPosition.getData()) != null && position instanceof PositionInfo) {
            itemInfo = new FilterItemInfo("position.id", (Object)((PositionInfo)position).getId(), CompareType.EQUALS);
            itemCollection.add(itemInfo);
        }
        FilterInfo timeFilter = new FilterInfo();
        if (this.dateBegin.getValue() != null) {
            timeFilter.getFilterItems().add(new FilterItemInfo("repealDate", (Object)((Date)this.dateBegin.getValue()), CompareType.LESS));
        }
        if (this.dateEnd.getValue() != null) {
            timeFilter.getFilterItems().add(new FilterItemInfo("repealDate", (Object)((Date)this.dateEnd.getValue()), CompareType.GREATER));
        }
        timeFilter.getFilterItems().add(new FilterItemInfo("repealDate", null, CompareType.IS));
        if (timeFilter.getFilterItems().size() == 2) {
            timeFilter.setMaskString("#0 or #1");
        } else if (timeFilter.getFilterItems().size() == 3) {
            timeFilter.setMaskString("#0 or #1 or #2");
        }
        if (timeFilter.getFilterItems().size() > 0) {
            try {
                filterInfo.mergeFilter(timeFilter, "and");
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        return filterInfo;
    }

    private void setAdminOrgFilter(boolean isIncludeChild, AdminOrgUnitInfo org, FilterInfo filter) {
        if (isIncludeChild) {
            if (filter.getFilterItems().size() > 0) {
                FilterInfo orgFilter = new FilterInfo();
                orgFilter.getFilterItems().add(new FilterItemInfo("adminOrg.longNumber", (Object)(org.getLongNumber() + "!%"), CompareType.LIKE));
                orgFilter.getFilterItems().add(new FilterItemInfo("adminOrg.number", (Object)org.getNumber(), CompareType.EQUALS));
                orgFilter.setMaskString("#0 or #1");
                try {
                    filter.mergeFilter(orgFilter, "and");
                }
                catch (BOSException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            } else {
                filter.getFilterItems().add(new FilterItemInfo("adminOrg.longNumber", (Object)(org.getLongNumber() + "!%"), CompareType.LIKE));
                filter.getFilterItems().add(new FilterItemInfo("adminOrg.number", (Object)org.getNumber(), CompareType.EQUALS));
                filter.setMaskString("#0 or #1");
            }
        } else {
            filter.getFilterItems().add(new FilterItemInfo("adminOrg.id", (Object)org.getId(), CompareType.EQUALS));
        }
    }

    private void setEmployeeFilter(boolean isLikeStyle, Object employee, FilterInfo filter) {
        if (isLikeStyle) {
            String condStr = this.txEmployee.getText();
            if (filter.getFilterItems().size() > 0) {
                FilterInfo employeeFilter = new FilterInfo();
                employeeFilter.getFilterItems().add(new FilterItemInfo("person.number", (Object)("%" + condStr + "%"), CompareType.LIKE));
                employeeFilter.getFilterItems().add(new FilterItemInfo("person.name", (Object)("%" + condStr + "%"), CompareType.LIKE));
                employeeFilter.setMaskString("#0 or #1");
                try {
                    filter.mergeFilter(employeeFilter, "and");
                }
                catch (BOSException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            } else {
                filter.getFilterItems().add(new FilterItemInfo("person.number", (Object)("%" + condStr + "%"), CompareType.LIKE));
                filter.getFilterItems().add(new FilterItemInfo("person.name", (Object)("%" + condStr + "%"), CompareType.LIKE));
                filter.setMaskString("#0 or #1");
            }
        } else if (employee != null && employee instanceof PersonInfo) {
            filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)((PersonInfo)employee).getId(), CompareType.EQUALS));
        }
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        ObjectUuidPK pk = null;
        this.latitudeType = cp.getCustomerParam("latitudeType");
        if (this.latitudeType.equals(LATITUDE_TYPE_DEPARTMENT)) {
            this.btnDepartment.setSelected(true);
            if (cp.getCustomerParam("adminOrg.id") != null) {
                AdminOrgUnitInfo adminOrg = null;
                pk = new ObjectUuidPK(BOSUuid.read((String)cp.getCustomerParam("adminOrg.id")));
                try {
                    adminOrg = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)pk);
                }
                catch (EASBizException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
                catch (BOSException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
                this.prmtDepartment.setData((Object)adminOrg);
            }
            this.chkIncludeChild.setSelected(cp.getBoolean("isIncludeChild"));
        } else if (this.latitudeType.equals(LATITUDE_TYPE_EMPLOYEE)) {
            this.btnEmployee.setSelected(true);
            this.chkLike.setSelected(cp.getBoolean("isLike"));
            if (!this.chkLike.isSelected()) {
                if (cp.getCustomerParam("person.id") != null) {
                    PersonInfo person = null;
                    pk = new ObjectUuidPK(BOSUuid.read((String)cp.getCustomerParam("person.id")));
                    try {
                        person = PersonFactory.getRemoteInstance().getPersonInfo((IObjectPK)pk);
                    }
                    catch (EASBizException e) {
                        ExceptionHandler.handle((Throwable)e);
                    }
                    catch (BOSException e) {
                        ExceptionHandler.handle((Throwable)e);
                    }
                    this.prmtEmployee.setValue((Object)person);
                }
            } else {
                this.txEmployee.setText(cp.getCustomerParam("person.name"));
            }
        } else if (this.latitudeType.equals(LATITUDE_TYPE_POSITION)) {
            this.btnPosition.setSelected(true);
            if (cp.getCustomerParam("position.id") != null) {
                PositionInfo position = null;
                pk = new ObjectUuidPK(BOSUuid.read((String)cp.getCustomerParam("position.id")));
                try {
                    position = PositionFactory.getRemoteInstance().getPositionInfo((IObjectPK)pk);
                }
                catch (EASBizException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
                catch (BOSException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
                this.prmtPosition.setValue((Object)position);
            }
        }
        if (cp.getCustomerParam("hrOrg.id") != null) {
            HROrgUnitInfo hrOrg = null;
            pk = new ObjectUuidPK(BOSUuid.read((String)cp.getCustomerParam("hrOrg.id")));
            try {
                hrOrg = HROrgUnitFactory.getRemoteInstance().getHROrgUnitInfo((IObjectPK)pk);
            }
            catch (EASBizException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            this.prmtHROrg.setValue((Object)hrOrg);
        }
        if (cp.getInt("typeCount") != 0) {
            int count = cp.getInt("typeCount");
            Object[] dataArray = new Object[count];
            RewardPunishTypeInfo rpType = null;
            for (int i = 0; i < count; ++i) {
                String id = cp.getCustomerParam("type.id" + i);
                pk = new ObjectUuidPK(BOSUuid.read((String)id));
                try {
                    rpType = RewardPunishTypeFactory.getRemoteInstance().getRewardPunishTypeInfo((IObjectPK)pk);
                }
                catch (EASBizException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
                catch (BOSException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
                dataArray[i] = rpType;
            }
            this.prmtRPType.setValue((Object)dataArray);
        }
        if (cp.getDate("beginDate") != null) {
            this.dateBegin.setValue((Object)cp.getDate("beginDate"));
        }
        if (cp.getDate("endDate") != null) {
            this.dateEnd.setValue((Object)cp.getDate("endDate"));
        }
    }

    public CustomerParams getCustomerParams() {
        CustomerParams params = super.getCustomerParams();
        if (this.btnDepartment.isSelected()) {
            if (this.prmtDepartment.getValue() != null) {
                params.addCustomerParam("adminOrg.id", ((AdminOrgUnitInfo)this.prmtDepartment.getValue()).getId().toString());
            }
            params.putBoolean("isIncludeChild", this.chkIncludeChild.isSelected());
            params.addCustomerParam("latitudeType", LATITUDE_TYPE_DEPARTMENT);
        } else if (this.btnEmployee.isSelected()) {
            boolean isLike = this.chkLike.isSelected();
            params.putBoolean("isLike", isLike);
            if (!isLike) {
                if (this.prmtEmployee.getValue() != null) {
                    params.addCustomerParam("person.id", ((PersonInfo)this.prmtEmployee.getValue()).getId().toString());
                }
            } else {
                params.addCustomerParam("person.name", this.txEmployee.getText());
            }
            params.addCustomerParam("latitudeType", LATITUDE_TYPE_EMPLOYEE);
        } else if (this.btnPosition.isSelected()) {
            if (this.prmtPosition.getValue() != null) {
                params.addCustomerParam("position.id", ((PositionInfo)this.prmtPosition.getValue()).getId().toString());
            }
            params.addCustomerParam("latitudeType", LATITUDE_TYPE_POSITION);
        }
        if (this.prmtHROrg.getValue() != null) {
            params.addCustomerParam("hrOrg.id", ((HROrgUnitInfo)this.prmtHROrg.getValue()).getId().toString());
        }
        if (this.prmtRPType.getValue() != null) {
            Object[] dataArray = (Object[])this.prmtRPType.getValue();
            int i = 0;
            for (i = 0; i < dataArray.length; ++i) {
                if (!(dataArray[i] instanceof RewardPunishTypeInfo)) continue;
                params.addCustomerParam("type.id" + i, ((RewardPunishTypeInfo)dataArray[i]).getId().toString());
            }
            params.putInt("typeCount", i);
        }
        if (this.dateBegin.getValue() != null) {
            params.putDate("beginDate", (Date)this.dateBegin.getValue());
        }
        if (this.dateEnd.getValue() != null) {
            params.putDate("endDate", (Date)this.dateEnd.getValue());
        }
        return params;
    }

    public String getPermissionItem() {
        return "PersonRPStatList_View";
    }
}

