/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.state.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.client.servicebinding.ActionProxyFactory;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.hraux.util.HRTreeUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.context.IMultiOrgSupport;
import com.kingdee.eas.hr.base.OutputExcelUtil;
import com.kingdee.eas.hr.base.RewardPunishTypeInfo;
import com.kingdee.eas.hr.emp.client.HRCellTreeRenderer;
import com.kingdee.eas.hr.emp.client.HRCellUserObject;
import com.kingdee.eas.hr.emp.client.HRTreeTable;
import com.kingdee.eas.hr.state.client.AbstractPersonRPStatListUI;
import com.kingdee.eas.hr.state.client.PersonRPStatFilterManager;
import com.kingdee.eas.hr.state.client.PersonRPStatFilterUI;
import com.kingdee.eas.hr.state.client.PersonRPStatUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.UuidException;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.Action;
import org.apache.log4j.Logger;

public class PersonRPStatListUI
extends AbstractPersonRPStatListUI {
    private static final Logger logger = CoreUIObject.getLogger(PersonRPStatListUI.class);
    private static final String RES = "com.kingdee.eas.hr.state.client.StateResource";
    private static final String PANEL_CLASSNAME = "com.kingdee.eas.hr.state.client.PersonRPStatFilterUI";
    private PersonRPStatFilterManager filterManager;
    private HashMap latitudeMap;
    private HashMap rpTypeMap;
    private String adminId;
    private DefaultKingdeeTreeNode childNode = null;
    private List rpType;

    protected void afterOnLoad() throws Exception {
        super.afterOnLoad();
        HRTreeTable.setHRTreeTable((KDTable)this.tblMain, (String)"treeColumn");
        this.tblMain.checkParsed();
        this.tblMain.setEditable(false);
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.setAutoscrolls(true);
        this.enableExportExcel(this.tblMain);
        this.tHelper.getDisabledTables().add(this.tblMain);
    }

    protected void initListener() {
    }

    public void initTableListner(KDTable table) {
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.menuItemExportData.setAction((Action)((IItemAction)ActionProxyFactory.getProxy((Object)this.actionExport, (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
        this.btnExport.setAction((Action)((IItemAction)ActionProxyFactory.getProxy((Object)this.actionExport, (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
        this.btnExport.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.btnExport.setText("");
        this.btnExport.setToolTipText(this.resHelper.getString("btnExport.toolTipText"));
        this.menuItemPageSetup.setVisible(true);
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected boolean isAllowDefaultSolutionNull() {
        return false;
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.refreshData();
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().print();
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().printPreview();
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        OutputExcelUtil excelUtil = new OutputExcelUtil();
        if (excelUtil.appendToExcel(this.tblMain, true, true, this.getUITitle()) != null) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"EXPORT_SUCCESS"));
        }
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        if (this.getDialog() != null) {
            if (this.filterManager == null) {
                this.filterManager = new PersonRPStatFilterManager(this.getDialog());
            } else {
                this.filterManager.reloadData(this.getDialog());
            }
            this.loadDatas();
        } else {
            IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
            PersonRPStatFilterUI filterUI = new PersonRPStatFilterUI();
            QuerySolutionInfo solution = iQuery.getDefaultSolution(this.getMetaDataPK().getFullName(), "com.kingdee.eas.hr.state.app.PersonRPStatFilterQuery");
            CustomerParams params = CustomerParams.getCustomerParams2((String)this.getCustomerParamsStr(solution));
            if (params != null) {
                filterUI.setCustomerParams(params);
                if (this.filterManager == null) {
                    this.filterManager = new PersonRPStatFilterManager(filterUI);
                } else {
                    this.filterManager.reloadData(filterUI);
                }
                this.loadDatas();
            }
        }
    }

    protected void handleQueryDialog(CommonQueryDialog dialog) throws Exception {
        super.handleQueryDialog(dialog);
        dialog.setUiObject(null);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected String getEditUIName() {
        return null;
    }

    protected IMultiOrgSupport getMainCustomerQueryPanel() {
        try {
            return new PersonRPStatFilterUI();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
            return null;
        }
    }

    private void resetTable() {
        this.tblMain.removeRows();
        int count = this.tblMain.getColumnCount();
        for (int i = count - 1; i > -1; --i) {
            this.tblMain.removeColumn(i);
        }
        this.tblMain.getHead().removeRows();
    }

    private void refreshData() {
        this.loadDatas();
    }

    private void loadDatas() {
        this.resetTable();
        this.tblMain.addColumn();
        if (this.filterManager.getLatitudeType().equals("department") && this.filterManager.isIncludeChild()) {
            this.tblMain.getColumn(this.tblMain.getColumnCount() - 1).setKey("treeColumn");
        } else {
            this.tblMain.getColumn(this.tblMain.getColumnCount() - 1).setKey("latitudeName");
        }
        this.latitudeMap = new HashMap();
        this.rpTypeMap = new HashMap();
        String latitudeType = (String)this.filterManager.getLatitudeType();
        this.initLatitude(latitudeType);
        this.initTableHead();
        this.initData(latitudeType);
        this.scanTable();
        this.tblMain.setRowCount(this.tblMain.getBody().size());
    }

    private void initLatitude(String latitudeType) {
        try {
            if (latitudeType.equals("department")) {
                this.initDepartmentLatitude();
            } else if (latitudeType.equals("employee")) {
                this.initEmployeeLatitude();
            } else if (latitudeType.equals("position")) {
                this.initPositionLatitude();
            }
        }
        catch (Exception e) {
            this.resetTable();
            this.handleException(e);
        }
    }

    private void initDepartmentLatitude() throws Exception {
        boolean isIncludeChild = this.filterManager.isIncludeChild();
        AdminOrgUnitInfo info = null;
        IRow row = null;
        if (isIncludeChild) {
            Vector<AdminOrgUnitInfo> vec = new Vector<AdminOrgUnitInfo>();
            DefaultKingdeeTreeNode rootNode = this.getOrgUnitTreeNode();
            if (rootNode == null) {
                return;
            }
            AdminOrgUnitInfo rootInfo = (AdminOrgUnitInfo)rootNode.getUserObject();
            if (HRTreeUtil.isTreeNodeDisable((DefaultKingdeeTreeNode)rootNode)) {
                rootInfo.put("isEnable", (Object)Boolean.FALSE);
            } else {
                rootInfo.put("isEnable", (Object)Boolean.TRUE);
            }
            rootInfo.setLevel(rootNode.getLevel());
            vec.add(rootInfo);
            this.getCellUserObjects(rootNode, vec);
            HRCellTreeRenderer orgCellRen = new HRCellTreeRenderer();
            int initLevel = 0;
            int size = vec.size();
            for (int i = 0; i < size; ++i) {
                info = (AdminOrgUnitInfo)vec.get(i);
                if (i == 0) {
                    initLevel = info.getLevel();
                }
                row = this.tblMain.addRow(i);
                if (!Boolean.valueOf(info.get("isEnable").toString()).booleanValue()) {
                    row.getStyleAttributes().setBackground(Color.LIGHT_GRAY);
                }
                HRCellUserObject orgCellObj = new HRCellUserObject();
                orgCellObj.setCompanyId(info.getId().toString());
                orgCellObj.setName(info.getName());
                orgCellObj.setLongNumber(info.getLongNumber());
                orgCellObj.setIsLeaf(info.isIsLeaf());
                orgCellObj.setLevel(info.getLevel() - initLevel);
                orgCellObj.setExpanded(true);
                this.latitudeMap.put(info.getId().toString(), row.getRowIndex());
                row.getCell("treeColumn").setValue((Object)orgCellObj);
                row.getCell("treeColumn").setRenderer((IBasicRender)orgCellRen);
            }
            IRow sumRow = this.tblMain.addRow();
            HRCellUserObject cellValue = new HRCellUserObject();
            cellValue.setCompanyId("");
            cellValue.setIsLeaf(true);
            cellValue.setLevel(0);
            cellValue.setLongNumber("01");
            cellValue.setName(EASResource.getString((String)RES, (String)"sum"));
            cellValue.setExpanded(true);
            sumRow.getCell(0).setValue((Object)cellValue);
            sumRow.getCell(0).setRenderer((IBasicRender)orgCellRen);
            this.tblMain.getColumn(0).setWidth(200);
        } else {
            List adminOrgs = null;
            String adminID = (String)this.filterManager.getDepartmentIDValue();
            if (adminID != null) {
                adminOrgs = PersonRPStatUtil.findAdminOrgNotIncludeChildByID(adminID);
            } else {
                String HROrgID = (String)this.filterManager.getHROrgValue();
                adminOrgs = PersonRPStatUtil.findAdminOrgNotIncludeChildByHR(HROrgID);
            }
            AdminOrgUnitInfo org = null;
            for (int i = 0; i < adminOrgs.size(); ++i) {
                row = this.tblMain.addRow();
                org = (AdminOrgUnitInfo)adminOrgs.get(i);
                this.latitudeMap.put(org.getId().toString(), row.getRowIndex());
                row.getCell("latitudeName").setValue((Object)org);
            }
        }
    }

    private void initEmployeeLatitude() throws BOSException, UuidException, SQLException {
        boolean isLike = true;
        String condValue = (String)this.filterManager.getEmployeeValue();
        String HROrgId = (String)this.filterManager.getHROrgValue();
        List employeeList = null;
        employeeList = PersonRPStatUtil.findEmployee(isLike, condValue, HROrgId);
        if (employeeList != null) {
            PersonInfo person = null;
            IRow row = null;
            int rowCount = this.tblMain.getRowCount();
            for (int i = 0; i < employeeList.size(); ++i) {
                person = (PersonInfo)employeeList.get(i);
                row = this.tblMain.addRow(rowCount + i);
                this.latitudeMap.put(person.getId().toString(), row.getRowIndex());
                row.getCell("latitudeName").setValue((Object)person);
            }
        }
    }

    private void initPositionLatitude() throws BOSException, UuidException, SQLException {
        List positionList = null;
        String positionId = (String)this.filterManager.getPositionValue();
        positionList = positionId != null ? PersonRPStatUtil.findPositionByID(positionId) : PersonRPStatUtil.findPositionByHR((String)this.filterManager.getHROrgValue());
        if (positionList != null) {
            PositionInfo position = null;
            IRow row = null;
            int rowConut = this.tblMain.getRowCount();
            for (int i = 0; i < positionList.size(); ++i) {
                position = (PositionInfo)positionList.get(i);
                row = this.tblMain.addRow(rowConut + i);
                this.latitudeMap.put(position.getId().toString(), row.getRowIndex());
                row.getCell("latitudeName").setValue((Object)position);
            }
        }
    }

    private DefaultKingdeeTreeNode getOrgUnitTreeNode() throws Exception {
        this.adminId = (String)this.filterManager.getDepartmentIDValue();
        HashSet<String> hroSet = new HashSet<String>();
        hroSet.add((String)this.filterManager.getHROrgValue());
        DefaultKingdeeTreeNode orgRoot = HRTreeUtil.createAdminTreeNodeByUserRange((boolean)false, (boolean)false, (boolean)true, (boolean)false, hroSet);
        if (orgRoot == null) {
            return null;
        }
        if (this.adminId != null) {
            HashMap<String, DefaultKingdeeTreeNode> map = new HashMap<String, DefaultKingdeeTreeNode>();
            map.put(this.getAdminIdByAdminNode(orgRoot), orgRoot);
            this.overTreeNodeSimple(orgRoot, map);
            orgRoot = (DefaultKingdeeTreeNode)map.get(this.adminId);
        } else {
            this.adminId = ((AdminOrgUnitInfo)orgRoot.getUserObject()).getId().toString();
        }
        return orgRoot;
    }

    private void overTreeNodeSimple(DefaultKingdeeTreeNode root, HashMap nodeMap) throws Exception {
        DefaultKingdeeTreeNode node = null;
        int count = root.getChildCount();
        for (int i = 0; i < count; ++i) {
            node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            nodeMap.put(this.getAdminIdByAdminNode(node), node);
            this.overTreeNodeSimple(node, nodeMap);
        }
    }

    private String getAdminIdByAdminNode(DefaultKingdeeTreeNode node) {
        AdminOrgUnitInfo adminInfo = null;
        if (node.getUserObject() instanceof AdminOrgUnitInfo) {
            adminInfo = (AdminOrgUnitInfo)node.getUserObject();
        }
        if (adminInfo != null) {
            return adminInfo.getId().toString();
        }
        return null;
    }

    private void getCellUserObjects(DefaultKingdeeTreeNode treeNode, Vector vec) {
        AdminOrgUnitInfo adminInfo = null;
        if (treeNode != null && treeNode.getUserObject() != null && treeNode.getUserObject() instanceof AdminOrgUnitInfo) {
            for (int i = 0; i < treeNode.getChildCount(); ++i) {
                this.childNode = (DefaultKingdeeTreeNode)treeNode.getChildAt(i);
                if (!(this.childNode.getUserObject() instanceof AdminOrgUnitInfo)) continue;
                adminInfo = (AdminOrgUnitInfo)this.childNode.getUserObject();
                adminInfo.setLevel(this.childNode.getLevel());
                if (HRTreeUtil.isTreeNodeDisable((DefaultKingdeeTreeNode)this.childNode)) {
                    adminInfo.put("isEnable", (Object)false);
                } else {
                    adminInfo.put("isEnable", (Object)true);
                }
                vec.add(adminInfo);
                if (this.childNode.getChildCount() <= 0) continue;
                this.getCellUserObjects(this.childNode, vec);
            }
        }
    }

    private void initTableHead() {
        try {
            this.rpType = PersonRPStatUtil.findRewardPunishType((HashSet)this.filterManager.getRewardPunishTypes());
        }
        catch (BOSException e) {
            this.resetTable();
            this.handleException((Exception)((Object)e));
        }
        this.tblMain.addHeadRow(0);
        this.tblMain.addHeadRow(1);
        int y = 0;
        y = this.filterManager.getLatitudeType().equals("department") && this.filterManager.isIncludeChild() ? this.tblMain.getColumnIndex("treeColumn") : this.tblMain.getColumnIndex("latitudeName");
        this.tblMain.getHeadMergeManager().mergeBlock(0, y, 1, y);
        int baseColSum = this.tblMain.getColumnCount();
        for (int i = 0; i < this.rpType.size(); ++i) {
            this.tblMain.addColumn();
            this.tblMain.getHeadMergeManager().mergeBlock(1, i * 2 + baseColSum, 1, i * 2 + baseColSum);
            this.tblMain.getHead().getRow(1).getCell(i * 2 + baseColSum).setValue((Object)(this.rpType.get(i).toString() + "(" + EASResource.getString((String)RES, (String)"countPersons") + ")"));
            this.tblMain.addColumn();
            this.tblMain.getHeadMergeManager().mergeBlock(1, i * 2 + baseColSum + 1, 1, i * 2 + baseColSum + 1);
            this.tblMain.getHead().getRow(1).getCell(i * 2 + baseColSum + 1).setValue((Object)(this.rpType.get(i).toString() + "(" + EASResource.getString((String)RES, (String)"countTimes") + ")"));
            this.rpTypeMap.put(((RewardPunishTypeInfo)this.rpType.get(i)).getId().toString(), i * 2 + baseColSum);
        }
        this.tblMain.getHeadMergeManager().mergeBlock(0, 1, 0, this.rpType.size() * 2);
        this.tblMain.getHead().getRow(0).getCell(1).setValue((Object)EASResource.getString((String)RES, (String)"rpType"));
        String latitudeType = (String)this.filterManager.getLatitudeType();
        if (latitudeType.equals("department")) {
            this.tblMain.getHeadRow(0).getCell(0).setValue((Object)"\u884c\u653f\u7ec4\u7ec7");
        } else if (latitudeType.equals("employee")) {
            this.tblMain.getHeadRow(0).getCell(0).setValue((Object)"\u5458\u5de5\u59d3\u540d");
        } else if (latitudeType.equals("position")) {
            this.tblMain.getHeadRow(0).getCell(0).setValue((Object)"\u804c\u4f4d");
        }
    }

    private void initData(String latitudeType) {
        try {
            if (latitudeType.equals("department")) {
                this.initDataOnDepartment();
            } else if (latitudeType.equals("employee")) {
                this.initDataOnEmployee();
            } else if (latitudeType.equals("position")) {
                this.initDataOnPostion();
            }
        }
        catch (Exception e) {
            this.resetTable();
            this.handleException(e);
        }
    }

    private void initDataOnDepartment() throws BOSException, SQLException {
        int indexY;
        int indexX;
        IRowSet rows = null;
        rows = PersonRPStatUtil.getTimesDataOnDepartment(this.mainQuery);
        if (rows != null) {
            Integer valueTimes = null;
            indexX = 0;
            indexY = 0;
            while (rows.next()) {
                if (rows.getString("TYPE.ID") == null || rows.getString("ADMINORG.ID") == null) continue;
                valueTimes = rows.getInt("COUNTTIMES");
                if (this.rpTypeMap == null || this.rpTypeMap.get(rows.getString("TYPE.ID")) == null || this.latitudeMap == null || this.latitudeMap.get(rows.getString("ADMINORG.ID")) == null) continue;
                indexX = (Integer)this.rpTypeMap.get(rows.getString("TYPE.ID"));
                indexY = (Integer)this.latitudeMap.get(rows.getString("ADMINORG.ID"));
                this.tblMain.getRow(indexY).getCell(indexX + 1).setValue((Object)valueTimes);
            }
        }
        if ((rows = PersonRPStatUtil.getPersonDataOnDepartment(this.mainQuery)) != null) {
            Integer valuePersons = null;
            indexX = 0;
            indexY = 0;
            while (rows.next()) {
                if (rows.getString("TYPEID") == null || rows.getString("ADMINORGID") == null) continue;
                valuePersons = rows.getInt("COUNTPERSONS");
                if (this.rpTypeMap.get(rows.getString("TYPEID")) == null || this.latitudeMap.get(rows.getString("ADMINORGID")) == null) continue;
                indexX = (Integer)this.rpTypeMap.get(rows.getString("TYPEID"));
                indexY = (Integer)this.latitudeMap.get(rows.getString("ADMINORGID"));
                this.tblMain.getRow(indexY).getCell(indexX).setValue((Object)valuePersons);
            }
        }
    }

    private void initDataOnEmployee() throws BOSException, SQLException {
        IRowSet rows = null;
        rows = PersonRPStatUtil.getPersonDataOnEmployee(this.mainQuery);
        if (rows != null) {
            Object value = null;
            int indexX = 0;
            int indexY = 0;
            while (rows.next()) {
                if (rows.getString("TYPE.ID") == null || rows.getString("PERSON.ID") == null) continue;
                value = rows.getObject("COUNTTIMES");
                if (this.rpTypeMap == null || this.rpTypeMap.get(rows.getString("TYPE.ID")) == null || this.latitudeMap == null || this.latitudeMap.get(rows.getString("PERSON.ID")) == null) continue;
                indexX = (Integer)this.rpTypeMap.get(rows.getString("TYPE.ID"));
                indexY = (Integer)this.latitudeMap.get(rows.getString("PERSON.ID"));
                this.tblMain.getRow(indexY).getCell(indexX + 1).setValue(value);
                if (value != null && (Integer)value > 0) {
                    this.tblMain.getRow(indexY).getCell(indexX).setValue((Object)1);
                    continue;
                }
                this.tblMain.getRow(indexY).getCell(indexX).setValue((Object)0);
            }
        }
    }

    private void initDataOnPostion() throws BOSException, SQLException {
        int indexY;
        int indexX;
        IRowSet rows = null;
        rows = PersonRPStatUtil.getTimesDataOnPosition(this.mainQuery);
        if (rows != null) {
            Integer valueTimes = null;
            indexX = 0;
            indexY = 0;
            while (rows.next()) {
                if (rows.getString("type.id") == null || rows.getString("position.id") == null) continue;
                valueTimes = rows.getInt("countTimes");
                if (this.rpTypeMap == null || this.rpTypeMap.get(rows.getString("type.id")) == null || this.latitudeMap == null || this.latitudeMap.get(rows.getString("position.id")) == null) continue;
                indexX = (Integer)this.rpTypeMap.get(rows.getString("type.id"));
                indexY = (Integer)this.latitudeMap.get(rows.getString("position.id"));
                this.tblMain.getRow(indexY).getCell(indexX + 1).setValue((Object)valueTimes);
            }
        }
        if ((rows = PersonRPStatUtil.getPersonsDataOnPosition(this.mainQuery)) != null) {
            Integer valuePersons = null;
            indexX = 0;
            indexY = 0;
            while (rows.next()) {
                if (rows.getString("TYPEID") == null || rows.getString("POSITIONID") == null) continue;
                valuePersons = rows.getInt("COUNTPERSONS");
                if (this.rpTypeMap.get(rows.getString("TYPEID")) == null || this.latitudeMap.get(rows.getString("POSITIONID")) == null) continue;
                indexX = (Integer)this.rpTypeMap.get(rows.getString("TYPEID"));
                indexY = (Integer)this.latitudeMap.get(rows.getString("POSITIONID"));
                this.tblMain.getRow(indexY).getCell(indexX).setValue((Object)valuePersons);
            }
        }
    }

    private void scanTable() {
        int lengthX = this.rpType.size() * 2;
        int lengthY = this.tblMain.getBody().size();
        IRow sumRow = null;
        if (this.filterManager.getLatitudeType().equals("department") && this.filterManager.isIncludeChild()) {
            sumRow = this.tblMain.getRow(this.tblMain.getBody().size() - 1);
        } else {
            sumRow = this.tblMain.addRow();
            sumRow.getCell(0).setValue((Object)EASResource.getString((String)RES, (String)"sum"));
        }
        if (sumRow != null) {
            for (int x = 1; x < lengthX + 1; ++x) {
                int sum = 0;
                Object value = null;
                for (int y = 0; y < lengthY; ++y) {
                    value = this.tblMain.getRow(y).getCell(x).getValue();
                    if (value == null) {
                        this.tblMain.getRow(y).getCell(x).setValue((Object)0);
                        continue;
                    }
                    sum += ((Integer)value).intValue();
                }
                sumRow.getCell(x).setValue((Object)sum);
            }
        }
    }

    private String getCustomerParamsStr(QuerySolutionInfo solution) {
        if (null != solution && null != solution.getQueryPanelInfo() && solution.getQueryPanelInfo().size() > 0) {
            int len = solution.getQueryPanelInfo().size();
            for (int i = 0; i < len; ++i) {
                if (null == solution.getQueryPanelInfo().get(i) || !PANEL_CLASSNAME.equals(solution.getQueryPanelInfo().get(i).getPanelClassName())) continue;
                return solution.getQueryPanelInfo().get(i).getCustomerParams();
            }
        }
        return null;
    }

    public String getPropertyOfBizOrg(OrgType orgType) {
        return null;
    }

    protected boolean isUseStandardPermission() {
        return true;
    }

    protected FilterInfo getDefaultFilter() throws Exception {
        return null;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog dialog = super.initCommonQueryDialog();
        dialog.setDisShowRowCount(true);
        return dialog;
    }
}

