/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.state.client;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.emp.client.EmployeeTreeEditUI;
import com.kingdee.eas.hr.state.PersonSpecialSubsidyInfo;
import com.kingdee.eas.hr.state.client.AbstractPersonSpecialSubsidyEditUI;
import com.kingdee.eas.hr.state.client.HRStateTWOClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.text.SimpleDateFormat;
import org.apache.log4j.Logger;

public class PersonSpecialSubsidyEditUI
extends AbstractPersonSpecialSubsidyEditUI {
    private static final Logger logger = CoreUIObject.getLogger(PersonSpecialSubsidyEditUI.class);
    private EmployeeTreeEditUI treeEditUI;
    private static SimpleDateFormat dateFormat = null;
    public static final String RES = "com.kingdee.eas.hr.state.ProfTechResource";

    public static boolean isValidDate(String s) {
        try {
            dateFormat.parse(s);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        HRStateTWOClientUtils.verifyEmpty((CoreUIObject)this, this.txtreason);
        HRStateTWOClientUtils.verifyEmpty((CoreUIObject)this, this.txtyear);
        HRStateTWOClientUtils.verifyEmpty((CoreUIObject)this, this.txtcriterion);
        if (!(this.editData.getYear() == null || PersonSpecialSubsidyEditUI.isValidDate(this.txtyear.getText()) && this.txtyear.getText().charAt(0) != '0' && this.txtyear.getText().length() == 4)) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"yearError"));
            this.txtyear.requestFocusInWindow();
            SysUtil.abort();
        }
    }

    @Override
    protected IObjectValue createNewData() {
        PersonSpecialSubsidyInfo objectValue = new PersonSpecialSubsidyInfo();
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        this.treeEditUI = (EmployeeTreeEditUI)this.getUIContext().get("GroupListEditUI");
        Object temp = this.getUIContext().get("PersonID");
        if (temp != null) {
            PersonInfo pInfo = null;
            try {
                pInfo = HRStateTWOClientUtils.getPersonInfo(BOSUuid.read((String)this.getUIContext().get("PersonID").toString()));
            }
            catch (Exception e1) {
                MsgBox.showError((String)EASResource.getString((String)RES, (String)"notPerson"));
                SysUtil.abort();
            }
            objectValue.setPerson(pInfo);
            return objectValue;
        }
        MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"PERSONID_NULL"));
        return null;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.actionAddNew.setVisible(false);
            this.actionEdit.setVisible(false);
            this.actionCopy.setVisible(false);
            this.actionSubmit.setVisible(false);
            this.actionRemove.setVisible(false);
        } else {
            this.actionAddNew.setVisible(true);
            this.actionEdit.setVisible(true);
            this.actionCopy.setVisible(true);
            this.actionSubmit.setVisible(true);
            this.actionRemove.setVisible(true);
        }
    }

    static {
        dateFormat = new SimpleDateFormat("yyyy");
        dateFormat.setLenient(false);
    }
}

