/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.state.client;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.hr.state.PersonTechnicalInfo;
import com.kingdee.eas.hr.state.client.AbstractPersonTechnicalEditUI;
import com.kingdee.eas.hr.state.client.HRStateTWOClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.UuidException;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Date;
import org.apache.log4j.Logger;

public class PersonTechnicalEditUI
extends AbstractPersonTechnicalEditUI {
    private static final Logger logger = CoreUIObject.getLogger(PersonTechnicalEditUI.class);
    protected final String MessageRES = "com.kingdee.eas.hr.state.StateTWOResource";
    protected final String RES = "com.kingdee.eas.hr.state.PersonTechnicalResource";

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        this.checkDate();
    }

    @Override
    protected IObjectValue createNewData() {
        return this.getPersonTechnicalInfo();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.setButtonStateByView();
    }

    private void checkDate() {
        Date getTechDutyDate = (Date)this.pkgetTechDutyDate.getValue();
        Date dateStartOfAppointment = (Date)this.pkdateStartOfAppointment.getValue();
        Date dateEndOfAppointment = (Date)this.pkdateEndOfAppointment.getValue();
        if (getTechDutyDate != null && dateStartOfAppointment != null && getTechDutyDate.after(dateStartOfAppointment)) {
            this.pkdateStartOfAppointment.requestFocusInWindow();
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.state.PersonTechnicalResource", (String)"dateStartOfAppointmentMustAfterOfGetTechDutyDate"));
            this.pkdateStartOfAppointment.setValue(null);
            SysUtil.abort();
        }
        if (dateStartOfAppointment == null && dateEndOfAppointment != null) {
            this.pkdateStartOfAppointment.requestFocusInWindow();
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.state.PersonTechnicalResource", (String)"pleaseInputDateStartOfAppointment"));
            SysUtil.abort();
        }
        if (dateStartOfAppointment != null && dateEndOfAppointment != null && dateStartOfAppointment.after(dateEndOfAppointment)) {
            this.pkdateEndOfAppointment.requestFocusInWindow();
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.state.PersonTechnicalResource", (String)"dateEndOfAppointmentMustAfterOfdateStartOfAppointment"));
            this.pkdateEndOfAppointment.setValue(null);
            SysUtil.abort();
        }
    }

    private PersonTechnicalInfo getPersonTechnicalInfo() {
        PersonTechnicalInfo personTechnicalInfo = new PersonTechnicalInfo();
        PersonInfo pInfo = new PersonInfo();
        try {
            pInfo = HRStateTWOClientUtils.getPersonInfo(BOSUuid.read((String)this.getUIContext().get("PersonID").toString()));
        }
        catch (UuidException e) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.state.SocietyPostResource", (String)"noPerson"));
            SysUtil.abort();
        }
        catch (Exception e) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.state.SocietyPostResource", (String)"noPerson"));
            SysUtil.abort();
        }
        PersonPositionInfo PPinfo = null;
        try {
            PPinfo = HRStateTWOClientUtils.getPersonPositionInfo(BOSUuid.read((String)this.getUIContext().get("PersonID").toString()));
        }
        catch (Exception et) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.state.StateTWOResource", (String)"notPosition"));
            SysUtil.abort();
        }
        if (PPinfo != null) {
            personTechnicalInfo.setPosition(PPinfo.getPrimaryPosition());
            personTechnicalInfo.setAdminOrg(PPinfo.getPersonDep());
        }
        pInfo.setName(this.getUIContext().get("personName").toString());
        personTechnicalInfo.setHrOrgUnit(SysContext.getSysContext().getCurrentHRUnit());
        personTechnicalInfo.setPerson(pInfo);
        personTechnicalInfo.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        return personTechnicalInfo;
    }

    private void setButtonStateByView() {
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.actionAddNew.setVisible(false);
            this.actionEdit.setVisible(false);
            this.actionCopy.setVisible(false);
            this.actionSubmit.setVisible(false);
            this.actionRemove.setVisible(false);
        } else {
            this.actionAddNew.setVisible(true);
            this.actionEdit.setVisible(true);
            this.actionCopy.setVisible(true);
            this.actionSubmit.setVisible(true);
            this.actionRemove.setVisible(true);
        }
    }

    protected void verifyInput(ActionEvent actionevent) throws Exception {
        HRStateTWOClientUtils.verifyEmpty((CoreUIObject)this, "com.kingdee.eas.hr.state.PersonTechnicalResource", this.txttechnicalGrade, "mustInputTechnicalGrade");
        HRStateTWOClientUtils.verifyEmpty((CoreUIObject)this, "com.kingdee.eas.hr.state.PersonTechnicalResource", this.txttechnicalDuty, "mustInputTechnicalDuty");
        HRStateTWOClientUtils.verifyEmpty((CoreUIObject)this, "com.kingdee.eas.hr.state.PersonTechnicalResource", this.pkgetTechDutyDate, "mustInputGetTechDutyDate");
    }
}

