/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.state.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.client.PositionPromptBox2;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.hr.base.client.FilterUIUtil;
import com.kingdee.eas.hr.base.client.IHRF7CommonRegister;
import com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox;
import com.kingdee.eas.hr.org.client.AdminByOrgRangePromptBox;
import com.kingdee.eas.hr.state.client.AbstractPersonTechnicalGeneralViewFilterUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.Date;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class PersonTechnicalGeneralViewFilterUI
extends AbstractPersonTechnicalGeneralViewFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(PersonTechnicalGeneralViewFilterUI.class);
    private static final String RES = "com.kingdee.eas.hr.state.PersonTechnicalResource";
    private static final String MESRES = "com.kingdee.eas.hr.state.MessageTWOResource";

    public void onLoad() throws Exception {
        super.onLoad();
        this.prmtAdminOrg.setEditable(false);
        this.prmtPerson.setEditable(false);
        this.prmtPosition.setEditable(false);
        this.chkIncludeChild.setEnabled(false);
        this.btnPerson.setSelected(true);
        this.chkLike.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PersonTechnicalGeneralViewFilterUI.this.setSearchType();
            }
        });
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        String[] ctrls = new String[]{this.prmtHROrg.getName()};
        FilterUIUtil.saveAllData((CustomerParams)cp, (CustomerQueryPanel)this, (String[])ctrls, (boolean)false);
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        String[] ctrls = new String[]{this.prmtHROrg.getName()};
        FilterUIUtil.retriveAllData((CustomerParams)cp, (CustomerQueryPanel)this, (String[])ctrls, (boolean)false);
    }

    public void clear() {
        super.clear();
        this.prmtPerson.setValue(null);
        this.prmtAdminOrg.setValue(null);
        this.prmtPosition.setValue(null);
        this.datePickerGetTechDutyDateBegin.setValue(null);
        this.datePickerGetTechDutyDateEnd.setValue(null);
        this.datePickerDateStartOfAppointmentBegin.setValue(null);
        this.datePickerDateStartOfAppointmentEnd.setValue(null);
        this.btnAdminOrg.setSelected(false);
        this.btnPerson.setSelected(true);
        this.btnPosition.setSelected(false);
        this.chkIncludeChild.setSelected(false);
        this.chkLike.setSelected(false);
        this.txPerson.setText("");
    }

    public FilterInfo getFilterInfo() {
        Object position;
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection itemCollection = filterInfo.getFilterItems();
        FilterItemInfo itemInfo = null;
        if (this.datePickerGetTechDutyDateBegin.getValue() != null) {
            itemInfo = new FilterItemInfo("getTechDutyDate", (Object)((Date)this.datePickerGetTechDutyDateBegin.getValue()), CompareType.GREATER_EQUALS);
            itemCollection.add(itemInfo);
        }
        if (this.datePickerGetTechDutyDateEnd.getValue() != null) {
            itemInfo = new FilterItemInfo("getTechDutyDate", (Object)((Date)this.datePickerGetTechDutyDateEnd.getValue()), CompareType.LESS_EQUALS);
            itemCollection.add(itemInfo);
        }
        if (this.datePickerDateStartOfAppointmentBegin.getValue() != null) {
            itemInfo = new FilterItemInfo("dateStartOfAppointment", (Object)((Date)this.datePickerDateStartOfAppointmentBegin.getValue()), CompareType.GREATER_EQUALS);
            itemCollection.add(itemInfo);
        }
        if (this.datePickerDateStartOfAppointmentEnd.getValue() != null) {
            itemInfo = new FilterItemInfo("dateStartOfAppointment", (Object)((Date)this.datePickerDateStartOfAppointmentEnd.getValue()), CompareType.LESS_EQUALS);
            itemCollection.add(itemInfo);
        }
        if (this.btnPerson.isSelected()) {
            Object person = this.prmtPerson.getData();
            this.setPersonFilter(this.chkLike.isSelected(), person, filterInfo);
        } else if (this.btnAdminOrg.isSelected()) {
            Object adminOrg = this.prmtAdminOrg.getData();
            if (adminOrg != null && adminOrg instanceof AdminOrgUnitInfo) {
                this.setAdminOrgFilter(this.chkIncludeChild.isSelected(), (AdminOrgUnitInfo)adminOrg, filterInfo);
            }
        } else if (this.btnPosition.isSelected() && (position = this.prmtPosition.getData()) != null && position instanceof PositionInfo) {
            itemInfo = new FilterItemInfo("position.id", (Object)((PositionInfo)position).getId().toString(), CompareType.EQUALS);
            itemCollection.add(itemInfo);
        }
        return filterInfo;
    }

    @Override
    protected void datePickerDateStartOfAppointmentBegin_dataChanged(DataChangeEvent e) throws Exception {
        super.datePickerDateStartOfAppointmentBegin_dataChanged(e);
    }

    @Override
    protected void btnPerson_stateChanged(ChangeEvent e) throws Exception {
        if (this.btnPerson.isSelected()) {
            this.setSelect("person");
        }
    }

    @Override
    protected void btnAdminOrg_stateChanged(ChangeEvent e) throws Exception {
        if (this.btnAdminOrg.isSelected()) {
            this.setSelect("adminOrg");
        }
    }

    @Override
    protected void btnPosition_stateChanged(ChangeEvent e) throws Exception {
        if (this.btnPosition.isSelected()) {
            this.setSelect("position");
        }
    }

    public boolean verify() {
        Date endTime;
        Date beginTime;
        if (this.datePickerGetTechDutyDateBegin.getValue() != null && this.datePickerGetTechDutyDateEnd.getValue() != null && (beginTime = (Date)this.datePickerGetTechDutyDateBegin.getValue()).after(endTime = (Date)this.datePickerGetTechDutyDateEnd.getValue())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"GetTechDutyDate"));
            this.datePickerGetTechDutyDateEnd.requestFocus();
            SysUtil.abort();
        }
        if (this.datePickerDateStartOfAppointmentBegin.getValue() != null && this.datePickerDateStartOfAppointmentEnd.getValue() != null && (beginTime = (Date)this.datePickerDateStartOfAppointmentBegin.getValue()).after(endTime = (Date)this.datePickerDateStartOfAppointmentEnd.getValue())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"DateStartOfAppointment"));
            this.datePickerDateStartOfAppointmentEnd.requestFocus();
            SysUtil.abort();
        }
        return true;
    }

    protected void initF7Context(IHRF7CommonRegister register) {
        super.initF7Context(register);
        AdminByOrgRangePromptBox adminOrgF7 = new AdminByOrgRangePromptBox();
        this.prmtAdminOrg.setEditFormat("$number$");
        this.prmtAdminOrg.setDisplayFormat("$name$");
        this.prmtAdminOrg.setCommitFormat("$number$");
        this.prmtAdminOrg.setSelector((KDPromptSelector)adminOrgF7);
        EmployeeMultiF7PromptBox empF7 = new EmployeeMultiF7PromptBox();
        empF7.setUserOrgRangeFilter(true);
        empF7.showNoPositionPerson(true);
        this.prmtPerson.setEditFormat("$number$");
        this.prmtPerson.setDisplayFormat("$name$");
        this.prmtPerson.setCommitFormat("$number$");
        this.prmtPerson.setSelector((KDPromptSelector)empF7);
        PositionPromptBox2 positionF7 = new PositionPromptBox2();
        this.prmtPosition.setEditFormat("$number$");
        this.prmtPosition.setDisplayFormat("$name$");
        this.prmtPosition.setCommitFormat("$number$");
        this.prmtPosition.setSelector((KDPromptSelector)positionF7);
        this.prmtAdminOrg.setEditable(true);
        this.prmtPerson.setEditable(true);
        this.prmtPosition.setEditable(true);
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.getMainOrg();
    }

    private void setAdminOrgFilter(boolean isIncludeChild, AdminOrgUnitInfo org, FilterInfo filter) {
        if (isIncludeChild) {
            if (filter.getFilterItems().size() > 0) {
                FilterInfo orgFilter = new FilterInfo();
                orgFilter.getFilterItems().add(new FilterItemInfo("adminOrg.longNumber", (Object)(org.getLongNumber() + "!%"), CompareType.LIKE));
                orgFilter.getFilterItems().add(new FilterItemInfo("adminOrg.number", (Object)org.getNumber(), CompareType.EQUALS));
                orgFilter.setMaskString("#0 or #1");
                try {
                    filter.mergeFilter(orgFilter, "and");
                }
                catch (BOSException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            } else {
                filter.getFilterItems().add(new FilterItemInfo("adminOrg.longNumber", (Object)(org.getLongNumber() + "!%"), CompareType.LIKE));
                filter.getFilterItems().add(new FilterItemInfo("adminOrg.number", (Object)org.getNumber(), CompareType.EQUALS));
                filter.setMaskString("#0 or #1");
            }
        } else {
            filter.getFilterItems().add(new FilterItemInfo("adminOrg.id", (Object)org.getId(), CompareType.EQUALS));
        }
    }

    private void setPersonFilter(boolean isLikeStyle, Object person, FilterInfo filter) {
        if (isLikeStyle) {
            String condStr = this.txPerson.getText();
            if (filter.getFilterItems().size() > 0) {
                FilterInfo employeeFilter = new FilterInfo();
                employeeFilter.getFilterItems().add(new FilterItemInfo("person.number", (Object)("%" + condStr + "%"), CompareType.LIKE));
                employeeFilter.getFilterItems().add(new FilterItemInfo("person.name", (Object)("%" + condStr + "%"), CompareType.LIKE));
                employeeFilter.setMaskString("#0 or #1");
                try {
                    filter.mergeFilter(employeeFilter, "and");
                }
                catch (BOSException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            } else {
                filter.getFilterItems().add(new FilterItemInfo("person.number", (Object)("%" + condStr + "%"), CompareType.LIKE));
                filter.getFilterItems().add(new FilterItemInfo("person.name", (Object)("%" + condStr + "%"), CompareType.LIKE));
                filter.setMaskString("#0 or #1");
            }
        } else if (person != null && person instanceof PersonInfo) {
            filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)((PersonInfo)person).getId().toString(), CompareType.EQUALS));
        }
    }

    private void setSearchType() {
        boolean style = this.chkLike.isSelected();
        if (style) {
            this.prmtPerson.setValue(null);
            this.prmtPerson.setEnabled(false);
            this.prmtPerson.setVisible(false);
            this.txPerson.setEnabled(true);
            this.txPerson.setVisible(true);
        } else {
            this.prmtPerson.setEnabled(true);
            this.prmtPerson.setVisible(true);
            this.txPerson.setText("");
            this.txPerson.setEnabled(false);
            this.txPerson.setVisible(false);
        }
    }

    private void setSelect(String selectType) {
        if (selectType.equals("adminOrg") && this.btnAdminOrg.isSelected()) {
            this.prmtAdminOrg.setEnabled(true);
            this.chkIncludeChild.setEnabled(true);
            this.chkIncludeChild.setSelected(false);
            this.chkLike.setSelected(false);
            this.chkLike.setEnabled(false);
            this.setSearchType();
            this.prmtPerson.setEnabled(false);
            this.prmtPerson.setValue(null);
            this.prmtPosition.setEnabled(false);
            this.prmtPosition.setValue(null);
        } else if (selectType.equals("person") && this.btnPerson.isSelected()) {
            this.chkLike.setEnabled(true);
            this.chkLike.setSelected(false);
            this.setSearchType();
            this.prmtAdminOrg.setEnabled(false);
            this.prmtAdminOrg.setValue(null);
            this.prmtPosition.setEnabled(false);
            this.prmtPosition.setValue(null);
            this.chkIncludeChild.setSelected(false);
            this.chkIncludeChild.setEnabled(false);
        } else if (selectType.equals("position") && this.btnPosition.isSelected()) {
            this.prmtPosition.setEnabled(true);
            this.chkLike.setSelected(false);
            this.chkLike.setEnabled(false);
            this.setSearchType();
            this.chkIncludeChild.setSelected(false);
            this.prmtPerson.setEnabled(false);
            this.prmtPerson.setValue(null);
            this.chkIncludeChild.setEnabled(false);
            this.prmtAdminOrg.setEnabled(false);
            this.prmtAdminOrg.setValue(null);
        }
    }
}

