/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.state.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitFactory;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.client.IHRF7CommonRegister;
import com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox;
import com.kingdee.eas.hr.org.client.AdminByOrgRangePromptBox;
import com.kingdee.eas.hr.state.client.AbstractPersonTechnicalStatFilterUI;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class PersonTechnicalStatFilterUI
extends AbstractPersonTechnicalStatFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(PersonTechnicalStatFilterUI.class);
    private static final String RES = "com.kingdee.eas.hr.state.client.StateTWOResource";
    public static final String LATITUDE_TYPE_DEPARTMENT = "department";
    public static final String LATITUDE_TYPE_EMPLOYEE = "employee";
    private String latitudeType;

    public void onLoad() throws Exception {
        super.onLoad();
        this.prmtDepartment.setEditable(false);
        this.prmtEmployee.setEditable(false);
        this.chkIncludeChild.setEnabled(false);
        this.btnEmployee.setSelected(true);
        this.latitudeType = LATITUDE_TYPE_EMPLOYEE;
        this.chkLike.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PersonTechnicalStatFilterUI.this.setSearchType();
            }
        });
    }

    @Override
    protected void btnDepartment_stateChanged(ChangeEvent e) throws Exception {
        if (this.btnDepartment.isSelected()) {
            this.setSelect(LATITUDE_TYPE_DEPARTMENT);
        }
    }

    @Override
    protected void btnEmployee_stateChanged(ChangeEvent e) throws Exception {
        if (this.btnEmployee.isSelected()) {
            this.setSelect(LATITUDE_TYPE_EMPLOYEE);
        }
    }

    public void clear() {
        super.clear();
        this.prmtEmployee.setValue(null);
        this.prmtDepartment.setValue(null);
        this.btnDepartment.setSelected(false);
        this.btnEmployee.setSelected(true);
        this.chkIncludeChild.setSelected(false);
        this.chkLike.setSelected(false);
        this.txEmployee.setText("");
    }

    public boolean verify() {
        return true;
    }

    protected void initF7Context(IHRF7CommonRegister register) {
        super.initF7Context(register);
        AdminByOrgRangePromptBox adminOrgF7 = new AdminByOrgRangePromptBox();
        this.prmtDepartment.setEditFormat("$number$");
        this.prmtDepartment.setDisplayFormat("$name$");
        this.prmtDepartment.setCommitFormat("$number$");
        this.prmtDepartment.setSelector((KDPromptSelector)adminOrgF7);
        EmployeeMultiF7PromptBox empF7 = new EmployeeMultiF7PromptBox();
        empF7.setUserOrgRangeFilter(true);
        empF7.showNoPositionPerson(true);
        this.prmtEmployee.setEditFormat("$number$");
        this.prmtEmployee.setDisplayFormat("$name$");
        this.prmtEmployee.setCommitFormat("$number$");
        this.prmtEmployee.setSelector((KDPromptSelector)empF7);
        this.prmtDepartment.setEditable(true);
        this.prmtEmployee.setEditable(true);
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.getMainOrg();
    }

    private void setSearchType() {
        boolean style = this.chkLike.isSelected();
        if (style) {
            this.prmtEmployee.setValue(null);
            this.prmtEmployee.setEnabled(false);
            this.prmtEmployee.setVisible(false);
            this.txEmployee.setEnabled(true);
            this.txEmployee.setVisible(true);
        } else {
            this.prmtEmployee.setEnabled(true);
            this.prmtEmployee.setVisible(true);
            this.txEmployee.setText("");
            this.txEmployee.setEnabled(false);
            this.txEmployee.setVisible(false);
        }
    }

    private void setSelect(String selectType) {
        if (selectType.equals(LATITUDE_TYPE_DEPARTMENT) && this.btnDepartment.isSelected()) {
            this.prmtDepartment.setEnabled(true);
            this.chkIncludeChild.setEnabled(true);
            this.chkIncludeChild.setSelected(false);
            this.chkLike.setSelected(false);
            this.chkLike.setEnabled(false);
            this.setSearchType();
            this.prmtEmployee.setEnabled(false);
            this.prmtEmployee.setValue(null);
            this.latitudeType = LATITUDE_TYPE_DEPARTMENT;
        } else if (selectType.equals(LATITUDE_TYPE_EMPLOYEE) && this.btnEmployee.isSelected()) {
            this.chkLike.setEnabled(true);
            this.chkLike.setSelected(false);
            this.setSearchType();
            this.prmtDepartment.setEnabled(false);
            this.prmtDepartment.setValue(null);
            this.chkIncludeChild.setSelected(false);
            this.chkIncludeChild.setEnabled(false);
            this.latitudeType = LATITUDE_TYPE_EMPLOYEE;
        }
    }

    public Map getParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("latitudeType", this.latitudeType);
        if (this.btnDepartment.isSelected()) {
            params.put("isIncludeChild", this.chkIncludeChild.isSelected());
            if (this.prmtDepartment.getValue() != null) {
                AdminOrgUnitInfo org = (AdminOrgUnitInfo)this.prmtDepartment.getValue();
                params.put("adminOrg.id", org.getId().toString());
                params.put("adminOrg.longNumber", org.getLongNumber());
            }
        }
        if (this.btnEmployee.isSelected()) {
            boolean isLike = this.chkLike.isSelected();
            params.put("isLike", isLike);
            if (!isLike) {
                if (this.prmtEmployee.getValue() != null) {
                    PersonInfo person = (PersonInfo)this.prmtEmployee.getValue();
                    params.put("person.id", person.getId().toString());
                }
            } else {
                params.put("personText", this.txEmployee.getText());
            }
        }
        if (this.prmtHROrg.getValue() != null) {
            HROrgUnitInfo hrOrg = (HROrgUnitInfo)this.prmtHROrg.getValue();
            params.put("hrOrgUnit.id", hrOrg.getId().toString());
        }
        return params;
    }

    public FilterInfo getFilterInfo() {
        Object adminOrg;
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection itemCollection = filterInfo.getFilterItems();
        Object itemInfo = null;
        if (this.btnEmployee.isSelected()) {
            Object employee = this.prmtEmployee.getData();
            this.setEmployeeFilter(this.chkLike.isSelected(), employee, filterInfo);
        } else if (this.btnDepartment.isSelected() && (adminOrg = this.prmtDepartment.getData()) != null && adminOrg instanceof AdminOrgUnitInfo) {
            this.setAdminOrgFilter(this.chkIncludeChild.isSelected(), (AdminOrgUnitInfo)adminOrg, filterInfo);
        }
        if (filterInfo.getFilterItems().size() == 0) {
            itemCollection.add(new FilterItemInfo("person.id", null, CompareType.ISNOT));
        }
        return filterInfo;
    }

    private void setAdminOrgFilter(boolean isIncludeChild, AdminOrgUnitInfo org, FilterInfo filter) {
        if (isIncludeChild) {
            if (filter.getFilterItems().size() > 0) {
                FilterInfo orgFilter = new FilterInfo();
                orgFilter.getFilterItems().add(new FilterItemInfo("adminOrg.longNumber", (Object)(org.getLongNumber() + "!%"), CompareType.LIKE));
                orgFilter.getFilterItems().add(new FilterItemInfo("adminOrg.number", (Object)org.getNumber(), CompareType.EQUALS));
                orgFilter.setMaskString("#0 or #1");
                try {
                    filter.mergeFilter(orgFilter, "and");
                }
                catch (BOSException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            } else {
                filter.getFilterItems().add(new FilterItemInfo("adminOrg.longNumber", (Object)(org.getLongNumber() + "!%"), CompareType.LIKE));
                filter.getFilterItems().add(new FilterItemInfo("adminOrg.number", (Object)org.getNumber(), CompareType.EQUALS));
                filter.setMaskString("#0 or #1");
            }
        } else {
            filter.getFilterItems().add(new FilterItemInfo("adminOrg.id", (Object)org.getId(), CompareType.EQUALS));
        }
    }

    private void setEmployeeFilter(boolean isLikeStyle, Object employee, FilterInfo filter) {
        if (isLikeStyle) {
            String condStr = this.txEmployee.getText();
            if (filter.getFilterItems().size() > 0) {
                FilterInfo employeeFilter = new FilterInfo();
                employeeFilter.getFilterItems().add(new FilterItemInfo("person.number", (Object)("%" + condStr + "%"), CompareType.LIKE));
                employeeFilter.getFilterItems().add(new FilterItemInfo("person.name", (Object)("%" + condStr + "%"), CompareType.LIKE));
                employeeFilter.setMaskString("#0 or #1");
                try {
                    filter.mergeFilter(employeeFilter, "and");
                }
                catch (BOSException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            } else {
                filter.getFilterItems().add(new FilterItemInfo("person.number", (Object)("%" + condStr + "%"), CompareType.LIKE));
                filter.getFilterItems().add(new FilterItemInfo("person.name", (Object)("%" + condStr + "%"), CompareType.LIKE));
                filter.setMaskString("#0 or #1");
            }
        } else if (employee != null && employee instanceof PersonInfo) {
            filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)((PersonInfo)employee).getId(), CompareType.EQUALS));
        }
    }

    public void setCustomerParams(CustomerParams cp) {
        ObjectUuidPK pk = null;
        this.latitudeType = cp.getCustomerParam("latitudeType");
        if (this.latitudeType.equals(LATITUDE_TYPE_DEPARTMENT)) {
            this.btnDepartment.setSelected(true);
            if (cp.getCustomerParam("adminOrg.id") != null) {
                AdminOrgUnitInfo adminOrg = null;
                pk = new ObjectUuidPK(BOSUuid.read((String)cp.getCustomerParam("adminOrg.id")));
                try {
                    adminOrg = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)pk);
                }
                catch (EASBizException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
                catch (BOSException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
                this.prmtDepartment.setData((Object)adminOrg);
            }
            this.chkIncludeChild.setSelected(cp.getBoolean("isIncludeChild"));
        } else if (this.latitudeType.equals(LATITUDE_TYPE_EMPLOYEE)) {
            this.btnEmployee.setSelected(true);
            this.chkLike.setSelected(cp.getBoolean("isLike"));
            if (!this.chkLike.isSelected()) {
                if (cp.getCustomerParam("person.id") != null) {
                    PersonInfo person = null;
                    pk = new ObjectUuidPK(BOSUuid.read((String)cp.getCustomerParam("person.id")));
                    try {
                        person = PersonFactory.getRemoteInstance().getPersonInfo((IObjectPK)pk);
                    }
                    catch (EASBizException e) {
                        ExceptionHandler.handle((Throwable)e);
                    }
                    catch (BOSException e) {
                        ExceptionHandler.handle((Throwable)e);
                    }
                    this.prmtEmployee.setValue((Object)person);
                }
            } else {
                this.txEmployee.setText(cp.getCustomerParam("person.name"));
            }
        }
        if (cp.getCustomerParam("hrOrg.id") != null) {
            HROrgUnitInfo hrOrg = null;
            pk = new ObjectUuidPK(BOSUuid.read((String)cp.getCustomerParam("hrOrg.id")));
            try {
                hrOrg = HROrgUnitFactory.getRemoteInstance().getHROrgUnitInfo((IObjectPK)pk);
            }
            catch (EASBizException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            this.prmtHROrg.setValue((Object)hrOrg);
        }
    }

    public CustomerParams getCustomerParams() {
        CustomerParams params = new CustomerParams();
        if (this.btnDepartment.isSelected()) {
            if (this.prmtDepartment.getValue() != null) {
                params.addCustomerParam("adminOrg.id", ((AdminOrgUnitInfo)this.prmtDepartment.getValue()).getId().toString());
            }
            params.putBoolean("isIncludeChild", this.chkIncludeChild.isSelected());
            params.addCustomerParam("latitudeType", LATITUDE_TYPE_DEPARTMENT);
        } else if (this.btnEmployee.isSelected()) {
            boolean isLike = this.chkLike.isSelected();
            params.putBoolean("isLike", isLike);
            if (!isLike) {
                if (this.prmtEmployee.getValue() != null) {
                    params.addCustomerParam("person.id", ((PersonInfo)this.prmtEmployee.getValue()).getId().toString());
                }
            } else {
                params.addCustomerParam("person.name", this.txEmployee.getText());
            }
            params.addCustomerParam("latitudeType", LATITUDE_TYPE_EMPLOYEE);
        }
        if (this.prmtHROrg.getValue() != null) {
            params.addCustomerParam("hrOrg.id", ((HROrgUnitInfo)this.prmtHROrg.getValue()).getId().toString());
        }
        return params;
    }

    public HashMap getStatusMap() {
        HashMap map = this.getCustomerParams().toHashMap();
        return map;
    }
}

