/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.state.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.hraux.util.HRTreeUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.context.IMultiOrgSupport;
import com.kingdee.eas.hr.base.OutputExcelUtil;
import com.kingdee.eas.hr.emp.client.HRCellTreeRenderer;
import com.kingdee.eas.hr.emp.client.HRCellUserObject;
import com.kingdee.eas.hr.emp.client.HRTreeTable;
import com.kingdee.eas.hr.state.client.AbstractPersonTechnicalStatListUI;
import com.kingdee.eas.hr.state.client.HRStateTWOClientUtils;
import com.kingdee.eas.hr.state.client.PersonTechnicalStatFilterUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.UuidException;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

public class PersonTechnicalStatListUI
extends AbstractPersonTechnicalStatListUI {
    private static final Logger logger = CoreUIObject.getLogger(PersonTechnicalStatListUI.class);
    private static final String RES = "com.kingdee.eas.hr.state.client.StateTWOResource";
    private static final String PANEL_CLASSNAME = "com.kingdee.eas.hr.state.client.PersonTechnicalStatFilterUI";
    private HashMap statusMap;
    private HashMap latitudeIDMap;
    private DefaultKingdeeTreeNode childNode = null;

    protected void afterOnLoad() throws Exception {
        super.afterOnLoad();
        HRTreeTable.setHRTreeTable((KDTable)this.tblMain, (String)"treeColumn");
        this.tblMain.checkParsed();
        this.tblMain.setEditable(false);
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.setAutoscrolls(true);
        this.enableExportExcel(this.tblMain);
        this.tHelper.getDisabledTables().add(this.tblMain);
    }

    protected void initListener() {
    }

    public void initTableListner(KDTable table) {
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnExportData.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
    }

    protected IMultiOrgSupport getMainCustomerQueryPanel() {
        try {
            return new PersonTechnicalStatFilterUI();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
            return null;
        }
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.refreshData();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    protected void handleQueryDialog(CommonQueryDialog dialog) throws Exception {
        super.handleQueryDialog(dialog);
        dialog.setUiObject(null);
        dialog.setMaxReturnCountVisible(false);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        if (this.getDialog() != null) {
            this.statusMap = ((PersonTechnicalStatFilterUI)this.getDialog().getUserPanel(PANEL_CLASSNAME)).getStatusMap();
            this.loadData();
        } else {
            IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
            PersonTechnicalStatFilterUI filterUI = new PersonTechnicalStatFilterUI();
            QuerySolutionInfo solution = iQuery.getDefaultSolution(this.getMetaDataPK().getFullName(), "com.kingdee.eas.hr.state.app.PersonTechnicalStatQuery");
            CustomerParams params = CustomerParams.getCustomerParams2((String)this.getCustomerParamsStr(solution));
            if (params != null) {
                filterUI.setCustomerParams(params);
                this.statusMap = filterUI.getStatusMap();
                this.loadData();
            }
        }
    }

    private String getCustomerParamsStr(QuerySolutionInfo solution) {
        if (null != solution && null != solution.getQueryPanelInfo() && solution.getQueryPanelInfo().size() > 0) {
            int len = solution.getQueryPanelInfo().size();
            for (int i = 0; i < len; ++i) {
                if (null == solution.getQueryPanelInfo().get(i) || !PANEL_CLASSNAME.equals(solution.getQueryPanelInfo().get(i).getPanelClassName())) continue;
                return solution.getQueryPanelInfo().get(i).getCustomerParams();
            }
        }
        return null;
    }

    private void refreshData() {
        this.loadData();
    }

    private void loadData() {
        this.tblMain.removeRows();
        String isIncludeChild = (String)this.statusMap.get("isIncludeChild");
        if (((String)this.statusMap.get("latitudeType")).equals("department") && "true".equals(isIncludeChild)) {
            this.tblMain.getColumn(0).setKey("treeColumn");
        } else {
            this.tblMain.getColumn(0).setKey("latitude");
        }
        this.initLatitude((String)this.statusMap.get("latitudeType"));
        this.initData((String)this.statusMap.get("latitudeType"));
        this.scanTable();
        if (this.tblMain.getColumn("latitude") != null) {
            this.tblMain.getColumn("latitude").setWidth(250);
        } else if (this.tblMain.getColumn("treeColumn") != null) {
            this.tblMain.getColumn("treeColumn").setWidth(250);
        }
        this.tblMain.getColumn("getTechDutyPersons").setWidth(250);
        this.tblMain.getColumn("getAppointmentPersons").setWidth(250);
        this.tblMain.setRowCount(this.tblMain.getBody().size());
    }

    private void initLatitude(String latitudeType) {
        this.latitudeIDMap = new HashMap();
        try {
            if (latitudeType.equals("department")) {
                this.initDepartmentLatitude();
            } else if (latitudeType.equals("employee")) {
                this.initEmployeeLatitude();
            }
        }
        catch (Exception e) {
            MsgBox.showError((String)EASResource.getString((String)RES, (String)"initLatitudeError"));
            SysUtil.abort();
        }
    }

    private void initDepartmentLatitude() throws Exception {
        String isIncludeChild = (String)this.statusMap.get("isIncludeChild");
        IRow row = null;
        AdminOrgUnitInfo info = null;
        if ("true".equals(isIncludeChild)) {
            Vector<AdminOrgUnitInfo> vec = new Vector<AdminOrgUnitInfo>();
            DefaultKingdeeTreeNode rootNode = this.getOrgUnitTreeNode();
            if (rootNode == null) {
                return;
            }
            AdminOrgUnitInfo rootInfo = (AdminOrgUnitInfo)rootNode.getUserObject();
            if (HRTreeUtil.isTreeNodeDisable((DefaultKingdeeTreeNode)rootNode)) {
                rootInfo.put("isEnable", (Object)false);
            } else {
                rootInfo.put("isEnable", (Object)true);
            }
            rootInfo.setLevel(rootNode.getLevel());
            vec.add(rootInfo);
            this.getCellUserObjects(rootNode, vec);
            HRCellTreeRenderer orgCellRen = new HRCellTreeRenderer();
            int initLevel = 0;
            int size = vec.size();
            for (int i = 0; i < size; ++i) {
                info = (AdminOrgUnitInfo)vec.get(i);
                if (i == 0) {
                    initLevel = info.getLevel();
                }
                row = this.tblMain.addRow(i);
                if (!Boolean.valueOf(info.get("isEnable").toString()).booleanValue()) {
                    row.getStyleAttributes().setBackground(Color.LIGHT_GRAY);
                }
                HRCellUserObject orgCellObj = new HRCellUserObject();
                orgCellObj.setCompanyId(info.getId().toString());
                orgCellObj.setName(info.getName());
                orgCellObj.setLongNumber(info.getLongNumber());
                orgCellObj.setIsLeaf(info.isIsLeaf());
                orgCellObj.setLevel(info.getLevel() - initLevel);
                orgCellObj.setExpanded(true);
                this.latitudeIDMap.put(info.getId().toString(), row.getRowIndex());
                row.getCell("treeColumn").setValue((Object)orgCellObj);
                row.getCell("treeColumn").setRenderer((IBasicRender)orgCellRen);
            }
            IRow sumRow = this.tblMain.addRow();
            HRCellUserObject cellValue = new HRCellUserObject();
            cellValue.setCompanyId("");
            cellValue.setIsLeaf(true);
            cellValue.setLevel(0);
            cellValue.setLongNumber("01");
            cellValue.setName(EASResource.getString((String)RES, (String)"sum"));
            cellValue.setExpanded(true);
            sumRow.getCell(0).setValue((Object)cellValue);
            sumRow.getCell(0).setRenderer((IBasicRender)orgCellRen);
        } else if (this.statusMap.get("adminOrg.id") == null) {
            AdminOrgUnitInfo topOrg = (AdminOrgUnitInfo)this.getOrgUnitTreeNode().getUserObject();
            IRow r = this.tblMain.addRow();
            if ("true".equals(isIncludeChild)) {
                r.getCell("treeColumn").setValue((Object)topOrg);
            } else {
                r.getCell("latitude").setValue((Object)topOrg);
            }
            this.latitudeIDMap.put(topOrg.getId().toString(), r.getRowIndex());
            r = this.tblMain.addRow();
            r.getCell("latitude").setValue((Object)EASResource.getString((String)RES, (String)"sum"));
        } else {
            List adminOrgList = this.findDepartment();
            for (int i = 0; i < adminOrgList.size(); ++i) {
                row = this.tblMain.addRow();
                info = (AdminOrgUnitInfo)adminOrgList.get(i);
                this.latitudeIDMap.put(info.getId().toString(), row.getRowIndex());
                row.getCell("latitude").setValue((Object)info);
            }
        }
        this.tblMain.getHeadRow(0).getCell(0).setValue((Object)"\u884c\u653f\u7ec4\u7ec7");
    }

    private DefaultKingdeeTreeNode getOrgUnitTreeNode() throws Exception {
        String adminId = (String)this.statusMap.get("adminOrg.id");
        DefaultKingdeeTreeNode orgRoot = HRTreeUtil.createAdminTreeNodeByUserRange((boolean)false, (boolean)false, (boolean)true, (boolean)false, null);
        if (orgRoot == null) {
            return null;
        }
        if (adminId != null) {
            HashMap<String, DefaultKingdeeTreeNode> map = new HashMap<String, DefaultKingdeeTreeNode>();
            map.put(this.getAdminIdByAdminNode(orgRoot), orgRoot);
            this.overTreeNodeSimple(orgRoot, map);
            orgRoot = (DefaultKingdeeTreeNode)map.get(adminId);
        }
        return orgRoot;
    }

    private void overTreeNodeSimple(DefaultKingdeeTreeNode root, HashMap nodeMap) throws Exception {
        DefaultKingdeeTreeNode node = null;
        int count = root.getChildCount();
        for (int i = 0; i < count; ++i) {
            node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            nodeMap.put(this.getAdminIdByAdminNode(node), node);
            this.overTreeNodeSimple(node, nodeMap);
        }
    }

    private String getAdminIdByAdminNode(DefaultKingdeeTreeNode node) {
        AdminOrgUnitInfo adminInfo = null;
        if (node.getUserObject() instanceof AdminOrgUnitInfo) {
            adminInfo = (AdminOrgUnitInfo)node.getUserObject();
        }
        if (adminInfo != null) {
            return adminInfo.getId().toString();
        }
        return null;
    }

    private void getCellUserObjects(DefaultKingdeeTreeNode treeNode, Vector vec) {
        AdminOrgUnitInfo adminInfo = null;
        if (treeNode != null && treeNode.getUserObject() != null && treeNode.getUserObject() instanceof AdminOrgUnitInfo) {
            for (int i = 0; i < treeNode.getChildCount(); ++i) {
                this.childNode = (DefaultKingdeeTreeNode)treeNode.getChildAt(i);
                if (!(this.childNode.getUserObject() instanceof AdminOrgUnitInfo)) continue;
                adminInfo = (AdminOrgUnitInfo)this.childNode.getUserObject();
                adminInfo.setLevel(this.childNode.getLevel());
                if (HRTreeUtil.isTreeNodeDisable((DefaultKingdeeTreeNode)this.childNode)) {
                    adminInfo.put("isEnable", (Object)false);
                } else {
                    adminInfo.put("isEnable", (Object)true);
                }
                vec.add(adminInfo);
                if (this.childNode.getChildCount() <= 0) continue;
                this.getCellUserObjects(this.childNode, vec);
            }
        }
    }

    private List findDepartment() throws BOSException, SQLException {
        IRowSet dataRows = null;
        AdminOrgUnitInfo adminOrg = null;
        Vector<AdminOrgUnitInfo> adminOrgList = new Vector<AdminOrgUnitInfo>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        String adminID = (String)this.statusMap.get("adminOrg.id");
        filter.getFilterItems().add(HRStateTWOClientUtils.getDefaultFilterForQuery("id"));
        if (adminID != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)adminID, CompareType.EQUALS));
        }
        view.setFilter(filter);
        dataRows = HRStateTWOClientUtils.query(view, "com.kingdee.eas.hr.state.app", "HRStatFindDepartmentQuery");
        while (dataRows.next()) {
            adminOrg = new AdminOrgUnitInfo();
            adminOrg.setId(BOSUuid.read((String)dataRows.getString("ID")));
            adminOrg.setName(dataRows.getString("NAME"));
            adminOrgList.add(adminOrg);
        }
        return adminOrgList;
    }

    private void initEmployeeLatitude() throws BOSException, UuidException, SQLException {
        EntityViewInfo viewInfo = null;
        viewInfo = this.getDialog() != null ? this.getDialog().getEntityViewInfoResult() : this.getDefaultEntityViewInfo();
        IRowSet rowSet = HRStateTWOClientUtils.query(viewInfo, "com.kingdee.eas.hr.state.app", "PersonTechnicalStatQuery");
        ArrayList<PersonInfo> employeeList = new ArrayList<PersonInfo>();
        PersonInfo personInfo = null;
        while (rowSet.next()) {
            personInfo = new PersonInfo();
            personInfo.setId(BOSUuid.read((String)rowSet.getString("person.id")));
            personInfo.setName(rowSet.getString("person.name"));
            employeeList.add(personInfo);
        }
        if (employeeList != null) {
            PersonInfo person = null;
            IRow row = null;
            int rowCount = this.tblMain.getRowCount();
            for (int i = 0; i < employeeList.size(); ++i) {
                person = (PersonInfo)employeeList.get(i);
                row = this.tblMain.addRow(rowCount + i);
                this.latitudeIDMap.put(person.getId().toString(), row.getRowIndex());
                row.getCell("latitude").setValue((Object)person);
            }
        }
        this.tblMain.getHeadRow(0).getCell("latitude").setValue((Object)"\u5458\u5de5\u59d3\u540d");
    }

    public static List findEmployee(String isLike, String condValue) throws BOSException, UuidException, SQLException {
        Vector<PersonInfo> persons;
        block6: {
            block5: {
                persons = new Vector<PersonInfo>();
                if (!"true".equals(isLike) && condValue != null) break block5;
                FilterInfo filter = new FilterInfo();
                EntityViewInfo view = new EntityViewInfo();
                IRowSet dataRow = null;
                filter.getFilterItems().add(HRStateTWOClientUtils.getDefaultFilterForQuery("adminOrg.id"));
                if ("true".equals(isLike) && condValue != null) {
                    filter.getFilterItems().add(new FilterItemInfo("name", (Object)("%" + condValue + "%"), CompareType.LIKE));
                    filter.getFilterItems().add(new FilterItemInfo("number", (Object)("%" + condValue + "%"), CompareType.LIKE));
                    filter.setMaskString("#0 and (#1 or #2)");
                }
                view.setFilter(filter);
                IQueryExecutor iqec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.state.app", "HRStatFindPersonQuery"));
                iqec.setObjectView(view);
                dataRow = iqec.executeQuery();
                if (dataRow == null) break block6;
                PersonInfo info = null;
                while (dataRow.next()) {
                    info = new PersonInfo();
                    info.setName(dataRow.getString("NAME"));
                    info.setId(BOSUuid.read((String)dataRow.getString("ID")));
                    persons.add(info);
                }
                break block6;
            }
            IPerson iPerson = null;
            iPerson = PersonFactory.getRemoteInstance();
            PersonCollection collection = null;
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            if (condValue != null) {
                FilterItemInfo filterItem = new FilterItemInfo("id", (Object)condValue, CompareType.EQUALS);
                filter.getFilterItems().add(filterItem);
            }
            view.setFilter(filter);
            collection = iPerson.getPersonCollection(view);
            if (collection != null) {
                for (int i = 0; i < collection.size(); ++i) {
                    persons.add(collection.get(i));
                }
            }
        }
        return persons;
    }

    private void initDataOnDepartment() throws BOSException, SQLException {
        IRowSet dataRows = null;
        dataRows = this.getPersonsDataOnDeparment("getTechDutyPersons");
        this.initDataOnTable("getTechDutyPersons", dataRows, "ADMINORGID", "COUNTPERSONS");
        dataRows = this.getPersonsDataOnDeparment("getAppointmentPersons");
        this.initDataOnTable("getAppointmentPersons", dataRows, "ADMINORGID", "COUNTPERSONS");
    }

    private IRowSet getPersonsDataOnDeparment(String str) throws BOSException {
        EntityViewInfo query = (EntityViewInfo)this.mainQuery.clone();
        if ("getAppointmentPersons".equals(str)) {
            FilterInfo filterInfo = query.getFilter();
            if (filterInfo.getFilterItems().size() > 0) {
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("appointStatus", null, CompareType.NOTEQUALS));
                try {
                    filterInfo.mergeFilter(filter, "and");
                }
                catch (BOSException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            } else {
                filterInfo.getFilterItems().add(new FilterItemInfo("appointStatus", null, CompareType.NOTEQUALS));
            }
            query.setFilter(filterInfo);
        }
        String subSQL = HRStateTWOClientUtils.metaQueryToSQL(query, "com.kingdee.eas.hr.state.app", "PersonTechnicalStatDepartmentQuery");
        StringBuffer queryStr = new StringBuffer();
        subSQL = subSQL.replaceAll("ADMINORG.ID", "ADMINORGID");
        queryStr.append("SELECT ADMINORGID,COUNT(*) AS COUNTPERSONS FROM (\n");
        queryStr.append(subSQL);
        queryStr.append("\n )AS T GROUP BY ADMINORGID");
        return HRStateTWOClientUtils.query(queryStr.toString());
    }

    private void initDataOnEmployee() throws BOSException, SQLException {
        IRowSet dataRows = null;
        dataRows = this.getPersonsDataOnEmployee("getTechDutyPersons");
        this.initDataOnTableForPerson("getTechDutyPersons", dataRows, "PERSON.ID", "COUNTTIMES");
        dataRows = this.getPersonsDataOnEmployee("getAppointmentPersons");
        this.initDataOnTableForPerson("getAppointmentPersons", dataRows, "PERSON.ID", "COUNTTIMES");
    }

    private IRowSet getPersonsDataOnEmployee(String str) throws BOSException {
        EntityViewInfo query = (EntityViewInfo)this.mainQuery.clone();
        if ("getAppointmentPersons".equals(str)) {
            FilterInfo filterInfo = query.getFilter();
            if (filterInfo.getFilterItems().size() > 0) {
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("appointStatus", null, CompareType.NOTEQUALS));
                try {
                    filterInfo.mergeFilter(filter, "and");
                }
                catch (BOSException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            } else {
                filterInfo.getFilterItems().add(new FilterItemInfo("appointStatus", null, CompareType.NOTEQUALS));
            }
            query.setFilter(filterInfo);
        }
        return HRStateTWOClientUtils.query(query, "com.kingdee.eas.hr.state.app", "PersonTechnicalStatEmploeeQuery");
    }

    public String getPropertyOfBizOrg(OrgType orgType) {
        return null;
    }

    private void initDataOnTableForPerson(String columnName, IRowSet dataRows, String idFieldName, String countFieldName) throws SQLException {
        if (dataRows != null) {
            Integer value = null;
            int indexX = this.tblMain.getColumn(columnName).getColumnIndex();
            int indexY = 0;
            while (dataRows.next()) {
                if (dataRows.getString(idFieldName) == null) continue;
                value = dataRows.getInt(countFieldName);
                if (this.latitudeIDMap.get(dataRows.getString(idFieldName)) == null) continue;
                indexY = (Integer)this.latitudeIDMap.get(dataRows.getString(idFieldName));
                if (value != null && value > 0) {
                    this.tblMain.getRow(indexY).getCell(indexX).setValue((Object)1);
                    continue;
                }
                this.tblMain.getRow(indexY).getCell(indexX).setValue((Object)0);
            }
        }
    }

    private void initDataOnTable(String columnName, IRowSet dataRows, String idFieldName, String countFieldName) throws SQLException {
        if (dataRows != null) {
            Integer value = null;
            int indexX = this.tblMain.getColumn(columnName).getColumnIndex();
            int indexY = 0;
            while (dataRows.next()) {
                if (dataRows.getString(idFieldName) == null) continue;
                value = dataRows.getInt(countFieldName);
                if (this.latitudeIDMap.get(dataRows.getString(idFieldName)) == null) continue;
                indexY = (Integer)this.latitudeIDMap.get(dataRows.getString(idFieldName));
                this.tblMain.getRow(indexY).getCell(indexX).setValue((Object)value);
            }
        }
    }

    private void initData(String latitudeType) {
        try {
            if (latitudeType.equals("department")) {
                this.initDataOnDepartment();
            } else if (latitudeType.equals("employee")) {
                this.initDataOnEmployee();
            }
        }
        catch (Exception e) {
            MsgBox.showError((String)EASResource.getString((String)RES, (String)"initTableDataError"));
            SysUtil.abort();
        }
    }

    private void scanTable() {
        int lengthX = 3;
        int lengthY = this.tblMain.getBody().size();
        IRow sumRow = null;
        if ("department".equals(this.statusMap.get("latitudeType")) && ("true".equals(this.statusMap.get("isIncludeChild")) || this.statusMap.get("adminOrg.id") == null)) {
            sumRow = this.tblMain.getRow(this.tblMain.getBody().size() - 1);
        } else {
            sumRow = this.tblMain.addRow();
            sumRow.getCell(0).setValue((Object)EASResource.getString((String)RES, (String)"sum"));
        }
        if (sumRow != null) {
            for (int x = 1; x < lengthX; ++x) {
                int sum = 0;
                Object value = null;
                for (int y = 0; y < lengthY; ++y) {
                    value = this.tblMain.getRow(y).getCell(x).getValue();
                    if (value == null) {
                        this.tblMain.getRow(y).getCell(x).setValue((Object)0);
                        continue;
                    }
                    sum += ((Integer)value).intValue();
                }
                sumRow.getCell(x).setValue((Object)sum);
            }
        }
        if (this.tblMain.getColumn("latitude") != null) {
            this.tblMain.getColumn("latitude").setWidth(250);
        } else if (this.tblMain.getColumn("treeColumn") != null) {
            this.tblMain.getColumn("treeColumn").setWidth(250);
        }
        this.tblMain.getColumn("getTechDutyPersons").setWidth(250);
        this.tblMain.getColumn("getAppointmentPersons").setWidth(250);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().print();
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().printPreview();
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        OutputExcelUtil excelUtil = new OutputExcelUtil();
        if (excelUtil.appendToExcel(this.tblMain, true, true, this.getUITitle()) != null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.state.client.StateResource", (String)"EXPORT_SUCCESS"));
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected String getEditUIName() {
        return null;
    }

    protected boolean isUseStandardPermission() {
        return true;
    }
}

