/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.state.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitFactory;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.hr.base.CompetencyLevelFactory;
import com.kingdee.eas.hr.base.CompetencyLevelInfo;
import com.kingdee.eas.hr.base.client.IHRF7CommonRegister;
import com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox;
import com.kingdee.eas.hr.org.client.AdminByOrgRangePromptBox;
import com.kingdee.eas.hr.state.ProfTechQualTypeFactory;
import com.kingdee.eas.hr.state.ProfTechQualTypeInfo;
import com.kingdee.eas.hr.state.client.AbstractProfCollectFilterUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class ProfCollectFilterUI
extends AbstractProfCollectFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(ProfCollectFilterUI.class);
    private static final String RES = "com.kingdee.eas.hr.state.client.StateTWOResource";
    private static final String MessageRES = "com.kingdee.eas.hr.state.client.MessageTWOResource";
    public static final String LATITUDE_TYPE_ADMINORG = "adminOrg";
    public static final String LATITUDE_TYPE_PERSON = "person";
    private String latitudeType;

    public void onLoad() throws Exception {
        super.onLoad();
        this.prmtAdminOrg.setEditable(false);
        this.prmtPerson.setEditable(false);
        this.prmtProfType.setEditable(false);
        this.prmtTechnicLevel.setEditable(false);
        this.setSelect(LATITUDE_TYPE_PERSON);
        this.initAllEditor();
    }

    private void initAllEditor() {
        this.btnAdminOrg.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    ProfCollectFilterUI.this.setSelect(ProfCollectFilterUI.LATITUDE_TYPE_ADMINORG);
                }
                catch (Exception exc) {
                    ProfCollectFilterUI.this.handUIException(exc);
                }
            }
        });
        this.btnPerson.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    ProfCollectFilterUI.this.setSelect(ProfCollectFilterUI.LATITUDE_TYPE_PERSON);
                }
                catch (Exception exc) {
                    ProfCollectFilterUI.this.handUIException(exc);
                }
            }
        });
        this.chkLike.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ProfCollectFilterUI.this.setSearchType();
            }
        });
    }

    public void clear() {
        super.clear();
        this.prmtPerson.setValue(null);
        this.prmtAdminOrg.setValue(null);
        this.prmtProfType.setValue(null);
        this.prmtTechnicLevel.setValue(null);
        this.btnAdminOrg.setSelected(false);
        this.btnPerson.setSelected(true);
        this.chkIncludeChild.setSelected(false);
        this.chkLike.setSelected(false);
        this.txPerson.setText("");
    }

    public boolean verify() {
        return true;
    }

    protected void initF7Context(IHRF7CommonRegister register) {
        super.initF7Context(register);
        AdminByOrgRangePromptBox adminOrgF7 = new AdminByOrgRangePromptBox("FALSE");
        this.prmtAdminOrg.setEditFormat("$number$");
        this.prmtAdminOrg.setDisplayFormat("$name$");
        this.prmtAdminOrg.setCommitFormat("$number$");
        this.prmtAdminOrg.setSelector((KDPromptSelector)adminOrgF7);
        EmployeeMultiF7PromptBox empF7 = new EmployeeMultiF7PromptBox();
        empF7.setUserOrgRangeFilter(true);
        empF7.showNoPositionPerson(true);
        this.prmtPerson.setEditFormat("$number$");
        this.prmtPerson.setDisplayFormat("$name$");
        this.prmtPerson.setCommitFormat("$number$");
        this.prmtPerson.setSelector((KDPromptSelector)empF7);
        this.prmtAdminOrg.setEditable(true);
        this.prmtPerson.setEditable(true);
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.getMainOrg();
    }

    private void setSearchType() {
        boolean style = this.chkLike.isSelected();
        if (style) {
            this.prmtPerson.setValue(null);
            this.prmtPerson.setEnabled(false);
            this.prmtPerson.setVisible(false);
            this.txPerson.setEnabled(true);
            this.txPerson.setVisible(true);
        } else {
            this.prmtPerson.setEnabled(true);
            this.prmtPerson.setVisible(true);
            this.txPerson.setText("");
            this.txPerson.setEnabled(false);
            this.txPerson.setVisible(false);
        }
    }

    private void setSelect(String selectType) {
        if (selectType.equals(LATITUDE_TYPE_ADMINORG) && this.btnAdminOrg.isSelected()) {
            this.prmtAdminOrg.setEnabled(true);
            this.chkIncludeChild.setEnabled(true);
            this.chkIncludeChild.setSelected(false);
            this.chkLike.setSelected(false);
            this.chkLike.setEnabled(false);
            this.setSearchType();
            this.prmtPerson.setEnabled(false);
            this.prmtPerson.setValue(null);
            this.latitudeType = LATITUDE_TYPE_ADMINORG;
        } else if (selectType.equals(LATITUDE_TYPE_PERSON) && this.btnPerson.isSelected()) {
            this.chkLike.setEnabled(true);
            this.chkLike.setSelected(false);
            this.setSearchType();
            this.prmtAdminOrg.setEnabled(false);
            this.prmtAdminOrg.setValue(null);
            this.chkIncludeChild.setSelected(false);
            this.chkIncludeChild.setEnabled(false);
            this.latitudeType = LATITUDE_TYPE_PERSON;
        }
    }

    public Map getParams() {
        int i;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("latitudeType", this.latitudeType);
        if (this.btnAdminOrg.isSelected()) {
            params.put("isIncludeChild", this.chkIncludeChild.isSelected());
            if (this.prmtAdminOrg.getValue() != null) {
                AdminOrgUnitInfo org = (AdminOrgUnitInfo)this.prmtAdminOrg.getValue();
                params.put("adminOrg.id", org.getId().toString());
                params.put("adminOrg.longNumber", org.getLongNumber());
            }
        }
        if (this.btnPerson.isSelected()) {
            boolean isLike = this.chkLike.isSelected();
            params.put("isLike", isLike);
            if (!isLike) {
                if (this.prmtPerson.getValue() != null) {
                    PersonInfo person = (PersonInfo)this.prmtPerson.getValue();
                    params.put("person.id", person.getId().toString());
                }
            } else {
                params.put("personText", this.txPerson.getText());
            }
        }
        if (this.prmtHROrg.getValue() != null) {
            HROrgUnitInfo hrOrg = (HROrgUnitInfo)this.prmtHROrg.getValue();
            params.put("hrOrgUnit.id", hrOrg.getId().toString());
        }
        if (this.prmtProfType.getValue() != null) {
            Object[] dataArray = (Object[])this.prmtProfType.getValue();
            HashSet<String> typeIDSet = new HashSet<String>();
            for (i = 0; i < dataArray.length; ++i) {
                if (dataArray[i] == null) continue;
                typeIDSet.add(((ProfTechQualTypeInfo)dataArray[i]).getId().toString());
            }
            params.put("types", typeIDSet);
        }
        if (this.prmtTechnicLevel.getValue() != null) {
            Object[] level = (Object[])this.prmtTechnicLevel.getValue();
            HashSet<String> levelIDSet = new HashSet<String>();
            for (i = 0; i < level.length; ++i) {
                if (level[i] == null) continue;
                levelIDSet.add(((CompetencyLevelInfo)level[i]).getId().toString());
            }
            params.put("levels", levelIDSet);
        }
        return params;
    }

    public FilterInfo getFilterInfo() {
        Object temp;
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection itemCollection = filterInfo.getFilterItems();
        FilterItemInfo itemInfo = null;
        Object value = this.prmtProfType.getValue();
        if (value != null) {
            Object[] dataArray = (Object[])value;
            HashSet<String> set = new HashSet<String>();
            if (dataArray.length > 0 && dataArray[0] != null && dataArray[0] instanceof ProfTechQualTypeInfo) {
                for (int i = 0; i < dataArray.length; ++i) {
                    if (dataArray[i] == null || !(dataArray[i] instanceof ProfTechQualTypeInfo)) continue;
                    set.add(((ProfTechQualTypeInfo)dataArray[i]).getId().toString());
                }
                if (set.size() > 0) {
                    itemInfo = new FilterItemInfo("profTechQualType.id", set, CompareType.INCLUDE);
                    filterInfo.getFilterItems().add(itemInfo);
                }
            }
        }
        if ((temp = this.prmtTechnicLevel.getValue()) != null) {
            Object[] dataArray = (Object[])temp;
            HashSet<String> set = new HashSet<String>();
            if (dataArray.length > 0 && dataArray[0] != null && dataArray[0] instanceof CompetencyLevelInfo) {
                for (int i = 0; i < dataArray.length; ++i) {
                    if (dataArray[i] == null || !(dataArray[i] instanceof CompetencyLevelInfo)) continue;
                    set.add(((CompetencyLevelInfo)dataArray[i]).getId().toString());
                }
                if (set.size() > 0) {
                    itemInfo = new FilterItemInfo("technicLevel.id", set, CompareType.INCLUDE);
                    filterInfo.getFilterItems().add(itemInfo);
                }
            }
        }
        if (this.btnPerson.isSelected()) {
            Object Person = this.prmtPerson.getData();
            this.setPersonFilter(this.chkLike.isSelected(), Person, filterInfo);
        } else if (this.btnAdminOrg.isSelected()) {
            Object adminOrg = this.prmtAdminOrg.getData();
            this.setAdminOrgFilter(this.chkIncludeChild.isSelected(), (AdminOrgUnitInfo)adminOrg, filterInfo);
        }
        if (filterInfo.getFilterItems().size() == 0) {
            itemCollection.add(new FilterItemInfo("person.id", null, CompareType.ISNOT));
        }
        return filterInfo;
    }

    private void setAdminOrgFilter(boolean isIncludeChild, AdminOrgUnitInfo org, FilterInfo filter) {
        String Num = "01";
        String longNum = "01";
        if (org == null) {
            return;
        }
        longNum = org.getLongNumber();
        Num = org.getNumber();
        if (org == null || isIncludeChild) {
            if (filter.getFilterItems().size() > 0) {
                FilterInfo orgFilter = new FilterInfo();
                orgFilter.getFilterItems().add(new FilterItemInfo("adminOrg.longNumber", (Object)(longNum + "!%"), CompareType.LIKE));
                orgFilter.getFilterItems().add(new FilterItemInfo("adminOrg.number", (Object)Num, CompareType.EQUALS));
                orgFilter.setMaskString("#0 or #1");
                try {
                    filter.mergeFilter(orgFilter, "and");
                }
                catch (BOSException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            } else {
                filter.getFilterItems().add(new FilterItemInfo("adminOrg.longNumber", (Object)(longNum + "!%"), CompareType.LIKE));
                filter.getFilterItems().add(new FilterItemInfo("adminOrg.number", (Object)Num, CompareType.EQUALS));
                filter.setMaskString("#0 or #1");
            }
        } else {
            filter.getFilterItems().add(new FilterItemInfo("adminOrg.id", (Object)org.getId(), CompareType.EQUALS));
        }
    }

    private void setPersonFilter(boolean isLikeStyle, Object person, FilterInfo filter) {
        if (isLikeStyle) {
            String condStr = this.txPerson.getText();
            if (filter.getFilterItems().size() > 0) {
                FilterInfo personFilter = new FilterInfo();
                personFilter.getFilterItems().add(new FilterItemInfo("person.number", (Object)("%" + condStr + "%"), CompareType.LIKE));
                personFilter.getFilterItems().add(new FilterItemInfo("person.name", (Object)("%" + condStr + "%"), CompareType.LIKE));
                personFilter.setMaskString("#0 or #1");
                try {
                    filter.mergeFilter(personFilter, "and");
                }
                catch (BOSException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            } else {
                filter.getFilterItems().add(new FilterItemInfo("person.number", (Object)("%" + condStr + "%"), CompareType.LIKE));
                filter.getFilterItems().add(new FilterItemInfo("person.name", (Object)("%" + condStr + "%"), CompareType.LIKE));
                filter.setMaskString("#0 or #1");
            }
        } else if (person != null && person instanceof PersonInfo) {
            filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)((PersonInfo)person).getId(), CompareType.EQUALS));
        } else {
            String condStr = "";
            filter.getFilterItems().add(new FilterItemInfo("person.number", (Object)("%" + condStr + "%"), CompareType.LIKE));
            filter.getFilterItems().add(new FilterItemInfo("person.name", (Object)("%" + condStr + "%"), CompareType.LIKE));
            filter.setMaskString("#0 or #1");
        }
    }

    public void setCustomerParams(CustomerParams cp) {
        try {
            this._setCustomerParams(cp);
        }
        catch (Exception e) {
            MsgBox.showError((String)EASResource.getString((String)MessageRES, (String)"setQueryError"));
            SysUtil.abort();
        }
    }

    private void _setCustomerParams(CustomerParams cp) throws Exception {
        String id;
        ObjectUuidPK pk = null;
        this.latitudeType = cp.getCustomerParam("latitudeType");
        if (this.latitudeType.equals(LATITUDE_TYPE_ADMINORG)) {
            this.btnAdminOrg.setSelected(true);
            if (cp.getCustomerParam("adminOrg.id") != null) {
                AdminOrgUnitInfo adminOrg = null;
                pk = new ObjectUuidPK(BOSUuid.read((String)cp.getCustomerParam("adminOrg.id")));
                adminOrg = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)pk);
                this.prmtAdminOrg.setData((Object)adminOrg);
            }
            this.chkIncludeChild.setSelected(cp.getBoolean("isIncludeChild"));
        } else if (this.latitudeType.equals(LATITUDE_TYPE_PERSON)) {
            this.btnPerson.setSelected(true);
            this.chkLike.setSelected(cp.getBoolean("isLike"));
            if (!this.chkLike.isSelected()) {
                if (cp.getCustomerParam("person.id") != null) {
                    PersonInfo person = null;
                    pk = new ObjectUuidPK(BOSUuid.read((String)cp.getCustomerParam("person.id")));
                    person = PersonFactory.getRemoteInstance().getPersonInfo((IObjectPK)pk);
                    this.prmtPerson.setValue((Object)person);
                }
            } else {
                this.txPerson.setText(cp.getCustomerParam("person.name"));
            }
        }
        if (cp.getCustomerParam("hrOrg.id") != null) {
            HROrgUnitInfo hrOrg = null;
            pk = new ObjectUuidPK(BOSUuid.read((String)cp.getCustomerParam("hrOrg.id")));
            hrOrg = HROrgUnitFactory.getRemoteInstance().getHROrgUnitInfo((IObjectPK)pk);
            this.prmtHROrg.setValue((Object)hrOrg);
        }
        int count = cp.getInt("typeCount");
        Object[] dataArray = new Object[count];
        ProfTechQualTypeInfo rpType = null;
        for (int i = 0; i < count; ++i) {
            id = cp.getCustomerParam("profTechQualType.id" + i);
            pk = new ObjectUuidPK(BOSUuid.read((String)id));
            rpType = ProfTechQualTypeFactory.getRemoteInstance().getProfTechQualTypeInfo((IObjectPK)pk);
            dataArray[i] = rpType;
        }
        this.prmtProfType.setValue((Object)dataArray);
        count = cp.getInt("levelCount");
        dataArray = new Object[count];
        CompetencyLevelInfo rpLevel = null;
        for (int i = 0; i < count; ++i) {
            id = cp.getCustomerParam("technicLevel.id" + i);
            pk = new ObjectUuidPK(BOSUuid.read((String)id));
            rpLevel = CompetencyLevelFactory.getRemoteInstance().getCompetencyLevelInfo((IObjectPK)pk);
            dataArray[i] = rpLevel;
        }
        this.prmtTechnicLevel.setValue((Object)dataArray);
    }

    public CustomerParams getCustomerParams() {
        CustomerParams params = new CustomerParams();
        if (this.btnAdminOrg.isSelected()) {
            if (this.prmtAdminOrg.getValue() != null) {
                params.addCustomerParam("adminOrg.id", ((AdminOrgUnitInfo)this.prmtAdminOrg.getValue()).getId().toString());
            }
            params.putBoolean("isIncludeChild", this.chkIncludeChild.isSelected());
            params.addCustomerParam("latitudeType", LATITUDE_TYPE_ADMINORG);
        } else if (this.btnPerson.isSelected()) {
            boolean isLike = this.chkLike.isSelected();
            params.putBoolean("isLike", isLike);
            if (!isLike) {
                if (this.prmtPerson.getValue() != null) {
                    params.addCustomerParam("person.id", ((PersonInfo)this.prmtPerson.getValue()).getId().toString());
                }
            } else {
                params.addCustomerParam("person.name", this.txPerson.getText());
            }
            params.addCustomerParam("latitudeType", LATITUDE_TYPE_PERSON);
        }
        if (this.prmtHROrg.getValue() != null) {
            params.addCustomerParam("hrOrg.id", ((HROrgUnitInfo)this.prmtHROrg.getValue()).getId().toString());
        }
        Object[] dataArray = null;
        int i = 0;
        if (this.prmtProfType.getValue() != null) {
            dataArray = (Object[])this.prmtProfType.getValue();
            for (i = 0; i < dataArray.length; ++i) {
                if (!(dataArray[i] instanceof ProfTechQualTypeInfo)) continue;
                params.addCustomerParam("profTechQualType.id" + i, ((ProfTechQualTypeInfo)dataArray[i]).getId().toString());
            }
        }
        params.putInt("typeCount", i);
        Object[] dataArray2 = null;
        i = 0;
        if (this.prmtTechnicLevel.getValue() != null) {
            dataArray2 = (Object[])this.prmtTechnicLevel.getValue();
            for (i = 0; i < dataArray2.length; ++i) {
                if (!(dataArray2[i] instanceof CompetencyLevelInfo)) continue;
                params.addCustomerParam("technicLevel.id" + i, ((CompetencyLevelInfo)dataArray2[i]).getId().toString());
            }
        }
        params.putInt("levelCount", i);
        return params;
    }
}

