/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.state.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.hraux.util.HRTreeUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.context.IMultiOrgSupport;
import com.kingdee.eas.hr.base.CompetencyLevelInfo;
import com.kingdee.eas.hr.base.HROrgContextManagerFacadeFactory;
import com.kingdee.eas.hr.base.OutputExcelUtil;
import com.kingdee.eas.hr.emp.client.HRCellTreeRenderer;
import com.kingdee.eas.hr.emp.client.HRCellUserObject;
import com.kingdee.eas.hr.emp.client.HRTreeTable;
import com.kingdee.eas.hr.state.ProfTechQualTypeInfo;
import com.kingdee.eas.hr.state.client.AbstractProfCollectListUI;
import com.kingdee.eas.hr.state.client.HRStateTWOClientUtils;
import com.kingdee.eas.hr.state.client.ProfCollectFilterManager;
import com.kingdee.eas.hr.state.client.ProfCollectFilterUI;
import com.kingdee.eas.hr.state.client.ProfCollectUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

public class ProfCollectListUI
extends AbstractProfCollectListUI {
    private static final Logger logger = CoreUIObject.getLogger(ProfCollectListUI.class);
    protected KDWorkButton btnExport;
    private ProfCollectFilterManager filterManager;
    private static final String RES = "com.kingdee.eas.hr.state.client.StateTWOResource";
    private static final String PANEL_CLASSNAME = "com.kingdee.eas.hr.state.client.ProfCollectFilterUI";
    private HashMap latitudeMap;
    private HashMap headMap;
    private String adminId;
    private DefaultKingdeeTreeNode childNode = null;
    private List rpType;
    private List tLevel;
    private List fetchId;

    protected void afterOnLoad() throws Exception {
        super.afterOnLoad();
        HRTreeTable.setHRTreeTable((KDTable)this.tblMain, (String)"treeColumn");
        this.tblMain.checkParsed();
        this.tblMain.setEditable(false);
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.setAutoscrolls(true);
        this.btnQueryScheme.setVisible(false);
        this.enableExportExcel(this.tblMain);
        this.refreshData();
        this.tHelper.getDisabledTables().add(this.tblMain);
    }

    protected void initListener() {
    }

    public void initTableListner(KDTable table) {
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnExportData.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.btnExportData.setText(null);
        this.btnQueryScheme.setVisible(true);
        this.actionQueryScheme.setVisible(false);
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        OutputExcelUtil excelUtil = new OutputExcelUtil();
        if (excelUtil.appendToExcel(this.tblMain, true, true, this.getUITitle()) != null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.state.client.StateResource", (String)"EXPORT_SUCCESS"));
        }
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.refreshData();
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().print();
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().printPreview();
    }

    protected void handleQueryDialog(CommonQueryDialog dialog) throws Exception {
        super.handleQueryDialog(dialog);
        dialog.setMaxReturnCountVisible(false);
        dialog.setShowSorter(false);
        dialog.setUiObject(null);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        String QueryName = "com.kingdee.eas.hr.state.app.ProfCollectQuery";
        if (this.getDialog() != null) {
            if (this.filterManager == null) {
                this.filterManager = new ProfCollectFilterManager(this.getDialog());
            } else {
                this.filterManager.reloadData(this.getDialog());
            }
            this.loadDatas();
        } else {
            IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
            ProfCollectFilterUI filterUI = new ProfCollectFilterUI();
            QuerySolutionInfo solution = iQuery.getDefaultSolution(this.getMetaDataPK().getFullName(), QueryName);
            CustomerParams params = CustomerParams.getCustomerParams2((String)this.getCustomerParamsStr(solution));
            if (params != null) {
                filterUI.setCustomerParams(params);
                if (this.filterManager == null) {
                    this.filterManager = new ProfCollectFilterManager(filterUI);
                } else {
                    this.filterManager.reloadData(filterUI);
                }
                this.loadDatas();
            }
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected String getEditUIName() {
        return null;
    }

    protected IMultiOrgSupport getMainCustomerQueryPanel() {
        try {
            return new ProfCollectFilterUI();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
            return null;
        }
    }

    private void resetTable() {
        this.tblMain.removeRows();
        int count = this.tblMain.getColumnCount();
        for (int i = count - 1; i > -1; --i) {
            this.tblMain.removeColumn(i);
        }
        this.tblMain.getHead().removeRows();
    }

    private void refreshData() {
        this.loadDatas();
    }

    private void loadDatas() {
        this.resetTable();
        this.tblMain.addColumn();
        if (this.filterManager.getLatitudeType().equals("adminOrg") && this.filterManager.isIncludeChild()) {
            this.tblMain.getColumn(this.tblMain.getColumnCount() - 1).setKey("treeColumn");
        } else {
            this.tblMain.getColumn(this.tblMain.getColumnCount() - 1).setKey("latitudeName");
        }
        this.latitudeMap = new HashMap();
        this.headMap = new HashMap();
        this.fetchId = new ArrayList();
        String latitudeType = (String)this.filterManager.getLatitudeType();
        this.initLatitude(latitudeType);
        this.initTableHead();
        this.initData(latitudeType);
        this.scanTable();
        this.tblMain.setRowCount(this.tblMain.getBody().size());
    }

    private void initLatitude(String latitudeType) {
        try {
            if (latitudeType.equals("adminOrg")) {
                this.initDepartmentLatitude();
            } else if (latitudeType.equals("person")) {
                this.initEmployeeLatitude();
            }
        }
        catch (Exception e) {
            MsgBox.showError((String)EASResource.getString((String)RES, (String)"initLatitudeError"));
            this.resetTable();
            SysUtil.abort();
        }
    }

    private void initDepartmentLatitude() throws Exception {
        boolean isIncludeChild = this.filterManager.isIncludeChild();
        AdminOrgUnitInfo info = null;
        IRow row = null;
        if (isIncludeChild) {
            Vector<AdminOrgUnitInfo> vec = new Vector<AdminOrgUnitInfo>();
            DefaultKingdeeTreeNode rootNode = this.getOrgUnitTreeNode();
            if (rootNode == null) {
                return;
            }
            AdminOrgUnitInfo rootInfo = (AdminOrgUnitInfo)rootNode.getUserObject();
            if (HRTreeUtil.isTreeNodeDisable((DefaultKingdeeTreeNode)rootNode)) {
                rootInfo.put("isEnable", (Object)false);
            } else {
                rootInfo.put("isEnable", (Object)true);
            }
            rootInfo.setLevel(rootNode.getLevel());
            vec.add(rootInfo);
            this.getCellUserObjects(rootNode, vec);
            HRCellTreeRenderer orgCellRen = new HRCellTreeRenderer();
            int initLevel = 0;
            int size = vec.size();
            for (int i = 0; i < size; ++i) {
                info = (AdminOrgUnitInfo)vec.get(i);
                if (i == 0) {
                    initLevel = info.getLevel();
                }
                row = this.tblMain.addRow(i);
                if (!Boolean.valueOf(info.get("isEnable").toString()).booleanValue()) {
                    row.getStyleAttributes().setBackground(Color.LIGHT_GRAY);
                }
                HRCellUserObject orgCellObj = new HRCellUserObject();
                orgCellObj.setCompanyId(info.getId().toString());
                orgCellObj.setName(info.getName());
                orgCellObj.setLongNumber(info.getLongNumber());
                orgCellObj.setIsLeaf(info.isIsLeaf());
                orgCellObj.setLevel(info.getLevel() - initLevel);
                orgCellObj.setExpanded(true);
                this.latitudeMap.put(info.getId().toString(), row.getRowIndex());
                row.getCell("treeColumn").setValue((Object)orgCellObj);
                row.getCell("treeColumn").setRenderer((IBasicRender)orgCellRen);
            }
            IRow sumRow = this.tblMain.addRow();
            HRCellUserObject cellValue = new HRCellUserObject();
            cellValue.setCompanyId("");
            cellValue.setIsLeaf(true);
            cellValue.setLevel(0);
            cellValue.setLongNumber("01");
            cellValue.setName(EASResource.getString((String)RES, (String)"sum"));
            cellValue.setExpanded(true);
            sumRow.getCell(0).setValue((Object)cellValue);
            sumRow.getCell(0).setRenderer((IBasicRender)orgCellRen);
            this.tblMain.getColumn(0).setWidth(200);
        } else if (this.filterManager.getDepartmentIDValue() == null) {
            AdminOrgUnitInfo topOrg = (AdminOrgUnitInfo)this.getOrgUnitTreeNode().getUserObject();
            IRow r = this.tblMain.addRow();
            r.getCell("latitudeName").setValue((Object)topOrg);
            this.latitudeMap.put(topOrg.getId().toString(), r.getRowIndex());
        } else {
            List adminOrgs = null;
            String adminID = (String)this.filterManager.getDepartmentIDValue();
            adminOrgs = adminID != null ? ProfCollectUtil.findAdminOrgNotIncludeChildByID(adminID) : ProfCollectUtil.findAdminOrgNotIncludeChild();
            AdminOrgUnitInfo org = null;
            for (int i = 0; i < adminOrgs.size(); ++i) {
                row = this.tblMain.addRow();
                org = (AdminOrgUnitInfo)adminOrgs.get(i);
                this.latitudeMap.put(org.getId().toString(), row.getRowIndex());
                row.getCell("latitudeName").setValue((Object)org);
            }
            this.tblMain.getColumn(0).setWidth(160);
        }
    }

    private void initEmployeeLatitude() throws Exception {
        PersonInfo person;
        EntityViewInfo viewInfo = null;
        viewInfo = this.getDialog() != null ? this.getDialog().getEntityViewInfoResult() : this.getDefaultEntityViewInfo();
        ArrayList<PersonInfo> employeeList = new ArrayList<PersonInfo>();
        IRowSet rowSet = HRStateTWOClientUtils.query(viewInfo, "com.kingdee.eas.hr.state.app", "ProfCollectQuery");
        List personList = HROrgContextManagerFacadeFactory.getRemoteInstance().getUserOrgRangePerson(null);
        HashSet<String> userOrgPerson = new HashSet<String>();
        for (int i = 0; i < personList.size(); ++i) {
            person = (PersonInfo)personList.get(i);
            userOrgPerson.add(person.getId().toString());
        }
        PersonInfo personInfo = null;
        while (rowSet.next()) {
            if (!userOrgPerson.contains(rowSet.getString("person.id"))) continue;
            personInfo = new PersonInfo();
            personInfo.setId(BOSUuid.read((String)rowSet.getString("person.id")));
            personInfo.setName(rowSet.getString("person.name"));
            this.fetchId.add(rowSet.getString("id"));
            employeeList.add(personInfo);
        }
        if (employeeList != null) {
            person = null;
            IRow row = null;
            int rowCount = this.tblMain.getRowCount();
            for (int i = 0; i < employeeList.size(); ++i) {
                person = (PersonInfo)employeeList.get(i);
                row = this.tblMain.addRow(rowCount + i);
                this.latitudeMap.put(this.fetchId.get(i), row.getRowIndex());
                row.getCell("latitudeName").setValue((Object)person);
            }
        }
    }

    private DefaultKingdeeTreeNode getOrgUnitTreeNode() throws Exception {
        this.adminId = (String)this.filterManager.getDepartmentIDValue();
        DefaultKingdeeTreeNode orgRoot = HRTreeUtil.createAdminTreeNodeByUserRange((boolean)false, (boolean)false, (boolean)true, (boolean)false, null);
        if (orgRoot == null) {
            return null;
        }
        if (this.adminId != null) {
            HashMap<String, DefaultKingdeeTreeNode> map = new HashMap<String, DefaultKingdeeTreeNode>();
            map.put(this.getAdminIdByAdminNode(orgRoot), orgRoot);
            this.overTreeNodeSimple(orgRoot, map);
            orgRoot = (DefaultKingdeeTreeNode)map.get(this.adminId);
        } else {
            this.adminId = ((AdminOrgUnitInfo)orgRoot.getUserObject()).getId().toString();
        }
        return orgRoot;
    }

    private void overTreeNodeSimple(DefaultKingdeeTreeNode root, HashMap nodeMap) throws Exception {
        DefaultKingdeeTreeNode node = null;
        int count = root.getChildCount();
        for (int i = 0; i < count; ++i) {
            node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            nodeMap.put(this.getAdminIdByAdminNode(node), node);
            this.overTreeNodeSimple(node, nodeMap);
        }
    }

    private String getAdminIdByAdminNode(DefaultKingdeeTreeNode node) {
        AdminOrgUnitInfo adminInfo = null;
        if (node.getUserObject() instanceof AdminOrgUnitInfo) {
            adminInfo = (AdminOrgUnitInfo)node.getUserObject();
        }
        if (adminInfo != null) {
            return adminInfo.getId().toString();
        }
        return null;
    }

    private void getCellUserObjects(DefaultKingdeeTreeNode treeNode, Vector vec) {
        AdminOrgUnitInfo adminInfo = null;
        if (treeNode != null && treeNode.getUserObject() != null && treeNode.getUserObject() instanceof AdminOrgUnitInfo) {
            for (int i = 0; i < treeNode.getChildCount(); ++i) {
                this.childNode = (DefaultKingdeeTreeNode)treeNode.getChildAt(i);
                if (!(this.childNode.getUserObject() instanceof AdminOrgUnitInfo)) continue;
                adminInfo = (AdminOrgUnitInfo)this.childNode.getUserObject();
                adminInfo.setLevel(this.childNode.getLevel());
                if (HRTreeUtil.isTreeNodeDisable((DefaultKingdeeTreeNode)this.childNode)) {
                    adminInfo.put("isEnable", (Object)false);
                } else {
                    adminInfo.put("isEnable", (Object)true);
                }
                vec.add(adminInfo);
                if (this.childNode.getChildCount() <= 0) continue;
                this.getCellUserObjects(this.childNode, vec);
            }
        }
    }

    private void initTableHead() {
        int i;
        try {
            this.rpType = ProfCollectUtil.findProfTechQualType((HashSet)this.filterManager.getProfTypes());
            this.tLevel = ProfCollectUtil.findTechnicLevel((HashSet)this.filterManager.getTechnicLevel());
        }
        catch (BOSException e) {
            MsgBox.showError((String)EASResource.getString((String)RES, (String)"initTableHeadError"));
            this.resetTable();
            SysUtil.abort();
        }
        this.tblMain.addHeadRow(0);
        this.tblMain.addHeadRow(1);
        this.tblMain.addHeadRow(2);
        int y = 0;
        y = this.filterManager.getLatitudeType().equals("adminOrg") && this.filterManager.isIncludeChild() ? this.tblMain.getColumnIndex("treeColumn") : this.tblMain.getColumnIndex("latitudeName");
        this.tblMain.getHeadMergeManager().mergeBlock(0, y, 2, y);
        int baseColSum = this.tblMain.getColumnCount();
        for (i = 0; i < this.rpType.size(); ++i) {
            this.tblMain.addColumn();
            this.tblMain.getHeadMergeManager().mergeBlock(2, i + baseColSum, 2, i + baseColSum);
            this.tblMain.getHead().getRow(2).getCell(i + baseColSum).setValue((Object)this.rpType.get(i).toString());
            this.headMap.put(((ProfTechQualTypeInfo)this.rpType.get(i)).getId().toString(), i + baseColSum);
        }
        if (this.rpType.size() == 1) {
            this.tblMain.getColumn(1).setWidth(120);
        }
        this.tblMain.getHeadMergeManager().mergeBlock(1, 1, 1, this.rpType.size());
        this.tblMain.getHead().getRow(1).getCell(1).setValue((Object)EASResource.getString((String)RES, (String)"profType"));
        for (i = 0; i < this.tLevel.size(); ++i) {
            this.tblMain.addColumn();
            this.tblMain.getHeadMergeManager().mergeBlock(2, i + baseColSum + this.rpType.size(), 2, i + baseColSum + this.rpType.size());
            this.tblMain.getHead().getRow(2).getCell(i + baseColSum + this.rpType.size()).setValue((Object)this.tLevel.get(i).toString());
            this.headMap.put(((CompetencyLevelInfo)this.tLevel.get(i)).getId().toString(), i + baseColSum + this.rpType.size());
        }
        this.tblMain.getHeadMergeManager().mergeBlock(1, this.rpType.size() + 1, 1, this.rpType.size() + this.tLevel.size());
        if (this.tblMain.getHead().getRow(1).getCell(this.rpType.size() + 1) != null) {
            this.tblMain.getHead().getRow(1).getCell(this.rpType.size() + 1).setValue((Object)EASResource.getString((String)RES, (String)"technicLevel"));
        }
        this.tblMain.getHeadMergeManager().mergeBlock(0, 1, 0, this.tLevel.size() + this.rpType.size());
        this.tblMain.getHead().getRow(0).getCell(1).setValue((Object)EASResource.getString((String)RES, (String)"personProf"));
        String latitudeType = (String)this.filterManager.getLatitudeType();
        if ("adminOrg".equals(latitudeType)) {
            this.tblMain.getHeadRow(0).getCell(0).setValue((Object)"\u884c\u653f\u7ec4\u7ec7");
        } else if ("person".equals(latitudeType)) {
            this.tblMain.getHeadRow(0).getCell(0).setValue((Object)"\u5458\u5de5\u59d3\u540d");
        }
    }

    private void initData(String latitudeType) {
        try {
            if (latitudeType.equals("adminOrg")) {
                this.initDataOnDepartment();
            } else if (latitudeType.equals("person")) {
                this.initDataOnEmployee();
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void initDataOnDepartment() throws BOSException, SQLException {
        int indexY;
        int indexX;
        Integer valuePersons;
        IRowSet rows = null;
        rows = ProfCollectUtil.countByDepartmentType(this.mainQuery);
        if (rows != null) {
            valuePersons = null;
            indexX = 0;
            indexY = 0;
            while (rows.next()) {
                if (rows.getString("PROFTECHQUALTYPEID") == null || rows.getString("ADMINORGID") == null) continue;
                valuePersons = rows.getInt("COUNTPERSONS");
                if (this.headMap.get(rows.getString("PROFTECHQUALTYPEID")) == null || this.latitudeMap.get(rows.getString("ADMINORGID")) == null) continue;
                indexX = (Integer)this.headMap.get(rows.getString("PROFTECHQUALTYPEID"));
                indexY = (Integer)this.latitudeMap.get(rows.getString("ADMINORGID"));
                this.tblMain.getRow(indexY).getCell(indexX).setValue((Object)valuePersons);
            }
        }
        if ((rows = ProfCollectUtil.countByDepartmentLevel(this.mainQuery)) != null) {
            valuePersons = null;
            indexX = 0;
            indexY = 0;
            while (rows.next()) {
                if (rows.getString("TECHNICLEVELID") == null || rows.getString("ADMINORGID") == null) continue;
                valuePersons = rows.getInt("COUNTPERSONS");
                if (this.headMap.get(rows.getString("TECHNICLEVELID")) == null || this.latitudeMap.get(rows.getString("ADMINORGID")) == null) continue;
                indexX = (Integer)this.headMap.get(rows.getString("TECHNICLEVELID"));
                indexY = (Integer)this.latitudeMap.get(rows.getString("ADMINORGID"));
                this.tblMain.getRow(indexY).getCell(indexX).setValue((Object)valuePersons);
            }
        }
    }

    private void initDataOnEmployee() throws BOSException, SQLException {
        int indexY;
        int indexX;
        Object value;
        IRowSet rows = null;
        rows = ProfCollectUtil.countByPersonType(this.mainQuery);
        if (rows != null) {
            value = null;
            indexX = 0;
            indexY = 0;
            while (rows.next()) {
                if (rows.getString("PROFTECHQUALTYPE.ID") == null || rows.getString("PERSON.ID") == null) continue;
                value = rows.getObject("COUNTPERSONS");
                if (this.headMap == null || this.headMap.get(rows.getString("PROFTECHQUALTYPE.ID")) == null || this.latitudeMap == null || this.latitudeMap.get(rows.getString("ID")) == null) continue;
                indexX = (Integer)this.headMap.get(rows.getString("PROFTECHQUALTYPE.ID"));
                indexY = (Integer)this.latitudeMap.get(rows.getString("ID"));
                this.tblMain.getRow(indexY).getCell(indexX).setValue(value);
                if (value != null && ((Number)value).intValue() > 0) {
                    this.tblMain.getRow(indexY).getCell(indexX).setValue((Object)1);
                    continue;
                }
                this.tblMain.getRow(indexY).getCell(indexX).setValue((Object)0);
            }
        }
        if ((rows = ProfCollectUtil.countByPersonLevel(this.mainQuery)) != null) {
            value = null;
            indexX = 0;
            indexY = 0;
            while (rows.next()) {
                if (rows.getString("TECHNICLEVEL.ID") == null || rows.getString("PERSON.ID") == null) continue;
                value = rows.getObject("COUNTPERSONS");
                if (this.headMap == null || this.headMap.get(rows.getString("TECHNICLEVEL.ID")) == null || this.latitudeMap == null || this.latitudeMap.get(rows.getString("ID")) == null) continue;
                indexX = (Integer)this.headMap.get(rows.getString("TECHNICLEVEL.ID"));
                indexY = (Integer)this.latitudeMap.get(rows.getString("ID"));
                this.tblMain.getRow(indexY).getCell(indexX).setValue(value);
                if (value != null && ((Number)value).intValue() > 0) {
                    this.tblMain.getRow(indexY).getCell(indexX).setValue((Object)1);
                    continue;
                }
                this.tblMain.getRow(indexY).getCell(indexX).setValue((Object)0);
            }
        }
    }

    private void scanTable() {
        int lengthX = this.rpType.size() + this.tLevel.size();
        int lengthY = this.tblMain.getBody().size();
        IRow sumRow = null;
        if (this.filterManager.getLatitudeType().equals("adminOrg") && this.filterManager.isIncludeChild()) {
            sumRow = this.tblMain.getRow(this.tblMain.getBody().size() - 1);
        } else {
            sumRow = this.tblMain.addRow();
            sumRow.getCell(0).setValue((Object)EASResource.getString((String)RES, (String)"sum"));
        }
        if (sumRow != null) {
            for (int x = 1; x < lengthX + 1; ++x) {
                int sum = 0;
                Object value = null;
                for (int y = 0; y < lengthY; ++y) {
                    value = this.tblMain.getRow(y).getCell(x).getValue();
                    if (value == null) {
                        this.tblMain.getRow(y).getCell(x).setValue((Object)0);
                        continue;
                    }
                    sum += ((Integer)value).intValue();
                }
                sumRow.getCell(x).setValue((Object)sum);
            }
        }
    }

    private String getCustomerParamsStr(QuerySolutionInfo solution) {
        if (null != solution && null != solution.getQueryPanelInfo() && solution.getQueryPanelInfo().size() > 0) {
            int len = solution.getQueryPanelInfo().size();
            for (int i = 0; i < len; ++i) {
                if (null == solution.getQueryPanelInfo().get(i) || !PANEL_CLASSNAME.equals(solution.getQueryPanelInfo().get(i).getPanelClassName())) continue;
                return solution.getQueryPanelInfo().get(i).getCustomerParams();
            }
        }
        return null;
    }

    public String getPropertyOfBizOrg(OrgType orgType) {
        return null;
    }

    protected boolean isUseStandardPermission() {
        return true;
    }
}

