/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.state.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.hr.base.CompetencyLevelCollection;
import com.kingdee.eas.hr.base.CompetencyLevelFactory;
import com.kingdee.eas.hr.base.CompetencyLevelInfo;
import com.kingdee.eas.hr.base.ICompetencyLevel;
import com.kingdee.eas.hr.state.IProfTechQualType;
import com.kingdee.eas.hr.state.ProfTechQualTypeCollection;
import com.kingdee.eas.hr.state.ProfTechQualTypeFactory;
import com.kingdee.eas.hr.state.ProfTechQualTypeInfo;
import com.kingdee.eas.hr.state.client.HRStateTWOClientUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.UuidException;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;

public class ProfCollectUtil {
    public static List findEmployee(boolean isLike, String condValue) throws BOSException, UuidException, SQLException {
        Vector<PersonInfo> persons;
        block6: {
            block5: {
                persons = new Vector<PersonInfo>();
                if (!isLike && condValue != null) break block5;
                FilterInfo filter = new FilterInfo();
                EntityViewInfo view = new EntityViewInfo();
                IRowSet dataRow = null;
                filter.getFilterItems().add(HRStateTWOClientUtils.getDefaultFilterForQuery("adminOrg.id"));
                if (isLike && !condValue.equals("")) {
                    filter.getFilterItems().add(new FilterItemInfo("name", (Object)("%" + condValue + "%"), CompareType.LIKE));
                    filter.getFilterItems().add(new FilterItemInfo("number", (Object)("%" + condValue + "%"), CompareType.LIKE));
                    filter.setMaskString("#0 and (#1 or #2))");
                }
                view.setFilter(filter);
                dataRow = HRStateTWOClientUtils.query(view, "com.kingdee.eas.hr.state.app", "HRStatFindPersonQuery");
                if (dataRow == null) break block6;
                PersonInfo info = null;
                while (dataRow.next()) {
                    info = new PersonInfo();
                    info.setName(dataRow.getString("NAME"));
                    info.setId(BOSUuid.read((String)dataRow.getString("ID")));
                    persons.add(info);
                }
                break block6;
            }
            IPerson iPerson = null;
            iPerson = PersonFactory.getRemoteInstance();
            PersonCollection collection = null;
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            if (condValue != null) {
                FilterItemInfo filterItem = new FilterItemInfo("id", (Object)condValue, CompareType.EQUALS);
                filter.getFilterItems().add(filterItem);
            }
            view.setFilter(filter);
            collection = iPerson.getPersonCollection(view);
            if (collection != null) {
                for (int i = 0; i < collection.size(); ++i) {
                    persons.add(collection.get(i));
                }
            }
        }
        return persons;
    }

    public static List findProfTechQualType(HashSet typeIDSet) throws BOSException {
        Vector<ProfTechQualTypeInfo> typeInfos = new Vector<ProfTechQualTypeInfo>();
        IProfTechQualType itype = null;
        ProfTechQualTypeCollection collection = null;
        if (typeIDSet == null || typeIDSet.size() == 0) {
            itype = ProfTechQualTypeFactory.getRemoteInstance();
            collection = itype.getProfTechQualTypeCollection();
        } else {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)typeIDSet, CompareType.INCLUDE));
            itype = ProfTechQualTypeFactory.getRemoteInstance();
            collection = itype.getProfTechQualTypeCollection(view);
        }
        if (collection != null && collection.size() > 0) {
            for (int i = 0; i < collection.size(); ++i) {
                typeInfos.add(collection.get(i));
            }
        }
        return typeInfos;
    }

    public static List findTechnicLevel(HashSet levelIDSet) throws BOSException {
        Vector<CompetencyLevelInfo> levelInfos = new Vector<CompetencyLevelInfo>();
        ICompetencyLevel ilevel = null;
        CompetencyLevelCollection collection = null;
        if (levelIDSet == null || levelIDSet.size() == 0) {
            ilevel = CompetencyLevelFactory.getRemoteInstance();
            collection = ilevel.getCompetencyLevelCollection();
        } else {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)levelIDSet, CompareType.INCLUDE));
            ilevel = CompetencyLevelFactory.getRemoteInstance();
            collection = ilevel.getCompetencyLevelCollection(view);
        }
        if (collection != null && collection.size() > 0) {
            for (int i = 0; i < collection.size(); ++i) {
                levelInfos.add(collection.get(i));
            }
        }
        return levelInfos;
    }

    public static List findAdminOrgNotIncludeChildByID(String adminID) throws BOSException, UuidException, SQLException {
        Vector<AdminOrgUnitInfo> adminList = new Vector<AdminOrgUnitInfo>();
        if (adminID != null) {
            AdminOrgUnitCollection collection = null;
            IAdminOrgUnit iOrg = null;
            iOrg = AdminOrgUnitFactory.getRemoteInstance();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(HRStateTWOClientUtils.getDefaultFilterForQuery("id"));
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)adminID, CompareType.EQUALS));
            view.setFilter(filter);
            collection = iOrg.getAdminOrgUnitCollection(view);
            if (collection != null) {
                for (int i = 0; i < collection.size(); ++i) {
                    adminList.add(collection.get(i));
                }
            }
        }
        return adminList;
    }

    public static List findAdminOrgNotIncludeChild() throws BOSException, UuidException, SQLException {
        Vector<AdminOrgUnitInfo> adminList = new Vector<AdminOrgUnitInfo>();
        IRowSet dataRows = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(HRStateTWOClientUtils.getDefaultFilterForQuery("id"));
        view.setFilter(filter);
        dataRows = HRStateTWOClientUtils.query(view, "com.kingdee.eas.hr.state.app", "HRStatFindDepartmentQuery");
        if (dataRows != null) {
            AdminOrgUnitInfo info = null;
            while (dataRows.next()) {
                info = new AdminOrgUnitInfo();
                info.setId(BOSUuid.read((String)dataRows.getString("ID")));
                info.setName(dataRows.getString("NAME"));
                adminList.add(info);
            }
        }
        return adminList;
    }

    public static IRowSet countByDepartmentType(EntityViewInfo view) throws BOSException {
        IRowSet dataRow = null;
        StringBuffer queryStr = new StringBuffer();
        String subSQL = HRStateTWOClientUtils.metaQueryToSQL(view, "com.kingdee.eas.hr.state.app", "ProfCollectDepartmentTypeQuery");
        subSQL = subSQL.replaceAll("ADMINORG.ID", "ADMINORGID").replaceAll("PROFTECHQUALTYPE.ID", "PROFTECHQUALTYPEID");
        queryStr.append("SELECT ADMINORGID,PROFTECHQUALTYPEID,COUNT(*) AS COUNTPERSONS\n");
        queryStr.append("FROM ( \n");
        queryStr.append(subSQL);
        queryStr.append("\n) AS T GROUP BY ADMINORGID,PROFTECHQUALTYPEID\n");
        dataRow = HRStateTWOClientUtils.query(queryStr.toString());
        return dataRow;
    }

    public static IRowSet countByDepartmentLevel(EntityViewInfo view) throws BOSException {
        IRowSet dataRow = null;
        StringBuffer queryStr = new StringBuffer();
        String subSQL = HRStateTWOClientUtils.metaQueryToSQL(view, "com.kingdee.eas.hr.state.app", "ProfCollectDepartmentLevelQuery");
        subSQL = subSQL.replaceAll("ADMINORG.ID", "ADMINORGID").replaceAll("TECHNICLEVEL.ID", "TECHNICLEVELID");
        queryStr.append("SELECT ADMINORGID,TECHNICLEVELID,COUNT(*) AS COUNTPERSONS\n");
        queryStr.append("FROM ( \n");
        queryStr.append(subSQL);
        queryStr.append("\n) AS T GROUP BY ADMINORGID,TECHNICLEVELID\n");
        dataRow = HRStateTWOClientUtils.query(queryStr.toString());
        return dataRow;
    }

    public static IRowSet countByPersonType(EntityViewInfo view) throws BOSException {
        IRowSet dataRow = null;
        dataRow = HRStateTWOClientUtils.query(view, "com.kingdee.eas.hr.state.app", "ProfCollectPersonTypeQuery");
        return dataRow;
    }

    public static IRowSet countByPersonLevel(EntityViewInfo view) throws BOSException {
        IRowSet dataRow = null;
        dataRow = HRStateTWOClientUtils.query(view, "com.kingdee.eas.hr.state.app", "ProfCollectPersonLevelQuery");
        return dataRow;
    }
}

