/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.state.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.client.PositionPromptBox2;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.hr.base.client.FilterUIUtil;
import com.kingdee.eas.hr.base.client.IHRF7CommonRegister;
import com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox;
import com.kingdee.eas.hr.org.client.AdminByOrgRangePromptBox;
import com.kingdee.eas.hr.state.client.AbstractProfDetailFilterUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.AbstractButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class ProfDetailFilterUI
extends AbstractProfDetailFilterUI {
    private final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private static final Logger logger = CoreUIObject.getLogger(ProfDetailFilterUI.class);
    public static final String RES = "com.kingdee.eas.hr.state.ProfTechResource";
    private static final String MESRES = "com.kingdee.eas.hr.state.MessageTWOResource";
    private boolean firstTimeView = true;

    protected void beforeOnLoad() throws Exception {
        this.chkIsSearch.setEnabled(true);
        this.chkIsIncludeOrg.setEnabled(false);
        this.kDRadioEmployees.setSelected(true);
        this.prmtEmployees.setEditable(false);
        this.prmtAdminOrg.setEditable(false);
        this.prmtPosition.setEditable(false);
        this.prmtAdminOrg.setData(null);
        this.prmtAdminOrg.setEnabled(false);
        this.prmtPosition.setData(null);
        this.prmtPosition.setEnabled(false);
    }

    public void clear() {
        super.clear();
        this.prmtEmployees.setValue(null);
        this.prmtAdminOrg.setValue(null);
        this.prmtPosition.setValue(null);
        this.chkIsIncludeOrg.setSelected(false);
        this.chkIsIncludeOrg.setEnabled(false);
        this.chkIsSearch.setSelected(false);
        this.txtEmployees.setEditable(false);
        this.txtEmployees.setEnabled(false);
        this.txtEmployees.setVisible(false);
        this.chkIsIncludeOrg.setEnabled(false);
        this.chkIsSearch.setEnabled(true);
        this.kDRadioEmployees.setSelected(true);
        this.pkqualGetStartDate.setValue(null);
        this.pkqualGetEndtDate.setValue(null);
        this.pkAppointStartDate.setValue(null);
        this.pkAppointEndDate.setValue(null);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initAllEditor();
    }

    private void initAllEditor() {
        this.kdbGroup.add((AbstractButton)this.kDRadioEmployees);
        this.kdbGroup.add((AbstractButton)this.kDRadioAdminOrg);
        this.kdbGroup.add((AbstractButton)this.kDRadioPosition);
        this.kDRadioEmployees.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                ProfDetailFilterUI.this.setSelect("person");
            }
        });
        this.kDRadioAdminOrg.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                ProfDetailFilterUI.this.setSelect("adminOrg");
            }
        });
        this.kDRadioPosition.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeevent) {
                ProfDetailFilterUI.this.setSelect("position");
            }
        });
        this.chkIsSearch.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeevent) {
                ProfDetailFilterUI.this.setSearchType();
            }
        });
    }

    protected void initF7Context(IHRF7CommonRegister register) {
        super.initF7Context(register);
        AdminByOrgRangePromptBox adminOrgF7 = new AdminByOrgRangePromptBox("FALSE");
        this.prmtAdminOrg.setEditFormat("$number$");
        this.prmtAdminOrg.setDisplayFormat("$name$");
        this.prmtAdminOrg.setCommitFormat("$number$");
        this.prmtAdminOrg.setSelector((KDPromptSelector)adminOrgF7);
        EmployeeMultiF7PromptBox empF7 = new EmployeeMultiF7PromptBox();
        empF7.setUserOrgRangeFilter(true);
        empF7.showNoPositionPerson(true);
        this.prmtEmployees.setEditFormat("$number$");
        this.prmtEmployees.setDisplayFormat("$name$");
        this.prmtEmployees.setCommitFormat("$number$");
        this.prmtEmployees.setSelector((KDPromptSelector)empF7);
        PositionPromptBox2 positionF7 = new PositionPromptBox2();
        this.prmtPosition.setEditFormat("$number$");
        this.prmtPosition.setDisplayFormat("$name$");
        this.prmtPosition.setCommitFormat("$number$");
        this.prmtPosition.setSelector((KDPromptSelector)positionF7);
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.getMainOrg();
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        String[] ctrls = new String[]{this.prmtHROrg.getName()};
        FilterUIUtil.saveAllData((CustomerParams)cp, (CustomerQueryPanel)this, (String[])ctrls, (boolean)false);
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        String[] ctrls = new String[]{this.prmtHROrg.getName()};
        FilterUIUtil.retriveAllData((CustomerParams)cp, (CustomerQueryPanel)this, (String[])ctrls, (boolean)false);
    }

    public FilterInfo getFilterInfo() {
        AdminOrgUnitInfo orgUnit;
        FilterInfo orgFilter;
        PositionInfo positionInfo;
        FilterInfo filter = new FilterInfo();
        this.setStartDateFilter(filter);
        this.setEndDateFilter(filter);
        if (this.kDRadioPosition.isSelected() && (positionInfo = (PositionInfo)this.prmtPosition.getData()) != null) {
            filter.getFilterItems().add(new FilterItemInfo("position.id", (Object)positionInfo.getId().toString(), CompareType.EQUALS));
        }
        if (this.kDRadioEmployees.isSelected()) {
            if (this.chkIsSearch.isSelected()) {
                String personNumberOrName = this.txtEmployees.getText().trim();
                if (personNumberOrName != null) {
                    if (filter.getFilterItems().size() > 0) {
                        orgFilter = new FilterInfo();
                        orgFilter.getFilterItems().add(new FilterItemInfo("person.number", (Object)("%" + personNumberOrName + "%"), CompareType.LIKE));
                        orgFilter.getFilterItems().add(new FilterItemInfo("person.name", (Object)("%" + personNumberOrName + "%"), CompareType.LIKE));
                        orgFilter.setMaskString("#0 or #1");
                        try {
                            filter.mergeFilter(orgFilter, "and");
                        }
                        catch (BOSException e) {
                            ExceptionHandler.handle((Throwable)e);
                        }
                    } else {
                        filter.getFilterItems().add(new FilterItemInfo("person.number", (Object)("%" + personNumberOrName + "%"), CompareType.LIKE));
                        filter.getFilterItems().add(new FilterItemInfo("person.name", (Object)("%" + personNumberOrName + "%"), CompareType.LIKE));
                        filter.setMaskString("#0 or #1");
                    }
                }
            } else {
                PersonInfo pInfo = (PersonInfo)this.prmtEmployees.getData();
                if (pInfo != null) {
                    filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)pInfo.getId().toString(), CompareType.EQUALS));
                }
            }
        }
        if (this.kDRadioAdminOrg.isSelected() && (orgUnit = (AdminOrgUnitInfo)this.prmtAdminOrg.getData()) != null) {
            if (this.chkIsIncludeOrg.isSelected()) {
                if (filter.getFilterItems().size() > 0) {
                    orgFilter = new FilterInfo();
                    orgFilter.getFilterItems().add(new FilterItemInfo("adminOrg.number", (Object)orgUnit.getNumber(), CompareType.EQUALS));
                    orgFilter.getFilterItems().add(new FilterItemInfo("adminOrg.longNumber", (Object)(orgUnit.getLongNumber() + "!%"), CompareType.LIKE));
                    orgFilter.setMaskString("#0 or #1");
                    try {
                        filter.mergeFilter(orgFilter, "and");
                    }
                    catch (BOSException e) {
                        ExceptionHandler.handle((Throwable)e);
                    }
                } else {
                    filter.getFilterItems().add(new FilterItemInfo("adminOrg.number", (Object)orgUnit.getNumber(), CompareType.EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("adminOrg.longNumber", (Object)(orgUnit.getLongNumber() + "!%"), CompareType.LIKE));
                    filter.setMaskString(" #0 or #1 ");
                }
            } else {
                filter.getFilterItems().add(new FilterItemInfo("adminOrg.number", (Object)orgUnit.getNumber(), CompareType.EQUALS));
            }
        }
        return filter;
    }

    private void setStartDateFilter(FilterInfo filter) {
        if (filter == null) {
            return;
        }
        Date startDateStart = (Date)this.pkqualGetStartDate.getValue();
        Date startDateEnd = (Date)this.pkqualGetEndtDate.getValue();
        if (startDateStart != null) {
            filter.getFilterItems().add(new FilterItemInfo("qualGetDate", (Object)this.simpleDateFormat.format(startDateStart), CompareType.GREATER_EQUALS));
        }
        if (startDateEnd != null) {
            filter.getFilterItems().add(new FilterItemInfo("qualGetDate", (Object)this.simpleDateFormat.format(startDateEnd), CompareType.LESS_EQUALS));
        }
    }

    private void setEndDateFilter(FilterInfo filter) {
        if (filter == null) {
            return;
        }
        Date endDateStart = (Date)this.pkAppointStartDate.getValue();
        Date endDateEnd = (Date)this.pkAppointEndDate.getValue();
        if (endDateStart != null) {
            filter.getFilterItems().add(new FilterItemInfo("dateStartOfAppoint", (Object)this.simpleDateFormat.format(endDateStart), CompareType.GREATER_EQUALS));
        }
        if (endDateEnd != null) {
            filter.getFilterItems().add(new FilterItemInfo("dateStartOfAppoint", (Object)this.simpleDateFormat.format(endDateEnd), CompareType.LESS_EQUALS));
        }
    }

    public boolean verify() {
        Date startDateStart = (Date)this.pkqualGetStartDate.getValue();
        Date startDateEnd = (Date)this.pkqualGetEndtDate.getValue();
        if (startDateStart != null && startDateEnd != null && startDateStart.getTime() > startDateEnd.getTime()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"checkqualGetDate"));
            this.pkqualGetEndtDate.requestFocus();
            return false;
        }
        Date endDateStart = (Date)this.pkAppointStartDate.getValue();
        Date endDateEnd = (Date)this.pkAppointEndDate.getValue();
        if (endDateStart != null && endDateEnd != null && endDateStart.getTime() > endDateEnd.getTime()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"checkAppointDate"));
            this.pkAppointEndDate.requestFocus();
            return false;
        }
        return true;
    }

    private void setSearchType() {
        if (this.kDRadioEmployees.isSelected()) {
            if (this.chkIsSearch.isSelected()) {
                this.prmtEmployees.setValue(null);
                this.prmtEmployees.setEnabled(false);
                this.prmtEmployees.setVisible(false);
                this.txtEmployees.setEnabled(true);
                this.txtEmployees.setEditable(true);
                this.txtEmployees.setVisible(true);
            } else {
                this.prmtEmployees.setEnabled(true);
                this.prmtEmployees.setVisible(true);
                this.txtEmployees.setEditable(false);
                this.txtEmployees.setText(null);
                this.txtEmployees.setEnabled(false);
                this.txtEmployees.setVisible(false);
            }
        }
    }

    private void setSelect(String selectType) {
        if ("person".equals(selectType) && this.kDRadioEmployees.isSelected()) {
            this.prmtEmployees.setEnabled(true);
            this.prmtEmployees.setVisible(true);
            this.chkIsSearch.setSelected(false);
            this.chkIsSearch.setEnabled(true);
            this.prmtAdminOrg.setData(null);
            this.prmtAdminOrg.setEnabled(false);
            this.chkIsIncludeOrg.setSelected(false);
            this.chkIsIncludeOrg.setEnabled(false);
            this.prmtPosition.setData(null);
            this.prmtPosition.setEnabled(false);
            this.txtEmployees.setText(null);
            this.txtEmployees.setEnabled(false);
            this.txtEmployees.setVisible(false);
        } else if ("adminOrg".equals(selectType) && this.kDRadioAdminOrg.isSelected()) {
            this.prmtAdminOrg.setEnabled(true);
            this.chkIsIncludeOrg.setEnabled(true);
            this.prmtEmployees.setData(null);
            this.prmtEmployees.setEnabled(false);
            this.prmtEmployees.setVisible(true);
            this.chkIsSearch.setSelected(false);
            this.chkIsSearch.setEnabled(false);
            this.prmtPosition.setEnabled(false);
            this.prmtPosition.setData(null);
            this.txtEmployees.setText(null);
            this.txtEmployees.setEnabled(false);
            this.txtEmployees.setVisible(false);
        } else if ("position".equals(selectType) && this.kDRadioPosition.isSelected()) {
            this.prmtPosition.setEnabled(true);
            this.prmtEmployees.setData(null);
            this.prmtEmployees.setEnabled(false);
            this.prmtEmployees.setVisible(true);
            this.chkIsSearch.setSelected(false);
            this.chkIsSearch.setEnabled(false);
            this.prmtAdminOrg.setData(null);
            this.prmtAdminOrg.setEnabled(false);
            this.chkIsIncludeOrg.setSelected(false);
            this.chkIsIncludeOrg.setEnabled(false);
            this.txtEmployees.setText(null);
            this.txtEmployees.setEnabled(false);
            this.txtEmployees.setVisible(false);
        }
    }
}

