/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.state.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.hr.base.client.FilterUIUtil;
import com.kingdee.eas.hr.base.client.IHRF7CommonRegister;
import com.kingdee.eas.hr.state.client.AbstractProfTechBillFilterUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.Date;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class ProfTechBillFilterUI
extends AbstractProfTechBillFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(ProfTechBillFilterUI.class);
    private static final String RES = "com.kingdee.eas.hr.state.ProfTechResource";
    public static final String LATITUDE_TYPE_ADMINORG = "adminOrg";
    public static final String LATITUDE_TYPE_POSITION = "position";
    public static final String LATITUDE_TYPE_PERSON = "person";
    private static final String MESRES = "com.kingdee.eas.hr.state.MessageTWOResource";

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.prmtDepartment.setEditable(false);
        this.prmtPerson.setEditable(false);
        this.prmtPosition.setEditable(false);
        this.initAllEditor();
    }

    private void initAllEditor() {
        this.btnDepartment.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    ProfTechBillFilterUI.this.setSelect(ProfTechBillFilterUI.LATITUDE_TYPE_ADMINORG);
                }
                catch (Exception exc) {
                    ProfTechBillFilterUI.this.handUIException(exc);
                }
            }
        });
        this.btnPerson.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    ProfTechBillFilterUI.this.setSelect(ProfTechBillFilterUI.LATITUDE_TYPE_PERSON);
                }
                catch (Exception exc) {
                    ProfTechBillFilterUI.this.handUIException(exc);
                }
            }
        });
        this.btnPosition.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    ProfTechBillFilterUI.this.setSelect(ProfTechBillFilterUI.LATITUDE_TYPE_POSITION);
                }
                catch (Exception exc) {
                    ProfTechBillFilterUI.this.handUIException(exc);
                }
            }
        });
        this.chkIsSearch.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ProfTechBillFilterUI.this.setSearchType();
            }
        });
    }

    public void clear() {
        super.clear();
        this.prmtPerson.setValue(null);
        this.prmtDepartment.setValue(null);
        this.prmtPosition.setValue(null);
        this.btnDepartment.setSelected(false);
        this.btnPerson.setSelected(true);
        this.btnPosition.setSelected(false);
        this.chkIsSearch.setSelected(false);
        this.chkIsIncludeOrg.setSelected(false);
        this.txPerson.setText("");
        this.dateEnd.setValue(null);
        this.dateStart.setValue(null);
    }

    public boolean verify() {
        if (this.prmtHROrg.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)MESRES, (String)"mustInputHr"));
            this.prmtHROrg.requestFocus();
            SysUtil.abort();
        }
        Date DateStart = (Date)this.dateStart.getValue();
        Date DateEnd = (Date)this.dateEnd.getValue();
        if (DateStart != null && DateEnd != null && DateStart.getTime() > DateEnd.getTime()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"checkqualGetDate"));
            this.dateEnd.requestFocus();
            SysUtil.abort();
        }
        return super.verify();
    }

    protected void initF7Context(IHRF7CommonRegister register) {
        super.initF7Context(register);
        register.registerAdminByOrgRangePromptBox(this.prmtDepartment);
        register.registerEmployeeMultiF7PromptBox(this.prmtPerson, true);
        register.registerPositionPromptBox2(this.prmtPosition);
        this.prmtDepartment.setEditable(true);
        this.prmtPerson.setEditable(true);
        this.prmtPosition.setEditable(true);
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.getMainOrg();
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = super.getCustomerParams();
        String[] ctrls = new String[]{this.prmtHROrg.getName()};
        FilterUIUtil.saveAllData((CustomerParams)cp, (CustomerQueryPanel)this, (String[])ctrls, (boolean)false);
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        String[] ctrls = new String[]{this.prmtHROrg.getName()};
        FilterUIUtil.retriveAllData((CustomerParams)cp, (CustomerQueryPanel)this, (String[])ctrls, (boolean)false);
    }

    private void setSearchType() {
        boolean style = this.chkIsSearch.isSelected();
        if (style) {
            this.prmtPerson.setValue(null);
            this.prmtPerson.setEnabled(false);
            this.prmtPerson.setVisible(false);
            this.txPerson.setEnabled(true);
            this.txPerson.setVisible(true);
        } else {
            this.prmtPerson.setEnabled(true);
            this.prmtPerson.setVisible(true);
            this.txPerson.setText("");
            this.txPerson.setEnabled(false);
            this.txPerson.setVisible(false);
        }
    }

    private void setSelect(String selectType) {
        if (selectType.equals(LATITUDE_TYPE_ADMINORG) && this.btnDepartment.isSelected()) {
            this.prmtDepartment.setEnabled(true);
            this.chkIsIncludeOrg.setEnabled(true);
            this.chkIsIncludeOrg.setSelected(false);
            this.chkIsSearch.setSelected(false);
            this.chkIsSearch.setEnabled(false);
            this.setSearchType();
            this.prmtPerson.setEnabled(false);
            this.prmtPerson.setValue(null);
            this.prmtPosition.setEnabled(false);
            this.prmtPosition.setValue(null);
        } else if (selectType.equals(LATITUDE_TYPE_PERSON) && this.btnPerson.isSelected()) {
            this.chkIsSearch.setEnabled(true);
            this.chkIsSearch.setSelected(false);
            this.setSearchType();
            this.prmtDepartment.setEnabled(false);
            this.prmtDepartment.setValue(null);
            this.chkIsIncludeOrg.setSelected(false);
            this.chkIsIncludeOrg.setEnabled(false);
            this.prmtPosition.setEnabled(false);
            this.prmtPosition.setValue(null);
        } else if (selectType.equals(LATITUDE_TYPE_POSITION) && this.btnPosition.isSelected()) {
            this.prmtPosition.setEnabled(true);
            this.chkIsSearch.setSelected(false);
            this.chkIsSearch.setEnabled(false);
            this.setSearchType();
            this.chkIsIncludeOrg.setSelected(false);
            this.chkIsIncludeOrg.setEnabled(false);
            this.prmtPerson.setEnabled(false);
            this.prmtPerson.setValue(null);
            this.prmtDepartment.setEnabled(false);
            this.prmtDepartment.setValue(null);
        }
    }

    public FilterInfo getFilterInfo() {
        Object position;
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection itemCollection = filterInfo.getFilterItems();
        FilterItemInfo itemInfo = null;
        if (this.btnPerson.isSelected()) {
            Object Person = this.prmtPerson.getData();
            this.setPersonFilter(this.chkIsSearch.isSelected(), Person, filterInfo);
        } else if (this.btnDepartment.isSelected()) {
            Object adminOrg = this.prmtDepartment.getData();
            if (adminOrg != null && adminOrg instanceof AdminOrgUnitInfo) {
                this.setAdminOrgFilter(this.chkIsIncludeOrg.isSelected(), (AdminOrgUnitInfo)adminOrg, filterInfo);
            }
        } else if (this.btnPosition.isSelected() && (position = this.prmtPosition.getData()) != null && position instanceof PositionInfo) {
            itemInfo = new FilterItemInfo("position.id", (Object)((PositionInfo)position).getId(), CompareType.EQUALS);
            itemCollection.add(itemInfo);
        }
        if (this.dateStart.getValue() != null) {
            itemCollection.add(new FilterItemInfo("entrys.qualGetDate", (Object)((Date)this.dateStart.getValue()), CompareType.GREATER_EQUALS));
        }
        if (this.dateEnd.getValue() != null) {
            itemCollection.add(new FilterItemInfo("entrys.qualGetDate", (Object)((Date)this.dateEnd.getValue()), CompareType.LESS_EQUALS));
        }
        return filterInfo;
    }

    private void setPersonFilter(boolean isLikeStyle, Object person, FilterInfo filter) {
        if (isLikeStyle) {
            String condStr = this.txPerson.getText();
            if (filter.getFilterItems().size() > 0) {
                FilterInfo personFilter = new FilterInfo();
                personFilter.getFilterItems().add(new FilterItemInfo("person.number", (Object)("%" + condStr + "%"), CompareType.LIKE));
                personFilter.getFilterItems().add(new FilterItemInfo("person.name", (Object)("%" + condStr + "%"), CompareType.LIKE));
                personFilter.setMaskString("#0 or #1");
                try {
                    filter.mergeFilter(personFilter, "and");
                }
                catch (BOSException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            } else {
                filter.getFilterItems().add(new FilterItemInfo("person.number", (Object)("%" + condStr + "%"), CompareType.LIKE));
                filter.getFilterItems().add(new FilterItemInfo("person.name", (Object)("%" + condStr + "%"), CompareType.LIKE));
                filter.setMaskString("#0 or #1");
            }
        } else if (person != null && person instanceof PersonInfo) {
            filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)((PersonInfo)person).getId(), CompareType.EQUALS));
        }
    }

    private void setAdminOrgFilter(boolean isIncludeChild, AdminOrgUnitInfo org, FilterInfo filter) {
        if (isIncludeChild) {
            if (filter.getFilterItems().size() > 0) {
                FilterInfo orgFilter = new FilterInfo();
                orgFilter.getFilterItems().add(new FilterItemInfo("adminOrg.longNumber", (Object)(org.getLongNumber() + "!%"), CompareType.LIKE));
                orgFilter.getFilterItems().add(new FilterItemInfo("adminOrg.number", (Object)org.getNumber(), CompareType.EQUALS));
                orgFilter.setMaskString("#0 or #1");
                try {
                    filter.mergeFilter(orgFilter, "and");
                }
                catch (BOSException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            } else {
                filter.getFilterItems().add(new FilterItemInfo("adminOrg.longNumber", (Object)(org.getLongNumber() + "!%"), CompareType.LIKE));
                filter.getFilterItems().add(new FilterItemInfo("adminOrg.number", (Object)org.getNumber(), CompareType.EQUALS));
                filter.setMaskString("#0 or #1");
            }
        } else {
            filter.getFilterItems().add(new FilterItemInfo("adminOrg.id", (Object)org.getId(), CompareType.EQUALS));
        }
    }
}

