/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.state.client;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.framework.CUIDGetterFacadeFactory;
import com.kingdee.eas.basedata.framework.DataBaseDException;
import com.kingdee.eas.basedata.framework.ICUIDGetterFacade;
import com.kingdee.eas.basedata.framework.client.ClientControlStrategy;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.state.RetirementCharacterFactory;
import com.kingdee.eas.hr.state.RetirementCharacterInfo;
import com.kingdee.eas.hr.state.client.AbstractRetirementCharacterEditUI;
import com.kingdee.eas.hr.state.client.HRStateClientUtils;
import com.kingdee.eas.hr.state.client.PassportTypeEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class RetirementCharacterEditUI
extends AbstractRetirementCharacterEditUI {
    private static final long serialVersionUID = -5719852351182627125L;
    private static final String RES = "com.kingdee.eas.hr.state.RetirementCharacterResource";
    private ClientControlStrategy ccStrategy;
    private static final String ACTION_ADDNEW = "ACTION_ADDNEW";
    private String controlType;
    private String currentCUID;
    private static final Logger logger = CoreUIObject.getLogger(PassportTypeEditUI.class);

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        HRStateClientUtils.verifyEmpty((CoreUIObject)this, this.txtNumber);
        HRStateClientUtils.verifyEmpty((CoreUIObject)this, this.txtName);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.checkForSType(ACTION_ADDNEW);
        super.actionAddNew_actionPerformed(e);
    }

    public void actionCopy_actionPerformed(ActionEvent arg0) throws Exception {
        this.checkForSType(ACTION_ADDNEW);
        super.actionCopy_actionPerformed(arg0);
    }

    private void checkForSType(String actionName) throws Exception {
        this.checkPermission(actionName);
    }

    private void checkPermission(String action) throws Exception {
        if (this.getControlType().equalsIgnoreCase("S1")) {
            if (!this.getCurrentCUID().equals("00000000-0000-0000-0000-000000000000CCE7AED4")) {
                this.throwsExceptionForNoPermission(action);
            }
        } else if ((this.getControlType().equalsIgnoreCase("S3") || this.getControlType().equalsIgnoreCase("S4")) && !action.equals(ACTION_ADDNEW) && !this.getCurrentCUID().equals(this.getCUIDFromBizobject())) {
            this.throwsExceptionForNoPermission(action);
        }
    }

    private String getControlType() throws Exception {
        this.controlType = "";
        if (this.getBizInterface() == null) {
            return this.controlType;
        }
        try {
            EntityObjectInfo eoi = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity(this.getBizType());
            if (eoi.containsExtendedPropertyKey("controlType")) {
                this.controlType = eoi.getExtendedProperty("controlType");
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
        return this.controlType;
    }

    protected String getCurrentCUID() {
        if (this.currentCUID == null) {
            this.currentCUID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        }
        return this.currentCUID;
    }

    private void throwsExceptionForNoPermission(String action) throws Exception {
        if (action.equals(ACTION_ADDNEW)) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_ADD);
        }
        if (action.equals("ACTION_DELETE")) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_DELETE);
        }
        if (action.equals("ACTION_MODIFY")) {
            throw new DataBaseDException(DataBaseDException.CAN_NOT_UPDATE);
        }
    }

    private String getCUIDFromBizobject() throws Exception {
        return this.getICGF().getCUID(this.editData.getId().toString());
    }

    private ICUIDGetterFacade getICGF() throws Exception {
        return CUIDGetterFacadeFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        RetirementCharacterInfo objectValue = new RetirementCharacterInfo();
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        objectValue.setHrOrgUnit(HRStateClientUtils.getCurrentHROrgUnit());
        return objectValue;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return RetirementCharacterFactory.getRemoteInstance();
    }
}

