/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.state.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.emp.client.EmployeeTreeEditUI;
import com.kingdee.eas.hr.state.ServeInfomationCollection;
import com.kingdee.eas.hr.state.ServeInfomationFactory;
import com.kingdee.eas.hr.state.ServeInfomationInfo;
import com.kingdee.eas.hr.state.client.AbstractServeInfomationEditUI;
import com.kingdee.eas.hr.state.client.HRStateTWOClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Date;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class ServeInfomationEditUI
extends AbstractServeInfomationEditUI {
    private static final Logger logger = CoreUIObject.getLogger(ServeInfomationEditUI.class);
    private ServeInfomationCollection pcmCol;
    protected final String PUBRES = "com.kingdee.eas.hr.state.SoldierManageResource";
    private EmployeeTreeEditUI treeEditUI;

    protected void beforeOnLoad() throws Exception {
        super.beforeOnLoad();
        this.treeEditUI = (EmployeeTreeEditUI)this.getUIContext().get("GroupListEditUI");
    }

    private HROrgUnitInfo getCurrentHRO() {
        if (this.treeEditUI != null && this.treeEditUI.getMainBizOrgInfo() != null) {
            return this.treeEditUI.getMainBizOrgInfo();
        }
        return SysContext.getSysContext().getCurrentHRUnit();
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        return new ObjectUuidPK(this.getCurrentHRO().getId());
    }

    @Override
    public void loadFields() {
        try {
            this.getValue(null);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        super.loadFields();
    }

    @Override
    protected IObjectValue createNewData() {
        ServeInfomationInfo objectValue = new ServeInfomationInfo();
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        PersonInfo pInfo = new PersonInfo();
        try {
            pInfo = HRStateTWOClientUtils.getPersonInfo(BOSUuid.read((String)this.getUIContext().get("ID").toString()));
        }
        catch (Exception e) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.state.SoldierManageResource", (String)"NO_PERSON"));
            SysUtil.abort();
        }
        objectValue.setPerson(pInfo);
        return objectValue;
    }

    protected IObjectValue getValue(IObjectPK pk) throws Exception {
        String recordId = null;
        if (this.getUIContext().get("CUR_OBJ_ID") != null) {
            recordId = this.getUIContext().get("CUR_OBJ_ID").toString();
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)recordId));
        view.put("selector", (Object)this.getMergedSelector());
        view.setFilter(filter);
        this.pcmCol = ServeInfomationFactory.getRemoteInstance().getServeInfomationCollection(view);
        this.editData = this.pcmCol.size() <= 0 ? (ServeInfomationInfo)this.createNewData() : this.pcmCol.get(0);
        this.setDataObject((IObjectValue)this.editData);
        this.editData.copyNewToOld();
        return this.editData;
    }

    @Override
    protected void chkisMaim_stateChanged(ChangeEvent e) throws Exception {
        if (this.chkisMaim.isSelected()) {
            this.txtmaimLevel.setEnabled(true);
        } else {
            this.txtmaimLevel.setEnabled(false);
            this.txtmaimLevel.setText(null);
        }
    }

    protected void verifyInput(ActionEvent actionevent) throws Exception {
        this.checkNoNull();
        this.checkDate();
    }

    private void checkNoNull() {
        HRStateTWOClientUtils.verifyEmpty((CoreUIObject)this, "com.kingdee.eas.hr.state.SoldierManageResource", this.pkjoinArmyDate, "InputJoinArmyDate");
        HRStateTWOClientUtils.verifyEmpty((CoreUIObject)this, "com.kingdee.eas.hr.state.SoldierManageResource", this.pkleaveArmyDate, "InputLeaveArmyDate");
        HRStateTWOClientUtils.verifyEmpty((CoreUIObject)this, "com.kingdee.eas.hr.state.SoldierManageResource", this.prmtleaveArmyStatus, "InputLeaveArmyStatus");
        HRStateTWOClientUtils.verifyEmpty((CoreUIObject)this, "com.kingdee.eas.hr.state.SoldierManageResource", this.pkapproveDate, "InputApproveDate");
    }

    private void checkDate() {
        Date joinArmyDate = (Date)this.pkjoinArmyDate.getValue();
        Date leaveArmyDate = (Date)this.pkleaveArmyDate.getValue();
        Date approveDate = (Date)this.pkapproveDate.getValue();
        if (joinArmyDate.after(leaveArmyDate)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.state.SoldierManageResource", (String)"LeaveArmyDateError"));
            this.pkleaveArmyDate.setValue(null);
            this.pkleaveArmyDate.requestFocusInWindow();
            SysUtil.abort();
        }
        if (joinArmyDate.after(approveDate)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.state.SoldierManageResource", (String)"ApproveDateError"));
            this.pkapproveDate.setValue(null);
            this.pkapproveDate.requestFocusInWindow();
            SysUtil.abort();
        }
    }

    protected void handlePermissionForItemAction(ItemAction action) {
        if (this.getUIContext().get("NO_PERMISSION") == null) {
            super.handlePermissionForItemAction(action);
        }
    }
}

