/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.time.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.benefit.util.CommonQueryUtil;
import com.kingdee.eas.hr.emp.IUserPermission;
import com.kingdee.eas.hr.emp.UserPermissionCollection;
import com.kingdee.eas.hr.emp.UserPermissionFactory;
import com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox;
import com.kingdee.eas.hr.time.CheckStateEnum;
import com.kingdee.eas.hr.time.client.AbstractAttendManagerReportBasePanelUI;
import com.kingdee.eas.hr.time.client.LeaveRegQueryPanelUI;
import com.kingdee.eas.hr.time.client.TimeAttendanceUtils;
import com.kingdee.eas.hr.time.client.TimeUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.log4j.Logger;

public class AttendManagerReportBasePanelUI
extends AbstractAttendManagerReportBasePanelUI {
    private static final long serialVersionUID = -61166L;
    private static final Logger logger = CoreUIObject.getLogger(LeaveRegQueryPanelUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
        this.initF7Selector();
    }

    void initF7Selector() {
        TimeAttendanceUtils.initF7Selector((IUIObject)this, this.promptBoxOrg);
        EmployeeMultiF7PromptBox mBox = new EmployeeMultiF7PromptBox((IUIObject)this);
        try {
            this.setF7Filter(mBox);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        mBox.setModal(true);
        mBox.setIsSingleSelect(true);
        mBox.showNoPositionPerson(true);
        mBox.showOnlyPayPerson(true);
        mBox.setUserOrgRangeFilter(true);
        mBox.setReturnPositionAndUnit(false);
        this.promptBoxPerson.setSelector((KDPromptSelector)mBox);
        this.promptBoxPerson.setEnabled(false);
        this.promptBoxPerson.setEditable(false);
    }

    private void setF7Filter(EmployeeMultiF7PromptBox pmt) throws Exception {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)"1"));
        filter.getFilterItems().add(new FilterItemInfo("user", (Object)SysContext.getSysContext().getCurrentUserInfo().getId().toString()));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        IUserPermission iup = UserPermissionFactory.getRemoteInstance();
        UserPermissionCollection collection = iup.getUserPermissionCollection(viewInfo);
        String filterString = null;
        if (collection != null && collection.size() > 0) {
            filterString = collection.get(0).getFilter();
        }
        if (filterString == null) {
            return;
        }
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.emp.app", "EmpInfoQuery");
        IQueryExecutor iQe = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        filter = new FilterInfo(filterString);
        viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        viewInfo.setSelector(sic);
        iQe.setObjectView(viewInfo);
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)iQe.getSQL(), CompareType.INNER));
        pmt.setNopositionPersonFilter(filter);
    }

    public FilterInfo getFilterInfo() {
        FilterInfo orgFilter = new FilterInfo();
        OrgUnitInfo orgInfo = (OrgUnitInfo)this.promptBoxOrg.getData();
        if (orgInfo != null && this.radioOrg.isSelected()) {
            if (this.chkInclude.isSelected()) {
                orgFilter.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.longNumber", (Object)orgInfo.getLongNumber()));
                orgFilter.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.longNumber", (Object)(orgInfo.getLongNumber() + "!%"), CompareType.LIKE));
                orgFilter.setMaskString("#0 or #1");
                try {
                    orgFilter.mergeFilter(TimeUtil.getHRAndAdminRangeFilterInfo(null, "AdminOrgUnit.id"), "AND");
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
            } else {
                orgFilter.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.longNumber", (Object)orgInfo.getLongNumber()));
            }
        } else {
            try {
                orgFilter = TimeUtil.getHRAndAdminRangeFilterInfo(null, "AdminOrgUnit.id");
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        FilterInfo pFilter = new FilterInfo();
        if (this.promptBoxPerson.getData() != null && this.radioPerson.isSelected()) {
            pFilter.getFilterItems().add(new FilterItemInfo("id", (Object)((PersonInfo)this.promptBoxPerson.getData()).getId().toString()));
        }
        if (!StringUtils.isEmpty((String)pFilter.toString())) {
            try {
                orgFilter.mergeFilter(pFilter, "AND");
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        return orgFilter;
    }

    public String getFilterSQL() {
        String strSql = "";
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        if (this.datePickerFrom.getValue() != null && this.datePickerTo.getValue() != null) {
            Date toDate = (Date)this.datePickerTo.getValue();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(toDate);
            calendar.add(5, 1);
            strSql = "FStartDate<={ts '" + format.format(calendar.getTime()) + "'}  and  FEndDate>={ts '" + format.format((Date)this.datePickerFrom.getValue()) + "'}";
        } else if (this.datePickerFrom.getValue() != null && this.datePickerTo.getValue() == null) {
            strSql = "FStartDate>={ts '" + format.format((Date)this.datePickerFrom.getValue()) + "'} ";
        } else if (this.datePickerFrom.getValue() == null && this.datePickerTo.getValue() != null) {
            Date toDate = (Date)this.datePickerTo.getValue();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(toDate);
            calendar.add(5, 1);
            strSql = "  FEndDate<{ts '" + format.format(calendar.getTime()) + "'}";
        }
        if (this.btnRadioCheck.isSelected()) {
            strSql = strSql.equals("") ? strSql + " FCheckState=1" : strSql + " and FCheckState=1";
        } else if (this.btnRadioUnCheck.isSelected()) {
            strSql = strSql.equals("") ? strSql + " FCheckState=0" : strSql + " and FCheckState=0";
        }
        return strSql;
    }

    public CheckStateEnum getCheckState() {
        if (this.btnRadioCheck.isSelected()) {
            return CheckStateEnum.CHECK;
        }
        if (this.btnRadioUnCheck.isSelected()) {
            return CheckStateEnum.UNCHECK;
        }
        return null;
    }

    public Date getStartDate() {
        return (Date)this.datePickerFrom.getValue();
    }

    public Date getEndDate() {
        return (Date)this.datePickerTo.getValue();
    }

    public void loadFields() {
        super.loadFields();
    }

    public void storeFields() {
        super.storeFields();
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        cp.putBoolean("radioOrg", this.radioOrg.isSelected());
        cp.putBoolean("radioPerson", this.radioPerson.isSelected());
        CommonQueryUtil.getAdminFromQueryPanel((CustomerParams)cp, (KDBizPromptBox)this.promptBoxOrg);
        CommonQueryUtil.getPerFromQueryPanel((CustomerParams)cp, (KDBizPromptBox)this.promptBoxPerson);
        cp.putDate("start", (Date)this.datePickerFrom.getValue());
        cp.putDate("end", (Date)this.datePickerTo.getValue());
        cp.putBoolean("unCheck", this.btnRadioUnCheck.isSelected());
        cp.putBoolean("check", this.btnRadioCheck.isSelected());
        cp.putBoolean("all", this.btnCheckAll.isSelected());
        cp.putBoolean("select", this.chkInclude.isSelected());
        cp.addCustomerParam("SQLFilter", this.getFilterSQL());
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        if (cp == null) {
            return;
        }
        this.radioOrg.setSelected(cp.getBoolean("radioOrg"));
        this.radioPerson.setSelected(cp.getBoolean("radioPerson"));
        CommonQueryUtil.setAdminFromQueryPanel((CustomerParams)cp, (KDBizPromptBox)this.promptBoxOrg);
        CommonQueryUtil.setPerFromQueryPanel((CustomerParams)cp, (KDBizPromptBox)this.promptBoxPerson);
        this.datePickerFrom.setValue((Object)cp.getDate("start"));
        this.datePickerTo.setValue((Object)cp.getDate("end"));
        this.btnRadioUnCheck.setSelected(cp.getBoolean("unCheck"));
        this.btnRadioCheck.setSelected(cp.getBoolean("check"));
        this.btnCheckAll.setSelected(cp.getBoolean("all"));
        this.chkInclude.setSelected(cp.getBoolean("select"));
    }

    public void initLayout() {
        super.initLayout();
        Date date = new Date();
        GregorianCalendar cal = new GregorianCalendar(DateTimeUtils.getYear((Date)date), DateTimeUtils.getMonth((Date)date) - 2, 1);
        this.datePickerFrom.setValue((Object)cal.getTime());
        this.datePickerTo.setValue((Object)this.getMonthEndDate());
        this.promptBoxOrg.setEditable(true);
    }

    private Date getMonthEndDate() {
        Date date = new Date();
        int day = DateTimeUtils.getDay((Date)date);
        Date beginDate = DateTimeUtils.addDay((Date)date, (long)(1 - day));
        date = DateTimeUtils.addMonth((Date)beginDate, (int)0);
        return DateTimeUtils.addDay((Date)date, (long)-1L);
    }

    public void clear() {
        super.clear();
        this.promptBoxOrg.setData(null);
        Date date = new Date();
        GregorianCalendar cal = new GregorianCalendar(DateTimeUtils.getYear((Date)date), DateTimeUtils.getMonth((Date)date) - 2, 1);
        this.datePickerFrom.setValue((Object)cal.getTime());
        this.datePickerTo.setValue((Object)this.getMonthEndDate());
        this.btnRadioUnCheck.setSelected(false);
        this.btnRadioCheck.setSelected(true);
        this.btnCheckAll.setSelected(false);
        this.chkInclude.setSelected(false);
    }

    public boolean verify() {
        if (this.datePickerFrom.getValue() != null && this.datePickerTo.getValue() != null && DateTimeUtils.dayBefore((Date)((Date)this.datePickerTo.getValue()), (Date)((Date)this.datePickerFrom.getValue()))) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.time.TimeResource.STARTDATE_MUST_ENDDATE"));
            return false;
        }
        return true;
    }

    protected void radioOrg_itemStateChanged(ItemEvent e) throws Exception {
        boolean flag = this.radioOrg.isSelected();
        this.promptBoxOrg.setEnabled(flag);
        this.chkInclude.setEnabled(flag);
        this.promptBoxPerson.setEnabled(!flag);
    }
}

