/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.time.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.benefit.util.CommonQueryUtil;
import com.kingdee.eas.hr.time.ITimeAttendance;
import com.kingdee.eas.hr.time.ITimeAttendanceCatalog;
import com.kingdee.eas.hr.time.TimeAttendanceCatalogCollection;
import com.kingdee.eas.hr.time.TimeAttendanceCatalogFactory;
import com.kingdee.eas.hr.time.TimeAttendanceCatalogInfo;
import com.kingdee.eas.hr.time.TimeAttendanceCollection;
import com.kingdee.eas.hr.time.TimeAttendanceFactory;
import com.kingdee.eas.hr.time.TimeAttendanceInfo;
import com.kingdee.eas.hr.time.client.AbstractAttendManagerReportCustomPanelUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class AttendManagerReportCustomPanelUI
extends AbstractAttendManagerReportCustomPanelUI {
    private static final Logger logger = CoreUIObject.getLogger(AttendManagerReportCustomPanelUI.class);
    private boolean isLoadScheme = false;
    private boolean isDefaultSelectAll = false;

    public void onLoad() throws Exception {
        if (!this.isLoadScheme) {
            this.getTimeAttendanceCatalogModel();
        }
    }

    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.btnToFirst.setIcon(EASResource.getIcon((String)"imgTbtn_movetop1"));
        this.btnToUp.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.btnToDown.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.btnToLast.setIcon(EASResource.getIcon((String)"imgTbtn_movebottom"));
        this.btnToRight.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_right"));
        this.btnToRightAll.setIcon(EASResource.getIcon((String)"imgTbtn_move_right"));
        this.btnToLeftAll.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_left"));
        this.btnToLeft.setIcon(EASResource.getIcon((String)"imgTbtn_move_left"));
    }

    void getTimeAttendanceCatalogModel() throws BOSException {
        this.cboTimeAttendType.removeAllItems();
        ITimeAttendanceCatalog iCata = TimeAttendanceCatalogFactory.getRemoteInstance();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)"00000000-0000-0000-0000-000000000001BE0D0183"));
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)"00000000-0000-0000-0000-000000000003BE0D0183"));
        filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("cu.id", (Object)"11111111-1111-1111-1111-111111111111CCE7AED4"));
        filterInfo.setMaskString("(#0 or #1) and (#2 or #3)");
        view.setFilter(filterInfo);
        TimeAttendanceCatalogCollection infos = iCata.getTimeAttendanceCatalogCollection(view);
        for (int i = 0; i < infos.size(); ++i) {
            this.cboTimeAttendType.addItem((Object)infos.get(i));
        }
    }

    public void loadFields() {
        super.loadFields();
    }

    public void storeFields() {
        super.storeFields();
    }

    protected void btnToRight_actionPerformed(ActionEvent e) throws Exception {
        int counts = this.lstLeft.getElementCount();
        for (int i = 0; i < counts; ++i) {
            if (this.checkIsExistElement((TimeAttendanceInfo)this.lstLeft.getElement(i), false)) continue;
            this.lstRight.addElement(this.lstLeft.getElement(i));
        }
        this.lstLeft.removeAllElements();
    }

    private void getLeftDataToRight() {
        if (this.lstLeft.getSelectedIndex() == -1) {
            return;
        }
        if (!this.checkIsExistElement((TimeAttendanceInfo)this.lstLeft.getSelectedValue(), false)) {
            this.lstRight.addElement(this.lstLeft.getSelectedValue());
            this.lstLeft.removeElementAt(this.lstLeft.getSelectedIndex());
        }
    }

    protected void btnToRightAll_actionPerformed(ActionEvent e) throws Exception {
        this.getLeftDataToRight();
    }

    boolean checkIsExistElement(TimeAttendanceInfo info, boolean isLeft) {
        KDList list = null;
        list = isLeft ? this.lstLeft : this.lstRight;
        int counts = list.getElementCount();
        for (int i = 0; i < counts; ++i) {
            if (!info.getId().toString().equals(((TimeAttendanceInfo)list.getElement(i)).getId().toString())) continue;
            return true;
        }
        return false;
    }

    protected void btnToLeft_actionPerformed(ActionEvent e) throws Exception {
        this.getRightDataToLeft();
    }

    private void getRightDataToLeft() {
        if (this.lstRight.getSelectedIndex() == -1) {
            return;
        }
        this.lstLeft.addElement(this.lstRight.getSelectedValue());
        this.lstRight.removeElementAt(this.lstRight.getSelectedIndex());
    }

    protected void btnToLeftAll_actionPerformed(ActionEvent e) throws Exception {
        int counts = this.lstRight.getElementCount();
        for (int i = 0; i < counts; ++i) {
            this.lstLeft.addElement(this.lstRight.getElement(i));
        }
        this.lstRight.removeAllElements();
    }

    protected void btnToFirst_actionPerformed(ActionEvent e) throws Exception {
        int index = this.lstRight.getSelectedIndex();
        if (index > 0) {
            TimeAttendanceInfo info = (TimeAttendanceInfo)this.lstRight.getElement(index);
            this.lstRight.removeElementAt(index);
            this.lstRight.insertElement((Object)info, 0);
            this.lstRight.setSelectedIndex(0);
        }
    }

    protected void btnToUp_actionPerformed(ActionEvent e) throws Exception {
        super.btnToUp_actionPerformed(e);
        int index = this.lstRight.getSelectedIndex();
        if (index > 0) {
            TimeAttendanceInfo info = (TimeAttendanceInfo)this.lstRight.getElement(index);
            this.lstRight.removeElementAt(index);
            this.lstRight.insertElement((Object)info, index - 1);
            this.lstRight.setSelectedIndex(index - 1);
        }
    }

    protected void btnToDown_actionPerformed(ActionEvent e) throws Exception {
        super.btnToDown_actionPerformed(e);
        int index = this.lstRight.getSelectedIndex();
        int count = this.lstRight.getElementCount();
        if (index >= 0 && count != index + 1) {
            TimeAttendanceInfo info = (TimeAttendanceInfo)this.lstRight.getElement(index);
            this.lstRight.removeElementAt(index);
            this.lstRight.insertElement((Object)info, index + 1);
            this.lstRight.setSelectedIndex(index + 1);
        }
    }

    protected void btnToLast_actionPerformed(ActionEvent e) throws Exception {
        super.btnToLast_actionPerformed(e);
        int index = this.lstRight.getSelectedIndex();
        int count = this.lstRight.getElementCount();
        if (index >= 0 && count != index + 1) {
            TimeAttendanceInfo info = (TimeAttendanceInfo)this.lstRight.getElement(index);
            this.lstRight.removeElementAt(index);
            this.lstRight.insertElement((Object)info, count - 1);
            this.lstRight.setSelectedIndex(count - 1);
        }
    }

    protected void cboTimeAttendType_itemStateChanged(ItemEvent e) throws Exception {
        if (e.getStateChange() == 1) {
            this.fillList();
        }
    }

    private void fillList() throws BOSException {
        TimeAttendanceCatalogInfo cataInfo = (TimeAttendanceCatalogInfo)this.cboTimeAttendType.getSelectedItem();
        ITimeAttendance iTime = TimeAttendanceFactory.getRemoteInstance();
        if (cataInfo != null && cataInfo.getId() != null) {
            TimeAttendanceCollection infos = iTime.getTimeAttendanceCollection("Select * Where attendCatalog.id='" + cataInfo.getId().toString() + "' and enable=1 and (hrOrgUnit.id='" + SysContext.getSysContext().getCurrentHRUnit().getId().toString() + "' or cu.id='" + "11111111-1111-1111-1111-111111111111CCE7AED4" + "')");
            this.lstLeft.removeAllElements();
            if (this.isDefaultSelectAll) {
                for (int i = 0; i < infos.size(); ++i) {
                    this.lstRight.addElement((Object)infos.get(i));
                }
                if (infos.size() > 0) {
                    this.lstRight.setSelectedIndex(0);
                }
            } else {
                for (int i = 0; i < infos.size(); ++i) {
                    ArrayList rightInfos = this.getDisplayTimeAttendance();
                    if (rightInfos.contains(infos.get(i))) continue;
                    this.lstLeft.addElement((Object)infos.get(i));
                }
                if (infos.size() > 0) {
                    this.lstLeft.setSelectedIndex(0);
                }
            }
        }
    }

    public ArrayList getDisplayTimeAttendance() {
        ArrayList<Object> list = new ArrayList<Object>();
        int counts = this.lstRight.getElementCount();
        for (int i = 0; i < counts; ++i) {
            list.add(this.lstRight.getElement(i));
        }
        return list;
    }

    protected void lstLeft_mouseClicked(MouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            this.getLeftDataToRight();
        }
    }

    protected void lstRight_mouseClicked(MouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            this.getRightDataToLeft();
        }
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        String right = CommonQueryUtil.getStringFromList((List)this.getRightList());
        String left = CommonQueryUtil.getStringFromList((List)this.getLeftList());
        cp.addCustomerParam("right", right);
        int rightCount = this.lstRight.getElementCount();
        cp.putInt("listRightCount", rightCount);
        TimeAttendanceInfo timeAttendInfo = null;
        for (int i = 0; i < rightCount; ++i) {
            timeAttendInfo = (TimeAttendanceInfo)this.lstRight.getElement(i);
            cp.addCustomerParam("rightListCount" + i, timeAttendInfo.getNumber());
        }
        cp.addCustomerParam("left", left);
        cp.addCustomerParam("SelectInfo", ((TimeAttendanceCatalogInfo)this.cboTimeAttendType.getSelectedItem()).getId().toString());
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        this.isLoadScheme = true;
        if (cp == null) {
            return;
        }
        try {
            this.lstLeft.removeAllElements();
            ITimeAttendanceCatalog iCata = TimeAttendanceCatalogFactory.getRemoteInstance();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)cp.getCustomerParam("SelectInfo")));
            filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId().toString()));
            filterInfo.getFilterItems().add(new FilterItemInfo("cu.id", (Object)"11111111-1111-1111-1111-111111111111CCE7AED4"));
            filterInfo.setMaskString("(#0) and (#1 or #2)");
            view.setFilter(filterInfo);
            TimeAttendanceCatalogCollection infos = iCata.getTimeAttendanceCatalogCollection(view);
            this.cboTimeAttendType.setSelectedItem((Object)infos.get(0));
            TimeAttendanceCollection infoCollect = CommonQueryUtil.getTimeColl((String)cp.getCustomerParam("right"));
            int listRightCount = cp.getInt("listRightCount");
            HashMap<String, Integer> defaultSelectMap = new HashMap<String, Integer>();
            for (int i = 0; i < listRightCount; ++i) {
                defaultSelectMap.put(cp.getCustomerParam("rightListCount" + i), i);
            }
            HashMap<Integer, TimeAttendanceInfo> tempMap = new HashMap<Integer, TimeAttendanceInfo>();
            for (int i = 0; i < infoCollect.size(); ++i) {
                if (!defaultSelectMap.containsKey(infoCollect.get(i).getNumber())) continue;
                Integer index = (Integer)defaultSelectMap.get(infoCollect.get(i).getNumber());
                tempMap.put(index, infoCollect.get(i));
            }
            ArrayList keyList = new ArrayList(tempMap.keySet());
            Collections.sort(keyList);
            this.lstRight.removeAllElements();
            for (int i = 0; i < keyList.size(); ++i) {
                this.lstRight.addElement(tempMap.get(keyList.get(i)));
            }
            if (keyList.size() == 0) {
                CommonQueryUtil.fillDataForList((KDList)this.lstRight, (IObjectCollection)CommonQueryUtil.getTimeColl((String)cp.getCustomerParam("right")));
            }
            CommonQueryUtil.fillDataForList((KDList)this.lstLeft, (IObjectCollection)CommonQueryUtil.getTimeColl((String)cp.getCustomerParam("left")));
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    ArrayList getLeftList() {
        ArrayList<TimeAttendanceInfo> arrList = new ArrayList<TimeAttendanceInfo>();
        int counts = this.lstLeft.getElementCount();
        for (int i = 0; i < counts; ++i) {
            arrList.add((TimeAttendanceInfo)this.lstLeft.getElement(i));
        }
        return arrList;
    }

    ArrayList getRightList() {
        ArrayList<TimeAttendanceInfo> arrList = new ArrayList<TimeAttendanceInfo>();
        int counts = this.lstRight.getElementCount();
        for (int i = 0; i < counts; ++i) {
            arrList.add((TimeAttendanceInfo)this.lstRight.getElement(i));
        }
        return arrList;
    }

    public void clear() {
        super.clear();
        try {
            this.lstLeft.removeAllElements();
            this.lstRight.removeAllElements();
            this.fillList();
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    public boolean verify() {
        if (this.lstRight.getElementCount() < 1) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.time.TimeResource.ATTENDMANAGER_ATTENDITEM_NOTNULL"));
            return false;
        }
        return true;
    }

    public boolean isDefaultSelectAll() {
        return this.isDefaultSelectAll;
    }

    public void setDefaultSelectAll(boolean isDefaultSelectAll) {
        this.isDefaultSelectAll = isDefaultSelectAll;
    }
}

