/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.time.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.perf.client.IProgTask;
import com.kingdee.eas.hr.perf.client.ProgDialog;
import com.kingdee.eas.hr.time.AttendanceManagerConst;
import com.kingdee.eas.hr.time.AttendanceManagerImportFacadeFactory;
import com.kingdee.eas.hr.time.TimeAttendanceCollection;
import com.kingdee.eas.hr.time.TimeAttendanceFactory;
import com.kingdee.eas.hr.time.TimeAttendanceInfo;
import com.kingdee.eas.hr.time.client.AbstractAttendanceDataImportUI;
import com.kingdee.eas.hr.time.client.TimeUtil;
import com.kingdee.eas.tools.datatask.ErrorHandleModeEnum;
import com.kingdee.eas.tools.datatask.FilesPathInfo;
import com.kingdee.eas.tools.datatask.client.FileSelector;
import com.kingdee.eas.tools.datatask.runtime.ExcelUtil;
import com.kingdee.eas.tools.datatask.runtime.ExternalExcelDataReader;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.Region;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.CellStyle;

public class AttendanceDataImportUI
extends AbstractAttendanceDataImportUI {
    private static final Logger logger = CoreUIObject.getLogger(AttendanceDataImportUI.class);
    private static final String RES = " ";
    private boolean cancel = true;
    private HSSFWorkbook workbook;
    private int fixedCol = 9;
    private int headRowNum = 4;
    private int dynamicColCount = 0;
    private Map numberNameMap = new LinkedHashMap();
    private Map numberInfoMap = new LinkedHashMap();
    private Set attNumSet = new LinkedHashSet();
    private boolean isHolidayImp = false;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initUI();
        this.initData();
    }

    private void initUI() {
        this.comboError.removeAllItems();
        this.comboError.addItem((Object)ErrorHandleModeEnum.ReturnRightnow);
        this.comboError.addItem((Object)ErrorHandleModeEnum.ReturnWhenFinish);
        this.comboError.setSelectedIndex(0);
    }

    private void initData() throws Exception {
        block4: {
            block3: {
                Object obj = this.getUIContext().get("isHolidayImp");
                this.isHolidayImp = obj != null && "true".equals(obj);
                this.actionConfirm.setDaemonRun(true);
                if (!this.isHolidayImp) break block3;
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId().toString()));
                filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", null));
                filter.getFilterItems().add(new FilterItemInfo("attendCatalog.id", (Object)"00000000-0000-0000-0000-000000000002BE0D0183"));
                filter.getFilterItems().add(new FilterItemInfo("enable", (Object)1));
                filter.setMaskString("(#0 or #1)and #2 and #3");
                view.setFilter(filter);
                TimeAttendanceCollection coll = TimeAttendanceFactory.getRemoteInstance().getTimeAttendanceCollection(view);
                this.dynamicColCount = coll.size();
                if (this.dynamicColCount <= 0) break block4;
                int j = coll.size();
                for (int i = 0; i < j; ++i) {
                    TimeAttendanceInfo info = coll.get(i);
                    this.numberNameMap.put(info.getNumber().trim(), info.getName());
                    this.numberInfoMap.put(info.getNumber().trim(), info);
                    this.attNumSet.add(info.getNumber().trim());
                }
                break block4;
            }
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("attendCatalog.id", (Object)"00000000-0000-0000-0000-000000000001BE0D0183"));
            fi.getFilterItems().add(new FilterItemInfo("attendCatalog.id", (Object)"00000000-0000-0000-0000-000000000003BE0D0183"));
            fi.getFilterItems().add(new FilterItemInfo("enable", (Object)1));
            fi.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId().toString()));
            fi.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", null));
            fi.setMaskString("(#0 or #1) and #2 and (#3 or #4)");
            evi.setFilter(fi);
            TimeAttendanceCollection coll = TimeAttendanceFactory.getRemoteInstance().getTimeAttendanceCollection(evi);
            this.dynamicColCount = coll.size();
            if (this.dynamicColCount > 0) {
                int j = coll.size();
                for (int i = 0; i < j; ++i) {
                    TimeAttendanceInfo info = coll.get(i);
                    this.numberNameMap.put(info.getNumber().trim(), info.getName());
                    this.numberInfoMap.put(info.getNumber().trim(), info);
                    this.attNumSet.add(info.getNumber().trim());
                }
            }
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnRefreshSheet.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    public void actionExportSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelected_actionPerformed(e);
    }

    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        int sheetNum;
        HSSFSheet sheet;
        int rowNum;
        if (this.workbook == null) {
            return;
        }
        if (!this.checkFile()) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"35_AttendanceDataImportUI"));
            this.txtFile.setText("");
            this.comboLabel.removeAllItems();
            SysUtil.abort();
        }
        if ((rowNum = (sheet = this.workbook.getSheetAt(sheetNum = this.comboLabel.getSelectedIndex())).getPhysicalNumberOfRows()) <= this.headRowNum) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"template_file_is_null"));
            return;
        }
        boolean isOverImport = this.chkUpdate.isSelected();
        ErrorHandleModeEnum erorrHandleMode = (ErrorHandleModeEnum)this.comboError.getSelectedItem();
        HSSFRow headNumberRow = sheet.getRow(2);
        int cellCount = headNumberRow.getPhysicalNumberOfCells();
        HSSFRow row = null;
        ArrayList list = new ArrayList();
        for (int i = this.headRowNum; i < rowNum; ++i) {
            HashMap<String, Object> valueMap = new HashMap<String, Object>();
            list.add(valueMap);
            row = sheet.getRow(i);
            if (row == null || row.getPhysicalNumberOfCells() <= 0) continue;
            String personNumber = ExcelUtil.getCellValue((HSSFCell)row.getCell((short)0));
            if (personNumber == null || personNumber.trim().length() == 0) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"NUMBER_IS_NULL"));
                SysUtil.abort();
            }
            personNumber = personNumber.trim();
            valueMap.put("personNumber", personNumber);
            LinkedHashSet<String> set = new LinkedHashSet<String>();
            for (int k = 2; k < cellCount; ++k) {
                String headNumber = ExcelUtil.getCellValue((HSSFCell)headNumberRow.getCell((short)k)).trim();
                String value = ExcelUtil.getCellValue((HSSFCell)row.getCell((short)k));
                if (value == null || value.trim().length() <= 0) continue;
                valueMap.put(headNumber, value.trim());
                if (!this.attNumSet.contains(headNumber)) continue;
                set.add(headNumber);
            }
            valueMap.put("attendanceSet", set);
        }
        boolean hasError = false;
        Map map = null;
        try {
            map = AttendanceManagerImportFacadeFactory.getRemoteInstance().importAttendanceData(list, isOverImport, erorrHandleMode.getValue(), this.isHolidayImp);
            if (map != null && map.containsKey("hasError")) {
                hasError = (Boolean)map.get("hasError");
            }
        }
        catch (Exception e1) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"36_AttendanceDataImportUI"), (String)e1.getMessage(), (int)2);
            SysUtil.abort();
        }
        if (hasError) {
            if (map != null && map.containsKey("errorStr")) {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"37_AttendanceDataImportUI"), (String)map.get("errorStr").toString(), (int)2);
            }
        } else {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"38_AttendanceDataImportUI"));
        }
        this.getUIWindow().close();
    }

    public void actionOpen_actionPerformed(ActionEvent e) throws Exception {
        super.actionOpen_actionPerformed(e);
        String filePath = this.txtFile.getText();
        if (filePath == null || filePath.trim().length() <= 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"39_AttendanceDataImportUI"));
            return;
        }
        if (this.tblMain.getRowCount() >= 0) {
            String str = filePath.substring(filePath.lastIndexOf("."));
            if (".xls".equals(str)) {
                this.initSheet();
                int sheetNum = this.comboLabel.getSelectedIndex();
                HSSFSheet sheet = this.workbook.getSheetAt(sheetNum);
                int rowNum = sheet.getPhysicalNumberOfRows();
                if (rowNum < 1) {
                    MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"40_AttendanceDataImportUI"));
                    this.txtFile.setText("");
                    this.comboLabel.removeAllItems();
                    SysUtil.abort();
                }
            } else {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"40_AttendanceDataImportUI"));
                this.txtFile.setText("");
                this.comboLabel.removeAllItems();
                SysUtil.abort();
            }
        }
    }

    public void actionNo_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    public void btnExportTemplate_actionPerformed(ActionEvent e) throws Exception {
        String value;
        String key;
        FileSelector fselector = new FileSelector((Component)((Object)this), "SAVE");
        fselector.setDefFileName("AttendanceData.xls");
        fselector.show();
        if (fselector.isCanceled()) {
            return;
        }
        if (this.numberNameMap == null || this.numberNameMap.size() <= 0) {
            if (this.isHolidayImp) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"41_AttendanceDataImportUI"));
            } else {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"42_AttendanceDataImportUI"));
            }
            return;
        }
        String expFilePath = fselector.getData().toString();
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(expFilePath);
        }
        catch (FileNotFoundException ex) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"43_AttendanceDataImportUI"));
            SysUtil.abort();
        }
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFCellStyle nameCellStyle = this.createNameCellStyle(wb);
        HSSFCellStyle codeCellStyle = this.createCodeCellStyle(wb);
        HSSFCellStyle titleStyle = this.createTitleCellStyle(wb);
        HSSFCellStyle cellValueStyle = this.createValueCellStyle(wb);
        HSSFSheet sheet = wb.createSheet();
        HSSFRow titleRow1 = sheet.createRow(0);
        HSSFRow titleRow2 = sheet.createRow(1);
        HSSFRow headRow = sheet.createRow(2);
        HSSFRow headRow2 = sheet.createRow(3);
        this.createHeadCell(headRow, codeCellStyle, 0, "personNumber");
        this.createHeadCell(headRow2, nameCellStyle, 0, EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"44_AttendanceDataImportUI"));
        this.createHeadCell(titleRow1, codeCellStyle, 0, "EAS");
        this.createHeadCell(titleRow2, codeCellStyle, 0, "attendancemanager");
        this.createHeadCell(headRow, codeCellStyle, 1, "personName");
        this.createHeadCell(headRow2, nameCellStyle, 1, EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"45_AttendanceDataImportUI"));
        this.createHeadCell(titleRow1, codeCellStyle, 1, "");
        if (this.isHolidayImp) {
            this.createHeadCell(titleRow2, codeCellStyle, 1, EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"46_AttendanceDataImportUI"));
        } else {
            this.createHeadCell(titleRow2, codeCellStyle, 1, EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"47_AttendanceDataImportUI"));
        }
        if (this.isHolidayImp) {
            this.createHeadCell(titleRow1, titleStyle, 2, EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"46_AttendanceDataImportUI"));
            this.createHeadCell(titleRow2, titleStyle, 2, EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"46_AttendanceDataImportUI"));
        } else {
            this.createHeadCell(titleRow1, titleStyle, 2, EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"47_AttendanceDataImportUI"));
            this.createHeadCell(titleRow2, titleStyle, 2, EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"47_AttendanceDataImportUI"));
        }
        int colIndex = 2;
        for (Map.Entry entry : this.numberInfoMap.entrySet()) {
            key = entry.getKey().toString().trim();
            this.createHeadCell(headRow, codeCellStyle, colIndex, key);
            TimeAttendanceInfo taInfo = (TimeAttendanceInfo)entry.getValue();
            value = ((TimeAttendanceInfo)entry.getValue()).getName() + "(" + taInfo.getUnitType().getAlias() + ")";
            this.createHeadCell(headRow2, nameCellStyle, colIndex, value);
            ++colIndex;
        }
        Map map = AttendanceManagerConst.getNumberNameMap(TimeUtil.getParamValue("AttendanceData_Relate_OrgUnit"));
        Set set = map.entrySet();
        for (Map.Entry entry : set) {
            key = entry.getKey().toString();
            value = entry.getValue().toString();
            this.createHeadCell(headRow, codeCellStyle, colIndex, key);
            this.createHeadCell(headRow2, nameCellStyle, colIndex, value);
            ++colIndex;
        }
        sheet.addMergedRegion((org.apache.poi.ss.util.Region)new Region(0, 2, 1, (short)(colIndex - 1)));
        for (int i = 0; i < colIndex; ++i) {
            sheet.setDefaultColumnStyle((int)((short)i), (CellStyle)cellValueStyle);
        }
        sheet.setDefaultColumnWidth((short)20);
        if (this.isHolidayImp) {
            wb.setSheetName(0, EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"48_AttendanceDataImportUI"));
        } else {
            wb.setSheetName(0, EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"49_AttendanceDataImportUI"));
        }
        wb.write((OutputStream)out);
        out.flush();
        out.close();
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"50_AttendanceDataImportUI"));
    }

    private void createHeadCell(HSSFRow headRow, HSSFCellStyle cellStyle, int index, String cellValue) {
        HSSFCell cell6 = headRow.createCell((short)index);
        cell6.setCellType(1);
        cell6.setCellValue(cellValue);
        cell6.setCellStyle(cellStyle);
    }

    private boolean checkTemplate(String filePath) {
        String str = filePath.substring(filePath.lastIndexOf("."));
        if (!".xls".equals(str)) {
            return false;
        }
        try {
            this.initSheet();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        int sheetNum = this.comboLabel.getSelectedIndex();
        HSSFSheet sheet = this.workbook.getSheetAt(sheetNum);
        int rowNum = sheet.getPhysicalNumberOfRows();
        return rowNum >= 1;
    }

    private boolean checkFile() {
        int columns;
        int sheetNum = this.comboLabel.getSelectedIndex();
        if (sheetNum < 0) {
            return false;
        }
        if (this.workbook == null) {
            try {
                this.initSheet();
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        HSSFRow headNumRow = null;
        if (this.workbook != null) {
            HSSFSheet sheet = this.workbook.getSheetAt(sheetNum);
            int rowNum = sheet.getPhysicalNumberOfRows();
            if (rowNum < 5) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"51_AttendanceDataImportUI"));
                SysUtil.abort();
            }
            headNumRow = sheet.getRow(2);
        }
        if (headNumRow == null) {
            MsgBox.showWarning((String)EASResource.getString((String)RES, (String)"template_error"));
            this.txtFile.setText("");
            this.comboLabel.removeAllItems();
            SysUtil.abort();
        }
        if ((columns = headNumRow.getPhysicalNumberOfCells()) > this.attNumSet.size() + this.fixedCol) {
            return false;
        }
        HSSFCell fCell = headNumRow.getCell((short)0);
        String value = ExcelUtil.getCellValue((HSSFCell)fCell);
        if (value == null || !value.trim().equals("personNumber")) {
            return false;
        }
        fCell = headNumRow.getCell((short)1);
        value = ExcelUtil.getCellValue((HSSFCell)fCell);
        if (value == null || !value.trim().equals("personName")) {
            return false;
        }
        HashSet dSet = new HashSet(this.attNumSet);
        dSet.addAll(AttendanceManagerConst.getNumberNameMap(true).keySet());
        HashSet<String> colSet = new HashSet<String>();
        boolean hasAttCol = false;
        int j = columns;
        for (int i = 2; i < j; ++i) {
            fCell = headNumRow.getCell((short)i);
            value = ExcelUtil.getCellValue((HSSFCell)fCell);
            if (value == null || !dSet.contains(value.toString().trim())) {
                MsgBox.showError((String)(EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"52_AttendanceDataImportUI") + (i + 1) + EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"53_AttendanceDataImportUI")));
                SysUtil.abort();
                return false;
            }
            colSet.add(value.trim());
            if (!this.attNumSet.contains(value.trim())) continue;
            hasAttCol = true;
        }
        if (!hasAttCol) {
            if (this.isHolidayImp) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"54_AttendanceDataImportUI"));
            } else {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"55_AttendanceDataImportUI"));
            }
            SysUtil.abort();
            return false;
        }
        if (!colSet.contains("beginDate")) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"56_AttendanceDataImportUI"));
            SysUtil.abort();
            return false;
        }
        if (!colSet.contains("endDate")) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"57_AttendanceDataImportUI"));
            SysUtil.abort();
            return false;
        }
        return true;
    }

    private void initSheet() throws Exception {
        this.comboLabel.removeAllItems();
        FilesPathInfo paths = (FilesPathInfo)this.txtFile.getUserObject();
        String path = "";
        if (paths == null || paths.getFilePath() == null || paths.getFilePath().length <= 0) {
            return;
        }
        path = paths.getFilePath()[0];
        ExternalExcelDataReader reader = new ExternalExcelDataReader();
        ArrayList sheetNames = null;
        sheetNames = reader.getSheetNameCollection(path);
        KDTDefaultCellEditor itemEditor = null;
        KDComboBox comSheetNames = new KDComboBox();
        if (sheetNames != null) {
            int sheetCount = sheetNames.size();
            for (int i = 0; i < sheetCount; ++i) {
                comSheetNames.addItem(sheetNames.get(i));
                this.comboLabel.addItem(sheetNames.get(i));
            }
        }
        itemEditor = new KDTDefaultCellEditor((JComboBox)comSheetNames);
        this.tblMain.getColumn("excelTabName").setEditor((ICellEditor)itemEditor);
        this.comboLabel.addItemListener((ItemListener)new ItemListenerImpl());
        POIFSFileSystem pfs = new POIFSFileSystem((InputStream)new FileInputStream(path));
        this.workbook = new HSSFWorkbook(pfs);
    }

    private HSSFCellStyle createValueCellStyle(HSSFWorkbook workbook) {
        HSSFCellStyle valueStyle = workbook.createCellStyle();
        valueStyle.setAlignment((short)1);
        valueStyle.setHidden(true);
        short borderstyle = 7;
        valueStyle.setBorderLeft(borderstyle);
        valueStyle.setBorderRight(borderstyle);
        valueStyle.setBorderTop(borderstyle);
        valueStyle.setBorderBottom(borderstyle);
        short backColorIndex = 8;
        valueStyle.setBottomBorderColor(backColorIndex);
        valueStyle.setTopBorderColor(backColorIndex);
        valueStyle.setLeftBorderColor(backColorIndex);
        valueStyle.setRightBorderColor(backColorIndex);
        valueStyle.setVerticalAlignment((short)1);
        HSSFFont defaultFont = workbook.createFont();
        defaultFont.setFontName(EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"58_AttendanceDataImportUI"));
        defaultFont.setColor((short)8);
        short size = 12;
        defaultFont.setFontHeightInPoints(size);
        valueStyle.setFont(defaultFont);
        valueStyle.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"@"));
        return valueStyle;
    }

    private HSSFCellStyle createNameCellStyle(HSSFWorkbook workbook) {
        HSSFCellStyle titleStyle = null;
        if (titleStyle == null) {
            titleStyle = workbook.createCellStyle();
            titleStyle.setFillPattern((short)1);
            titleStyle.setFillForegroundColor((short)26);
            titleStyle.setAlignment((short)2);
            titleStyle.setHidden(false);
            titleStyle.setLocked(false);
            short borderstyle = 7;
            titleStyle.setBorderLeft(borderstyle);
            titleStyle.setBorderRight(borderstyle);
            titleStyle.setBorderTop(borderstyle);
            titleStyle.setBorderBottom(borderstyle);
            short backColorIndex = 8;
            titleStyle.setBottomBorderColor(backColorIndex);
            titleStyle.setTopBorderColor(backColorIndex);
            titleStyle.setLeftBorderColor(backColorIndex);
            titleStyle.setRightBorderColor(backColorIndex);
            titleStyle.setVerticalAlignment((short)1);
            HSSFFont defaultFont = workbook.createFont();
            defaultFont.setFontName(EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"58_AttendanceDataImportUI"));
            defaultFont.setColor((short)8);
            short size = 12;
            defaultFont.setFontHeightInPoints(size);
            titleStyle.setFont(defaultFont);
        }
        return titleStyle;
    }

    private HSSFCellStyle createCodeCellStyle(HSSFWorkbook workbook) {
        HSSFCellStyle orgStructStyle = null;
        if (orgStructStyle == null) {
            orgStructStyle = workbook.createCellStyle();
            orgStructStyle.setFillPattern((short)1);
            orgStructStyle.setFillForegroundColor((short)31);
            orgStructStyle.setAlignment((short)1);
            orgStructStyle.setHidden(false);
            orgStructStyle.setLocked(false);
            short borderstyle = 7;
            orgStructStyle.setBorderLeft(borderstyle);
            orgStructStyle.setBorderRight(borderstyle);
            orgStructStyle.setBorderTop(borderstyle);
            orgStructStyle.setBorderBottom(borderstyle);
            short backColorIndex = 8;
            orgStructStyle.setBottomBorderColor(backColorIndex);
            orgStructStyle.setTopBorderColor(backColorIndex);
            orgStructStyle.setLeftBorderColor(backColorIndex);
            orgStructStyle.setRightBorderColor(backColorIndex);
            orgStructStyle.setVerticalAlignment((short)1);
            HSSFFont defaultFont = workbook.createFont();
            defaultFont.setFontName(EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"58_AttendanceDataImportUI"));
            short size = 12;
            defaultFont.setFontHeightInPoints(size);
            orgStructStyle.setFont(defaultFont);
        }
        return orgStructStyle;
    }

    private HSSFCellStyle createTitleCellStyle(HSSFWorkbook workbook) {
        HSSFCellStyle titleStyle = null;
        if (titleStyle == null) {
            titleStyle = workbook.createCellStyle();
            titleStyle.setFillPattern((short)1);
            titleStyle.setFillForegroundColor((short)26);
            titleStyle.setAlignment((short)2);
            titleStyle.setHidden(false);
            titleStyle.setLocked(false);
            titleStyle.setBorderLeft((short)0);
            titleStyle.setBorderRight((short)0);
            titleStyle.setBorderTop((short)0);
            titleStyle.setBorderBottom((short)0);
            short backColorIndex = 8;
            titleStyle.setBottomBorderColor(backColorIndex);
            titleStyle.setTopBorderColor(backColorIndex);
            titleStyle.setLeftBorderColor(backColorIndex);
            titleStyle.setRightBorderColor(backColorIndex);
            titleStyle.setVerticalAlignment((short)1);
            HSSFFont defaultFont = workbook.createFont();
            defaultFont.setFontName(EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"58_AttendanceDataImportUI"));
            defaultFont.setColor((short)17);
            short size = 18;
            defaultFont.setFontHeight(size);
            defaultFont.setFontHeightInPoints(size);
            titleStyle.setFont(defaultFont);
        }
        return titleStyle;
    }

    public boolean isCancel() {
        return this.cancel;
    }

    public void setCancel(boolean cancel) {
        this.cancel = cancel;
    }

    private class ItemListenerImpl
    implements ItemListener {
        private ItemListenerImpl() {
        }

        public void itemStateChanged(ItemEvent e) {
            Object obj = AttendanceDataImportUI.this.comboLabel.getSelectedItem();
            if (obj != null) {
                ICell cell = AttendanceDataImportUI.this.tblMain.getCell(0, "excelTabName");
                cell.setValue((Object)obj.toString());
            }
        }
    }

    public class MyProgTask
    implements IProgTask {
        private List list;
        private boolean isOverImport;
        private int erorrHandleMode;
        private Map reuslt;

        public MyProgTask(List list, boolean isOverImport, int erorrHandleMode) {
            this.list = list;
            this.isOverImport = isOverImport;
            this.erorrHandleMode = erorrHandleMode;
        }

        public Object exec() throws Exception {
            this.reuslt = AttendanceManagerImportFacadeFactory.getRemoteInstance().importAttendanceData(this.list, this.isOverImport, this.erorrHandleMode, AttendanceDataImportUI.this.isHolidayImp);
            return "";
        }

        public void afterExec(Object result) throws Exception {
        }

        public void show() {
            Window win = SwingUtilities.getWindowAncestor((Component)((Object)AttendanceDataImportUI.this));
            ProgDialog dialog = null;
            if (win instanceof Frame) {
                dialog = new ProgDialog((Frame)win);
            } else if (win instanceof Dialog) {
                dialog = new ProgDialog((Dialog)win);
            } else {
                return;
            }
            dialog.setLongTimeTask((IProgTask)this);
            dialog.show();
        }

        public Map getResult() {
            return this.reuslt;
        }
    }
}

