/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.time.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.ControlUtilities;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.export.POIExportException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTMenuManager;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QueryPanelCollection;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.org.client.PositionPromptBox2;
import com.kingdee.eas.basedata.org.client.f7.NewAdminByHROF7;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.calc.CalculatorDialog;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.base.OutputExcelUtil;
import com.kingdee.eas.hr.base.client.util.HRClientUtil;
import com.kingdee.eas.hr.compensation.CmpItemPrecisionTypeEnum;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeInfo;
import com.kingdee.eas.hr.compensation.ItemDataTypeEnum;
import com.kingdee.eas.hr.compensation.util.HRCmpItemUtils;
import com.kingdee.eas.hr.emp.PersonPositionCollection;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.client.EmployeeClientUtils;
import com.kingdee.eas.hr.emp.client.PersonMultiPromptBox;
import com.kingdee.eas.hr.time.AttendanceManagerCollection;
import com.kingdee.eas.hr.time.AttendanceManagerFactory;
import com.kingdee.eas.hr.time.AttendanceManagerInfo;
import com.kingdee.eas.hr.time.CheckStateEnum;
import com.kingdee.eas.hr.time.IAttendanceManager;
import com.kingdee.eas.hr.time.ITimeAttendance;
import com.kingdee.eas.hr.time.RefStateEnum;
import com.kingdee.eas.hr.time.TimeAttendanceCollection;
import com.kingdee.eas.hr.time.TimeAttendanceException;
import com.kingdee.eas.hr.time.TimeAttendanceFactory;
import com.kingdee.eas.hr.time.TimeAttendanceInfo;
import com.kingdee.eas.hr.time.UnitTypeEnum;
import com.kingdee.eas.hr.time.client.AbstractAttendanceManagerEditUI;
import com.kingdee.eas.hr.time.client.AttendanceDataImportUI;
import com.kingdee.eas.hr.time.client.AttendanceManagerPanelUI;
import com.kingdee.eas.hr.time.client.HRTimeClientUtils;
import com.kingdee.eas.hr.time.client.TimeAttendanceUtils;
import com.kingdee.eas.hr.time.client.TimeUtil;
import com.kingdee.eas.hr.train.client.LocateAssistant;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.KeyStroke;

public class AttendanceManagerEditUI
extends AbstractAttendanceManagerEditUI {
    private static final long serialVersionUID = -61166L;
    private static final String RES = "com.kingdee.eas.hr.time.TimeResource";
    private PersonMultiPromptBox personPrompt = new PersonMultiPromptBox((IUIObject)this);
    private ArrayList deleteList = new ArrayList();
    private Color yColor = new Color(250, 250, 220);
    private Color nColor = new Color(217, 217, 210);
    private PersonInfo personInfo = null;
    private CommonQueryDialog commonQueryDialog = null;
    private FilterInfo commonQuery = null;
    private Date fromDate = null;
    private Date toDate = null;
    private AdminOrgUnitInfo orgUnit = null;
    private boolean isInclude = false;
    private boolean isFirstDefaultQuery = true;
    private FilterInfo copyFilter = null;
    private boolean isUser = false;
    private AttendanceManagerCollection oldAttendInfos;
    private String cmpSchemeF7URL = "com.kingdee.eas.hr.compensation.app.F7CmpSchemeQuery";
    private boolean isRelateOrg;
    private LocateAssistant locateAssisant;
    private HROrgUnitInfo hrOrgUnitInfo = null;
    private int returnRowCount = 1000;
    private Set orgRangePerIds;
    boolean isChang = true;
    boolean flag = false;
    boolean flag1 = true;

    public AttendanceManagerEditUI() throws Exception {
        HRClientUtil.checkCurrentHRUnitNotNull((CoreUI)this);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.setOutputTableData();
        this.preparePrintPage(this.tblOutput);
        this.tblOutput.getPrintManager().printPreview();
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.setOutputTableData();
        this.tblOutput.getPrintManager().pageSetup();
    }

    public void onLoad() throws Exception {
        this.datePickerStart.setValue(null);
        this.datePickerEnd.setValue(null);
        super.onLoad();
        this.isRelateOrg = TimeUtil.getParamValue("AttendanceData_Relate_OrgUnit");
        TimeAttendanceUtils.initF7Selector((IUIObject)this, this.promptOrgUnit);
        this.orgRangePerIds = TimeUtil.getAdminRangePersonIdSet();
        this.initSelector();
        this.inOnload();
        this.setButtonDefaultStyl(this.btnQuery);
        this.processNullPer();
        this.tblMain.setColumnMoveable(true);
        this.tblAttendance.setColumnMoveable(true);
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblAttendance.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                int colIndex = e.getColIndex();
                int rowIndex = e.getRowIndex();
                if (e.getColIndex() == AttendanceManagerEditUI.this.tblAttendance.getColumnIndex("position.name") && AttendanceManagerEditUI.this.tblAttendance.getCell(rowIndex, "adminOrgUnit.name") != null) {
                    try {
                        AttendanceManagerEditUI.this.tblAttendance_Changed(rowIndex, colIndex);
                    }
                    catch (Exception e1) {
                        AttendanceManagerEditUI.this.handleException(e1);
                    }
                }
            }
        });
        this.tblAttendance.getColumn("adminOrgUnit.name").setRequired(true);
        this.tblMain.getSelectManager().select(0, 0);
        AttendanceManagerEditUI.processTableKeyBoardEvent(this.tblAttendance, "attend");
    }

    private void tblAttendance_Changed(int rowIndex, int colIndex) throws BOSException {
        Object adminOrgUnit = UIRuleUtil.getProperty((IObjectValue)((IObjectValue)this.tblAttendance.getCell(rowIndex, "position.name").getValue()), (String)"adminOrgUnit");
        if (adminOrgUnit != null) {
            this.tblAttendance.getCell(rowIndex, "adminOrgUnit.name").setValue(adminOrgUnit);
        }
    }

    private void processNullPer() {
        if (this.tblMain.getRowCount() > 0 || this.tblMain.getRowCount() == -1) {
            this.btnWorkInsert.setEnabled(true);
            this.btnWorkDelete.setEnabled(true);
        } else {
            this.tblAttendance.removeRows();
            this.btnWorkInsert.setEnabled(false);
            this.btnWorkDelete.setEnabled(false);
        }
    }

    protected void inOnload() throws Exception {
        this.tblMain.checkParsed();
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getDataRequestManager().setDataRequestMode(1);
        this.tblMain.getSelectManager().setSelectMode(10);
        if (this.mainQuery == null) {
            this.mainQuery = new EntityViewInfo();
        }
        this.tblOutput.checkParsed();
        this.attendanceManagerQuery = null;
        this.tblOutput.removeRows();
        this.tblMain.removeRows();
    }

    void setModifyData(ArrayList list) throws Exception {
        if (list == null) {
            return;
        }
        IAttendanceManager iMana = AttendanceManagerFactory.getRemoteInstance();
        AttendanceManagerCollection attendInfos = iMana.getCollectionByList(list);
        if (attendInfos != null && attendInfos.size() > 0) {
            this.fillTableData(attendInfos);
        }
    }

    void fillTableData(AttendanceManagerCollection attendInfos) throws Exception {
        IRow curRow;
        int size = attendInfos.size();
        for (int i = 0; i < size && (curRow = this.tblAttendance.addRow()).getCell("id") != null; ++i) {
            curRow.getCell("id").setValue((Object)attendInfos.get(i).getId().toString());
            if (attendInfos.get(i).getRefrence().getValue() == 1) {
                curRow.getStyleAttributes().setLocked(true);
                curRow.getStyleAttributes().setBackground(this.nColor);
            }
            if (attendInfos.get(i).getCheckState().getValue() == 1) {
                curRow.getStyleAttributes().setLocked(true);
                curRow.getStyleAttributes().setBackground(this.nColor);
            }
            curRow.getCell("colTotalValue").setEditor(TimeAttendanceUtils.getTheCellEditor(attendInfos.get(i).getAttendance().getLength(), attendInfos.get(i).getAttendance().getDecDigital(), attendInfos.get(i).getAttendance().getDataType()));
            curRow.getCell("colTotalValue").getStyleAttributes().setNumberFormat(TimeAttendanceUtils.getFomatString(attendInfos.get(i).getAttendance().getLength(), attendInfos.get(i).getAttendance().getDecDigital()));
            curRow.getCell("colAttendance").setValue((Object)attendInfos.get(i).getAttendance());
            curRow.getCell("colStartDate").setValue((Object)attendInfos.get(i).getStartDate());
            curRow.getCell("colEndDate").setValue((Object)attendInfos.get(i).getEndDate());
            curRow.getCell("colTotalValue").setValue((Object)Float.valueOf(String.valueOf(attendInfos.get(i).getTotalValue())));
            curRow.getCell("colRecordPerson").setValue((Object)attendInfos.get(i).getRecordPerson());
            curRow.getCell("colMemo").setValue((Object)attendInfos.get(i).getDescription());
            curRow.getCell("colTotalUnit").setValue((Object)attendInfos.get(i).getAttendance().getUnitType());
            curRow.getCell("colCmpPeriod").setValue((Object)attendInfos.get(i).getCmpPeriod());
            curRow.getCell("position.name").setValue((Object)attendInfos.get(i).getPosition());
            curRow.getCell("adminOrgUnit.name").setValue((Object)attendInfos.get(i).getAdminOrgUnit());
            curRow.getCell("attendancecmp").setValue((Object)attendInfos.get(i).getCmpScheme());
        }
    }

    AttendanceManagerCollection getAttendanceManagerCollection() throws Exception {
        int i;
        AttendanceManagerCollection attendInfos = new AttendanceManagerCollection();
        AttendanceManagerInfo info = null;
        int counts = this.tblAttendance.getRowCount();
        for (i = 0; i < counts; ++i) {
            info = new AttendanceManagerInfo();
            if (this.tblAttendance.getRow(i).getCell("id").getValue() != null) {
                info.setId(BOSUuid.read((String)((String)this.tblAttendance.getRow(i).getCell("id").getValue())));
            } else {
                info.setRefrence(RefStateEnum.UNREF);
                info.setCheckState(CheckStateEnum.UNCHECK);
            }
            TimeAttendanceInfo attendanceInfo = (TimeAttendanceInfo)this.tblAttendance.getRow(i).getCell("colAttendance").getValue();
            info.setAttendance(attendanceInfo);
            Date temp = (Date)this.tblAttendance.getRow(i).getCell("colStartDate").getValue();
            if (temp == null) {
                MsgBox.showError((Component)((Object)this), (String)(EASResource.getString((String)RES, (String)"STARTDATE_NULL") + ""));
                SysUtil.abort();
            }
            Calendar ca = Calendar.getInstance();
            ca.setTime(temp);
            ca.set(13, 0);
            ca.set(14, 0);
            info.setStartDate(temp);
            temp = (Date)this.tblAttendance.getRow(i).getCell("colEndDate").getValue();
            if (temp == null) {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"ENDDATE_NULL"));
                SysUtil.abort();
            }
            Calendar endca = Calendar.getInstance();
            endca.setTime(temp);
            endca.set(13, 0);
            endca.set(14, 0);
            info.setEndDate(temp);
            if (ca.getTimeInMillis() > endca.getTimeInMillis()) {
                throw new TimeAttendanceException(TimeAttendanceException.TIME_ENDDATE_BEGINDATE);
            }
            if (ItemDataTypeEnum.FLOAT.equals((Object)attendanceInfo.getDataType())) {
                BigDecimal colTotalValue = new BigDecimal(this.tblAttendance.getRow(i).getCell("colTotalValue").getValue().toString().trim());
                colTotalValue = HRCmpItemUtils.convertPrecisionForBigDecimal((BigDecimal)colTotalValue, (int)attendanceInfo.getDecDigital(), (CmpItemPrecisionTypeEnum)CmpItemPrecisionTypeEnum.SISHEWURU);
                info.setTotalValue(Float.parseFloat(colTotalValue.toString()));
            } else {
                info.setTotalValue(Float.parseFloat(this.tblAttendance.getRow(i).getCell("colTotalValue").getValue().toString().trim()));
            }
            if (this.tblAttendance.getRow(i).getCell("colRecordPerson").getValue() != null) {
                info.setRecordPerson((PersonInfo)this.tblAttendance.getRow(i).getCell("colRecordPerson").getValue());
            }
            info.setDescription((String)this.tblAttendance.getRow(i).getCell("colMemo").getValue());
            info.setCmpPeriod((CmpPeriodInfo)this.tblAttendance.getRow(i).getCell("colCmpPeriod").getValue());
            info.setPerson(this.personInfo);
            info.setPosition((PositionInfo)this.tblAttendance.getRow(i).getCell("position.name").getValue());
            info.setAdminOrgUnit((AdminOrgUnitInfo)this.tblAttendance.getRow(i).getCell("adminOrgUnit.name").getValue());
            info.setCmpScheme((CmpSchemeInfo)this.tblAttendance.getRow(i).getCell("attendancecmp").getValue());
            attendInfos.add(info);
        }
        if (attendInfos.size() > 1) {
            int size = attendInfos.size();
            for (i = 0; i < size; ++i) {
                for (int j = i + 1; j < size; ++j) {
                    AttendanceManagerInfo amInfo1 = attendInfos.get(i);
                    AttendanceManagerInfo amInfo2 = attendInfos.get(j);
                    if (!amInfo1.getStartDate().equals(amInfo2.getStartDate()) || !amInfo1.getEndDate().equals(amInfo2.getEndDate()) || !amInfo1.getAttendance().getId().toString().equals(amInfo2.getAttendance().getId().toString()) || (amInfo1.getAdminOrgUnit() == null || amInfo2.getAdminOrgUnit() == null || !amInfo1.getAdminOrgUnit().getId().toString().equals(amInfo2.getAdminOrgUnit().getId().toString())) && (amInfo1.getAdminOrgUnit() != null || amInfo2.getAdminOrgUnit() != null)) continue;
                    MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"ATTENDMANAGER_REPEAT"));
                    SysUtil.abort();
                }
            }
        }
        return attendInfos;
    }

    void initSelector() throws BOSException {
        KDTMenuManager tm;
        this.tblAttendance.checkParsed();
        this.btnWorkDelete.setEnabled(true);
        this.btnWorkInsert.setEnabled(true);
        EmployeeClientUtils.initTableBtn((JButton)this.btnWorkInsert, (JButton)this.btnWorkDelete);
        KDDatePicker endDatePicker = new KDDatePicker();
        endDatePicker.setTimeEnabled(true);
        endDatePicker.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                Date endDate = (Date)eventObj.getNewValue();
                AttendanceManagerEditUI.this.calTotalValueByEndDatePicker(endDate);
            }
        });
        this.tblAttendance.getColumn("colEndDate").setEditor((ICellEditor)new KDTDefaultCellEditor(endDatePicker));
        this.tblAttendance.getColumn("colEndDate").getStyleAttributes().setNumberFormat(HRTimeClientUtils.getLongTimePatternStr());
        KDDatePicker startDatePicker = new KDDatePicker();
        startDatePicker.setTimeEnabled(true);
        startDatePicker.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                Date startDate = (Date)eventObj.getNewValue();
                AttendanceManagerEditUI.this.calTotalValueByStartDatePicker(startDate);
            }
        });
        this.tblAttendance.getColumn("colStartDate").setEditor((ICellEditor)new KDTDefaultCellEditor(startDatePicker));
        this.tblAttendance.getColumn("colStartDate").getStyleAttributes().setNumberFormat(HRTimeClientUtils.getLongTimePatternStr());
        this.tblAttendance.getColumn("colAttendance").setEditor(this.getComboBoxCellEditor());
        this.tblAttendance.getColumn("colRecordPerson").setEditor(this.getF7CellEditor());
        this.tblAttendance.getColumn("colTotalValue").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblAttendance.getColumn("colCmpPeriod").setEditor(this.getCmpPersonF7CellEditor());
        this.tblAttendance.getColumn("colTotalUnit").getStyleAttributes().setLocked(true);
        this.tblAttendance.getColumn("colTotalUnit").getStyleAttributes().setBackground(this.nColor);
        this.tblAttendance.getColumn("colAttendance").getStyleAttributes().setBackground(this.yColor);
        this.tblAttendance.getColumn("colTotalValue").getStyleAttributes().setBackground(this.yColor);
        this.tblAttendance.getColumn("colStartDate").getStyleAttributes().setBackground(this.yColor);
        this.tblAttendance.getColumn("colEndDate").getStyleAttributes().setBackground(this.yColor);
        this.tblAttendance.getColumn("colTotalValue").getStyleAttributes().setNumberFormat("%r{#.##}d");
        EmployeeClientUtils.setCellEditor((KDTable)this.tblAttendance, (String)"colMemo");
        this.tblAttendance.getColumn("position.name").setEditor(this.getPositionF7Editor());
        this.tblAttendance.getColumn("adminOrgUnit.name").setEditor(this.getAdminOrgUnitF7());
        this.tblAttendance.getColumn("attendancecmp").setEditor(this.getCmpSchemeF7());
        ObjectValueRender render = new ObjectValueRender();
        render.setFormat((IDataFormat)new BizDataFormat("$name$"));
        this.tblAttendance.getColumn("attendancecmp").setRenderer((IBasicRender)render);
        if (!this.isRelateOrg) {
            this.tblAttendance.getColumn("position.name").getStyleAttributes().setHided(true);
            this.tblAttendance.getColumn("adminOrgUnit.name").getStyleAttributes().setHided(true);
            this.tblAttendance.getColumn("attendancecmp").getStyleAttributes().setHided(true);
        }
        if ((tm = this.getMenuManager(this.tblMain)) == null) {
            return;
        }
        KDPopupMenu pop = tm.getMenu();
        for (int i = 0; i < pop.getComponentCount(); ++i) {
            if (!"menuItemCopy".equalsIgnoreCase(pop.getComponent(i).getName())) continue;
            pop.getComponent(i).setVisible(false);
            break;
        }
    }

    private void calTotalValueByStartDatePicker(Date startDate) {
        double t1 = 0.0;
        int curRowNum = KDTableUtil.getSelectedRow((KDTable)this.tblAttendance);
        IRow curRow = this.tblAttendance.getRow(curRowNum);
        if (curRow.getCell("colEndDate") == null) {
            return;
        }
        Date endDate = (Date)curRow.getCell("colEndDate").getValue();
        long longTime = DateTimeUtils.dateDiff((Date)startDate, (Date)endDate);
        if (curRow.getCell("colTotalUnit").getValue() == UnitTypeEnum.DAY) {
            t1 = (double)longTime / 1000.0 / 60.0 / 60.0 / 24.0;
        } else if (curRow.getCell("colTotalUnit").getValue() == UnitTypeEnum.HOUR) {
            t1 = (double)longTime / 1000.0 / 60.0 / 60.0;
        } else if (curRow.getCell("colTotalUnit").getValue() == UnitTypeEnum.MINUTE) {
            t1 = (double)longTime / 1000.0 / 60.0;
        }
        curRow.getCell("colTotalValue").setValue((Object)String.valueOf(t1));
    }

    private void calTotalValueByEndDatePicker(Date endDate) {
        double t2 = 0.0;
        int curRowNum = KDTableUtil.getSelectedRow((KDTable)this.tblAttendance);
        IRow curRow = this.tblAttendance.getRow(curRowNum);
        if (curRow.getCell("colStartDate") == null) {
            return;
        }
        Date startDate = (Date)curRow.getCell("colStartDate").getValue();
        long longTime = DateTimeUtils.dateDiff((Date)startDate, (Date)endDate);
        if (curRow.getCell("colTotalUnit").getValue() == UnitTypeEnum.DAY) {
            t2 = (double)longTime / 1000.0 / 60.0 / 60.0 / 24.0;
        } else if (curRow.getCell("colTotalUnit").getValue() == UnitTypeEnum.HOUR) {
            t2 = (double)longTime / 1000.0 / 60.0 / 60.0;
        } else if (curRow.getCell("colTotalUnit").getValue() == UnitTypeEnum.MINUTE) {
            t2 = (double)longTime / 1000.0 / 60.0;
        }
        curRow.getCell("colTotalValue").setValue((Object)String.valueOf(t2));
    }

    private ICellEditor getF7CellEditor() {
        KDBizPromptBox f7 = new KDBizPromptBox();
        f7.setSelector((KDPromptSelector)this.personPrompt);
        f7.setDisplayFormat("$name$");
        f7.setEditFormat("$number$");
        f7.setCommitFormat("$number$");
        f7.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                try {
                    AttendanceManagerEditUI.this.setOrgValue(e, AttendanceManagerEditUI.this.personPrompt);
                }
                catch (Exception e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
            }
        });
        return new KDTDefaultCellEditor((IKDEditor)f7);
    }

    private ICellEditor getPositionF7Editor() {
        KDBizPromptBox prmtPosition = new KDBizPromptBox();
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        hashMap.put("HRO_FILTER", Boolean.TRUE);
        PositionPromptBox2 pmtNew = new PositionPromptBox2((IUIObject)this, hashMap);
        prmtPosition.setSelector((KDPromptSelector)pmtNew);
        prmtPosition.setDisplayFormat("$name$");
        prmtPosition.setEditable(false);
        return new KDTDefaultCellEditor((IKDEditor)prmtPosition);
    }

    private ICellEditor getAdminOrgUnitF7() {
        NewAdminByHROF7 f7 = new NewAdminByHROF7();
        f7.setMultiSelect(false);
        KDBizPromptBox prmtAdminOrgUnit = new KDBizPromptBox();
        prmtAdminOrgUnit.setSelector((KDPromptSelector)f7);
        prmtAdminOrgUnit.setEnabledMultiSelection(false);
        prmtAdminOrgUnit.setDisplayFormat("$name$");
        prmtAdminOrgUnit.setEditable(false);
        return new KDTDefaultCellEditor((IKDEditor)prmtAdminOrgUnit);
    }

    private ICellEditor getCmpSchemeF7() {
        KDBizPromptBox prmtCmpScheme = new KDBizPromptBox();
        prmtCmpScheme.setQueryInfo(this.cmpSchemeF7URL);
        prmtCmpScheme.setEditable(false);
        prmtCmpScheme.setEditFormat("$name$");
        prmtCmpScheme.setDisplayFormat("$name$");
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfoCmpSch = new FilterInfo();
        filterInfoCmpSch.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)this.getHROrgUnit().getId().toString()));
        filterInfoCmpSch.getFilterItems().add(new FilterItemInfo("enable", (Object)1));
        filterInfoCmpSch.getFilterItems().add(new FilterItemInfo("enable", (Object)3));
        filterInfoCmpSch.getFilterItems().add(new FilterItemInfo("isDelete", (Object)"0"));
        filterInfoCmpSch.setMaskString("#0 and (#1 or #2) and #3");
        evi.setFilter(filterInfoCmpSch);
        prmtCmpScheme.setEntityViewInfo(evi);
        prmtCmpScheme.setEnabled(true);
        return new KDTDefaultCellEditor((IKDEditor)prmtCmpScheme);
    }

    private ICellEditor getCmpPersonF7CellEditor() {
        KDBizPromptBox f7 = new KDBizPromptBox();
        f7.setQueryInfo("com.kingdee.eas.hr.compensation.app.F7CmpPeriodQuery");
        f7.setDisplayFormat("$name$");
        f7.setEditFormat("$number$");
        f7.setCommitFormat("$number$");
        f7.setEditable(true);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("enableState", (Object)0));
        filter.setMaskString("#0 and #1");
        view.setFilter(filter);
        f7.setEntityViewInfo(view);
        return new KDTDefaultCellEditor((IKDEditor)f7);
    }

    private void setOrgValue(PreChangeEvent e, PersonMultiPromptBox pmt) {
        if (pmt.getData() instanceof Object[]) {
            IRow curRow = null;
            Object[] obj = (Object[])pmt.getData();
            int length = obj.length;
            for (int i = 0; i < length; ++i) {
                if (i == 0) {
                    curRow = this.tblAttendance.getRow(KDTableUtil.getSelectedRow((KDTable)this.tblAttendance));
                } else {
                    curRow = this.tblAttendance.addRow();
                    curRow.getCell("colEndDate").setValue((Object)new Date());
                    curRow.getCell("colStartDate").setValue((Object)new Date());
                }
                curRow.getCell("colRecordPerson").setValue((Object)this.getLoginPersonInfo());
            }
        }
    }

    private ICellEditor getEndDateCellEditor() {
        KDDatePicker dpDate = new KDDatePicker();
        dpDate.setValue((Object)new Date());
        dpDate.setTimeEnabled(true);
        return new KDTDefaultCellEditor(dpDate);
    }

    private ICellEditor getStartDateCellEditor() {
        KDDatePicker dpDate = new KDDatePicker();
        dpDate.setValue((Object)new Date());
        dpDate.setTimeEnabled(true);
        return new KDTDefaultCellEditor(dpDate);
    }

    private ICellEditor getComboBoxCellEditor() throws BOSException {
        KDComboBox combo = new KDComboBox((ComboBoxModel)this.getComboModel());
        combo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                try {
                    AttendanceManagerEditUI.this.cboContractType_itemStateChanged(e);
                }
                catch (Exception exc) {
                    AttendanceManagerEditUI.this.handUIException(exc);
                }
            }
        });
        return new KDTDefaultCellEditor((JComboBox)combo);
    }

    private void cboContractType_itemStateChanged(ItemEvent e) throws Exception {
        TimeAttendanceInfo info = (TimeAttendanceInfo)((KDComboBox)e.getSource()).getSelectedItem();
        if (info == null) {
            return;
        }
        IRow curRow = this.tblAttendance.getRow(KDTableUtil.getSelectedRow((KDTable)this.tblAttendance));
        curRow.getCell("colTotalUnit").setValue((Object)info.getUnitType());
        curRow.getCell("colTotalValue").setEditor(TimeAttendanceUtils.getTheCellEditor(info.getLength(), info.getDecDigital(), info.getDataType()));
        curRow.getCell("colTotalValue").getStyleAttributes().setNumberFormat(TimeAttendanceUtils.getFomatString(info.getLength(), info.getDecDigital()));
        if (curRow.getCell("colStartDate") == null) {
            return;
        }
        Date startDate = (Date)curRow.getCell("colStartDate").getValue();
        this.calTotalValueByStartDatePicker(startDate);
    }

    public DefaultComboBoxModel getComboModel() throws BOSException {
        DefaultComboBoxModel<TimeAttendanceInfo> model = new DefaultComboBoxModel<TimeAttendanceInfo>();
        ITimeAttendance iAttend = TimeAttendanceFactory.getRemoteInstance();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("attendCatalog", (Object)"00000000-0000-0000-0000-000000000001BE0D0183"));
        filterInfo.getFilterItems().add(new FilterItemInfo("attendCatalog", (Object)"00000000-0000-0000-0000-000000000003BE0D0183"));
        filterInfo.getFilterItems().add(new FilterItemInfo("enable", (Object)1));
        filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", null));
        filterInfo.setMaskString("(#0 or #1) and #2 and (#3 or #4)");
        view.setFilter(filterInfo);
        SorterItemInfo sorterOrderItem = new SorterItemInfo("number");
        sorterOrderItem.setSortType(SortType.ASCEND);
        view.getSorter().add(sorterOrderItem);
        TimeAttendanceCollection timeInfos = iAttend.getTimeAttendanceCollection(view);
        for (int i = 0; i < timeInfos.size(); ++i) {
            model.addElement(timeInfos.get(i));
        }
        if (timeInfos.size() != 0) {
            model.setSelectedItem(timeInfos.get(0));
        }
        return model;
    }

    protected IObjectValue createNewData() {
        return new AttendanceManagerInfo();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return AttendanceManagerFactory.getRemoteInstance();
    }

    public void actionWorkDelete_actionPerformed(ActionEvent e) throws Exception {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblAttendance);
        if (selectRows != null && selectRows.length > 0) {
            for (int i = selectRows.length - 1; i >= 0; --i) {
                int selectRow = selectRows[i];
                IRow row = this.tblAttendance.getRow(selectRow);
                if (row != null && row.getCell("id") != null && row.getCell("id").getValue() != null) {
                    String strId = (String)row.getCell("id").getValue();
                    this.deleteList.add(strId);
                }
                this.tblAttendance.removeRow(selectRow);
            }
        }
    }

    public void actionWorkInsert_actionPerformed(ActionEvent e) throws Exception {
        super.actionWorkInsert_actionPerformed(e);
        IRow curRow = this.tblAttendance.addRow();
        curRow.getCell("colEndDate").setValue((Object)((Date)this.datePickerEnd.getValue()));
        curRow.getCell("colStartDate").setValue((Object)((Date)this.datePickerStart.getValue()));
        curRow.getCell("colRecordPerson").setValue((Object)this.getLoginPersonInfo());
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectRows.length > 0) {
            Object pId = this.tblMain.getCell(selectRows[0], "id").getValue();
            if (pId == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"59_AttendanceManagerEditUI"));
                SysUtil.abort();
            }
            if (!this.isRelateOrg) {
                return;
            }
            if (!this.orgRangePerIds.contains(pId)) {
                if (this.tblAttendance.getRowCount() > 0) {
                    PositionInfo psInfo = (PositionInfo)this.tblAttendance.getCell(0, "position.name").getValue();
                    curRow.getCell("position.name").setValue((Object)psInfo);
                    AdminOrgUnitInfo orgInfo = (AdminOrgUnitInfo)this.tblAttendance.getCell(0, "adminOrgUnit.name").getValue();
                    curRow.getCell("adminOrgUnit.name").setValue((Object)orgInfo);
                }
            } else {
                EntityViewInfo evi = new EntityViewInfo();
                FilterInfo fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("person.id", (Object)pId.toString()));
                fi.getFilterItems().add(new FilterItemInfo("isPrimary", (Object)1));
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("position.id"));
                sic.add(new SelectorItemInfo("position.name"));
                sic.add(new SelectorItemInfo("position.adminOrgUnit.id"));
                sic.add(new SelectorItemInfo("position.adminOrgUnit.name"));
                evi.setFilter(fi);
                evi.setSelector(sic);
                PositionMemberCollection pColl = PositionMemberFactory.getRemoteInstance().getPositionMemberCollection(evi);
                if (pColl.size() > 0) {
                    curRow.getCell("position.name").setValue((Object)pColl.get(0).getPosition());
                    curRow.getCell("adminOrgUnit.name").setValue((Object)pColl.get(0).getPosition().getAdminOrgUnit());
                } else {
                    EntityViewInfo evi1 = new EntityViewInfo();
                    FilterInfo fi1 = new FilterInfo();
                    fi1.getFilterItems().add(new FilterItemInfo("person.id", (Object)pId.toString()));
                    SelectorItemCollection sic1 = new SelectorItemCollection();
                    sic1.add(new SelectorItemInfo("id"));
                    sic1.add(new SelectorItemInfo("gkAdmin.id"));
                    sic1.add(new SelectorItemInfo("gkAdmin.name"));
                    evi1.setFilter(fi1);
                    evi1.setSelector(sic1);
                    PersonPositionCollection psColl = PersonPositionFactory.getRemoteInstance().getPersonPositionCollection(evi1);
                    if (psColl.size() > 0) {
                        curRow.getCell("adminOrgUnit.name").setValue((Object)psColl.get(0).getGkAdmin());
                    }
                }
            }
        }
    }

    PersonInfo getLoginPersonInfo() {
        return SysContext.getSysContext().getCurrentUserInfo().getPerson();
    }

    void checkInput() throws TimeAttendanceException {
        int[] selectRows;
        int counts = this.tblAttendance.getRowCount();
        IRow curRow = null;
        ArrayList<String> psList = new ArrayList<String>();
        ArrayList<String> orgList = new ArrayList<String>();
        for (int i = 0; i < counts; ++i) {
            curRow = this.tblAttendance.getRow(i);
            if (curRow.getCell("colAttendance").getValue() == null) {
                throw new TimeAttendanceException(TimeAttendanceException.ATTENDANCECOLUMN_NOT_NULL);
            }
            if (curRow.getCell("colTotalValue").getValue() == null) {
                throw new TimeAttendanceException(TimeAttendanceException.TOTALVALUECOLUMN_NOT_NULL);
            }
            if (curRow.getCell("colStartDate").getValue() != null && curRow.getCell("colEndDate").getValue() != null) {
                Date beginDate = (Date)curRow.getCell("colStartDate").getValue();
                Date endDate = (Date)curRow.getCell("colEndDate").getValue();
                if (beginDate.getTime() > endDate.getTime()) {
                    throw new TimeAttendanceException(TimeAttendanceException.TIME_ENDDATE_BEGINDATE);
                }
            }
            if (!this.isRelateOrg) continue;
            PositionInfo psInfo = (PositionInfo)this.tblAttendance.getRow(i).getCell("position.name").getValue();
            AdminOrgUnitInfo orgInfo = (AdminOrgUnitInfo)this.tblAttendance.getRow(i).getCell("adminOrgUnit.name").getValue();
            if (orgInfo == null) {
                MsgBox.showWarning((Component)((Object)this), (String)(EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"1_AttendanceManagerImportFacadeControllerBean") + (i + 1) + EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"60_AttendanceManagerEditUI")));
                SysUtil.abort();
            }
            if (psInfo != null) {
                psList.add(psInfo.getId().toString());
            } else {
                psList.add("");
            }
            orgList.add(orgInfo.getId().toString());
        }
        if (this.isRelateOrg) {
            try {
                String ouId = null;
                if (this.orgUnit != null) {
                    ouId = this.orgUnit.getId().toString();
                }
                AttendanceManagerFactory.getRemoteInstance().checkPositionAndOrg(psList, orgList, ouId, this.isInclude);
            }
            catch (Exception e) {
                MsgBox.showWarning((Component)((Object)this), (String)e.getMessage());
                SysUtil.abort();
            }
        }
        if ((selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain)).length > 0) {
            IRow row = this.tblMain.getRow(selectRows[0]);
            String pName = row.getCell("colName").getValue().toString();
            String pId = row.getCell("id").getValue().toString();
            if (!this.orgRangePerIds.contains(pId)) {
                MsgBox.showWarning((Component)((Object)this), (String)(pName + EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"61_AttendanceManagerEditUI")));
            }
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.personInfo == null) {
            throw new TimeAttendanceException(TimeAttendanceException.MUST_SELECT_PERSON);
        }
        this.checkInput();
        AttendanceManagerCollection infos = this.getAttendanceManagerCollection();
        IObjectPK[] pk = null;
        int counts = this.deleteList.size();
        if (counts > 0) {
            pk = new IObjectPK[this.deleteList.size()];
            for (int i = 0; i < counts; ++i) {
                pk[i] = new ObjectUuidPK(this.deleteList.get(i).toString());
            }
        }
        IAttendanceManager iManager = AttendanceManagerFactory.getRemoteInstance();
        iManager.submitAll(infos, pk);
        this.deleteList = new ArrayList();
        this.tblMain_activeCellChanged(null);
        this.setMessageText(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Save_OK"));
        this.showMessage();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionCopyData.setEnabled(true);
        this.actionCata.setVisible(false);
        this.actionPrint.setEnabled(true);
        this.actionPrintPreview.setEnabled(true);
        this.btnLocate.setIcon(EASResource.getIcon((String)"imgTbtn_speedgoto"));
        this.actionLocate.setEnabled(true);
        this.setButtonDefaultStyl(this.btnSave);
        this.btnView.setVisible(false);
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
    }

    public void actionCata_actionPerformed(ActionEvent e) throws Exception {
        super.actionCata_actionPerformed(e);
        CalculatorDialog calc = new CalculatorDialog((Container)((Object)this));
        calc.showDialog();
    }

    public void actionCopyData_actionPerformed(ActionEvent e) throws Exception {
        KDTSelectBlock sb = null;
        int size = this.tblAttendance.getSelectManager().size();
        if (size > 0) {
            sb = this.tblAttendance.getSelectManager().get(0);
            ICell iCell = null;
            int row = sb.getTop();
            int column = sb.getLeft();
            IColumn iColumn = this.tblAttendance.getColumn(column);
            if (iColumn.getStyleAttributes().isLocked()) {
                return;
            }
            if (row == -1) {
                return;
            }
            Object value = this.tblAttendance.getCell(row, column).getValue();
            Object valueUnit = this.tblAttendance.getCell(row, 3).getValue();
            int length = this.tblAttendance.getRowCount();
            for (int i = 0; i < length; ++i) {
                if (i == row || this.tblAttendance.getCell(i, column).getStyleAttributes().isLocked()) continue;
                iCell = this.tblAttendance.getCell(i, column);
                iCell.setValue(value);
                if (!iColumn.getKey().equals("colAttendance")) continue;
                this.tblAttendance.getCell(i, 3).setValue(valueUnit);
            }
        }
    }

    protected void selectFirstRow() {
        super.selectFirstRow();
        this.flag = true;
    }

    protected void tblMain_activeCellChanged(KDTActiveCellEvent e) throws Exception {
        AttendanceManagerCollection attendInfos;
        if (this.flag && this.isModify() && e != null) {
            if (!this.isChang) {
                this.isChang = true;
                return;
            }
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.time.LeaveDetailResource", (String)"CHANGE_CONFIRM"));
            if (result == 0) {
                if (!this.flag1) {
                    this.flag1 = true;
                }
                this.actionSave.setDaemonRun(false);
                ActionEvent event = new ActionEvent(this.btnSave, 1001, this.btnSave.getActionCommand());
                this.actionSave.actionPerformed(event);
                if (this.flag1) {
                    this.isChang = false;
                    this.tblMain.getSelectManager().select(e.getPrevRowIndex(), 0);
                    return;
                }
                this.flag1 = true;
            } else if (result != 1) {
                this.isChang = false;
                this.tblMain.getSelectManager().select(e.getPrevRowIndex(), 0);
                return;
            }
        }
        this.oldAttendInfos = attendInfos = this.queryPersonAttendance();
        if (attendInfos != null && attendInfos.size() > 0) {
            this.tblAttendance.removeRows();
            this.fillTableData(attendInfos);
        } else {
            this.tblAttendance.removeRows();
        }
    }

    public void actionInput_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<DatataskParameter> importParam = new ArrayList<DatataskParameter>();
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "eas.hr.time.attendanceManage";
        param.alias = EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"62_AttendanceManagerEditUI");
        importParam.add(param);
        UIContext context = new UIContext((Object)this);
        context.put((Object)"params", importParam);
        context.put((Object)"mode", (Object)0);
        int selectRow = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        if (selectRow == -1 && this.tblMain.getRowCount() > 0) {
            selectRow = 0;
        }
        if (selectRow >= 0) {
            if (this.tblMain.getRow(selectRow) != null && this.tblMain.getRow(selectRow).getCell("id") != null) {
                String personId = this.tblMain.getRow(selectRow).getCell("id").getValue().toString();
                context.put((Object)"personId", (Object)personId);
            } else {
                return;
            }
        }
        context.put((Object)"Owner", (Object)this);
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow curDialog = uiFactory.create(AttendanceDataImportUI.class.getName(), (Map)context, null, OprtState.ADDNEW);
        curDialog.show();
        curDialog.close();
        this.tblMain_activeCellChanged(null);
    }

    public void actionOutput_actionPerformed(ActionEvent e) throws Exception {
        this.setOutputTableData();
        OutputExcelUtil excelUtil = new OutputExcelUtil();
        try {
            excelUtil.appendToExcel(this.tblOutput, true, true, this.getUITitle());
        }
        catch (POIExportException ex) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"63_AttendanceManagerEditUI"));
        }
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = super.getQueryExecutor(queryPK, viewInfo);
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        exec.option().topCount = this.commonQueryDialog == null ? this.returnRowCount : this.commonQueryDialog.getMaxReturnRowCount();
        return exec;
    }

    protected void afterTableFillData(KDTDataRequestEvent e) {
        super.afterTableFillData(e);
        if (this.commonQueryDialog == null) {
            this.tblMain.setRowCount(this.tblMain.getRowCount() > this.returnRowCount ? this.returnRowCount : this.tblMain.getRowCount());
            if (this.getRowCount() > this.returnRowCount) {
                String msg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_QueryResultCount_1");
                Object[] objs = new Object[]{new Integer(this.getRowCount()), new Integer(this.returnRowCount)};
                String nexts = MessageFormat.format(msg, objs);
                this.setMessageBarText(nexts);
            } else {
                String msg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_ShowListDataCount_0");
                Object[] objs = new Object[]{new Integer(this.tblMain.getRowCount())};
                String nexts = MessageFormat.format(msg, objs);
                this.setMessageBarText(nexts);
            }
        }
    }

    private void setOutputTableData() throws BOSException {
        EntityViewInfo view1 = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        if (!this.isRelateOrg) {
            fi.getFilterItems().add(new FilterItemInfo("checkState", (Object)0, CompareType.EQUALS));
            if (this.fromDate != null) {
                fi.getFilterItems().add(new FilterItemInfo("startDate", (Object)this.fromDate, CompareType.GREATER_EQUALS));
            }
            if (this.toDate != null) {
                fi.getFilterItems().add(new FilterItemInfo("endDate", (Object)this.toDate, CompareType.LESS_EQUALS));
            }
            if (this.orgUnit != null) {
                String longNum = this.orgUnit.getLongNumber();
                if (this.isInclude) {
                    FilterInfo oFi = new FilterInfo();
                    oFi.getFilterItems().add(new FilterItemInfo("adminOrgUnit.longNumber", (Object)longNum));
                    oFi.getFilterItems().add(new FilterItemInfo("adminOrgUnit.longNumber", (Object)(longNum + "!%"), CompareType.LIKE));
                    oFi.setMaskString("#0 or #1");
                    fi.mergeFilter(oFi, "and");
                } else {
                    fi.getFilterItems().add(new FilterItemInfo("adminOrgUnit.longNumber", (Object)longNum));
                }
            }
            fi.mergeFilter(TimeUtil.getAdminRangePersonFilter("person.id"), "and");
        } else {
            fi = this.getOutOrgRangePersonFilter(this.orgUnit, this.isInclude, this.fromDate, this.toDate, true);
            fi.getFilterItems().add(new FilterItemInfo("checkState", (Object)0, CompareType.EQUALS));
        }
        view1.setFilter(fi);
        this.attendanceManagerQuery = view1;
        this.tblOutput.getColumn("colStartDate").getStyleAttributes().setNumberFormat("yyyy-mm-dd hh:mm");
        this.tblOutput.getColumn("colEndDate").getStyleAttributes().setNumberFormat("yyyy-mm-dd hh:mm");
        this.tblOutput.getColumn("colTotalValue").getStyleAttributes().setNumberFormat("%r{0.00}10.2f");
        this.tblOutput.removeRows();
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        CacheServiceFactory.getInstance().discardAll();
        this.showFilterDialog();
        this.processNullPer();
    }

    protected OrgUnitInfo getOrgUnitInfo() {
        return SysContext.getSysContext().getCurrentOrgUnit(this.getMainBizOrgType());
    }

    protected UserInfo getUserInfo() {
        return SysContext.getSysContext().getCurrentUserInfo();
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return null;
    }

    protected boolean isAllowDefaultSolutionNull() {
        return false;
    }

    protected EntityViewInfo getInitDefaultSolution() {
        return null;
    }

    void showFilterDialog() throws Exception {
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        String queryName = AttendanceManagerEditUI.getQueryInfo((IMetaDataPK)this.mainQueryPK).getFullName();
        if (this.isFirstDefaultQuery && iQuery.hasDefaultSolution(this.getMetaDataPK().getFullName(), queryName)) {
            EntityViewInfo defaultView = (EntityViewInfo)iQuery.getDefaultFilterInfo(this.getMetaDataPK().getFullName(), queryName);
            QuerySolutionInfo solution = iQuery.getDefaultSolution(this.getMetaDataPK().getFullName(), queryName);
            if (defaultView == null) {
                this.showFilterUI();
            } else {
                if (!StringUtils.isEmpty((String)defaultView.toString())) {
                    this.copyFilter = (FilterInfo)defaultView.getFilter().clone();
                }
                this.tblMain.removeRows();
                QueryPanelCollection queryPanelCollection = solution.getQueryPanelInfo();
                this.returnRowCount = solution.getRowCount();
                CustomerParams cp = null;
                if (queryPanelCollection != null && queryPanelCollection.size() > 0) {
                    int n = queryPanelCollection.size();
                    for (int i = 0; i < n; ++i) {
                        if (!"com.kingdee.eas.hr.time.client.AttendanceManagerPanelUI".equalsIgnoreCase(queryPanelCollection.get(i).getPanelClassName())) continue;
                        cp = CustomerParams.getCustomerParams2((String)queryPanelCollection.get(i).getCustomerParams());
                        this.commonQuery = new FilterInfo(solution.getQueryPanelInfo().get(i).getFilterInfo());
                        break;
                    }
                }
                if (this.copyFilter == null) {
                    this.copyFilter = this.getAdminRangePersonFilter();
                } else {
                    this.copyFilter.mergeFilter(this.getAdminRangePersonFilter(), "and");
                }
                if (cp != null) {
                    this.fromDate = cp.getDate("timeFrom");
                    this.toDate = cp.getDate("timeTo");
                    if (cp.getCustomerParam("OrgUnit") != null) {
                        this.orgUnit = (AdminOrgUnitInfo)AdminOrgUnitFactory.getRemoteInstance().getOrgUnitInfo((IObjectPK)new ObjectUuidPK(cp.getCustomerParam("OrgUnit")));
                    }
                    this.isInclude = cp.getBoolean("chkInclude");
                    this.datePickerStart.setValue((Object)this.fromDate);
                    this.datePickerEnd.setValue((Object)this.toDate);
                    this.isUser = false;
                    this.promptOrgUnit.setValue((Object)this.orgUnit);
                    this.isUser = true;
                    this.chkInclude.setSelected(this.isInclude);
                    if (TimeUtil.getParamValue("AttendanceData_Relate_OrgUnit")) {
                        FilterInfo oFi = this.getOutOrgRangePersonFilter(this.orgUnit, this.isInclude, this.fromDate, this.toDate, false);
                        this.copyFilter.mergeFilter(oFi, "or");
                    }
                    defaultView.setFilter(this.copyFilter);
                } else {
                    Date date = new Date();
                    GregorianCalendar cal = new GregorianCalendar(DateTimeUtils.getYear((Date)date), DateTimeUtils.getMonth((Date)date) - 1, 1);
                    GregorianCalendar calTo = new GregorianCalendar(DateTimeUtils.getYear((Date)date), DateTimeUtils.getMonth((Date)date) - 1, HRTimeClientUtils.getLastDay(new GregorianCalendar()));
                    this.datePickerStart.setValue((Object)cal.getTime());
                    this.datePickerEnd.setValue((Object)calTo.getTime());
                    this.isUser = false;
                    this.orgUnit = null;
                    this.promptOrgUnit.setValue(null);
                    this.isUser = true;
                    this.isInclude = false;
                    this.chkInclude.setSelected(false);
                }
                if (StringUtils.isEmpty((String)defaultView.toString())) {
                    defaultView.setFilter(this.copyFilter);
                }
                this.mainQuery = defaultView;
            }
            this.isFirstDefaultQuery = false;
        } else {
            this.showFilterUI();
        }
    }

    void showFilterUI() throws Exception {
        if (this.commonQueryDialog == null) {
            this.commonQueryDialog = new CommonQueryDialog();
            this.commonQueryDialog.setHeight(320);
            this.commonQueryDialog.setWidth(400);
            if (this.getUIWindow() == null) {
                this.commonQueryDialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            } else {
                this.commonQueryDialog.setOwner((Component)((Object)this));
            }
            this.commonQueryDialog.setParentUIClassName(((Object)((Object)this)).getClass().getName());
            this.commonQueryDialog.setTitle(this.getUITitle() + " - " + EASResource.getString((String)RES, (String)"CONDITION_QUERY"));
            this.commonQueryDialog.setQueryObjectPK(this.mainQueryPK);
            this.commonQueryDialog.setShowFilter(true);
            this.commonQueryDialog.setShowSorter(false);
            this.commonQueryDialog.setShowToolbar(true);
            AttendanceManagerPanelUI customerPanel = new AttendanceManagerPanelUI();
            this.commonQueryDialog.addUserPanel((KDPanel)customerPanel);
        }
        if (this.commonQueryDialog.show()) {
            FilterInfo filterInfo;
            this.commonQuery = filterInfo = this.commonQueryDialog.getCommonFilterPanel().getInnerFilterInfo();
            AttendanceManagerPanelUI customerPanel = (AttendanceManagerPanelUI)this.commonQueryDialog.getUserPanel(0);
            this.doQuery(this.commonQueryDialog);
            FilterInfo custFilter = customerPanel.getFilterInfo();
            if (filterInfo != null && !StringUtils.isEmpty((String)filterInfo.toString())) {
                if (custFilter == null || custFilter.toString().equals("")) {
                    custFilter = filterInfo;
                } else {
                    custFilter.mergeFilter(filterInfo, "AND");
                }
            }
            FilterInfo fi = this.getAdminRangePersonFilter();
            custFilter.mergeFilter(fi, "and");
            this.fromDate = (Date)customerPanel.DatePickFrom.getValue();
            this.toDate = (Date)customerPanel.DatePickerTo.getValue();
            this.orgUnit = (AdminOrgUnitInfo)customerPanel.promptBoxOrg.getValue();
            this.isInclude = customerPanel.chkInclude.isSelected();
            if (TimeUtil.getParamValue("AttendanceData_Relate_OrgUnit")) {
                FilterInfo oFi = this.getOutOrgRangePersonFilter(this.orgUnit, this.isInclude, this.fromDate, this.toDate, false);
                oFi.mergeFilter(filterInfo, "and");
                custFilter.mergeFilter(oFi, "or");
            }
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(custFilter);
            this.copyFilter = (FilterInfo)custFilter.clone();
            this.mainQuery = view;
            this.datePickerStart.setValue((Object)this.fromDate);
            this.datePickerEnd.setValue((Object)this.toDate);
            if (this.toDate != null) {
                Calendar cal = Calendar.getInstance();
                cal.set(DateTimeUtils.getYear((Date)this.toDate), DateTimeUtils.getMonth((Date)this.toDate) - 1, DateTimeUtils.getDay((Date)this.toDate), 23, 59, 59);
                this.toDate = cal.getTime();
            }
            FilterInfo dateFilter = new FilterInfo();
            if (this.fromDate != null && this.toDate == null) {
                dateFilter.getFilterItems().add(new FilterItemInfo("startDate", (Object)this.fromDate, CompareType.GREATER_EQUALS));
            } else if (this.fromDate == null && this.toDate != null) {
                dateFilter.getFilterItems().add(new FilterItemInfo("endDate", (Object)this.toDate, CompareType.LESS));
            } else if (this.fromDate != null && this.toDate != null) {
                dateFilter.getFilterItems().add(new FilterItemInfo("startDate", (Object)this.fromDate, CompareType.GREATER_EQUALS));
                dateFilter.getFilterItems().add(new FilterItemInfo("endDate", (Object)this.toDate, CompareType.LESS));
            }
            dateFilter.getFilterItems().add(new FilterItemInfo("checkState", (Object)0));
            if (dateFilter != null && !StringUtils.isEmpty((String)dateFilter.toString())) {
                this.copyFilter.mergeFilter(dateFilter, "AND");
            }
            this.isUser = false;
            this.promptOrgUnit.setValue((Object)this.orgUnit);
            this.isUser = true;
            this.chkInclude.setSelected(this.isInclude);
            this.mainQuery.setTopCount(this.commonQueryDialog.getMaxReturnRowCount());
            this.doQuery(this.commonQueryDialog);
            this.tblMain.removeRows();
            if (this.tblMain.getRowCount() != 0) {
                this.tblMain.getSelectManager().select(0, 0);
                this.tblMain_activeCellChanged(null);
            }
        } else {
            SysUtil.abort();
        }
    }

    private FilterInfo getOutOrgRangePersonFilter(AdminOrgUnitInfo orgUnit, boolean isInclude, Date fromDate, Date toDate, boolean isOutputQuery) {
        FilterInfo fi = new FilterInfo();
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        String hrOrgUnitID = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        StringBuffer sql = new StringBuffer();
        if (isOutputQuery) {
            sql.append(" select am.FId from t_hr_attendanceManager am ");
        } else {
            sql.append(" select distinct am.FPersonId from t_hr_attendanceManager am ");
        }
        sql.append(" left join t_org_admin org on am.FAdminOrgUnitId = org.FId ");
        sql.append(" where ");
        sql.append(" am.FAdminOrgUnitId in ");
        sql.append(" ( ");
        sql.append(" SELECT FFromUnitID FROM T_ORG_UnitRelation WHERE FToUnitID = ");
        sql.append("'").append(hrOrgUnitID).append("'");
        sql.append(" AND FTypeRelationID = '00000000-0000-0000-0000-0000000000100FE9F8B5'");
        sql.append(" AND FFromUnitID IN ");
        sql.append("(");
        sql.append(" SELECT FOrgID FROM T_PM_OrgRange ");
        sql.append(" WHERE FUserID = ");
        sql.append("'").append(userID).append("'");
        sql.append(" and FType = 20 ");
        sql.append(")");
        sql.append(")");
        if (orgUnit != null) {
            if (isInclude) {
                sql.append(" and ");
                sql.append(" ( ");
                sql.append(" org.FLongNumber = '").append(orgUnit.getLongNumber()).append("'");
                sql.append(" or org.FLongNumber like '").append(orgUnit.getLongNumber()).append("%'");
                sql.append(" ) ");
            } else {
                sql.append(" and org.FLongNumber = '").append(orgUnit.getLongNumber()).append("'");
            }
        }
        if (fromDate != null) {
            sql.append(" and am.FStartDate >= to_date('").append(format.format(fromDate)).append("')");
        }
        if (toDate != null) {
            sql.append(" and am.FEndDate <= to_date('").append(format.format(toDate)).append("')");
        }
        ISQLExecutor exec = SQLExecutorFactory.getRemoteInstance((String)sql.toString());
        IRowSet rs = null;
        ArrayList<String> listIds = new ArrayList<String>();
        try {
            rs = exec.executeSQL();
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        try {
            if (rs != null) {
                while (rs.next()) {
                    if (rs.getString(1) == null) continue;
                    listIds.add(rs.getString(1));
                }
            }
        }
        catch (SQLException e) {
            this.handleException(e);
        }
        if (listIds.size() > 0) {
            fi.getFilterItems().add(new FilterItemInfo("id", new HashSet(listIds), CompareType.INNER));
        } else {
            listIds.add("");
            fi.getFilterItems().add(new FilterItemInfo("id", new HashSet(listIds), CompareType.INNER));
        }
        return fi;
    }

    private FilterInfo getAdminRangePersonFilter() {
        FilterInfo fi = new FilterInfo();
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        String hrOrgUnitID = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FFromUnitID FROM T_ORG_UnitRelation WHERE FToUnitID = ");
        sql.append("'");
        sql.append(hrOrgUnitID);
        sql.append("'");
        sql.append(" AND ");
        sql.append(" FTypeRelationID = ");
        sql.append("'00000000-0000-0000-0000-0000000000100FE9F8B5'");
        sql.append(" AND ");
        sql.append("FFromUnitID IN (");
        sql.append("SELECT FOrgID FROM T_PM_OrgRange WHERE FUserID = ");
        sql.append("'");
        sql.append(userID);
        sql.append("'");
        sql.append(" AND ");
        sql.append("FType = ");
        sql.append(20);
        sql.append(")");
        fi.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.id", (Object)sql.toString(), CompareType.INNER));
        return fi;
    }

    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
        this.btnOutput.setEnabled(true);
        this.btnInput.setEnabled(true);
        this.btnQuery.setEnabled(true);
        this.btnOutput.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.btnInput.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.btnCata.setIcon(EASResource.getIcon((String)"imgTbtn_counter"));
        this.btnCopyData.setIcon(EASResource.getIcon((String)"imgTbtn_copytotier"));
        this.menuItemOutput.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.menuItemInput.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this.menuItemQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.menuItemCopyCol.setIcon(EASResource.getIcon((String)"imgTbtn_copytotier"));
    }

    protected ArrayList getImportParam() {
        String solutionName;
        DatataskParameter param = new DatataskParameter();
        param.solutionName = solutionName = "eas.hr.time.attendancemanager";
        param.alias = EASResource.getString((String)"com.kingdee.eas.hr.time.TimeResource.ATTENDANCE_TITLE");
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filterInfo = new FilterInfo();
        if (this.orgUnit != null) {
            if (this.isInclude) {
                FilterInfo oFi = new FilterInfo();
                oFi.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.longNumber", (Object)this.orgUnit.getLongNumber()));
                oFi.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.longNumber", (Object)(this.orgUnit.getLongNumber() + "!%"), CompareType.LIKE));
                oFi.setMaskString("( #0 or #1 )");
                try {
                    filterInfo.mergeFilter(oFi, "and");
                    filterInfo.mergeFilter(TimeUtil.getAdminRangePersonFilter("id"), "AND");
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
            } else {
                filterInfo.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.id", (Object)this.orgUnit.getId().toString()));
            }
        } else {
            try {
                filterInfo = TimeUtil.getAdminRangePersonFilter("id");
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        if (this.isRelateOrg) {
            FilterInfo fi = this.getOutOrgRangePersonFilter(this.orgUnit, this.isInclude, this.fromDate, this.toDate, false);
            try {
                filterInfo.mergeFilter(fi, "or");
            }
            catch (BOSException e) {
                super.handleException((Exception)((Object)e));
            }
        }
        return filterInfo;
    }

    protected void chkInclude_actionPerformed(ActionEvent e) throws Exception {
        this.isInclude = this.chkInclude.isSelected();
        FilterInfo filter = this.getFilterInfo();
        FilterInfo orgFi = this.getOutOrgRangePersonFilter(this.orgUnit, this.isInclude, this.fromDate, this.toDate, true);
        filter.mergeFilter(orgFi, "or");
        if (this.commonQuery != null) {
            filter.mergeFilter(this.commonQuery, "AND");
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        this.mainQuery = viewInfo;
        this.tblMain.removeRows();
        this.processNullPer();
    }

    protected void promptOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        if (!this.isUser) {
            return;
        }
        this.orgUnit = (AdminOrgUnitInfo)this.promptOrgUnit.getValue();
        FilterInfo filter = this.getFilterInfo();
        if (this.commonQuery != null) {
            filter.mergeFilter(this.commonQuery, "AND");
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        this.mainQuery = viewInfo;
        this.tblMain.removeRows();
        this.processNullPer();
    }

    protected void datePickerEnd_dataChanged(DataChangeEvent e) throws Exception {
        super.datePickerEnd_dataChanged(e);
        this.checkFromToData();
        Date temp = (Date)this.datePickerEnd.getValue();
        if (temp != null) {
            Calendar cal = Calendar.getInstance();
            cal.set(DateTimeUtils.getYear((Date)temp), DateTimeUtils.getMonth((Date)temp) - 1, DateTimeUtils.getDay((Date)temp), 23, 59, 59);
            this.toDate = cal.getTime();
        }
        this.tblMain_activeCellChanged(null);
    }

    protected void datePickerStart_dataChanged(DataChangeEvent e) throws Exception {
        this.checkFromToData();
        this.fromDate = (Date)this.datePickerStart.getValue();
        this.tblMain_activeCellChanged(null);
    }

    void checkFromToData() {
        if (this.datePickerStart.getValue() != null && this.datePickerEnd.getValue() != null && DateTimeUtils.dayBefore((Date)((Date)this.datePickerEnd.getValue()), (Date)((Date)this.datePickerStart.getValue()))) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.time.TimeResource.STARTDATE_MUST_ENDDATE"));
        }
    }

    public void initUIMenuBarLayout() {
        super.initUIMenuBarLayout();
        this.menuItemInput.setEnabled(true);
        this.menuItemOutput.setEnabled(true);
        this.menuItemQuery.setEnabled(true);
        this.menuItemCopyCol.setEnabled(true);
    }

    public boolean checkBeforeWindowClosing() {
        boolean b = super.checkBeforeWindowClosing();
        if (!b) {
            return b;
        }
        if (this.isModify()) {
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Exit"));
            if (result == 0) {
                this.actionSave.setDaemonRun(false);
                ActionEvent event = new ActionEvent(this.btnSave, 1001, this.btnSave.getActionCommand());
                this.actionSave.actionPerformed(event);
                return !this.actionSave.isInvokeFailed();
            }
            return result == 1;
        }
        return true;
    }

    public boolean isModify() {
        AttendanceManagerInfo aInfo;
        try {
            ControlUtilities.checkFocusAndCommit();
        }
        catch (ParseException e) {
            super.handleException((Exception)e);
        }
        if (this.oldAttendInfos == null) {
            return this.tblAttendance.getRowCount3() > 0;
        }
        if (this.oldAttendInfos.size() != this.tblAttendance.getRowCount3()) {
            return true;
        }
        HashMap<String, AttendanceManagerInfo> map = new HashMap<String, AttendanceManagerInfo>();
        int j = this.oldAttendInfos.size();
        for (int i = 0; i < j; ++i) {
            aInfo = this.oldAttendInfos.get(i);
            map.put(aInfo.getId().toString(), aInfo);
        }
        int j2 = this.tblAttendance.getRowCount3();
        for (int i = 0; i < j2; ++i) {
            if (this.tblAttendance.getCell(i, "id") == null || this.tblAttendance.getCell(i, "id").getValue() == null) continue;
            String id = this.tblAttendance.getCell(i, "id").getValue().toString();
            aInfo = (AttendanceManagerInfo)map.get(id);
            IRow row = this.tblAttendance.getRow(i);
            Object newValue = row.getCell("colAttendance").getValue();
            if (!newValue.equals(aInfo.getAttendance())) {
                return true;
            }
            newValue = row.getCell("colStartDate").getValue();
            if (!this.cmpObject(newValue, aInfo.getStartDate())) {
                return true;
            }
            newValue = row.getCell("colEndDate").getValue();
            if (!this.cmpObject(newValue, aInfo.getEndDate())) {
                return true;
            }
            newValue = row.getCell("colTotalValue").getValue();
            if (!this.cmpObject(newValue, new Float(aInfo.getTotalValue()))) {
                return true;
            }
            newValue = row.getCell("colRecordPerson").getValue();
            if (!this.cmpObject(newValue, aInfo.getRecordPerson())) {
                return true;
            }
            newValue = row.getCell("colMemo").getValue();
            if (!this.cmpObject(newValue, aInfo.getDescription())) {
                return true;
            }
            newValue = row.getCell("colCmpPeriod").getValue();
            if (this.cmpObject(newValue, aInfo.getCmpPeriod())) continue;
            return true;
        }
        return false;
    }

    private boolean cmpObject(Object o1, Object o2) {
        if (o1 != null && o2 != null && o1.equals(o2)) {
            return true;
        }
        return o1 == null && o2 == null;
    }

    private AttendanceManagerCollection queryPersonAttendance() throws BOSException {
        int iSelectRow = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        if (iSelectRow == -1) {
            return new AttendanceManagerCollection();
        }
        if (this.tblMain.getRow(iSelectRow) == null) {
            return new AttendanceManagerCollection();
        }
        String id = this.tblMain.getRow(iSelectRow).getCell("id").getValue().toString();
        String number = this.tblMain.getRow(iSelectRow).getCell("colNumber").getValue().toString();
        String name = this.tblMain.getRow(iSelectRow).getCell("colName").getValue().toString();
        if (id == null) {
            return new AttendanceManagerCollection();
        }
        this.personInfo = new PersonInfo();
        this.personInfo.setId(BOSUuid.read((String)id));
        this.personInfo.setNumber(number);
        this.personInfo.setName(name);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("person.id", (Object)id));
        if (this.fromDate != null) {
            fi.getFilterItems().add(new FilterItemInfo("startDate", (Object)this.fromDate, CompareType.GREATER_EQUALS));
        }
        if (this.toDate != null) {
            fi.getFilterItems().add(new FilterItemInfo("endDate", (Object)this.toDate, CompareType.LESS));
        }
        fi.getFilterItems().add(new FilterItemInfo("checkState", (Object)CheckStateEnum.UNCHECK));
        if (this.isRelateOrg) {
            FilterInfo orgRangeF = TimeUtil.getAdminRangeFilterInfo("adminOrgUnit.id", this.getHROrgUnit().getId().toString());
            FilterInfo orgNullF = new FilterInfo();
            orgNullF.getFilterItems().add(new FilterItemInfo("adminOrgUnit.id", null));
            orgRangeF.mergeFilter(orgNullF, "or");
            fi.mergeFilter(orgRangeF, "and");
        }
        evi.setFilter(fi);
        SelectorItemCollection sic = evi.getSelector();
        sic.add(new SelectorItemInfo("totalValue"));
        sic.add(new SelectorItemInfo("startDate"));
        sic.add(new SelectorItemInfo("endDate"));
        sic.add(new SelectorItemInfo("checkState"));
        sic.add(new SelectorItemInfo("refrence"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("recordPerson.id"));
        sic.add(new SelectorItemInfo("recordPerson.name"));
        sic.add(new SelectorItemInfo("attendance.id"));
        sic.add(new SelectorItemInfo("attendance.name"));
        sic.add(new SelectorItemInfo("attendance.unitType"));
        sic.add(new SelectorItemInfo("attendance.innerType"));
        sic.add(new SelectorItemInfo("attendance.dataType"));
        sic.add(new SelectorItemInfo("attendance.decDigital"));
        sic.add(new SelectorItemInfo("attendance.length"));
        sic.add(new SelectorItemInfo("attendance.enable"));
        sic.add(new SelectorItemInfo("cmpPeriod.id"));
        sic.add(new SelectorItemInfo("cmpPeriod.name"));
        sic.add(new SelectorItemInfo("position.id"));
        sic.add(new SelectorItemInfo("position.name"));
        sic.add(new SelectorItemInfo("adminOrgUnit.id"));
        sic.add(new SelectorItemInfo("adminOrgUnit.name"));
        sic.add(new SelectorItemInfo("cmpScheme.id"));
        sic.add(new SelectorItemInfo("cmpScheme.name"));
        String sorterItem = "endDate";
        SorterItemInfo sortInfo = new SorterItemInfo(sorterItem);
        sortInfo.setSortType(SortType.ASCEND);
        SorterItemCollection sortCollectiom = evi.getSorter();
        sortCollectiom.add(sortInfo);
        return AttendanceManagerFactory.getRemoteInstance().getAttendanceManagerCollection(evi);
    }

    private HROrgUnitInfo getHROrgUnit() {
        if (this.hrOrgUnitInfo == null) {
            this.hrOrgUnitInfo = SysContext.getSysContext().getCurrentHRUnit();
        }
        return this.hrOrgUnitInfo;
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 0) {
            super.tblMain_tableClicked(e);
        }
    }

    protected String getEditUIName() {
        return null;
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.actionSubmit_actionPerformed(e);
        this.flag1 = false;
    }

    public void actionLocate_actionPerformed(ActionEvent e) throws Exception {
        if (this.locateAssisant == null) {
            this.locateAssisant = new LocateAssistant((CoreUIObject)this, this.tblMain, this.getLocateNames());
        }
        this.locateAssisant.actionLocate();
    }

    protected String[] getLocateNames() {
        return new String[]{"colNumber", "colName"};
    }

    public void actionSelectCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelectCopy_actionPerformed(e);
        this.selectedCopys(this.tblAttendance);
    }

    private void selectedCopys(KDTable table) {
        if (table.getRowCount() == 0) {
            return;
        }
        int size = table.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            KDTSelectBlock sb = table.getSelectManager().get(0);
            int row = sb.getTop();
            int column = sb.getLeft();
            IColumn iColumn = table.getColumn(column);
            if (iColumn.getStyleAttributes().isLocked() || table.getCell(row, column).getStyleAttributes().isLocked()) {
                return;
            }
            Object value = table.getCell(row, column).getValue();
            Object valueTime = table.getCell(row, "colAttendance").getValue();
            Object valueUnit = table.getCell(row, "colTotalUnit").getValue();
            Object cmpPeriodInfo = table.getCell(row, "colCmpPeriod").getValue();
            sb = table.getSelectManager().get(i);
            if (sb.getLeft() > column || sb.getRight() < column) continue;
            for (int j = sb.getBeginRow(); j <= sb.getEndRow(); ++j) {
                if (table.getCell(j, column).getStyleAttributes().isLocked()) continue;
                table.getCell(j, column).setValue(value);
                if (iColumn.getKey().equals("colAttendance")) {
                    table.getCell(j, "colAttendance").setValue(valueTime);
                    table.getCell(j, "colTotalUnit").setValue(valueUnit);
                }
                if (!iColumn.getKey().equals("colCmpPeriod")) continue;
                table.getCell(j, "colCmpPeriod").setValue(cmpPeriodInfo);
            }
        }
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionPopupCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionPopupCopy_actionPerformed(e);
    }

    public void actionPopupPaste_actionPerformed(ActionEvent e) throws Exception {
        if (TimeAttendanceInfo.class.equals(e.getSource())) {
            super.actionPopupPaste_actionPerformed(e);
        }
    }

    public static void processTableKeyBoardEvent(KDTable table, String strActionKey) {
        KDTable tbl = table;
        tbl.getInputMap().put(KeyStroke.getKeyStroke(67, 128), "copy" + strActionKey);
        tbl.getActionMap().put("copy" + strActionKey, new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
            }
        });
        tbl.getInputMap().put(KeyStroke.getKeyStroke(86, 128), "paste" + strActionKey);
        tbl.getActionMap().put("paste" + strActionKey, new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
            }
        });
    }

    protected String[] getCountQueryFields() {
        return new String[]{"id"};
    }
}

