/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.time.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.time.CheckStateEnum;
import com.kingdee.eas.hr.time.client.AbstractAttendanceManagerFilterPanelUI;
import com.kingdee.eas.hr.time.client.TimeAttendanceUtils;
import com.kingdee.eas.hr.time.client.TimeUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class AttendanceManagerFilterPanelUI
extends AbstractAttendanceManagerFilterPanelUI {
    private static final long serialVersionUID = -61166L;
    private static final String RES = "com.kingdee.eas.hr.time.TimeResource";

    public FilterInfo getFilterInfo() {
        boolean isRelateOrg = false;
        try {
            isRelateOrg = TimeUtil.getParamValue("AttendanceData_Relate_OrgUnit");
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
        Date sDate = (Date)this.kDDatePickerFrom.getValue();
        Date eDate = (Date)this.kDDatePickerTo.getValue();
        String longNum = null;
        boolean isInclude = this.chkInclude.isSelected();
        Object state = this.comboState.getSelectedItem();
        CmpPeriodInfo cmInfo = (CmpPeriodInfo)this.prmptCmpPeriod.getValue();
        OrgUnitInfo orgInfo = (OrgUnitInfo)this.promptOrgUnit.getData();
        if (!isRelateOrg) {
            Calendar calendar;
            FilterInfo orgFilter = TimeUtil.getAdminRangePersonFilter("person.id");
            if (orgInfo != null) {
                if (isInclude) {
                    FilterInfo numFi = new FilterInfo();
                    numFi.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.longNumber", (Object)orgInfo.getLongNumber()));
                    numFi.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.longNumber", (Object)(orgInfo.getLongNumber() + "!%"), CompareType.LIKE));
                    numFi.setMaskString("#0 or #1");
                    try {
                        orgFilter.mergeFilter(numFi, "and");
                    }
                    catch (Exception e) {
                        this.handUIException(e);
                    }
                } else {
                    orgFilter.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.id", (Object)orgInfo.getId().toString()));
                }
            }
            FilterInfo dateFilter = new FilterInfo();
            SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
            String fromStr = null;
            String toStr = null;
            if (this.kDDatePickerFrom.getValue() != null && (Date)this.kDDatePickerTo.getValue() != null) {
                fromStr = sf.format((Date)this.kDDatePickerFrom.getValue());
                Date endDate = (Date)this.kDDatePickerTo.getValue();
                calendar = Calendar.getInstance();
                calendar.setTime(endDate);
                calendar.add(5, 1);
                toStr = sf.format(calendar.getTime());
                dateFilter.getFilterItems().add(new FilterItemInfo("startDate", (Object)toStr, CompareType.LESS_EQUALS));
                dateFilter.getFilterItems().add(new FilterItemInfo("endDate", (Object)fromStr, CompareType.GREATER_EQUALS));
            } else if (this.kDDatePickerFrom.getValue() != null && (Date)this.kDDatePickerTo.getValue() == null) {
                fromStr = sf.format((Date)this.kDDatePickerFrom.getValue());
                dateFilter.getFilterItems().add(new FilterItemInfo("startDate", (Object)fromStr, CompareType.GREATER_EQUALS));
            } else if (this.kDDatePickerFrom.getValue() == null && (Date)this.kDDatePickerTo.getValue() != null) {
                Date toDate = (Date)this.kDDatePickerTo.getValue();
                calendar = Calendar.getInstance();
                calendar.setTime(toDate);
                calendar.add(5, 1);
                toStr = sf.format(calendar.getTime());
                dateFilter.getFilterItems().add(new FilterItemInfo("endDate", (Object)toStr, CompareType.LESS));
            }
            if (!StringUtils.isEmpty((String)dateFilter.toString())) {
                try {
                    orgFilter.mergeFilter(dateFilter, "AND");
                }
                catch (BOSException e) {
                    this.handUIException(e);
                }
            }
            FilterInfo filterOther = new FilterInfo();
            if (this.prmptCmpPeriod.getValue() != null) {
                CmpPeriodInfo info = (CmpPeriodInfo)this.prmptCmpPeriod.getValue();
                StringBuffer sqlPeriod = new StringBuffer();
                sqlPeriod.append("select fid from T_HR_CMPPERIOD where fnumber = '").append(info.getNumber().toString().trim()).append("'");
                filterOther.getFilterItems().add(new FilterItemInfo("cmpPeriod.id", (Object)sqlPeriod.toString(), CompareType.INNER));
            }
            if (state instanceof CheckStateEnum) {
                filterOther.getFilterItems().add(new FilterItemInfo("checkState", (Object)((CheckStateEnum)((Object)state)).getValue()));
            }
            if (filterOther.getFilterItems().size() > 0) {
                try {
                    orgFilter.mergeFilter(filterOther, "AND");
                }
                catch (Exception ex) {
                    super.handUIException((Throwable)ex);
                }
            }
            return orgFilter;
        }
        if (orgInfo != null) {
            longNum = orgInfo.getLongNumber();
        }
        Calendar c = Calendar.getInstance();
        if (sDate == null) {
            c.set(5, 1);
            c.set(11, 0);
            c.set(12, 0);
            c.set(14, 0);
            c.set(11, 0);
            c.set(12, 0);
            c.set(13, 0);
        } else {
            c.setTime(sDate);
            c.set(11, 0);
            c.set(12, 0);
            c.set(13, 0);
        }
        sDate = c.getTime();
        if (eDate == null) {
            eDate = new Date();
        }
        c.setTime(eDate);
        c.set(11, 23);
        c.set(12, 59);
        c.set(13, 59);
        eDate = c.getTime();
        FilterInfo filter = state instanceof CheckStateEnum ? this.getOutOrgRangePersonFilter(longNum, isInclude, sDate, eDate, cmInfo, (CheckStateEnum)((Object)state)) : this.getOutOrgRangePersonFilter(longNum, isInclude, sDate, eDate, cmInfo, null);
        return filter;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        TimeAttendanceUtils.initF7Selector((IUIObject)this, this.promptOrgUnit);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("enableState", (Object)Boolean.FALSE));
        filter.setMaskString("#0 and #1");
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        this.prmptCmpPeriod.setEntityViewInfo(evi);
        this.comboState.addItem((Object)EASResource.getString((String)RES, (String)"ALL"));
        this.comboState.addItems(CheckStateEnum.getEnumList().toArray());
        this.comboState.setSelectedIndex(0);
    }

    public void initLayout() {
        super.initLayout();
        Date date = new Date();
        GregorianCalendar cal = new GregorianCalendar(DateTimeUtils.getYear((Date)date), DateTimeUtils.getMonth((Date)date) - 2, 1);
        this.kDDatePickerFrom.setValue((Object)cal.getTime());
        this.promptOrgUnit.setEditable(true);
    }

    public CustomerParams getCustomerParams() {
        return TimeUtil.saveAllData(this);
    }

    public void setCustomerParams(CustomerParams cp) {
        TimeUtil.retriveAllData(cp, this);
    }

    public void clear() {
        super.clear();
        this.promptOrgUnit.setData(null);
        Date date = new Date();
        GregorianCalendar cal = new GregorianCalendar(DateTimeUtils.getYear((Date)date), DateTimeUtils.getMonth((Date)date) - 2, 1);
        this.kDDatePickerFrom.setValue((Object)cal.getTime());
        this.kDDatePickerTo.setValue((Object)new Date());
        this.chkInclude.setSelected(false);
        this.comboState.setSelectedIndex(0);
        this.prmptCmpPeriod.setValue(null);
    }

    public boolean verify() {
        if (this.kDDatePickerFrom.getValue() != null && this.kDDatePickerTo.getValue() != null && DateTimeUtils.dayBefore((Date)((Date)this.kDDatePickerTo.getValue()), (Date)((Date)this.kDDatePickerFrom.getValue()))) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.time.TimeResource.STARTDATE_MUST_ENDDATE"));
            return false;
        }
        return true;
    }

    public CheckStateEnum getState() {
        if (this.comboState.getSelectedItem() instanceof CheckStateEnum) {
            return (CheckStateEnum)((Object)this.comboState.getSelectedItem());
        }
        return null;
    }

    private FilterInfo getOutOrgRangePersonFilter(String orgLongNum, boolean isInclude, Date fromDate, Date toDate, CmpPeriodInfo cmpInfo, CheckStateEnum state) {
        FilterInfo fi = new FilterInfo();
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        String hrOrgUnitID = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        StringBuffer sql = new StringBuffer();
        sql.append(" select am.FId from T_HR_AttendanceManager am ");
        sql.append(" left join t_org_admin org on am.FAdminOrgUnitId = org.FId ");
        sql.append(" where ");
        sql.append(" am.FAdminOrgUnitId in ");
        sql.append(" ( ");
        sql.append(" SELECT FFromUnitID FROM T_ORG_UnitRelation WHERE FToUnitID = ");
        sql.append("'").append(hrOrgUnitID).append("'");
        sql.append(" AND FTypeRelationID = '00000000-0000-0000-0000-0000000000100FE9F8B5'");
        sql.append(" AND FFromUnitID IN ");
        sql.append("(");
        sql.append(" SELECT FOrgID FROM T_PM_OrgRange ");
        sql.append(" WHERE FUserID = ");
        sql.append("'").append(userID).append("'");
        sql.append(" and FType = 20 ");
        sql.append(")");
        sql.append(")");
        if (orgLongNum != null) {
            if (isInclude) {
                sql.append(" and ");
                sql.append(" ( ");
                sql.append(" org.FLongNumber = '").append(orgLongNum).append("'");
                sql.append(" or org.FLongNumber like '").append(orgLongNum).append("%'");
                sql.append(" ) ");
            } else {
                sql.append(" and org.FLongNumber = '").append(orgLongNum).append("'");
            }
        }
        if (fromDate != null && toDate != null) {
            sql.append(" and am.FStartDate <= to_date('").append(format.format(toDate)).append("')");
            sql.append(" and am.FEndDate >= to_date('").append(format.format(fromDate)).append("')");
        } else if (fromDate != null && toDate == null) {
            sql.append(" and am.FStartDate >= to_date('").append(format.format(fromDate)).append("')");
        } else if (toDate != null && fromDate == null) {
            sql.append(" and am.FEndDate <= to_date('").append(format.format(toDate)).append("')");
        }
        if (cmpInfo != null) {
            sql.append(" and am.FCmpPeriodID in (");
            sql.append("select fid from T_HR_CMPPERIOD where fnumber = '").append(cmpInfo.getNumber().toString().trim()).append("'");
            sql.append(")");
        }
        if (state != null) {
            fi.getFilterItems().add(new FilterItemInfo("checkState", (Object)new Integer(state.getValue())));
        }
        fi.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.INNER));
        return fi;
    }
}

