/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.time.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.client.PositionPromptBox2;
import com.kingdee.eas.basedata.org.client.f7.NewAdminByHROF7;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.base.OutputExcelUtil;
import com.kingdee.eas.hr.base.client.util.HRClientUtil;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeInfo;
import com.kingdee.eas.hr.compensation.ItemDataTypeEnum;
import com.kingdee.eas.hr.emp.client.EmployeeClientUtils;
import com.kingdee.eas.hr.time.AttendanceManagerCollection;
import com.kingdee.eas.hr.time.AttendanceManagerFactory;
import com.kingdee.eas.hr.time.AttendanceManagerInfo;
import com.kingdee.eas.hr.time.CheckStateEnum;
import com.kingdee.eas.hr.time.IAttendanceManager;
import com.kingdee.eas.hr.time.RefStateEnum;
import com.kingdee.eas.hr.time.TimeAttendanceException;
import com.kingdee.eas.hr.time.client.AbstractAttendanceManagerListUI;
import com.kingdee.eas.hr.time.client.AttendanceManagerFilterPanelUI;
import com.kingdee.eas.hr.time.client.HRTimeClientUtils;
import com.kingdee.eas.hr.time.client.IProgTask;
import com.kingdee.eas.hr.time.client.ProgDialog;
import com.kingdee.eas.hr.time.client.TimeAttendanceUtils;
import com.kingdee.eas.hr.time.client.TimeUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class AttendanceManagerListUI
extends AbstractAttendanceManagerListUI {
    private static final long serialVersionUID = 61166L;
    private static final String RES = "com.kingdee.eas.hr.time.TimeResource";
    private Color yColor = new Color(252, 255, 206);
    private Color mColor = Color.LIGHT_GRAY;
    private CommonQueryDialog commonQueryDialog = null;
    private CheckStateEnum checkState = null;
    private int rowPosID = 0;
    private static final String MACHINE = "machine";
    private static final String USER = "user";
    private String cmpSchemeF7URL = "com.kingdee.eas.hr.compensation.app.F7CmpSchemeQuery";
    private boolean isRelateOrg;
    private HROrgUnitInfo hrOrgUnitInfo = null;
    private boolean isAll = true;
    private Set changeList = new HashSet();
    private Object object = null;

    public void onLoad() throws Exception {
        HRClientUtil.checkCurrentHRUnitNotNull((CoreUI)this);
        this.initCombState();
        this.isRelateOrg = TimeUtil.getParamValue("AttendanceData_Relate_OrgUnit");
        super.onLoad();
        this.actionEdit.setEnabled(false);
        this.actionCopyToColumn.setEnabled(true);
        this.setCombStateByQuery();
        this.initSelector();
        this.setButtonDefaultStyl(this.btnSave);
        this.tblMain.setColumnMoveable(true);
        KDTSortManager sm = new KDTSortManager(this.tblMain);
        for (int i = this.tblMain.getColumnCount() - 1; i >= 0; --i) {
            this.tblMain.getColumn(i).setSortable(true);
        }
        sm.setSortAuto(true);
    }

    private void initCombState() {
        this.combState.setActionCommand(MACHINE);
        this.combState.addItem((Object)EASResource.getString((String)RES, (String)"ALL"));
        this.combState.addItems(CheckStateEnum.getEnumList().toArray());
        this.combState.setActionCommand(USER);
    }

    private void initSelector() throws BOSException {
        this.tblMain.getStyleAttributes().setLocked(false);
        this.tblMain.getColumn("refrence").getStyleAttributes().setBackground(this.mColor);
        this.tblMain.getColumn("orgName").getStyleAttributes().setBackground(this.mColor);
        this.tblMain.getColumn("personNumber").getStyleAttributes().setBackground(this.mColor);
        this.tblMain.getColumn("person.name").getStyleAttributes().setBackground(this.mColor);
        this.tblMain.getColumn("attendance.name").getStyleAttributes().setBackground(this.mColor);
        this.tblMain.getColumn("attendance.unitType").getStyleAttributes().setBackground(this.mColor);
        this.tblMain.getColumn("recordPerson").getStyleAttributes().setBackground(this.mColor);
        this.tblMain.getColumn("checkState").getStyleAttributes().setBackground(this.mColor);
        this.tblMain.getColumn("refrence").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("orgName").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("personNumber").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("person.name").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("attendance.name").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("attendance.unitType").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("recordPerson").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("checkState").getStyleAttributes().setLocked(true);
        this.tblMain.getSelectManager().setSelectMode(15);
        this.tblMain.getColumn("startDate").setEditor(EmployeeClientUtils.getDateTimeCellEditor());
        this.tblMain.getColumn("startDate").getStyleAttributes().setNumberFormat(HRTimeClientUtils.getLongTimePatternStr());
        this.tblMain.getColumn("endDate").setEditor(EmployeeClientUtils.getDateTimeCellEditor());
        this.tblMain.getColumn("endDate").getStyleAttributes().setNumberFormat(HRTimeClientUtils.getLongTimePatternStr());
        this.tblMain.getColumn("totalValue").setEditor(AttendanceManagerListUI.getIntCellEditor());
        this.tblMain.getColumn("cmpPeriod").setEditor(this.getCmpPersonF7CellEditor());
        this.tblMain.getColumn("totalValue").getStyleAttributes().setBackground(this.yColor);
        this.tblMain.getColumn("position1.name").setEditor(this.getPositionF7Editor());
        this.tblMain.getColumn("adminOrgUnit1.name").setEditor(this.getAdminOrgUnitF7());
        this.tblMain.getColumn("attendancecmp").setEditor(this.getCmpSchemeF7());
        this.tblMain.getColumn("totalValue").getStyleAttributes().setNumberFormat("%r{0.00}10.2f");
        this.tblMain.getColumn("totalValue").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        EmployeeClientUtils.setCellEditor((KDTable)this.tblMain, (String)"description");
        this.tblMain.getColumn("adminOrgUnit1.name").setRequired(true);
        this.tblMain.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStarting(KDTEditEvent e) {
                AttendanceManagerListUI.this.rowPosID = e.getRowIndex();
            }

            public void editStopped(KDTEditEvent e) {
                int colIndex = e.getColIndex();
                int rowIndex = e.getRowIndex();
                if (e.getColIndex() == AttendanceManagerListUI.this.tblMain.getColumnIndex("position1.name") && AttendanceManagerListUI.this.tblMain.getCell(rowIndex, "adminOrgUnit1.name") != null) {
                    try {
                        AttendanceManagerListUI.this.tblAttendance_Changed(rowIndex, colIndex);
                    }
                    catch (Exception e1) {
                        AttendanceManagerListUI.this.handleException(e1);
                    }
                }
            }
        });
    }

    private void tblAttendance_Changed(int rowIndex, int colIndex) throws BOSException {
        Object value = this.tblMain.getCell(rowIndex, "position1.name").getValue();
        Object adminOrgUnit = null;
        if (value instanceof PositionInfo) {
            adminOrgUnit = UIRuleUtil.getProperty((IObjectValue)((PositionInfo)value), (String)"adminOrgUnit");
        }
        if (adminOrgUnit != null) {
            this.tblMain.getCell(rowIndex, "adminOrgUnit1.name").setValue(adminOrgUnit);
            this.tblMain.getCell(rowIndex, "adminOrgUnitId").setValue((Object)((AdminOrgUnitInfo)adminOrgUnit).getId().toString());
        }
    }

    public ICellEditor getCmpPersonF7CellEditor() {
        KDBizPromptBox f7 = new KDBizPromptBox();
        f7.setQueryInfo("com.kingdee.eas.hr.compensation.app.F7CmpPeriodQuery");
        f7.setDisplayFormat("$name$");
        f7.setEditFormat("$number$");
        f7.setCommitFormat("$number$");
        f7.setEditable(true);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("enableState", (Object)0));
        filter.setMaskString("#0 and #1");
        view.setFilter(filter);
        f7.setEntityViewInfo(view);
        f7.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                try {
                    AttendanceManagerListUI.this.setCmpPeriod(e);
                }
                catch (Exception e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
            }
        });
        return new KDTDefaultCellEditor((IKDEditor)f7);
    }

    public ICellEditor getPositionF7Editor() {
        KDBizPromptBox prmtPosition = new KDBizPromptBox();
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        hashMap.put("HRO_FILTER", Boolean.TRUE);
        PositionPromptBox2 pmtNew = new PositionPromptBox2((IUIObject)this, hashMap);
        prmtPosition.setSelector((KDPromptSelector)pmtNew);
        prmtPosition.setDisplayFormat("$name$");
        prmtPosition.setEditable(false);
        prmtPosition.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                try {
                    PositionInfo info = (PositionInfo)e.getData();
                    if (info != null) {
                        AttendanceManagerListUI.this.tblMain.getRow(AttendanceManagerListUI.this.rowPosID).getCell("positionId").setValue((Object)info.getId().toString());
                        AttendanceManagerListUI.this.tblMain.getRow(AttendanceManagerListUI.this.rowPosID).getCell("position1.name").setValue((Object)info.getName());
                    }
                }
                catch (Exception e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
            }
        });
        return new KDTDefaultCellEditor((IKDEditor)prmtPosition);
    }

    public ICellEditor getAdminOrgUnitF7() {
        NewAdminByHROF7 f7 = new NewAdminByHROF7();
        f7.setMultiSelect(false);
        KDBizPromptBox prmtAdminOrgUnit = new KDBizPromptBox();
        prmtAdminOrgUnit.setSelector((KDPromptSelector)f7);
        prmtAdminOrgUnit.setEnabledMultiSelection(false);
        prmtAdminOrgUnit.setDisplayFormat("$name$");
        prmtAdminOrgUnit.setEditable(false);
        prmtAdminOrgUnit.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                try {
                    AdminOrgUnitInfo info = (AdminOrgUnitInfo)e.getData();
                    if (info != null) {
                        AttendanceManagerListUI.this.tblMain.getRow(AttendanceManagerListUI.this.rowPosID).getCell("adminOrgUnitId").setValue((Object)info.getId().toString());
                        AttendanceManagerListUI.this.tblMain.getRow(AttendanceManagerListUI.this.rowPosID).getCell("adminOrgUnit1.name").setValue((Object)info.getName());
                    }
                }
                catch (Exception e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
            }
        });
        return new KDTDefaultCellEditor((IKDEditor)prmtAdminOrgUnit);
    }

    public ICellEditor getCmpSchemeF7() {
        KDBizPromptBox prmtCmpScheme = new KDBizPromptBox();
        prmtCmpScheme.setQueryInfo(this.cmpSchemeF7URL);
        prmtCmpScheme.setEditable(false);
        prmtCmpScheme.setEditFormat("$name$");
        prmtCmpScheme.setDisplayFormat("$name$");
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfoCmpSch = new FilterInfo();
        filterInfoCmpSch.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)this.getHROrgUnit().getId().toString()));
        filterInfoCmpSch.getFilterItems().add(new FilterItemInfo("enable", (Object)1));
        filterInfoCmpSch.getFilterItems().add(new FilterItemInfo("enable", (Object)3));
        filterInfoCmpSch.getFilterItems().add(new FilterItemInfo("isDelete", (Object)"0"));
        filterInfoCmpSch.setMaskString("#0 and (#1 or #2) and #3");
        evi.setFilter(filterInfoCmpSch);
        prmtCmpScheme.setEntityViewInfo(evi);
        prmtCmpScheme.setEnabled(true);
        prmtCmpScheme.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                try {
                    CmpSchemeInfo info = (CmpSchemeInfo)e.getData();
                    if (info != null) {
                        AttendanceManagerListUI.this.tblMain.getRow(AttendanceManagerListUI.this.rowPosID).getCell("cmpSchemeId").setValue((Object)info.getId().toString());
                        AttendanceManagerListUI.this.tblMain.getRow(AttendanceManagerListUI.this.rowPosID).getCell("attendancecmp").setValue((Object)info.getName());
                    }
                }
                catch (Exception e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
            }
        });
        return new KDTDefaultCellEditor((IKDEditor)prmtCmpScheme);
    }

    void setCmpPeriod(PreChangeEvent e) {
        CmpPeriodInfo info = (CmpPeriodInfo)e.getData();
        if (info != null) {
            this.tblMain.getRow(this.rowPosID).getCell("cmpPeriodId").setValue((Object)info.getId().toString());
            this.tblMain.getRow(this.rowPosID).getCell("cmpPeriod").setValue((Object)info.getName());
        }
    }

    public static ICellEditor getIntCellEditor() {
        KDFormattedTextField kft = new KDFormattedTextField();
        kft.setDataType(4);
        kft.setHorizontalAlignment(4);
        return new KDTDefaultCellEditor((JTextField)kft);
    }

    public ICellEditor getEndDateCellEditor() {
        KDDatePicker dpDate = new KDDatePicker();
        dpDate.setValue((Object)new Date());
        dpDate.setTimeEnabled(true);
        return new KDTDefaultCellEditor(dpDate);
    }

    public ICellEditor getStartDateCellEditor() {
        KDDatePicker dpDate = new KDDatePicker();
        dpDate.setValue((Object)new Date());
        dpDate.setTimeEnabled(true);
        return new KDTDefaultCellEditor(dpDate);
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.commonQueryDialog == null) {
            this.commonQueryDialog = super.initCommonQueryDialog();
            AttendanceManagerFilterPanelUI filterUI = null;
            try {
                filterUI = new AttendanceManagerFilterPanelUI();
            }
            catch (Exception e) {
                this.handUIException(e);
            }
            this.commonQueryDialog.addUserPanel((KDPanel)filterUI);
        }
        return this.commonQueryDialog;
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.confirmSave(e);
        super.actionQuery_actionPerformed(e);
        this.setCombStateByQuery();
    }

    private void setCombStateByQuery() {
        if (this.commonQueryDialog != null) {
            this.checkState = ((AttendanceManagerFilterPanelUI)this.commonQueryDialog.getUserPanel(0)).getState();
        } else if (this.mainQuery != null && this.mainQuery.getFilter() != null) {
            FilterItemCollection collection = this.mainQuery.getFilter().getFilterItems();
            int size = collection.size();
            for (int i = 0; i < size; ++i) {
                if (!collection.get(i).getPropertyName().endsWith("checkState")) continue;
                if (Integer.parseInt(collection.get(i).getCompareValue().toString()) == 0) {
                    this.checkState = CheckStateEnum.UNCHECK;
                    break;
                }
                this.checkState = CheckStateEnum.CHECK;
                break;
            }
        }
        if (this.combState.getItemCount() > 0) {
            this.combState.setActionCommand(MACHINE);
            if (this.checkState != null) {
                this.combState.setSelectedItem((Object)this.checkState);
            } else {
                this.combState.setSelectedIndex(0);
            }
            this.combState.setActionCommand(USER);
        }
    }

    private AttendanceManagerCollection getAttendanceManagerCollection() throws Exception {
        AttendanceManagerCollection attendInfos = new AttendanceManagerCollection();
        AttendanceManagerInfo info = null;
        CmpPeriodInfo cmpInfo = null;
        int counts = this.tblMain.getRowCount();
        for (int i = 0; i < counts; ++i) {
            Object obj1;
            Date temp;
            info = new AttendanceManagerInfo();
            if (this.tblMain.getRow(i).getCell("id").getValue() != null) {
                info.setId(BOSUuid.read((String)((String)this.tblMain.getRow(i).getCell("id").getValue())));
            }
            if ((temp = (Date)this.tblMain.getRow(i).getCell("startDate").getValue()) == null) {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"STARTDATE_NULL"));
                SysUtil.abort();
            }
            Calendar ca = Calendar.getInstance();
            ca.setTime(temp);
            ca.set(13, 0);
            ca.set(14, 0);
            info.setStartDate(temp);
            temp = (Date)this.tblMain.getRow(i).getCell("endDate").getValue();
            if (temp == null) {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"ENDDATE_NULL"));
                SysUtil.abort();
            }
            Calendar endca = Calendar.getInstance();
            endca.setTime(temp);
            endca.set(13, 0);
            endca.set(14, 0);
            info.setEndDate(temp);
            if (((Date)this.tblMain.getRow(i).getCell("startDate").getValue()).getTime() > temp.getTime()) {
                throw new TimeAttendanceException(TimeAttendanceException.TIME_ENDDATE_BEGINDATE);
            }
            if (this.tblMain.getRow(i).getCell("totalValue") != null) {
                info.setTotalValue(Float.parseFloat(this.tblMain.getRow(i).getCell("totalValue").getValue().toString()));
            }
            info.setDescription((String)this.tblMain.getRow(i).getCell("description").getValue());
            if (this.tblMain.getRow(i).getCell("cmpPeriod").getValue() != null && this.tblMain.getRow(i).getCell("cmpPeriodId").getValue() != null) {
                cmpInfo = new CmpPeriodInfo();
                cmpInfo.setId(BOSUuid.read((String)this.tblMain.getRow(i).getCell("cmpPeriodId").getValue().toString()));
                info.setCmpPeriod(cmpInfo);
            }
            if ((obj1 = this.tblMain.getRow(i).getCell("position1.name").getValue()) != null && obj1 instanceof PositionInfo) {
                info.setPosition((PositionInfo)obj1);
            } else if (obj1 instanceof String) {
                PositionInfo period = new PositionInfo();
                period.setId(BOSUuid.read((String)this.tblMain.getRow(i).getCell("positionId").getValue().toString()));
                info.setPosition(period);
            } else {
                info.setPosition(null);
            }
            Object obj2 = this.tblMain.getRow(i).getCell("adminOrgUnit1.name").getValue();
            if (obj2 != null && obj2 instanceof AdminOrgUnitInfo) {
                info.setAdminOrgUnit((AdminOrgUnitInfo)obj2);
            } else if (obj2 instanceof String) {
                AdminOrgUnitInfo period = new AdminOrgUnitInfo();
                period.setId(BOSUuid.read((String)this.tblMain.getRow(i).getCell("adminOrgUnitId").getValue().toString()));
                info.setAdminOrgUnit(period);
            } else {
                info.setAdminOrgUnit(null);
            }
            Object obj3 = this.tblMain.getRow(i).getCell("attendancecmp").getValue();
            if (obj3 != null && obj3 instanceof CmpSchemeInfo) {
                info.setCmpScheme((CmpSchemeInfo)obj3);
            } else if (obj3 instanceof String) {
                CmpSchemeInfo period = new CmpSchemeInfo();
                period.setId(BOSUuid.read((String)this.tblMain.getRow(i).getCell("cmpSchemeId").getValue().toString()));
                info.setCmpScheme(period);
            } else {
                info.setCmpScheme(null);
            }
            attendInfos.add(info);
        }
        return attendInfos;
    }

    public void actionCheck_actionPerformed(ActionEvent e) throws Exception {
        this.tblMain.requestFocus();
        if (this.changeList.size() > 0) {
            if (this.showConfirm("comfirmSave")) {
                this.checkInputs();
                AttendanceManagerCollection infos = this.getAttendanceManagerCollection();
                IAttendanceManager iAttend = AttendanceManagerFactory.getRemoteInstance();
                iAttend.saveALL(infos);
                this.changeList.clear();
            } else {
                this.changeList.clear();
            }
        }
        this.checkSelected();
        final ArrayList aList = this.getSelectedIdValues();
        if (this.showConfirm("CONFIRM_AUDIT")) {
            IProgTask prog = new IProgTask(){
                int checkCounts = 0;

                public Object exec() throws Exception {
                    IAttendanceManager iAttend = AttendanceManagerFactory.getRemoteInstance();
                    String[] strId = new String[aList.size()];
                    for (int i = 0; i < strId.length; ++i) {
                        strId[i] = aList.get(i).toString();
                    }
                    this.checkCounts = iAttend.checkAttendance(strId);
                    return "";
                }

                public void afterExec(Object result) throws Exception {
                    if (this.checkCounts == aList.size()) {
                        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.time.TimeResource.CHECK_SUCCESSFUL"));
                        AttendanceManagerListUI.this.refreshList();
                        AttendanceManagerListUI.this.setRowState();
                    } else {
                        String strMsg = EASResource.getString((String)"com.kingdee.eas.hr.time.LeaveDetailCheckResource.CHECK_FAIL_NO_CMPPERIOD");
                        MsgBox.showInfo((String)strMsg);
                    }
                }
            };
            ProgDialog progDialog = null;
            Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
            progDialog = win instanceof Frame ? new ProgDialog((Frame)win) : (win instanceof Dialog ? new ProgDialog((Dialog)win) : new ProgDialog((Frame)this.getUIContext().get("OwnerWindow")));
            progDialog.setLongTimeTask(prog);
            progDialog.show();
        }
    }

    public void actionUnCheck_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int[] rows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        IRow row = null;
        for (int i = 0; i < rows.length; ++i) {
            row = this.tblMain.getRow(rows[i]);
            if (!RefStateEnum.REF.getAlias().equals(row.getCell("refrence").getValue().toString())) continue;
            MsgBox.showInfo((String)"\u5df2\u88ab\u5f15\u7528\u7684\u6570\u636e\u4e0d\u80fd\u53cd\u5ba1\u6838\uff01");
            SysUtil.abort();
        }
        IProgTask prog = new IProgTask(){

            public Object exec() throws Exception {
                IAttendanceManager iAttend = AttendanceManagerFactory.getRemoteInstance();
                ArrayList aList = AttendanceManagerListUI.this.getSelectedIdValues();
                String[] strId = new String[aList.size()];
                for (int i = 0; i < strId.length; ++i) {
                    strId[i] = aList.get(i).toString();
                }
                int unCheckCounts = iAttend.unCheckAttendance(strId);
                if (unCheckCounts == aList.size()) {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.time.TimeResource.UNCHECK_SUCCESSFUL"));
                } else {
                    String strMsg = EASResource.getString((String)"com.kingdee.eas.hr.time.TimeResource.ALL_UNCHECK_RECORD") + "[ " + aList.size() + " ]" + EASResource.getString((String)"com.kingdee.eas.hr.time.TimeResource.MIDDLE_RECORDER") + "[ " + unCheckCounts + " ]" + EASResource.getString((String)"com.kingdee.eas.hr.time.TimeResource.RECORDER") + EASResource.getString((String)"com.kingdee.eas.hr.time.TimeResource.UNCHECK_SUCCESSFUL");
                    MsgBox.showInfo((String)strMsg);
                }
                return "";
            }

            public void afterExec(Object result) throws Exception {
                AttendanceManagerListUI.this.refreshList();
                AttendanceManagerListUI.this.setRowState();
            }
        };
        ProgDialog progDialog = null;
        Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
        progDialog = win instanceof Frame ? new ProgDialog((Frame)win) : (win instanceof Dialog ? new ProgDialog((Dialog)win) : new ProgDialog((Frame)this.getUIContext().get("OwnerWindow")));
        progDialog.setLongTimeTask(prog);
        progDialog.show();
    }

    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
        this.actionCheck.setEnabled(true);
        this.actionUnCheck.setEnabled(true);
        this.actionOutput.setEnabled(true);
        this.actionSave.setEnabled(true);
        this.btnOutput.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnWorkCheck.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.btnWorkUnCheck.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.btnUnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_ffreeze"));
        this.btnCopyToColumn.setIcon(EASResource.getIcon((String)"imgTbtn_electcopy"));
    }

    public void actionCopyToColumn_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        KDTSelectBlock sb = null;
        int size = this.tblMain.getSelectManager().size();
        if (size > 0) {
            sb = this.tblMain.getSelectManager().get(0);
            ICell iCell = null;
            int row = sb.getTop();
            int column = sb.getLeft();
            IColumn iColumn = this.tblMain.getColumn(column);
            if (iColumn == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
                SysUtil.abort();
            }
            if (iColumn == null || iColumn.getStyleAttributes().isLocked()) {
                return;
            }
            if (row == -1) {
                return;
            }
            Object value = this.tblMain.getCell(row, column).getValue();
            int[] selectDis = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
            int count = selectDis.length;
            for (int i = 0; i < count; ++i) {
                if (selectDis[i] == row || this.tblMain.getCell(selectDis[i], column).getStyleAttributes().isLocked()) continue;
                iCell = this.tblMain.getCell(selectDis[i], column);
                this.changeList.add(i);
                iCell.setValue(value);
            }
            if (iColumn.getColumnIndex() == this.tblMain.getColumn("cmpPeriod").getColumnIndex()) {
                Object value1 = this.tblMain.getRow(row).getCell("cmpPeriodId").getValue();
                int count2 = selectDis.length;
                for (int i = 0; i < count2; ++i) {
                    if (selectDis[i] == row || this.tblMain.getCell(selectDis[i], column).getStyleAttributes().isLocked()) continue;
                    iCell = this.tblMain.getRow(selectDis[i]).getCell("cmpPeriodId");
                    iCell.setValue(value1);
                }
            }
        }
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    public void actionOutput_actionPerformed(ActionEvent e) throws Exception {
        OutputExcelUtil excelUtil = new OutputExcelUtil();
        excelUtil.appendToExcel(this.tblMain, true, true, this.getUITitle());
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        if (!this.isAll) {
            return;
        }
        IRow row = this.tblMain.getRow(e.getSelectBlock().getTop());
        if (row == null) {
            return;
        }
        if (RefStateEnum.REF.toString().equals(row.getCell("refrence").getValue().toString())) {
            this.btnEdit.setEnabled(false);
            this.btnRemove.setEnabled(false);
        }
        if (CheckStateEnum.CHECK.toString().equals(row.getCell("checkState").getValue().toString())) {
            this.btnEdit.setEnabled(false);
            this.btnRemove.setEnabled(false);
            this.btnWorkCheck.setEnabled(false);
            this.menuItemCheck.setEnabled(false);
            this.btnWorkUnCheck.setEnabled(true);
            this.btnUnAudit.setEnabled(true);
            this.menuItemUnCheck.setEnabled(true);
            this.menuItemUnAudit.setEnabled(true);
        } else {
            this.btnEdit.setEnabled(true);
            this.btnRemove.setEnabled(true);
            this.btnWorkCheck.setEnabled(true);
            this.menuItemCheck.setEnabled(true);
            this.btnWorkUnCheck.setEnabled(false);
            this.btnUnAudit.setEnabled(false);
            this.menuItemUnCheck.setEnabled(false);
            this.menuItemUnAudit.setEnabled(false);
        }
    }

    void checkInputs() throws TimeAttendanceException {
        int counts = this.tblMain.getRowCount();
        IRow curRow = null;
        ArrayList<String> psList = new ArrayList<String>();
        ArrayList<String> orgList = new ArrayList<String>();
        for (int i = 0; i < counts; ++i) {
            curRow = this.tblMain.getRow(i);
            if (!this.isRelateOrg) continue;
            Object ps = this.tblMain.getRow(i).getCell("positionId").getValue();
            Object org = this.tblMain.getRow(i).getCell("adminOrgUnitId").getValue();
            if (org == null) {
                MsgBox.showWarning((Component)((Object)this), (String)(EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"1_AttendanceManagerImportFacadeControllerBean") + (i + 1) + EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"60_AttendanceManagerEditUI")));
                SysUtil.abort();
            }
            if (ps != null) {
                psList.add(ps.toString());
            } else {
                psList.add("");
            }
            orgList.add(org.toString());
        }
        if (this.isRelateOrg) {
            try {
                AttendanceManagerFactory.getRemoteInstance().checkPositionAndOrg(psList, orgList, null, false);
            }
            catch (Exception e) {
                MsgBox.showWarning((Component)((Object)this), (String)e.getMessage());
                SysUtil.abort();
            }
        }
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.checkInputs();
        AttendanceManagerCollection infos = this.getAttendanceManagerCollection();
        IAttendanceManager iAttend = AttendanceManagerFactory.getRemoteInstance();
        iAttend.saveALL(infos);
        this.setMessageText(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Save_OK"));
        this.showMessage();
        this.refreshList();
        this.changeList.clear();
    }

    void checkInput() throws TimeAttendanceException {
        int counts = this.tblMain.getRowCount();
        IRow curRow = null;
        for (int i = 0; i < counts; ++i) {
            Date endDate;
            Date beginDate;
            curRow = this.tblMain.getRow(i);
            if (curRow.getCell("totalValue").getValue() == null) {
                throw new TimeAttendanceException(TimeAttendanceException.TOTALVALUECOLUMN_NOT_NULL);
            }
            if (curRow.getCell("startDate").getValue() == null || curRow.getCell("endDate").getValue() == null || !DateTimeUtils.dayAfter((Date)(beginDate = (Date)curRow.getCell("startDate").getValue()), (Date)(endDate = (Date)curRow.getCell("endDate").getValue()))) continue;
            throw new TimeAttendanceException(TimeAttendanceException.TIME_ENDDATE_BEGINDATE);
        }
    }

    protected void combState_itemStateChanged(ItemEvent e) throws Exception {
        if (MACHINE.equals(this.combState.getActionCommand())) {
            return;
        }
        this.checkState = this.combState.getSelectedItem() instanceof CheckStateEnum ? (CheckStateEnum)((Object)this.combState.getSelectedItem()) : null;
        this.setCheckStateFilter();
        this.refreshList();
    }

    private void setCheckStateFilter() {
        if (this.mainQuery != null && this.mainQuery.getFilter() != null) {
            FilterItemCollection collection = this.mainQuery.getFilter().getFilterItems();
            FilterItemInfo info = null;
            boolean hasCheckStateProperty = false;
            int size = collection.size();
            for (int i = 0; i < size; ++i) {
                if (!collection.get(i).getPropertyName().endsWith("checkState")) continue;
                info = collection.get(i);
                hasCheckStateProperty = true;
                break;
            }
            if (hasCheckStateProperty) {
                if (this.checkState != null) {
                    info.setCompareValue((Object)this.checkState.getValue());
                    info.setCompareType(CompareType.EQUALS);
                } else {
                    info.setCompareValue((Object)-9999);
                    info.setCompareType(CompareType.NOTEQUALS);
                }
            } else if (this.checkState != null) {
                String maskString = this.mainQuery.getFilter().getMaskString();
                info = new FilterItemInfo("checkState", (Object)this.checkState.getValue());
                collection.add(info);
                this.mainQuery.getFilter().setMaskString("(" + maskString + ") and (#" + String.valueOf(collection.size() - 1) + ")");
            }
        }
    }

    void setRowState() {
        int counts = this.tblMain.getRowCount();
        for (int i = 0; i < counts; ++i) {
            if (((BizEnumValueInfo)this.tblMain.getRow(i).getCell("checkState").getValue()).getInt() == 1) {
                this.tblMain.getRow(i).getStyleAttributes().setLocked(true);
                continue;
            }
            this.tblMain.getRow(i).getStyleAttributes().setLocked(false);
        }
    }

    public void initUIMenuBarLayout() {
        super.initUIMenuBarLayout();
        this.menuItemOutput.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.menuItemSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.menuItemCheck.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.menuItemUnCheck.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.menuItemCopy.setIcon(EASResource.getIcon((String)"imgTbtn_copytotier"));
        this.menuItemUnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_ffreeze"));
    }

    public void refreshList() throws Exception {
        super.refreshList();
        this.setLeaveDataDisplayFormat();
        if (!this.isRelateOrg) {
            this.tblMain.getColumn("position1.name").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("adminOrgUnit1.name").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("attendancecmp").getStyleAttributes().setHided(true);
        }
    }

    private void setLeaveDataDisplayFormat() throws Exception {
        IRow row = null;
        int decDigital = 2;
        int length = 10;
        int dataType = 50;
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.tblMain.getRow(i);
            if (row.getCell("decDigital").getValue() != null) {
                decDigital = (Integer)row.getCell("decDigital").getValue();
            }
            if (row.getCell("length").getValue() != null) {
                length = (Integer)row.getCell("length").getValue();
            }
            if (row.getCell("dataType").getValue() != null) {
                dataType = ((BizEnumValueInfo)row.getCell("dataType").getValue()).getInt();
            }
            row.getCell("totalValue").getStyleAttributes().setNumberFormat("%r{0.00}10.2f");
            row.getCell("totalValue").setEditor(TimeAttendanceUtils.getTheNegCellEditor(length, decDigital, ItemDataTypeEnum.getEnum((int)dataType)));
        }
    }

    public void initTableListner(KDTable table) {
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return null;
    }

    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        IProgTask prog = new IProgTask(){

            public Object exec() throws Exception {
                IAttendanceManager iAttend = AttendanceManagerFactory.getRemoteInstance();
                ArrayList aList = AttendanceManagerListUI.this.getSelectedIdValues();
                String[] strId = new String[aList.size()];
                for (int i = 0; i < strId.length; ++i) {
                    strId[i] = aList.get(i).toString();
                }
                int unCheckCounts = iAttend.unAudit(strId);
                if (unCheckCounts == aList.size()) {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.time.TimeResource.UNCHECK_SUCCESSFUL"));
                } else {
                    String strMsg = EASResource.getString((String)"com.kingdee.eas.hr.time.TimeResource.ALL_UNCHECK_RECORD") + "[ " + aList.size() + " ]" + EASResource.getString((String)"com.kingdee.eas.hr.time.TimeResource.MIDDLE_RECORDER") + "[ " + unCheckCounts + " ]" + EASResource.getString((String)"com.kingdee.eas.hr.time.TimeResource.RECORDER") + EASResource.getString((String)"com.kingdee.eas.hr.time.TimeResource.UNCHECK_SUCCESSFUL");
                    MsgBox.showInfo((String)strMsg);
                }
                return "";
            }

            public void afterExec(Object result) throws Exception {
                AttendanceManagerListUI.this.refreshList();
                AttendanceManagerListUI.this.setRowState();
            }
        };
        ProgDialog progDialog = null;
        Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
        progDialog = win instanceof Frame ? new ProgDialog((Frame)win) : (win instanceof Dialog ? new ProgDialog((Dialog)win) : new ProgDialog((Frame)this.getUIContext().get("OwnerWindow")));
        progDialog.setLongTimeTask(prog);
        progDialog.show();
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = super.getQueryExecutor(queryPK, viewInfo);
        exec.option().isAutoIgnoreZero = false;
        return exec;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    protected boolean isAllowDefaultSolutionNull() {
        return false;
    }

    private HROrgUnitInfo getHROrgUnit() {
        if (this.hrOrgUnitInfo == null) {
            this.hrOrgUnitInfo = SysContext.getSysContext().getCurrentHRUnit();
        }
        return this.hrOrgUnitInfo;
    }

    protected void tblMain_editStarting(KDTEditEvent e) throws Exception {
        this.object = e.getOldValue();
    }

    protected void tblMain_editStopped(KDTEditEvent e) throws Exception {
        Object newObject = e.getValue();
        if (newObject != null && this.object != null && (this.object instanceof BigDecimal || this.object instanceof Float)) {
            if ((int)(new Float(newObject.toString()).floatValue() * 100.0f) != (int)(new Float(this.object.toString()).floatValue() * 100.0f)) {
                this.changeList.add(e.getRowIndex());
            }
        } else if (newObject != null && !newObject.equals(this.object)) {
            this.changeList.add(e.getRowIndex());
        } else if (newObject == null && this.object != null) {
            this.changeList.add(e.getRowIndex());
        }
    }

    private void confirmSave(ActionEvent e) throws Exception {
        this.tblMain.requestFocus();
        if (this.changeList.size() > 0) {
            if (this.showConfirm("comfirmSave")) {
                this.actionSave_actionPerformed(e);
                this.changeList.clear();
            } else {
                this.changeList.clear();
            }
        }
    }

    public boolean showConfirm(String label) {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)("com.kingdee.eas.hr.time.LeaveDetailCheckResource." + label))));
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.confirmSave(e);
        super.actionRefresh_actionPerformed(e);
    }

    protected void afterTableFillData(KDTDataRequestEvent e) {
        IRow row = null;
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.tblMain.getRow(i);
            row.getCell("checkState").getValue();
            if (!CheckStateEnum.CHECK.toString().equals(row.getCell("checkState").getValue().toString())) continue;
            row.getCell("totalValue").getStyleAttributes().setLocked(true);
            row.getCell("startDate").getStyleAttributes().setLocked(true);
            row.getCell("endDate").getStyleAttributes().setLocked(true);
            row.getCell("position1.name").getStyleAttributes().setLocked(true);
            row.getCell("adminOrgUnit1.name").getStyleAttributes().setLocked(true);
            row.getCell("attendancecmp").getStyleAttributes().setLocked(true);
            row.getCell("cmpPeriodId").getStyleAttributes().setLocked(true);
            row.getCell("cmpPeriod").getStyleAttributes().setLocked(true);
            row.getCell("recordPerson").getStyleAttributes().setLocked(true);
            row.getCell("description").getStyleAttributes().setLocked(true);
            row.getCell("decDigital").getStyleAttributes().setLocked(true);
            row.getCell("length").getStyleAttributes().setLocked(true);
            row.getCell("dataType").getStyleAttributes().setLocked(true);
        }
        if (this.combState.getSelectedItem() instanceof CheckStateEnum) {
            this.checkState = (CheckStateEnum)((Object)this.combState.getSelectedItem());
            if (this.checkState.getValue() == CheckStateEnum.CHECK.getValue()) {
                this.actionSave.setEnabled(false);
            } else {
                this.actionSave.setEnabled(true);
            }
        }
    }
}

