/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.time.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.hr.time.client.AbstractAttendanceManagerPanelUI;
import com.kingdee.eas.hr.time.client.HRTimeClientUtils;
import com.kingdee.eas.hr.time.client.TimeAttendanceUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.LocaleUtils;
import java.awt.Component;
import java.util.Date;
import java.util.GregorianCalendar;

public class AttendanceManagerPanelUI
extends AbstractAttendanceManagerPanelUI {
    private static final long serialVersionUID = -61166L;

    public void loadFields() {
        super.loadFields();
    }

    public FilterInfo getFilterInfo() {
        OrgUnitInfo orgInfo = (OrgUnitInfo)this.promptBoxOrg.getData();
        FilterInfo filterInfo = new FilterInfo();
        if (orgInfo != null) {
            if (this.chkInclude.isSelected()) {
                FilterInfo orgFi = new FilterInfo();
                orgFi.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.longNumber", (Object)orgInfo.getLongNumber()));
                orgFi.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.longNumber", (Object)(orgInfo.getLongNumber() + "!%"), CompareType.LIKE));
                orgFi.setMaskString("(#0 or #1)");
                try {
                    filterInfo.mergeFilter(orgFi, "and");
                }
                catch (BOSException e) {
                    super.handUIException((Throwable)e);
                }
            } else {
                filterInfo.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.id", (Object)orgInfo.getId().toString()));
            }
        }
        return filterInfo;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        TimeAttendanceUtils.initF7Selector((IUIObject)this, this.promptBoxOrg);
    }

    public void storeFields() {
        super.storeFields();
    }

    public void initLayout() {
        super.initLayout();
        Date date = new Date();
        GregorianCalendar cal = new GregorianCalendar(DateTimeUtils.getYear((Date)date), DateTimeUtils.getMonth((Date)date) - 1, 1);
        GregorianCalendar calTo = new GregorianCalendar(DateTimeUtils.getYear((Date)date), DateTimeUtils.getMonth((Date)date) - 1, HRTimeClientUtils.getLastDay(new GregorianCalendar()));
        this.DatePickFrom.setValue((Object)cal.getTime());
        this.DatePickerTo.setValue((Object)calTo.getTime());
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        if (this.promptBoxOrg.getData() != null) {
            AdminOrgUnitInfo orgUnit = (AdminOrgUnitInfo)this.promptBoxOrg.getData();
            cp.addCustomerParam("OrgUnit", orgUnit.getId().toString());
            cp.addCustomerParam("OrgUnit_Name_L1", orgUnit.getName(LocaleUtils.getLocale((String)"L1")));
            cp.addCustomerParam("OrgUnit_Name_L2", orgUnit.getName(LocaleUtils.getLocale((String)"L2")));
            cp.addCustomerParam("OrgUnit_Name_L3", orgUnit.getName(LocaleUtils.getLocale((String)"L3")));
        }
        cp.putDate("timeFrom", (Date)this.DatePickFrom.getValue());
        cp.putDate("timeTo", (Date)this.DatePickerTo.getValue());
        cp.putBoolean("chkInclude", this.chkInclude.isSelected());
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        this.clear();
        if (cp == null) {
            return;
        }
        try {
            String orgID = cp.getCustomerParam("OrgUnit");
            if (orgID != null) {
                AdminOrgUnitInfo orgUnit = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgID));
                this.promptBoxOrg.setValue((Object)orgUnit);
            }
            this.DatePickFrom.setValue((Object)cp.getDate("timeFrom"));
            this.DatePickerTo.setValue((Object)cp.getDate("timeTo"));
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
        this.chkInclude.setSelected(cp.getBoolean("chkInclude"));
    }

    public void clear() {
        super.clear();
        this.promptBoxOrg.setData(null);
        Date date = new Date();
        GregorianCalendar cal = new GregorianCalendar(DateTimeUtils.getYear((Date)date), DateTimeUtils.getMonth((Date)date) - 1, 1);
        GregorianCalendar calTo = new GregorianCalendar(DateTimeUtils.getYear((Date)date), DateTimeUtils.getMonth((Date)date) - 1, HRTimeClientUtils.getLastDay(new GregorianCalendar()));
        this.DatePickFrom.setValue((Object)cal.getTime());
        this.DatePickerTo.setValue((Object)calTo.getTime());
        this.chkInclude.setSelected(false);
    }

    public boolean verify() {
        if (this.DatePickFrom.getValue() != null && this.DatePickerTo.getValue() != null && DateTimeUtils.dayBefore((Date)((Date)this.DatePickerTo.getValue()), (Date)((Date)this.DatePickFrom.getValue()))) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.time.TimeResource.STARTDATE_MUST_ENDDATE"));
            return false;
        }
        return true;
    }
}

