/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.time.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDTimePicker;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.hr.time.LeaveDetailException;
import com.kingdee.eas.hr.time.TimeAttendanceCollection;
import com.kingdee.eas.hr.time.TimeAttendanceFactory;
import com.kingdee.eas.hr.time.TimeAttendanceInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.UuidException;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;

public class HRTimeClientUtils {
    public static final String strResource = "com.kingdee.eas.hr.time.LeaveBillResource.";
    public static final String strLeaveCheckResource = "com.kingdee.eas.hr.time.LeaveDetailCheckResource.";
    public static final String LEAVE_ITEM_ID_YEAR = "00000000-0000-0000-0000-000000000008649E3405";
    public static final String LEAVE_ITEM_ID_PRIVATE_AFFAIR = "00000000-0000-0000-0000-000000000011649E3405";

    public static TimeAttendanceInfo getAffairLeaveItem() throws EASBizException, BOSException, UuidException {
        return TimeAttendanceFactory.getRemoteInstance().getTimeAttendanceInfo("select * where id = '00000000-0000-0000-0000-000000000011649E3405'");
    }

    public static String getLongTimePatternStr() {
        return "yyyy-MM-dd HH:mm:ss";
    }

    public static String getTimePatternStr() {
        return "HH:mm:ss";
    }

    public static Date getDateByStr(String dateStr, String fmtStr) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat(fmtStr);
        return format.parse(fmtStr);
    }

    public static String getDatePatternStr() {
        return "yyyy-MM-dd";
    }

    public static String getDecimalFormatStr() {
        return "%r{############.#}d";
    }

    public static String getDecimalFormatStrTwo() {
        return "%r{############.#}dd";
    }

    public static String getDecimalFormatStr(int decDigital) {
        StringBuffer sb = new StringBuffer();
        sb.append("%r{############.");
        for (int i = 0; i < decDigital; ++i) {
            sb.append("#");
        }
        sb.append("}d");
        return sb.toString();
    }

    public static void checkDate(KDTable tbl) throws Exception {
        int rowCount = tbl.getRowCount();
        Date beginDate = null;
        Date endDate = null;
        IRow row = null;
        int colIndex = tbl.getColumn("endDate").getColumnIndex();
        TimeAttendanceInfo timeAttendanceInfo = null;
        BigDecimal LeaveLength = new BigDecimal("0.0");
        BigDecimal lastUnit = new BigDecimal("0.00");
        for (int i = 0; i < rowCount; ++i) {
            int b;
            int a;
            row = tbl.getRow(i);
            beginDate = (Date)row.getCell("beginDate").getValue();
            endDate = (Date)row.getCell("endDate").getValue();
            if (beginDate.getTime() > endDate.getTime()) {
                tbl.getSelectManager().select(i, colIndex);
                throw new LeaveDetailException(LeaveDetailException.DATEERROR);
            }
            timeAttendanceInfo = (TimeAttendanceInfo)row.getCell("type").getValue();
            if (timeAttendanceInfo != null) {
                lastUnit = timeAttendanceInfo.getLastUnit();
            }
            if (row.getCell("leaveLength").getValue() != null && !row.getCell("leaveLength").getValue().toString().trim().equals("")) {
                LeaveLength = new BigDecimal(row.getCell("leaveLength").getValue().toString());
            }
            if (LeaveLength.floatValue() > 0.0f && lastUnit != null && lastUnit.floatValue() > 0.0f && (a = (int)(LeaveLength.floatValue() * 100.0f)) % (b = (int)(lastUnit.floatValue() * 100.0f)) != 0) {
                MsgBox.showInfo((String)(EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"1_AttendanceManagerImportFacadeControllerBean") + (i + 1) + EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"64_HRTimeClientUtils") + lastUnit.floatValue() + EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"65_HRTimeClientUtils")));
                SysUtil.abort();
            }
            if (!(LeaveLength.floatValue() <= 0.0f)) continue;
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"DAYNUM"));
            SysUtil.abort();
        }
    }

    public static Timestamp getTime(KDDatePicker pkDate, KDTimePicker pkTime) {
        Date date = (Date)pkDate.getValue();
        Date time = (Date)pkTime.getValue();
        return new Timestamp(HRTimeClientUtils.getTime(date, time).getTime());
    }

    public static Date getTime(Date date, Date time) {
        date = DateTimeUtils.truncateDate((Date)date);
        date = DateTimeUtils.addHour((Date)date, (long)time.getHours());
        date = DateTimeUtils.addMinute((Date)date, (long)time.getMinutes());
        date = DateTimeUtils.addSecond((Date)date, (long)time.getSeconds());
        return date;
    }

    public static Date getTrucateDate(Date date) {
        return DateTimeUtils.truncateDate((Date)date);
    }

    public static Timestamp getTime(Timestamp date, Timestamp time) {
        int year = date.getYear();
        int month = date.getMonth();
        int day = date.getDay();
        int hour = time.getHours();
        int minute = time.getMinutes();
        int second = time.getSeconds();
        return new Timestamp(year, month, day, hour, minute, second, 0);
    }

    public static String getCurCUId() {
        String cuId = null;
        if (SysContext.getSysContext().getCurrentCtrlUnit() != null) {
            cuId = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        }
        return cuId;
    }

    public static TimeAttendanceCollection getSimpleLeaveItems() throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("*"));
        FilterInfo filter = new FilterInfo();
        viewInfo.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("attendCatalog.id", (Object)"00000000-0000-0000-0000-000000000002BE0D0183"));
        filter.getFilterItems().add(new FilterItemInfo("enable", (Object)1));
        if (SysContext.getSysContext().getCurrentHRUnit() != null) {
            filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId().toString()));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", null));
        }
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", null));
        filter.setMaskString("#0 and #1 and (#2 or #3)");
        SorterItemInfo sorterOrderItem = new SorterItemInfo("number");
        sorterOrderItem.setSortType(SortType.ASCEND);
        viewInfo.getSorter().add(sorterOrderItem);
        return TimeAttendanceFactory.getRemoteInstance().getTimeAttendanceCollection(viewInfo);
    }

    public static TimeAttendanceCollection getLeaveItems() throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("*"));
        FilterInfo filter = new FilterInfo();
        viewInfo.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("attendCatalog.id", (Object)"00000000-0000-0000-0000-000000000002BE0D0183"));
        filter.getFilterItems().add(new FilterItemInfo("enable", (Object)1));
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", null));
        filter.setMaskString("#0 and #1 and (#2 or #3)");
        return TimeAttendanceFactory.getRemoteInstance().getTimeAttendanceCollection(viewInfo);
    }

    public static BigDecimal getYearHoliday(String personId) throws Exception {
        int year = DateTimeUtils.getYear((Date)new Date());
        Map mapValue = HRUtils.getYearVacation((int)year, (String)personId);
        float currQuantity = ((Float)mapValue.get("FCurrAvailable")).floatValue();
        return new BigDecimal(String.valueOf(currQuantity));
    }

    public static Timestamp getDateTime(Object date) {
        if (date == null) {
            return null;
        }
        Date date_ = (Date)date;
        return new Timestamp(date_.getTime());
    }

    public static Date getThisYearBeginDate() {
        Calendar c = Calendar.getInstance();
        int year = c.get(1);
        c.set(year, 0, 1, 0, 0, 0);
        return c.getTime();
    }

    public static Date getThisYearEndDate() {
        Calendar c = Calendar.getInstance();
        int year = c.get(1);
        c.set(year, 11, 31, 23, 59, 59);
        return DateTimeUtils.addSecond((Date)c.getTime(), (long)-1L);
    }

    public static Timestamp getBeginTime(Date date) {
        date = DateTimeUtils.truncateDate((Date)date);
        return new Timestamp(date.getTime());
    }

    public static Timestamp getEndTime(Date date) {
        date = DateTimeUtils.addSecond((Date)DateTimeUtils.addDay((Date)DateTimeUtils.truncateDate((Date)date), (long)-1L), (long)-1L);
        return new Timestamp(date.getTime());
    }

    public static BigDecimal getThisYearLeaveSumup(String leaveTypeId, String personId) throws Exception {
        return HRTimeClientUtils.getLeaveSumup(leaveTypeId, personId, HRTimeClientUtils.getThisYearBeginDate(), HRTimeClientUtils.getThisYearEndDate());
    }

    public static BigDecimal getLeaveSumup(String leaveTypeId, String personId, Date beginDate, Date endDate) throws Exception {
        BigDecimal value = new BigDecimal("0");
        IRowSet rows = null;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("checkState", (Object)1));
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId));
        filter.getFilterItems().add(new FilterItemInfo("startDateReal", (Object)HRTimeClientUtils.getBeginTime(beginDate), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("endDateReal", (Object)HRTimeClientUtils.getEndTime(endDate), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("timeAttendance.id", (Object)leaveTypeId));
        filter.setMaskString("#0 and #1 and #2 and #3 and #4");
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        MetaDataPK pk = new MetaDataPK("com.kingdee.eas.hr.time.app.SelfLeaveQuery");
        IQueryExecutor iqry = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)pk);
        iqry.setObjectView(evi);
        rows = iqry.executeQuery();
        if (rows.size() > 0 && rows.next()) {
            value = rows.getBigDecimal("totalRegReal");
        }
        rows.close();
        return value;
    }

    public static Object getSelectedCellValue(KDTable table, String colName) {
        int index = KDTableUtil.getSelectedRow((KDTable)table);
        if (index != -1) {
            IRow row = table.getRow(index);
            return row.getCell(colName).getValue();
        }
        return null;
    }

    public static int getLastDay(GregorianCalendar date) {
        int m = DateTimeUtils.getMonth((Date)date.getTime());
        int y = 0;
        y = DateTimeUtils.getYear((Date)date.getTime());
        if (m == 4 || m == 6 || m == 9 || m == 11) {
            return 30;
        }
        if (m == 2) {
            if (date.isLeapYear(y)) {
                return 29;
            }
            return 28;
        }
        return 31;
    }

    public static String getNumberFormatStr() {
        return "%r{#.##}d";
    }
}

