/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.time.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.core.hr.util.HRParamUtil;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.FrameWorkUtils;
import com.kingdee.eas.framework.util.QueryUtility;
import com.kingdee.eas.framework.util.UIConfigUtility;
import com.kingdee.eas.hr.time.IYearVacationBalance;
import com.kingdee.eas.hr.time.YearVacationBalanceFactory;
import com.kingdee.eas.hr.time.client.AbstractLeaveBillAllListUI;
import com.kingdee.eas.hr.time.client.LeaveBillFilterUI;
import com.kingdee.eas.hr.time.client.LeaveBillPrintProvider;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class LeaveBillAllListUI
extends AbstractLeaveBillAllListUI {
    private CommonQueryDialog cqDialog = null;
    private KDPanel userPanel = null;
    private boolean isQJ = false;
    private static final long serialVersionUID = -61166L;

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.getColumn("entries.beginTime").getStyleAttributes().setNumberFormat("yyyy-MM-dd hh:mm:ss");
        this.tblMain.getColumn("entries.endTime").getStyleAttributes().setNumberFormat("yyyy-MM-dd hh:mm:ss");
        HROrgUnitInfo hrInfo = this.getCurrentHRO();
        this.isQJ = HRParamUtil.getParamOfHR(null, (String)"QJ003", (String)hrInfo.getId().toString());
        if (!this.isQJ) {
            this.tblMain.getColumn("reportState").getStyleAttributes().setHided(true);
        }
    }

    private HROrgUnitInfo getCurrentHRO() {
        if (this.getMainOrgContext() == null) {
            return SysContext.getSysContext().getCurrentHRUnit();
        }
        if (FrameWorkUtils.getCurrentOrgUnit((Context)this.getMainOrgContext(), (OrgType)OrgType.HRO) != null) {
            return (HROrgUnitInfo)FrameWorkUtils.getCurrentOrgUnit((Context)this.getMainOrgContext(), (OrgType)OrgType.HRO);
        }
        return SysContext.getSysContext().getCurrentHRUnit();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAnyPrint.setIcon(EASResource.getIcon((String)"imgTbtn_printbill"));
    }

    public void actionSelectPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelectPrint_actionPerformed(e);
        ArrayList leaveBillIds = this.getEntryIds();
        LeaveBillPrintProvider.executeActionPrint(leaveBillIds, (Component)((Object)this));
    }

    private ArrayList getEntryIds() {
        this.checkSelected();
        ArrayList<String> arrayList = new ArrayList<String>();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        for (int i = 0; i < selectRows.length; ++i) {
            int rowIndex = selectRows[i];
            IRow row = this.tblMain.getRow(rowIndex);
            if (row == null || row.getCell("entries.id") == null) continue;
            arrayList.add(row.getCell("entries.id").getValue().toString());
        }
        return arrayList;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.cqDialog != null) {
            return this.cqDialog;
        }
        this.cqDialog = super.initCommonQueryDialog();
        KDPanel userPanel = this.getUserPanel();
        if (userPanel != null) {
            this.cqDialog.addUserPanel(userPanel);
        }
        this.cqDialog.setShowSorter(false);
        return this.cqDialog;
    }

    private KDPanel getUserPanel() {
        if (this.userPanel != null) {
            return this.userPanel;
        }
        try {
            this.userPanel = new LeaveBillFilterUI();
        }
        catch (Exception ex) {
            super.handleException(ex);
        }
        return this.userPanel;
    }

    protected void getUIState() {
        this.isSelf = false;
    }

    protected boolean isEditable() throws Exception {
        boolean value = true;
        BizEnumValueInfo state = (BizEnumValueInfo)this.getCellValue("bizState");
        if (state == null) {
            value = true;
        } else if (state.getInt() != 0 && state.getInt() != -1) {
            value = false;
            return value;
        }
        String proposerId = (String)this.getCellValue("proposer.id");
        Boolean isMulti = (Boolean)this.getCellValue("isMultiEntry");
        if (proposerId == null) {
            value = true;
        } else if (isMulti != null && !isMulti.booleanValue()) {
            value = proposerId.equals(this.personId.toString());
        }
        return value;
    }

    public boolean isPrepareActionAudit() {
        return false;
    }

    public boolean isPrepareActionAuditResult() {
        return true;
    }

    public boolean isPrepareInit() {
        return false;
    }

    public boolean isPrepareActionQuery() {
        return false;
    }

    public boolean isPrepareActionAddNew() {
        return true;
    }

    public boolean isPrepareActionEdit() {
        return false;
    }

    public boolean isPrepareActionView() {
        return false;
    }

    public boolean isActionRefresh() {
        return true;
    }

    public boolean isPrepareActionRefresh() {
        return true;
    }

    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        int[] rows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        super.actionAudit_actionPerformed(e);
        List lstPerson = this.getSelectedPerIDs(rows);
        if (lstPerson.size() > 0) {
            IYearVacationBalance iyvBalacne = YearVacationBalanceFactory.getRemoteInstance();
            int year = Calendar.getInstance().get(1);
            iyvBalacne.calculate(year, lstPerson, 4, new Date(), 4);
        }
    }

    private List getSelectedPerIDs(int[] rows) {
        ArrayList<String> lstPerson = new ArrayList<String>();
        int size = rows.length;
        for (int i = 0; i < size; ++i) {
            if (!this.tblMain.getRow(rows[i]).getCell("type.name").getValue().toString().equals(EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"68_LeaveBillAllListUI"))) continue;
            lstPerson.add(this.tblMain.getRow(rows[i]).getCell("person.id").getValue().toString());
        }
        return lstPerson;
    }

    public boolean isShowWeiBoSideBar() throws BOSException, EASBizException {
        return this.isBOSTypeConfiged();
    }

    protected String getCurrentBillID() {
        if (this.getSelectedRowCount(this.getMainTable()) > 0) {
            return this.getSelectedKeyValue();
        }
        return null;
    }

    protected BOSObjectType getBOSObjectType() {
        return QueryUtility.getMainEntityBOSType((IMetaDataPK)this.getMainQueryPK());
    }

    protected String getEditUIModal() {
        String openModel = UIConfigUtility.getOpenModel();
        if (openModel != null) {
            return openModel;
        }
        return "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
    }
}

