/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.time.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ICommonBOSType;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDTimePicker;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.core.hr.util.HRParamUtil;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.weibo.util.WeiboBizUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.PositionMemberInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.resource.FWResourceManager;
import com.kingdee.eas.hr.affair.AffairRegFacadeFactory;
import com.kingdee.eas.hr.affair.IAffairRegFacade;
import com.kingdee.eas.hr.affair.util.AffairUtil;
import com.kingdee.eas.hr.compensation.ItemDataTypeEnum;
import com.kingdee.eas.hr.emp.IUserPermission;
import com.kingdee.eas.hr.emp.UserPermissionCollection;
import com.kingdee.eas.hr.emp.UserPermissionFactory;
import com.kingdee.eas.hr.emp.client.EmployeeClientUtils;
import com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox;
import com.kingdee.eas.hr.emp.client.PersonMultiPromptBox;
import com.kingdee.eas.hr.time.ApproveStateEnum;
import com.kingdee.eas.hr.time.BizStateEnum;
import com.kingdee.eas.hr.time.LeaveBillEntryFactory;
import com.kingdee.eas.hr.time.LeaveBillEntryInfo;
import com.kingdee.eas.hr.time.LeaveBillFactory;
import com.kingdee.eas.hr.time.LeaveBillInfo;
import com.kingdee.eas.hr.time.LeaveDetailFactory;
import com.kingdee.eas.hr.time.SubmitStateEnum;
import com.kingdee.eas.hr.time.TimeAttendanceCollection;
import com.kingdee.eas.hr.time.TimeAttendanceInfo;
import com.kingdee.eas.hr.time.TimeEntryBaseCollection;
import com.kingdee.eas.hr.time.client.AbstractLeaveBillEditUI;
import com.kingdee.eas.hr.time.client.HRTimeClientUtils;
import com.kingdee.eas.hr.time.client.SelfLeaveQueryUI;
import com.kingdee.eas.hr.time.client.TimeAttendanceUtils;
import com.kingdee.eas.hr.time.client.TimeBaseClientUtils;
import com.kingdee.eas.hr.time.client.TimeUtil;
import com.kingdee.eas.hr.time.util.TimeServerUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class LeaveBillEditUI
extends AbstractLeaveBillEditUI {
    private static final long serialVersionUID = -61166L;
    private String prompt;
    private int selectedIndex;
    private KDNoteHelper appHlp;
    private String resClass;
    public static final String LEAVE_FILENAME = "/HR/OrgUnit/LeaveBill";
    private BOSUuid actPersonId;
    private String billId;

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        HRTimeClientUtils.checkDate(this.kdtEntries);
    }

    protected ArrayList getNoNullColumns() {
        ArrayList<String> cols = new ArrayList<String>();
        cols.add("person");
        cols.add("type");
        cols.add("beginDate");
        cols.add("endDate");
        cols.add("leaveLength");
        return cols;
    }

    public void initUIMenuBarLayout() {
        super.initUIMenuBarLayout();
        this.btnLeaveQuery.setIcon(EASResource.getIcon((String)"imgTbtn_showlist"));
        this.menuItemLeaveQuery.setIcon(EASResource.getIcon((String)"imgTbtn_showlist"));
    }

    public LeaveBillEditUI() throws Exception {
        this.prompt = this.lblPromote.getText();
        this.selectedIndex = -1;
        this.appHlp = new KDNoteHelper();
        this.resClass = "com.kingdee.eas.hr.affair.HRAffairResource.";
    }

    protected IObjectValue createNewData() {
        LeaveBillInfo info = new LeaveBillInfo();
        info.setIsMultiEntry(true);
        try {
            info.setApplyDate(DateTimeUtils.truncateDate((Date)TimeUtil.getServerTime()));
            info.setAdminOrg(LeaveBillFactory.getRemoteInstance().getAdminForHRandUserOrgRange());
        }
        catch (EASBizException e) {
            super.handleException((Exception)((Object)e));
        }
        catch (BOSException e) {
            super.handleException((Exception)((Object)e));
        }
        info.setHrOrgUnit(SysContext.getSysContext().getCurrentHRUnit());
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return LeaveBillFactory.getRemoteInstance();
    }

    protected void setTableCellEditor() throws Exception {
        this.kdtEntries.getColumn("person").setEditor(EmployeeClientUtils.getF7CellEditor((KDPromptSelector)new PersonMultiPromptBox((IUIObject)this)));
        this.kdtEntries.getColumn("beginDate").setEditor(EmployeeClientUtils.getDateTimeCellEditor());
        this.kdtEntries.getColumn("beginDate").getStyleAttributes().setNumberFormat(HRTimeClientUtils.getLongTimePatternStr());
        this.kdtEntries.getColumn("beginTime").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)new KDTimePicker()));
        this.kdtEntries.getColumn("beginTime").getStyleAttributes().setNumberFormat(HRTimeClientUtils.getTimePatternStr());
        this.kdtEntries.getColumn("endDate").setEditor(EmployeeClientUtils.getDateTimeCellEditor());
        this.kdtEntries.getColumn("endDate").getStyleAttributes().setNumberFormat(HRTimeClientUtils.getLongTimePatternStr());
        this.kdtEntries.getColumn("endTime").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)new KDTimePicker()));
        this.kdtEntries.getColumn("endTime").getStyleAttributes().setNumberFormat(HRTimeClientUtils.getTimePatternStr());
        this.kdtEntries.getColumn("leaveLength").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdtEntries.getColumn("leaveLength").getStyleAttributes().setNumberFormat(HRTimeClientUtils.getNumberFormatStr());
        KDTextArea txtReason = new KDTextArea();
        txtReason.setMaxLength(500);
        this.kdtEntries.getColumn("reason").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextArea)txtReason));
        TimeAttendanceCollection c = HRTimeClientUtils.getSimpleLeaveItems();
        DefaultComboBoxModel<TimeAttendanceInfo> model = new DefaultComboBoxModel<TimeAttendanceInfo>();
        int size = c.size();
        for (int i = 0; i < size; ++i) {
            model.addElement(c.get(i));
        }
        KDComboBox combo = new KDComboBox(model);
        combo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                try {
                    LeaveBillEditUI.this.cboContractType_itemStateChanged(e);
                }
                catch (Exception exc) {
                    LeaveBillEditUI.this.handUIException(exc);
                }
            }
        });
        this.kdtEntries.getColumn("type").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)combo));
        this.kdtEntries.getColumn("remark").setEditor(EmployeeClientUtils.getTextAreaCellEditor());
        this.kdtEntries.getColumn("reason").setEditor(EmployeeClientUtils.getTextAreaCellEditor());
    }

    void cboContractType_itemStateChanged(ItemEvent e) throws Exception {
        TimeAttendanceInfo info = (TimeAttendanceInfo)((KDComboBox)e.getSource()).getSelectedItem();
        if (info == null) {
            return;
        }
        IRow curRow = this.kdtEntries.getRow(KDTableUtil.getSelectedRow((KDTable)this.kdtEntries));
        curRow.getCell("unit").setValue((Object)info.getUnitType());
        curRow.getCell("leaveLength").setEditor(TimeAttendanceUtils.getTheCellEditor(info.getLength(), info.getDecDigital(), info.getDataType()));
        curRow.getCell("leaveLength").getStyleAttributes().setNumberFormat(TimeAttendanceUtils.getFomatString(info.getLength(), info.getDecDigital()));
    }

    private String getDeptByPerson(String personId) {
        try {
            PositionMemberInfo postRelInfo = TimeBaseClientUtils.getPersonMemberInfo(personId);
            if (postRelInfo != null && postRelInfo.getPosition() != null && postRelInfo.getPosition().getAdminOrgUnit() != null) {
                return postRelInfo.getPosition().getAdminOrgUnit().getName();
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return null;
    }

    private AdminOrgUnitInfo getAdminOrgByPerson(String personId) {
        try {
            PositionMemberInfo postRelInfo = TimeBaseClientUtils.getPersonMemberInfo(personId);
            if (postRelInfo != null && postRelInfo.getPosition() != null && postRelInfo.getPosition().getAdminOrgUnit() != null) {
                return postRelInfo.getPosition().getAdminOrgUnit();
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return null;
    }

    public void loadEntries() throws Exception {
    }

    public void loadFields() {
        super.loadFields();
        try {
            this.setNumberInput();
        }
        catch (Exception e1) {
            super.handleException(e1);
        }
        this.pInfo = this.editData.getProposer();
        LeaveBillEntryInfo info = null;
        int j = this.kdtEntries.getRowCount();
        for (int i = 0; i < j; ++i) {
            IRow row = this.kdtEntries.getRow(i);
            PersonInfo pInfo = (PersonInfo)row.getCell("person").getValue();
            if (pInfo == null) continue;
            row.getCell("dept").setValue((Object)this.getDeptByPerson(pInfo.getId().toString()));
            info = this.editData.getEntries().get(i);
            row.getCell("decDigital").setValue((Object)info.getType().getDecDigital());
            row.getCell("length").setValue((Object)info.getType().getLength());
            row.getCell("dataType").setValue((Object)info.getType().getDataType());
        }
        try {
            LeaveBillEditUI.setLeaveLengthStyle(this.kdtEntries);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        super.setAuditActionState();
    }

    public static void setLeaveLengthStyle(KDTable tbl) throws Exception {
        IRow curRow = null;
        int size = tbl.getRowCount();
        for (int i = 0; i < size; ++i) {
            curRow = tbl.getRow(i);
            ItemDataTypeEnum dataType = (ItemDataTypeEnum)curRow.getCell("dataType").getValue();
            Integer length = (Integer)curRow.getCell("length").getValue();
            Integer decDigital = (Integer)curRow.getCell("decDigital").getValue();
            if (dataType == null || length == null || decDigital == null) continue;
            curRow.getCell("leaveLength").setEditor(TimeAttendanceUtils.getTheCellEditor(length, decDigital, dataType));
            curRow.getCell("leaveLength").getStyleAttributes().setNumberFormat(TimeAttendanceUtils.getFomatString(length, decDigital));
        }
    }

    public void storeFields() {
        super.storeFields();
        this.editData.setIsMultiEntry(true);
        if (this.editData.getApproveState().getValue() == 0) {
            this.editData.setExtendedProperty("ignoreWorkflow", "true");
        }
        String versionStr = null;
        try {
            versionStr = AffairUtil.getCurrentClientName();
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
        if (versionStr != null && versionStr.equals("hnjt") && this.editData.getBizState().equals((Object)BizStateEnum.COMPLETE) && OprtState.VIEW.equals(this.getOprtState())) {
            this.btnAffairReg.setEnabled(true);
            this.btnAffairReg.setVisible(true);
        }
    }

    private void setPromote(PersonInfo pInfo) throws Exception {
        if (pInfo != null) {
            this.lblPromote.setVisible(true);
            String text = this.prompt;
            text = text.replaceAll("#1", pInfo.getName());
            text = text.replaceAll("#2", this.CurrCanUser(pInfo.getId().toString()));
            String unitTypeString = TimeServerUtils.getTimeAttendanceType(null);
            text = text.replaceAll(text.substring(text.length() - 1), unitTypeString);
            this.lblPromote.setText(text);
        } else {
            this.lblPromote.setVisible(false);
        }
    }

    protected void kdtEntries_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.kdtEntries_tableSelectChanged(e);
        if (e.getSelectBlock() != null) {
            int index = e.getSelectBlock().getTop();
            if (index == this.selectedIndex || index < 0) {
                return;
            }
            this.selectedIndex = index;
            IRow row = this.kdtEntries.getRow(index);
            PersonInfo pInfo = (PersonInfo)row.getCell("person").getValue();
            TimeAttendanceInfo leaveItem = (TimeAttendanceInfo)row.getCell("type").getValue();
            if (leaveItem != null && leaveItem.getId().toString().equals("00000000-0000-0000-0000-000000000008649E3405")) {
                this.setPromote(pInfo);
            } else {
                this.lblPromote.setText(null);
            }
        }
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("adminOrg.id"));
        sic.add(new SelectorItemInfo("adminOrg.name"));
        sic.add(new SelectorItemInfo("adminOrg.number"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("proposer.name"));
        sic.add(new SelectorItemInfo("proposer.id"));
        sic.add(new SelectorItemInfo("proposer.number"));
        sic.add(new SelectorItemInfo("dept"));
        sic.add(new SelectorItemInfo("phone"));
        sic.add(new SelectorItemInfo("applyDate"));
        sic.add(new SelectorItemInfo("isMultiEntry"));
        sic.add(new SelectorItemInfo("bizState"));
        sic.add(new SelectorItemInfo("approveState"));
        sic.add(new SelectorItemInfo("submitState"));
        sic.add(new SelectorItemInfo("entries.id"));
        sic.add(new SelectorItemInfo("entries.beginTime"));
        sic.add(new SelectorItemInfo("entries.endTime"));
        sic.add(new SelectorItemInfo("entries.leaveLength"));
        sic.add(new SelectorItemInfo("entries.type.id"));
        sic.add(new SelectorItemInfo("entries.type.name"));
        sic.add(new SelectorItemInfo("entries.type.number"));
        sic.add(new SelectorItemInfo("entries.type.unitType"));
        sic.add(new SelectorItemInfo("entries.type.decdigital"));
        sic.add(new SelectorItemInfo("entries.type.length"));
        sic.add(new SelectorItemInfo("entries.type.dataType"));
        sic.add(new SelectorItemInfo("entries.type.lastUnit"));
        sic.add(new SelectorItemInfo("entries.reason"));
        sic.add(new SelectorItemInfo("entries.remark"));
        sic.add(new SelectorItemInfo("entries.person.id"));
        sic.add(new SelectorItemInfo("entries.person.number"));
        sic.add(new SelectorItemInfo("entries.person.name"));
        sic.add(new SelectorItemInfo("entries.org.id"));
        sic.add(new SelectorItemInfo("entries.org.name"));
        return sic;
    }

    protected void kdtEntries_editStopped(KDTEditEvent e) throws Exception {
        TimeAttendanceInfo type;
        PersonInfo pInfo = null;
        IRow row = null;
        int colIndex = e.getColIndex();
        row = this.kdtEntries.getRow(e.getRowIndex());
        if (colIndex == this.kdtEntries.getColumn("person").getColumnIndex()) {
            TimeAttendanceInfo leaveItem;
            pInfo = (PersonInfo)e.getValue();
            if (pInfo != null && pInfo.getId() != null) {
                String personId = pInfo.getId().toString();
                row.getCell("dept").setValue((Object)this.getDeptByPerson(personId));
                row.getCell("adminOrg").setValue((Object)this.getAdminOrgByPerson(personId));
                if (e.getRowIndex() == 0) {
                    TimeAttendanceInfo leaveItem2 = HRTimeClientUtils.getAffairLeaveItem();
                    row.getCell("type").setValue((Object)leaveItem2);
                    Date date = HRTimeClientUtils.getTrucateDate(new Date());
                    row.getCell("beginDate").setValue((Object)date);
                    row.getCell("endDate").setValue((Object)date);
                    row.getCell("unit").setValue((Object)leaveItem2.getUnitType().getAlias());
                    row.getCell("leaveLength").setEditor(TimeUtil.getFloatCellEditor(Float.valueOf("0.00"), Float.valueOf("99999.99"), leaveItem2.getDecDigital()));
                    row.getCell("leaveLength").getStyleAttributes().setNumberFormat(HRTimeClientUtils.getDecimalFormatStr(leaveItem2.getDecDigital()));
                } else {
                    IRow firstRow = this.kdtEntries.getRow(0);
                    if (firstRow != null) {
                        if (firstRow.getCell("type").getValue() != null) {
                            row.getCell("type").setValue(firstRow.getCell("type").getValue());
                            row.getCell("unit").setValue(firstRow.getCell("unit").getValue());
                        }
                        if (firstRow.getCell("beginDate").getValue() != null) {
                            row.getCell("beginDate").setValue(firstRow.getCell("beginDate").getValue());
                        }
                        if (firstRow.getCell("endDate").getValue() != null) {
                            row.getCell("endDate").setValue(firstRow.getCell("endDate").getValue());
                        }
                        if (firstRow.getCell("leaveLength").getValue() != null) {
                            row.getCell("leaveLength").setValue(firstRow.getCell("leaveLength").getValue());
                        }
                    }
                }
            }
            if ((leaveItem = (TimeAttendanceInfo)row.getCell("type").getValue()) != null && leaveItem.getId().toString().equals("00000000-0000-0000-0000-000000000008649E3405")) {
                this.setPromote(pInfo);
            } else {
                this.lblPromote.setText(null);
            }
        }
        if (colIndex == this.kdtEntries.getColumn("type").getColumnIndex() && (type = (TimeAttendanceInfo)e.getValue()) != null) {
            row.getCell("unit").setValue((Object)type.getUnitType().getAlias());
            KDFormattedTextField kft = new KDFormattedTextField();
            if (type.getDataType().equals((Object)ItemDataTypeEnum.INT)) {
                kft.setDataType(0);
                kft.setDataVerifierType(12);
                if (type.getLength() > 0) {
                    kft.setMaximumValue((Comparable)Integer.valueOf(Double.valueOf(Math.pow(10.0, type.getLength())).intValue() - 1));
                }
                kft.setMinimumValue((Comparable)Integer.valueOf(0));
                kft.setPrecision(0);
            } else if (type.getDataType().equals((Object)ItemDataTypeEnum.FLOAT)) {
                kft.setDataType(4);
                kft.setDataVerifierType(12);
                if (type.getLength() >= 0 && type.getDecDigital() >= 0) {
                    kft.setMaximumValue((Comparable)Double.valueOf(Math.pow(10.0, type.getLength()) - this.getPrecisionValue(type.getDecDigital())));
                }
                kft.setMinimumValue((Comparable)Integer.valueOf(0));
                kft.setPrecision(type.getDecDigital());
            }
            row.getCell("leaveLength").setEditor(TimeUtil.getFloatCellEditor(Float.valueOf("0.00"), Float.valueOf("99999.99"), type.getDecDigital()));
            pInfo = (PersonInfo)row.getCell("person").getValue();
            if (type.getId().toString().equals("00000000-0000-0000-0000-000000000008649E3405") && pInfo != null) {
                this.setPromote(pInfo);
            } else {
                this.lblPromote.setText(null);
            }
        }
    }

    private double getPrecisionValue(int len) {
        StringBuffer value = new StringBuffer("0.");
        if (len > 0) {
            for (int i = 0; i < len; ++i) {
                if (i == len - 1) {
                    value.append("1");
                    continue;
                }
                value.append("0");
            }
        }
        if (len == 0) {
            return Double.valueOf("1");
        }
        return Double.valueOf(value.toString());
    }

    public void actionLeaveQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionLeaveQuery_actionPerformed(e);
        Object obj = HRTimeClientUtils.getSelectedCellValue(this.kdtEntries, "person");
        if (obj == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        } else {
            String personId = ((PersonInfo)obj).getId().toString();
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"personId", (Object)personId);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(SelfLeaveQueryUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.menuBar.setVisible(false);
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.btnCopy.setEnabled(false);
            this.menuItemCopy.setEnabled(false);
            this.actionCopy.setEnabled(false);
            this.actionSave.setEnabled(false);
            this.actionSubmit.setEnabled(false);
        }
        this.actionEdit.setEnabled(false);
        this.btnEdit.setEnabled(false);
        this.btnEdit.setVisible(false);
        this.btnAttachment.setVisible(true);
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            String HRO_ID;
            IParamControl iParam = ParamControlFactory.getRemoteInstance();
            String val = iParam.getParamValue((IObjectPK)new ObjectUuidPK(HRO_ID = SysContext.getSysContext().getCurrentHRUnit().getId().toString()), "QJ001");
            if ("true".equals(val)) {
                this.comboSubmitType.setSelectedItem((Object)ApproveStateEnum.WORKFLOW);
            } else {
                this.comboSubmitType.setSelectedItem((Object)ApproveStateEnum.DIRECT);
            }
        } else if (OprtState.EDIT.equals(this.getOprtState())) {
            this.txtNumber.setEnabled(this.txtNumberCanModifiyWhenOprtStateEdit());
            if (ApproveStateEnum.DIRECT.equals((Object)this.editData.getApproveState())) {
                if (BizStateEnum.TEMP.equals((Object)this.editData.getBizState())) {
                    this.actionSave.setEnabled(true);
                    this.actionSubmit.setEnabled(true);
                } else if (BizStateEnum.EDIT.equals((Object)this.editData.getBizState())) {
                    this.actionSave.setEnabled(false);
                    this.actionSubmit.setEnabled(true);
                }
            } else if (BizStateEnum.TEMP.equals((Object)this.editData.getBizState())) {
                this.actionSave.setEnabled(true);
                this.actionSubmit.setEnabled(true);
            }
        } else {
            this.actionSave.setEnabled(false);
            this.actionSubmit.setEnabled(false);
        }
        this.kdtEntries.getInputMap().remove(KeyStroke.getKeyStroke("ctrl pressed V"));
        this.kdtEntries.getActionMap().remove("Paste");
        this.kdtEntries.getColumn("adminOrg").getStyleAttributes().setLocked(true);
        if (this.isBOSTypeConfiged()) {
            this.btnCloud.setIcon(FWResourceManager.getIcon((String)"kdCloud.png"));
            this.btnCloud.setVisible(true);
            this.kDSeparatorCloud.setVisible(true);
            this.toolBar.remove((Component)this.btnCloud);
            this.toolBar.remove((Component)this.kDSeparatorCloud);
            this.toolBar.add((Component)this.btnCloud, 1);
            this.toolBar.add((Component)this.kDSeparatorCloud, 2);
            this.toolBar.repaint();
            this.menuItemCloudFeed.setIcon(FWResourceManager.getIcon((String)"kdCloud.png"));
            this.menuItemCloudFeed.setVisible(true);
            this.kdSeparatorFWFile1.setVisible(true);
            this.menuFile.remove((JMenuItem)this.menuItemCloudFeed);
            this.menuFile.remove((Component)this.kdSeparatorFWFile1);
            this.menuFile.add((Component)this.menuItemCloudFeed, 0);
            this.menuFile.add((Component)this.kdSeparatorFWFile1, 1);
        }
    }

    private boolean txtNumberCanModifiyWhenOprtStateEdit() throws Exception {
        boolean isModifiable = true;
        String orgUnitId = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
        boolean result = codingRuleManager.isExist((IObjectValue)this.editData, orgUnitId);
        if (result) {
            isModifiable = codingRuleManager.isModifiable((IObjectValue)this.editData, orgUnitId);
        }
        return isModifiable;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAttachment.setVisible(true);
        this.btnRowAddNew.setIcon(EASResource.getIcon((String)"imgTbtn_userview"));
        this.btnRowDelete.setIcon(EASResource.getIcon((String)"imgTbtn_logoutuser"));
        this.btnCopy.setVisible(true);
        this.btnCopy.setIcon(EASResource.getIcon((String)"imgTbtn_copytotier"));
        this.menuItemCopy.setVisible(true);
        this.menuItemCopy.setIcon(EASResource.getIcon((String)"imgTbtn_copytotier"));
        this.menuItemCopySelect.setVisible(true);
        this.menuItemCopySelect.setIcon(this.menuItemCopy.getIcon());
        this.menuItemSave.setVisible(true);
        this.menuItemPerson.setIcon(EASResource.getIcon((String)"imgTbtn_unforbidPerm"));
        this.menuItemPerson.setEnabled(true);
        this.menuItemWorkflowG.setIcon(EASResource.getIcon((String)"imgTbtn_flowchart"));
        this.menuItemWorkflowG.setEnabled(true);
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.enabledWorkButton(false);
        } else {
            this.enabledWorkButton(true);
        }
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.menuItemFirst.setEnabled(false);
            this.menuItemFirst.setVisible(false);
            this.actionFirst.setEnabled(false);
            this.menuItemPre.setEnabled(false);
            this.menuItemPre.setVisible(false);
            this.actionPre.setEnabled(false);
            this.menuItemNext.setEnabled(false);
            this.menuItemNext.setVisible(false);
            this.actionNext.setEnabled(false);
            this.menuItemLast.setEnabled(false);
            this.menuItemLast.setVisible(false);
            this.actionLast.setEnabled(false);
            this.separator1.setVisible(false);
        }
        this.btnAffairReg.setEnabled(false);
        this.btnAffairReg.setVisible(false);
        this.btnRemove.setVisible(false);
    }

    private void enabledWorkButton(boolean isEnabled) {
        this.btnCopy.setEnabled(isEnabled);
        this.menuItemCopy.setEnabled(isEnabled);
        this.actionCopy.setEnabled(isEnabled);
        this.menuItemCopySelect.setEnabled(isEnabled);
        this.btnCopySelect.setEnabled(isEnabled);
        this.actionCopySelect.setEnabled(isEnabled);
        this.menuItemSave.setEnabled(isEnabled);
        this.btnSave.setEnabled(isEnabled);
        this.actionSave.setEnabled(isEnabled);
    }

    public void actionAddPerson_actionPerformed(ActionEvent e) throws Exception {
        EmployeeMultiF7PromptBox f7 = new EmployeeMultiF7PromptBox((IUIObject)this);
        this.setF7Filter(f7);
        f7.setModal(true);
        f7.setIsSingleSelect(false);
        f7.showNoPositionPerson(true);
        f7.setUserOrgRangeFilter(true);
        f7.setReturnPositionAndUnit(false);
        HashSet<BOSUuid> set = new HashSet<BOSUuid>();
        set.add(SysContext.getSysContext().getCurrentHRUnit().getId());
        f7.setHROFilter(set);
        f7.setIsPluralityIsChooseContral(false);
        f7.show();
        if (!f7.isCanceled()) {
            if (f7.getData() instanceof Object[]) {
                Object[] obj = (Object[])f7.getData();
                if (obj == null || obj.length <= 0) {
                    return;
                }
                PersonInfo personInfo = null;
                int size = obj.length;
                for (int i = 0; i < size; ++i) {
                    personInfo = (PersonInfo)obj[i];
                    this.fillKdtEntryTable(personInfo);
                }
                this.kdtEntries.getSelectManager().select(0, 0);
            }
            if (f7.getData() instanceof PersonInfo) {
                this.fillKdtEntryTable((PersonInfo)f7.getData());
                this.kdtEntries.getSelectManager().select(0, 0);
            }
        }
    }

    private void setF7Filter(EmployeeMultiF7PromptBox pmt) throws Exception {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)"1"));
        filter.getFilterItems().add(new FilterItemInfo("user", (Object)SysContext.getSysContext().getCurrentUserInfo().getId().toString()));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        IUserPermission iup = UserPermissionFactory.getRemoteInstance();
        UserPermissionCollection collection = iup.getUserPermissionCollection(viewInfo);
        String filterString = null;
        if (collection != null && collection.size() > 0) {
            filterString = collection.get(0).getFilter();
        }
        if (filterString == null) {
            return;
        }
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.emp.app", "EmpInfoQuery");
        IQueryExecutor iQe = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        filter = new FilterInfo(filterString);
        viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        viewInfo.setSelector(sic);
        iQe.setObjectView(viewInfo);
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)iQe.getSQL(), CompareType.INNER));
        pmt.setNopositionPersonFilter(filter);
    }

    private void fillKdtEntryTable(PersonInfo info) throws Exception {
        if (info == null) {
            return;
        }
        ICell iCell = null;
        IRow iRow = null;
        int length = this.kdtEntries.getRowCount();
        for (int i = 0; i < length; ++i) {
            iCell = this.kdtEntries.getRow(i).getCell("person");
            if (iCell.getValue() == null || !iCell.getValue().toString().equalsIgnoreCase(info.getId().toString())) continue;
            return;
        }
        iRow = this.kdtEntries.addRow();
        iCell = iRow.getCell("person");
        iCell.setValue((Object)info);
        KDComboBox combo = (KDComboBox)this.kdtEntries.getColumn("type").getEditor().getComponent();
        TimeAttendanceInfo item = null;
        TimeAttendanceInfo leaveItem = null;
        int size = combo.getItemCount();
        for (int i = 0; i < size; ++i) {
            item = (TimeAttendanceInfo)combo.getItemAt(i);
            if (!item.getId().toString().equals("00000000-0000-0000-0000-000000000011649E3405")) continue;
            leaveItem = item;
            break;
        }
        if (iCell.getColumnIndex() == this.kdtEntries.getColumn("person").getColumnIndex()) {
            TimeAttendanceInfo typeItem;
            if (info != null && info.getId() != null) {
                String personId = info.getId().toString();
                iRow.getCell("dept").setValue((Object)this.getDeptByPerson(personId));
                iRow.getCell("adminOrg").setValue((Object)this.getAdminOrgByPerson(personId));
                if (leaveItem != null) {
                    iRow.getCell("type").setValue((Object)leaveItem);
                }
                Date date = HRTimeClientUtils.getTrucateDate(new Date());
                iRow.getCell("beginDate").setValue((Object)date);
                iRow.getCell("endDate").setValue((Object)date);
                if (leaveItem != null) {
                    iRow.getCell("unit").setValue((Object)leaveItem.getUnitType().getAlias());
                    iRow.getCell("leaveLength").setEditor(TimeUtil.getFloatCellEditor(Float.valueOf("0.00"), Float.valueOf("99999.99"), leaveItem.getDecDigital()));
                    iRow.getCell("leaveLength").getStyleAttributes().setNumberFormat(HRTimeClientUtils.getDecimalFormatStr(leaveItem.getDecDigital()));
                }
            }
            if ((typeItem = (TimeAttendanceInfo)iRow.getCell("type").getValue()) != null && typeItem.getId().toString().equals("00000000-0000-0000-0000-000000000008649E3405")) {
                this.setPromote(info);
            } else {
                this.lblPromote.setText(null);
            }
        }
    }

    public void actionDelPerson_actionPerformed(ActionEvent e) throws Exception {
        if (this.kdtEntries.getRowCount() <= 0) {
            return;
        }
        int[] selectRows = LeaveBillEditUI.getSelectedRows(this.kdtEntries);
        this.kdtEntries.getSelectManager().setSelectMode(10);
        for (int i = selectRows.length - 1; i >= 0; --i) {
            this.kdtEntries.removeRow(selectRows[i]);
        }
    }

    public static int[] getSelectedRows(KDTable table) {
        if (table.getSelectManager().size() == 0) {
            return new int[0];
        }
        TreeSet<Integer> set = new TreeSet<Integer>();
        for (int i = 0; i < table.getSelectManager().size(); ++i) {
            IBlock block = KDTBlock.change((KDTable)table, (IBlock)table.getSelectManager().get(i));
            for (int j = block.getTop(); j <= block.getBottom(); ++j) {
                set.add(j);
            }
        }
        int[] rows = new int[set.size()];
        Iterator iter = set.iterator();
        int k = 0;
        while (iter.hasNext()) {
            rows[k++] = (Integer)iter.next();
        }
        return rows;
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        KDTSelectBlock sb = null;
        int size = this.kdtEntries.getSelectManager().size();
        if (size > 0) {
            sb = this.kdtEntries.getSelectManager().get(0);
            ICell iCell = null;
            int row = sb.getTop();
            if (row < 0) {
                return;
            }
            int column = sb.getLeft();
            IColumn iColumn = this.kdtEntries.getColumn(column);
            if (iColumn.getStyleAttributes().isLocked()) {
                return;
            }
            Object value = this.kdtEntries.getCell(row, column).getValue();
            int length = this.kdtEntries.getRowCount();
            for (int i = 0; i < length; ++i) {
                if (i == row || this.kdtEntries.getCell(i, column).getStyleAttributes().isLocked()) continue;
                iCell = this.kdtEntries.getCell(i, column);
                iCell.setValue(value);
            }
        }
    }

    public void actionAffairReg_actionPerformed(ActionEvent e) throws Exception {
        if (this.kdtEntries.getRowCount() == 0) {
            return;
        }
        KDTSelectBlock sb = null;
        int size = this.kdtEntries.getSelectManager().size();
        if (this.billId == null) {
            this.billId = this.editData.getId().toString();
        }
        if (size > 0) {
            sb = this.kdtEntries.getSelectManager().get(0);
            int row = sb.getTop();
            Object value = this.kdtEntries.getCell(row, 0).getValue();
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("person.name", value));
            filter.getFilterItems().add(new FilterItemInfo("bill.id", (Object)this.billId));
            filter.setMaskString(" #0 and #1 ");
            ev.setFilter(filter);
            TimeEntryBaseCollection leaveCols = LeaveBillEntryFactory.getRemoteInstance().getTimeEntryBaseCollection(ev);
            if (leaveCols != null && leaveCols.size() > 0) {
                this.actPersonId = ((LeaveBillEntryInfo)leaveCols.get(0)).getPerson().getId();
            }
        }
        if (this.actPersonId != null) {
            DataProvider data = new DataProvider();
            this.appHlp.printPreview(LEAVE_FILENAME, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)(this.resClass + "NO_SELECT_ROW")));
        }
    }

    protected String getWFActionName() {
        return "ActionSubmit";
    }

    protected String getWFUIFuctionName() {
        return "com.kingdee.eas.hr.time.LeaveBillBizFunction";
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
        this.btnRowDelete.setVisible(true);
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
        this.btnRowDelete.setVisible(true);
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
        this.btnRowDelete.setVisible(true);
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
        this.btnRowDelete.setVisible(true);
    }

    protected void applyDefaultValue(IObjectValue vo) {
    }

    protected String getEditUIName() {
        return null;
    }

    protected OrgType getMainBizOrgType() {
        return null;
    }

    protected String getTDFileName() {
        return null;
    }

    protected IMetaDataPK getTDQueryPK() {
        return null;
    }

    protected void recycleNumberByOrg(IObjectValue editData, String orgType, String number) {
    }

    protected void removeByPK(IObjectPK pk) throws Exception {
    }

    protected void setAutoNumberByOrg(String orgType) {
    }

    protected void setFieldsNull(AbstractObjectValue arg0) {
    }

    protected void setOrgF7(KDBizPromptBox f7, OrgType orgType) throws Exception {
    }

    public boolean checkBeforeWindowClosing() {
        return super.checkBeforeWindowClosing();
    }

    public boolean isPrepareInit() {
        return true;
    }

    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        String oldOprtState = this.getOprtState();
        if (this.actionAudit.isEnabled()) {
            this.setOprtState(OprtState.EDIT);
        }
        super.actionAttachment_actionPerformed(e);
        if (this.actionAudit.isEnabled()) {
            this.setOprtState(oldOprtState);
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.editData.setApproveState((ApproveStateEnum)((Object)this.comboSubmitType.getSelectedItem()));
        super.actionSubmit_actionPerformed(e);
    }

    private void verifyInputForYC() throws EASBizException, BOSException, Exception {
        String HRO_ID = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
        if (HRParamUtil.getParamOfHR(null, (String)"Is_allow_leave", (String)HRO_ID)) {
            IRow row = null;
            PersonInfo personInfo = null;
            TimeAttendanceInfo timeAttendanceInfo = null;
            BigDecimal LeaveLength = new BigDecimal("0.0");
            String unitTypeString = TimeServerUtils.getTimeAttendanceType(null);
            int size = this.kdtEntries.getRowCount();
            for (int i = 0; i < size; ++i) {
                row = this.kdtEntries.getRow(i);
                personInfo = (PersonInfo)row.getCell("person").getValue();
                timeAttendanceInfo = (TimeAttendanceInfo)row.getCell("type").getValue();
                if (timeAttendanceInfo != null && !timeAttendanceInfo.getId().toString().equals("00000000-0000-0000-0000-000000000008649E3405")) continue;
                if (row.getCell("leaveLength").getValue() != null && !row.getCell("leaveLength").getValue().toString().trim().equals("")) {
                    LeaveLength = new BigDecimal(row.getCell("leaveLength").getValue().toString());
                }
                String name = personInfo.getName();
                String personId = personInfo.getId().toString();
                BigDecimal b = HRTimeClientUtils.getYearHoliday(personId);
                if (b.compareTo(new BigDecimal("0.0")) == 0) {
                    String msg = EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"69_LeaveBillEditUI");
                    msg = msg.replaceAll(msg.substring(5, 6), unitTypeString);
                    msg = name + msg;
                    MsgBox.showInfo((Component)((Object)this), (String)msg);
                    SysUtil.abort();
                }
                ArrayList<String> lstPersonID = new ArrayList<String>();
                lstPersonID.add(personId);
                Map map = LeaveDetailFactory.getRemoteInstance().getOnAuditVacation(lstPersonID);
                BigDecimal b1 = new BigDecimal("0.0");
                if (map.get(personId) != null) {
                    b1 = new BigDecimal(map.get(personId).toString());
                }
                if (!(b.subtract(b1).subtract(LeaveLength).floatValue() < 0.0f)) continue;
                String msg = EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"70_LeaveBillEditUI");
                msg = msg.replaceAll(msg.substring(3, 4), unitTypeString);
                msg = name + msg;
                MsgBox.showInfo((Component)((Object)this), (String)msg);
                SysUtil.abort();
            }
        }
    }

    private Map getLeaveLengthForPerID() {
        LeaveBillEntryInfo info = null;
        PersonInfo perInfo = null;
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        int size = this.editData.getEntries().size();
        for (int i = 0; i < size; ++i) {
            info = this.editData.getEntries().get(i);
            perInfo = info.getPerson();
            if (perInfo == null || perInfo.getId() == null || info.getType() == null || !info.getType().getId().toString().equals("00000000-0000-0000-0000-000000000008649E3405")) continue;
            map.put(perInfo.getId().toString(), info.getLeaveLength());
        }
        return map;
    }

    private String CurrCanUser(String personId) throws Exception {
        BigDecimal b = HRTimeClientUtils.getYearHoliday(personId);
        if (b.compareTo(new BigDecimal("0.0")) == 0) {
            return b.toString();
        }
        String HRO_ID = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
        if (HRParamUtil.getParamOfHR(null, (String)"Is_allow_leave", (String)HRO_ID)) {
            ArrayList<String> lstPersonID = new ArrayList<String>();
            lstPersonID.add(personId);
            Map map = LeaveDetailFactory.getRemoteInstance().getOnAuditVacation(lstPersonID);
            BigDecimal b1 = new BigDecimal("0.0");
            if (map.get(personId) != null) {
                b1 = new BigDecimal(map.get(personId).toString());
            }
            return b + EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"71_LeaveBillEditUI") + b1.setScale(1);
        }
        return b.toString();
    }

    public IObjectPK runSubmit() throws Exception {
        this.verivfInputZeroNumber();
        this.verifyInputForYC();
        return super.runSubmit();
    }

    protected void doBeforeSubmitForWF(CoreBaseInfo editData) throws Exception {
        super.doBeforeSubmitForWF(editData);
    }

    private void verivfInputZeroNumber() {
        IRow row = null;
        BigDecimal LeaveLength = new BigDecimal("0.0");
        int size = this.kdtEntries.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.kdtEntries.getRow(i);
            if (row.getCell("leaveLength").getValue() != null && !row.getCell("leaveLength").getValue().toString().trim().equals("")) {
                LeaveLength = new BigDecimal(row.getCell("leaveLength").getValue().toString());
            }
            if (LeaveLength.floatValue() != 0.0f) continue;
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"86_inputZeroLeavelDay"));
            SysUtil.abort();
        }
    }

    protected boolean isModifySave() {
        return this.getOprtState().equals(OprtState.ADDNEW) || this.editData.getSubmitState().getValue() == SubmitStateEnum.NO_SUBMIT.getValue();
    }

    protected String getCurrentBillID() {
        if (this.editData != null && this.editData.getId() != null) {
            return this.editData.getId().toString();
        }
        return null;
    }

    protected String getCurrentBillNumber() {
        if (this.editData != null && this.editData.getNumber() != null) {
            return this.editData.getNumber().toString();
        }
        return null;
    }

    public boolean isShowWeiBoSideBar() throws BOSException, EASBizException {
        return this.isBOSTypeConfiged();
    }

    protected BOSObjectType getBOSObjectType() {
        if (this.editData != null) {
            return this.editData.getBOSType();
        }
        return null;
    }

    protected void doAfterSave(IObjectPK pk) throws Exception {
        super.doAfterSave(pk);
        if (super.isSave()) {
            this.feedToWeibo();
        }
    }

    private void feedToWeibo() throws BOSException, EASBizException {
        this.createFeed();
        WeiboBizUtil.updateBillDigest((String)this.getCurrentBillID());
    }

    protected void doAfterSubmit(IObjectPK pk) throws Exception {
        super.doAfterSubmit(pk);
        if (super.isSave()) {
            this.feedToWeibo();
        }
    }

    protected String getCurrentBillStatus() {
        String sta = "";
        if (super.isSave()) {
            sta = "\u5b8c\u6210";
        }
        return sta;
    }

    private IObjectValue getBizInfo4Wf() {
        try {
            IObjectValue copy = this.createCopy(this.editData);
            Enumeration e = this.editData.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                Object value = this.editData.get(key);
                if (value == null || value instanceof IObjectCollection) continue;
                copy.put(key, value);
            }
            return copy;
        }
        catch (Exception e) {
            return this.editData;
        }
    }

    private IObjectValue createCopy(CoreBillBaseInfo editData) throws Exception {
        IObjectValue copy = (IObjectValue)editData.getClass().newInstance();
        if (copy instanceof ICommonBOSType) {
            IMetaDataPK pk = ((ICommonBOSType)editData).getPK();
            ((ICommonBOSType)copy).setPK(pk);
            ((ICommonBOSType)copy).setBOSType(editData.getBOSType());
        }
        return copy;
    }

    public void onShow() throws Exception {
        super.onShow();
        if (!this.isWeiBoEnabled()) {
            return;
        }
        if (this.isBOSTypeConfiged()) {
            this.btnCloudShare.setVisible(true);
            this.btnCloudShare.setIcon(FWResourceManager.getIcon((String)"tbtn_share.gif"));
        }
    }

    public class DataProvider
    implements BOSQueryDelegate {
        public IRowSet execute(BOSQueryDataSource ds) {
            try {
                IAffairRegFacade iAffairReg = AffairRegFacadeFactory.getRemoteInstance();
                if (ds.getID() != null) {
                    if (ds.getID().equals("ds12")) {
                        return iAffairReg.getLeaveBillByPerson(LeaveBillEditUI.this.actPersonId, BOSUuid.read((String)LeaveBillEditUI.this.billId));
                    }
                    if (ds.getID().equals("ds13")) {
                        return iAffairReg.getLeaveApproveDecByPerson(LeaveBillEditUI.this.actPersonId, BOSUuid.read((String)LeaveBillEditUI.this.billId));
                    }
                    if (ds.getID().equals("ds14")) {
                        return iAffairReg.getLeaveApproveIDecByPerson(LeaveBillEditUI.this.actPersonId, BOSUuid.read((String)LeaveBillEditUI.this.billId));
                    }
                }
            }
            catch (Exception e) {
                LeaveBillEditUI.this.handUIException(e);
            }
            return null;
        }
    }
}

