/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.time.client;

import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.base.client.util.HRClientUtil;
import com.kingdee.eas.hr.time.HRTimeException;
import com.kingdee.eas.hr.time.LeaveBillFactory;
import com.kingdee.eas.hr.time.ReportToStateEnum;
import com.kingdee.eas.hr.time.client.AbstractLeaveBillListUI;
import com.kingdee.eas.hr.time.client.HRTimeClientUtils;
import com.kingdee.eas.hr.time.client.LeaveBillEditUI;
import com.kingdee.eas.hr.time.client.LeaveBillSelfEditUI;
import com.kingdee.eas.hr.time.client.LeaveReportBillEditUI;
import com.kingdee.eas.hr.time.client.LeaveReportBillListUI;
import com.kingdee.eas.hr.time.client.LeaveReportBillSelfEditUI;
import com.kingdee.eas.hr.time.client.SelfLeaveQueryUI;
import com.kingdee.eas.hr.time.client.TimeUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Map;
import javax.swing.JFrame;

public class LeaveBillListUI
extends AbstractLeaveBillListUI {
    private static final long serialVersionUID = -61166L;
    protected boolean isSelf = false;
    protected boolean isForReport = false;

    public String[] getMergeColumnKeys() {
        return new String[]{"id", "number", "proposer.name", "dept", "applyDate", "bizState", "phone", "isMultiEntry", "reportState"};
    }

    public LeaveBillListUI() throws Exception {
        HRClientUtil.checkCurrentHRUnitNotNull((CoreUI)this);
    }

    protected void initUIP() {
        super.initUIP();
        this.setMainQuery();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnLeaveQuery.setIcon(EASResource.getIcon((String)"imgTbtn_showlist"));
        this.btnReportTo.setIcon(EASResource.getIcon((String)"imgTbtn_cancelholiday"));
        this.btnReportList.setIcon(EASResource.getIcon((String)"imgTbtn_copyline"));
        this.menuItemLeaveQuery.setIcon(EASResource.getIcon((String)"imgTbtn_showlist"));
        this.menuItemReport.setIcon(EASResource.getIcon((String)"imgTbtn_cancelholiday"));
        this.menuItemReportList.setIcon(EASResource.getIcon((String)"imgTbtn_copyline"));
        this.menuItemAudit.setIcon(EASResource.getIcon((String)"imgTbtn_audit"));
        this.menuItemAuditResult.setIcon(EASResource.getIcon((String)"imgTbtn_multapproveresult"));
        this.menuBiz.setVisible(false);
        this.menuItemReportList.setVisible(false);
        this.menuItemWorkFlowG.setIcon(EASResource.getIcon((String)"imgTbtn_flowchart"));
    }

    protected ICoreBase getBizInterface() throws Exception {
        return LeaveBillFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        if (this.isAddNew) {
            if (this.isSelf) {
                return LeaveBillSelfEditUI.class.getName();
            }
            return LeaveBillEditUI.class.getName();
        }
        Boolean isMulti = (Boolean)this.getCellValue("isMultiEntry");
        if (isMulti == null) {
            if (this.isSelf) {
                return LeaveBillSelfEditUI.class.getName();
            }
            return LeaveBillEditUI.class.getName();
        }
        if (isMulti.booleanValue()) {
            return LeaveBillEditUI.class.getName();
        }
        return LeaveBillSelfEditUI.class.getName();
    }

    protected String getReportUIName() {
        Boolean isMulti = (Boolean)this.getCellValue("isMultiEntry");
        if (isMulti == null) {
            if (this.isSelf) {
                return LeaveReportBillSelfEditUI.class.getName();
            }
            return LeaveReportBillEditUI.class.getName();
        }
        if (isMulti.booleanValue()) {
            return LeaveReportBillEditUI.class.getName();
        }
        return LeaveReportBillSelfEditUI.class.getName();
    }

    protected boolean isAllowDefaultSolutionNull() {
        return true;
    }

    public void actionLeaveQuery_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String personId = (String)this.getCellValue("person.id");
        if (personId == null) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"personId", (Object)personId);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(SelfLeaveQueryUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
    }

    public void actionReportTo_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkCanReportTo();
        this.doReportTo();
    }

    public void doReportTo() throws Exception {
        IUIObject ownerUiObject;
        Map ownerContext;
        Object ownersOwner;
        UIContext uiContext = new UIContext((Object)this);
        String leaveBillId = this.getSelectedKeyValue();
        uiContext.put((Object)"leaveBillId", (Object)leaveBillId);
        Object owner = uiContext.get((Object)"Owner");
        String ui = this.getReportUIName();
        String type = "com.kingdee.eas.base.uiframe.client.UINewTabFactory";
        if (owner instanceof IUIObject && ((ownersOwner = (ownerContext = (ownerUiObject = (IUIObject)owner).getUIContext()).get("OwnerWindow")) == null || !(ownersOwner instanceof JFrame))) {
            type = "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)type).create(ui, (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
    }

    protected void checkCanReportTo() throws Exception {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock != null) {
            int rowIndex = selectBlock.getTop();
            IRow row = this.tblMain.getRow(rowIndex);
            BizEnumValueInfo enumInfo = (BizEnumValueInfo)row.getCell("reportState").getValue();
            int state = Integer.parseInt(enumInfo.getValue().toString());
            String msg = null;
            switch (state) {
                case 3: {
                    msg = ReportToStateEnum.INPROGRESS.getAlias();
                    break;
                }
                case 1: {
                    msg = ReportToStateEnum.COMPLETE.getAlias();
                    break;
                }
                case 0: {
                    msg = ReportToStateEnum.STOP.getAlias();
                    break;
                }
            }
            if (msg != null) {
                throw new HRTimeException(HRTimeException.LEAVEBILL_CAN_NOT_REPORTTO, new Object[]{msg});
            }
        }
    }

    protected boolean confirmReportTo() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.time.LeaveBillResource.Confirm_ReportTo")));
    }

    public void actionReportList_actionPerformed(ActionEvent e) throws Exception {
        IUIObject ownerUiObject;
        Map ownerContext;
        Object ownersOwner;
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"isSelf", (Object)this.isSelf);
        Object owner = uiContext.get((Object)"Owner");
        String ui = LeaveReportBillListUI.class.getName();
        String type = "com.kingdee.eas.base.uiframe.client.UINewTabFactory";
        if (owner instanceof IUIObject && ((ownersOwner = (ownerContext = (ownerUiObject = (IUIObject)owner).getUIContext()).get("OwnerWindow")) == null || !(ownersOwner instanceof JFrame))) {
            type = "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)type).create(ui, (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }

    protected void getUIState() {
        Object obj = this.getUIContext().get("isSelf");
        this.isSelf = obj == null ? this.getUIContext().get("UIClassParam") == null : (Boolean)obj;
    }

    protected void setMainQuery() {
    }

    protected void setActionByQuery() {
        if (this.mainQueryPK.getFullName().equals("com.kingdee.eas.hr.time.app.LeaveBillQuery")) {
            this.actionReportTo.setVisible(false);
            this.actionReportList.setVisible(false);
        } else {
            this.actionReportTo.setVisible(true);
            this.actionReportList.setVisible(true);
        }
    }

    protected FilterInfo getDefaultFilterForQuery() {
        this.getUIState();
        if (this.isSelf) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("proposer.id", (Object)this.personId.toString()));
            filter.getFilterItems().add(new FilterItemInfo("isMultiEntry", (Object)Boolean.FALSE));
            filter.setMaskString("#0 and #1");
            return filter;
        }
        return TimeUtil.getHRAndAdminRangeFilterInfo("HROrgUnit.id", "adminOrg.id");
    }

    protected void handlePermissionForItemAction(ItemAction action) {
        if (!this.isSelf) {
            super.handlePermissionForItemAction(action);
        }
    }

    public void onLoad() throws Exception {
        this.getUIState();
        super.onLoad();
        this.setActionByQuery();
        this.tblMain.getColumn("entries.beginTime").getStyleAttributes().setNumberFormat(HRTimeClientUtils.getLongTimePatternStr());
        this.tblMain.getColumn("entries.endTime").getStyleAttributes().setNumberFormat(HRTimeClientUtils.getLongTimePatternStr());
        this.tblMain.getColumn("entries.leaveLength").getStyleAttributes().setNumberFormat("0.00");
        this.tblMain.getColumn("entries.leaveLength").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.actionReportTo.setEnabled(true);
    }

    protected boolean canUpdate() throws Exception {
        return true;
    }

    protected void setEditAction() throws Exception {
        super.setEditAction();
        this.tbl_select();
    }

    private boolean isSelfBill() {
        boolean value = false;
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock != null && selectBlock.getTop() != -1) {
            int rowIndex = selectBlock.getTop();
            IRow row = this.tblMain.getRow(rowIndex);
            String personId = (String)row.getCell("proposer.id").getValue();
            if (this.personId == null) {
                return value;
            }
            value = personId.equals(this.personId.toString());
        }
        return value;
    }

    private boolean isValidReportState() {
        boolean value = false;
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock != null && selectBlock.getTop() != -1) {
            int rowIndex = selectBlock.getTop();
            IRow row = this.tblMain.getRow(rowIndex);
            BizEnumValueInfo enumInfo = (BizEnumValueInfo)row.getCell("reportState").getValue();
            int state = Integer.parseInt(enumInfo.getValue().toString());
            value = state == 4 ? true : (state = Integer.parseInt((enumInfo = (BizEnumValueInfo)row.getCell("bizState").getValue()).getValue().toString())) == 3;
        }
        return value;
    }

    private void tbl_select() throws Exception {
        if (this.isSelfBill() && this.isValidReportState()) {
            this.actionReportTo.setEnabled(true);
        } else {
            this.actionReportTo.setEnabled(false);
        }
    }

    public IMetaDataPK getMetaDataPK() {
        if (!this.isSelf) {
            return super.getMetaDataPK();
        }
        return super.getMetaDataPK();
    }

    protected void refresh(ActionEvent e) throws Exception {
        super.refresh(e);
        String nexts = null;
        String msg = null;
        Object[] objs = null;
        msg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_ShowListDataCount_0");
        objs = new Object[]{this.tblMain.getRowCount3()};
        nexts = MessageFormat.format(msg, objs);
        this.setMessageBarText(nexts);
    }

    protected void Remove() throws Exception {
        super.Remove();
        String nexts = null;
        String msg = null;
        Object[] objs = null;
        msg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_ShowListDataCount_0");
        objs = new Object[]{this.tblMain.getRowCount3()};
        nexts = MessageFormat.format(msg, objs);
        this.setMessageBarText(nexts);
    }

    public boolean isPrepareActionReportList() {
        return true;
    }

    public boolean isPrepareActionReportTo() {
        return true;
    }

    public boolean isPrepareInit() {
        return true;
    }

    public IUIActionPostman prepareInit() {
        this.getUIState();
        IUIActionPostman postMan = super.prepareInit();
        RequestContext req = (RequestContext)postMan.getRequestContext();
        if (req == null) {
            req = new RequestContext();
        }
        req.put("isSelf", (Object)this.isSelf);
        postMan.setRequestContext((Serializable)req);
        return postMan;
    }

    public IUIActionPostman prepareQuery(RequestRowSetEvent e) {
        this.getUIState();
        IUIActionPostman postMan = super.prepareQuery(e);
        RequestContext req = (RequestContext)postMan.getRequestContext();
        if (req == null) {
            req = new RequestContext();
        }
        req.put("isSelf", (Object)this.isSelf);
        postMan.setRequestContext((Serializable)req);
        return postMan;
    }

    public boolean isPrepareActionQuery() {
        return true;
    }
}

