/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.time.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ICommonBOSType;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.hr.util.HRParamUtil;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.weibo.util.WeiboBizUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitFactory;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.resource.FWResourceManager;
import com.kingdee.eas.hr.emp.PersonPositionCollection;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.time.ApproveStateEnum;
import com.kingdee.eas.hr.time.BizStateEnum;
import com.kingdee.eas.hr.time.HRTimeException;
import com.kingdee.eas.hr.time.ILeaveBill;
import com.kingdee.eas.hr.time.LeaveBillEntryInfo;
import com.kingdee.eas.hr.time.LeaveBillFactory;
import com.kingdee.eas.hr.time.LeaveBillInfo;
import com.kingdee.eas.hr.time.LeaveDetailException;
import com.kingdee.eas.hr.time.LeaveDetailFactory;
import com.kingdee.eas.hr.time.TimeAttendanceCollection;
import com.kingdee.eas.hr.time.TimeAttendanceInfo;
import com.kingdee.eas.hr.time.client.AbstractLeaveBillSelfEditUI;
import com.kingdee.eas.hr.time.client.HRTimeClientUtils;
import com.kingdee.eas.hr.time.client.SelfLeaveQueryUI;
import com.kingdee.eas.hr.time.client.TimeUtil;
import com.kingdee.eas.hr.time.util.TimeServerUtils;
import com.kingdee.eas.hr.train.client.TrainClientUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;

public class LeaveBillSelfEditUI
extends AbstractLeaveBillSelfEditUI {
    private String prompt;
    private static final long serialVersionUID = -61166L;
    protected BOSUuid entryId;
    private BigDecimal LeaveLength;
    private boolean issubtract;
    private BigDecimal lastUnit;

    public LeaveBillSelfEditUI() throws Exception {
        this.prompt = this.lblPrompt.getText();
        this.entryId = null;
        this.LeaveLength = new BigDecimal("0.00");
        this.issubtract = false;
        this.lastUnit = new BigDecimal("0.00");
    }

    public void onLoad() throws Exception {
        this.kdtEntries.checkParsed();
        this.initTypeCombo();
        super.onLoad();
        this.menuBar.setVisible(false);
        this.actionEdit.setEnabled(false);
        this.btnEdit.setEnabled(false);
        this.btnEdit.setVisible(false);
        this.btnAttachment.setVisible(true);
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            String HRO_ID;
            IParamControl iParam = ParamControlFactory.getRemoteInstance();
            String val = iParam.getParamValue((IObjectPK)new ObjectUuidPK(HRO_ID = SysContext.getSysContext().getCurrentHRUnit().getId().toString()), "QJ001");
            if ("true".equals(val)) {
                this.comboSubmitType.setSelectedItem((Object)ApproveStateEnum.WORKFLOW);
            } else {
                this.comboSubmitType.setSelectedItem((Object)ApproveStateEnum.DIRECT);
            }
        } else if (OprtState.EDIT.equals(this.getOprtState())) {
            if (ApproveStateEnum.DIRECT.equals((Object)this.editData.getApproveState())) {
                if (BizStateEnum.TEMP.equals((Object)this.editData.getBizState())) {
                    this.actionSave.setEnabled(true);
                    this.actionSubmit.setEnabled(true);
                } else if (BizStateEnum.EDIT.equals((Object)this.editData.getBizState())) {
                    this.actionSave.setEnabled(false);
                    this.actionSubmit.setEnabled(true);
                }
            } else if (BizStateEnum.TEMP.equals((Object)this.editData.getBizState())) {
                this.actionSave.setEnabled(true);
                this.actionSubmit.setEnabled(true);
            }
        } else if (OprtState.VIEW.equals(this.getOprtState())) {
            this.actionSave.setEnabled(false);
            this.actionSubmit.setEnabled(false);
        } else {
            this.actionSave.setEnabled(false);
            this.actionSubmit.setEnabled(false);
        }
        this.promptOrg.setEnabled(false);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnNextPerson.setEnabled(true);
        this.btnNextPerson.setVisible(true);
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.btnSave.setEnabled(false);
            this.btnSubmit.setEnabled(false);
        }
        this.menuItemWorkflowG.setIcon(EASResource.getIcon((String)"imgTbtn_flowchart"));
        if ("self".equals(this.getUIContext().get("fromList"))) {
            this.actionAudit.setEnabled(false);
            this.btnAudit.setEnabled(false);
            this.btnAudit.setVisible(false);
        }
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        if (this.comboType.getSelectedItem() == null) {
            this.comboType.requestFocusInWindow();
            throw new HRTimeException(HRTimeException.LEAVE_TYPE_NOT_NULL);
        }
        if (StringUtils.isEmpty((String)this.txtLeaveLength.getText())) {
            this.txtLeaveLength.requestFocusInWindow();
            throw new HRTimeException(HRTimeException.LEAVE_LENGTH_NOT_NULL);
        }
        BigDecimal b1 = (BigDecimal)this.txtLeaveLength.getValue();
        if (b1.floatValue() == 0.0f) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"86_inputZeroLeavelDay"));
            SysUtil.abort();
        }
        if (this.txtReason.getText() == null || this.txtReason.getText().trim().length() == 0) {
            this.txtReason.requestFocusInWindow();
            throw new HRTimeException(HRTimeException.LEAVE_REASON_NOT_NULL);
        }
        if (this.pkBeginDate.getValue() == null) {
            this.pkBeginDate.requestFocusInWindow();
            throw new LeaveDetailException(LeaveDetailException.BEGINTIME_NULL);
        }
        if (this.pkBeginTime.getValue() == null) {
            this.pkBeginTime.requestFocusInWindow();
            throw new LeaveDetailException(LeaveDetailException.BEGINTIME_NULL);
        }
        if (this.pkEndDate.getValue() == null) {
            this.pkEndDate.requestFocusInWindow();
            throw new LeaveDetailException(LeaveDetailException.ENDTIME_NULL);
        }
        if (this.pkEndTime.getValue() == null) {
            this.pkEndTime.requestFocusInWindow();
            throw new LeaveDetailException(LeaveDetailException.ENDTIME_NULL);
        }
        Timestamp beginDate = HRTimeClientUtils.getTime(this.pkBeginDate, this.pkBeginTime);
        Timestamp endDate = HRTimeClientUtils.getTime(this.pkEndDate, this.pkEndTime);
        if (((Date)beginDate).getTime() > ((Date)endDate).getTime()) {
            this.pkEndDate.requestFocusInWindow();
            throw new LeaveDetailException(LeaveDetailException.DATEERROR);
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return LeaveBillFactory.getRemoteInstance();
    }

    protected void lockUIForViewStatus() {
        super.lockUIForViewStatus();
        this.pkBeginDate.setEnabled(false);
        this.pkEndDate.setEnabled(false);
        this.pkBeginTime.setEnabled(false);
        this.pkEndTime.setEnabled(false);
        this.comboType.setEnabled(false);
    }

    public void initUIMenuBarLayout() {
        super.initUIMenuBarLayout();
        this.btnLeaveQuery.setIcon(EASResource.getIcon((String)"imgTbtn_showlist"));
    }

    protected BOSObjectType getBillBOSType() {
        return new LeaveBillInfo().getBOSType();
    }

    protected IObjectValue createNewData() {
        LeaveBillInfo info = new LeaveBillInfo();
        info.setIsMultiEntry(false);
        try {
            info.setApplyDate(DateTimeUtils.truncateDate((Date)TimeUtil.getServerTime()));
            info.setAdminOrg(this.getAdminOrg());
        }
        catch (Exception e) {
            super.handleException(e);
        }
        info.setHrOrgUnit(SysContext.getSysContext().getCurrentHRUnit());
        LeaveBillEntryInfo entry = new LeaveBillEntryInfo();
        entry.setBeginTime(new Timestamp(DateTimeUtils.truncateDate((Date)new Date()).getTime()));
        entry.setEndTime(new Timestamp(DateTimeUtils.truncateDate((Date)new Date()).getTime()));
        TrainClientUtil.checkValidPerson((CoreUI)this);
        entry.setPerson(SysContext.getSysContext().getCurrentUserInfo().getPerson());
        entry.setType((TimeAttendanceInfo)this.comboType.getSelectedItem());
        info.getEntries().add(entry);
        return info;
    }

    private void initTypeCombo() throws Exception {
        int i;
        TimeAttendanceCollection c = HRTimeClientUtils.getSimpleLeaveItems();
        ItemListener[] listener = this.comboType.getItemListeners();
        for (int i2 = 0; i2 < listener.length; ++i2) {
            this.comboType.removeItemListener(listener[i2]);
        }
        DefaultComboBoxModel<TimeAttendanceInfo> model = new DefaultComboBoxModel<TimeAttendanceInfo>();
        int size = c.size();
        for (i = 0; i < size; ++i) {
            model.addElement(c.get(i));
        }
        this.comboType.setModel(model);
        this.comboType.setSelectedIndex(-1);
        this.lblUnit.setText(null);
        for (i = 0; i < listener.length; ++i) {
            this.comboType.addItemListener(listener[i]);
        }
        this.lblPrompt.setVisible(false);
    }

    protected void comboType_itemStateChanged(ItemEvent e) throws Exception {
        Object obj = e.getItem();
        if (obj == null) {
            this.lblPrompt.setVisible(false);
            this.lblUnit.setText(null);
            this.lblPrompt.setText(null);
        } else {
            TimeAttendanceInfo info = (TimeAttendanceInfo)obj;
            this.txtLeaveLength.setMinimumNumber((Number)new BigDecimal("0.00"));
            this.txtLeaveLength.setMaximumNumber((Number)new BigDecimal("99999.99"));
            this.txtLeaveLength.setPrecision(info.getDecDigital());
            this.lblUnit.setText(info.getUnitType().getAlias());
            if (info.getId().toString().equals("00000000-0000-0000-0000-000000000008649E3405") && this.pInfo != null) {
                String unitTypeString = TimeServerUtils.getTimeAttendanceType(null);
                String msg = this.prompt.replaceFirst("#1", this.CurrCanUser());
                msg = msg.replaceAll(msg.substring(msg.length() - 1), unitTypeString);
                this.lblPrompt.setText(msg);
                this.lblPrompt.setVisible(true);
            } else {
                this.lblPrompt.setText(null);
                this.lblPrompt.setVisible(false);
            }
            this.txtLeaveLength.setPrecision(info.getDecDigital());
            this.lastUnit = info.getLastUnit();
        }
    }

    public void loadFields() {
        super.loadFields();
        if (this.editData.getEntries() != null && this.editData.getEntries().size() > 0) {
            LeaveBillEntryInfo info = this.editData.getEntries().get(0);
            Date beginDate = new Date(info.getBeginTime().getTime());
            Date endDate = new Date(info.getEndTime().getTime());
            this.pkBeginDate.setValue((Object)beginDate);
            this.pkBeginTime.setValue((Object)beginDate);
            this.pkEndDate.setValue((Object)endDate);
            this.pkEndTime.setValue((Object)endDate);
            this.txtReason.setText(info.getReason());
            this.txtRemark.setText(info.getRemark());
            this.txtLeaveLength.setValue((Object)info.getLeaveLength());
            this.LeaveLength = info.getLeaveLength();
            if (this.editData.getBizState().equals((Object)BizStateEnum.EDIT) && info.getType() != null && info.getType().getId().toString().equals("00000000-0000-0000-0000-000000000008649E3405")) {
                this.issubtract = true;
            }
            TimeAttendanceInfo tInfo = null;
            if (this.comboType.getItemCount() == 0) {
                try {
                    this.initTypeCombo();
                }
                catch (Exception e) {
                    super.handleException(e);
                }
            }
            boolean flag = true;
            int size = this.comboType.getItemCount();
            for (int i = 0; i < size; ++i) {
                tInfo = (TimeAttendanceInfo)this.comboType.getItemAt(i);
                if (info.getType() == null || !info.getType().getId().toString().equals(tInfo.getId().toString())) continue;
                this.comboType.setSelectedIndex(i);
                this.txtLeaveLength.setMinimumNumber((Number)new BigDecimal("0.00"));
                this.txtLeaveLength.setMaximumNumber((Number)new BigDecimal("99999.99"));
                this.txtLeaveLength.setPrecision(tInfo.getDecDigital());
                flag = false;
                break;
            }
            if (this.getOprtState() != OprtState.ADDNEW && flag) {
                this.comboType.addItem((Object)info.getType());
                this.comboType.setSelectedIndex(this.comboType.getItemCount() - 1);
                if (info.getType() != null) {
                    this.txtLeaveLength.setMinimumNumber((Number)new BigDecimal("0.00"));
                }
                this.txtLeaveLength.setMaximumNumber((Number)new BigDecimal("99999.99"));
                this.txtLeaveLength.setPrecision(info.getType().getDecDigital());
            }
            this.pInfo = info.getPerson();
            this.personId = this.pInfo.getId();
            this.entryId = info.getId();
            if (this.getOprtState().equals(OprtState.EDIT) && info.getType() != null && info.getType().getId().toString().equals("00000000-0000-0000-0000-000000000008649E3405") && this.pInfo != null) {
                try {
                    this.lblPrompt.setText(this.prompt.replaceFirst("#1", this.CurrCanUser()));
                    String unitTypeString = TimeServerUtils.getTimeAttendanceType(null);
                    String msg = this.lblPrompt.getText();
                    msg = msg.replaceAll(msg.substring(msg.length() - 1), unitTypeString);
                    this.lblPrompt.setText(msg);
                }
                catch (Exception e) {
                    super.handleException(e);
                }
                this.lblPrompt.setVisible(true);
            }
        } else {
            this.pkBeginTime.setValue((Object)HRTimeClientUtils.getTrucateDate((Date)this.pkBeginDate.getValue()));
            this.pkEndTime.setValue((Object)HRTimeClientUtils.getTrucateDate((Date)this.pkEndDate.getValue()));
        }
        super.setAuditActionState();
        try {
            this.setNumberInput();
            if (this.txtNumber.getText() == null) {
                this.txtNumber.setText(this.editData.getNumber());
            }
        }
        catch (Exception e) {
            super.handleException(e);
        }
    }

    public void storeFields() {
        IRow row = null;
        row = OprtState.ADDNEW.equals(this.getOprtState()) && this.kdtEntries.getRowCount() == 0 ? this.kdtEntries.addRow() : this.kdtEntries.getRow(0);
        row.getCell("beginTime").setValue((Object)HRTimeClientUtils.getTime(this.pkBeginDate, this.pkBeginTime));
        row.getCell("endTime").setValue((Object)HRTimeClientUtils.getTime(this.pkEndDate, this.pkEndTime));
        row.getCell("type").setValue(this.comboType.getSelectedItem());
        row.getCell("reason").setValue((Object)this.txtReason.getText());
        row.getCell("remark").setValue((Object)this.txtRemark.getText());
        row.getCell("leaveLength").setValue((Object)this.txtLeaveLength.getBigDecimalValue());
        row.getCell("person").setValue((Object)this.pInfo);
        super.storeFields();
        this.editData.setApproveState((ApproveStateEnum)((Object)this.comboSubmitType.getSelectedItem()));
        this.editData.setProposer(this.pInfo);
        this.editData.setIsMultiEntry(false);
        if (this.editData.getApproveState().getValue() == 0) {
            this.editData.setExtendedProperty("ignoreWorkflow", "true");
        }
    }

    protected void initOnload() throws Exception {
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("adminOrg.id"));
        sic.add(new SelectorItemInfo("adminOrg.name"));
        sic.add(new SelectorItemInfo("adminOrg.number"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("proposer.name"));
        sic.add(new SelectorItemInfo("proposer.id"));
        sic.add(new SelectorItemInfo("proposer.number"));
        sic.add(new SelectorItemInfo("dept"));
        sic.add(new SelectorItemInfo("phone"));
        sic.add(new SelectorItemInfo("applyDate"));
        sic.add(new SelectorItemInfo("isMultiEntry"));
        sic.add(new SelectorItemInfo("bizState"));
        sic.add(new SelectorItemInfo("approveState"));
        sic.add(new SelectorItemInfo("submitState"));
        sic.add(new SelectorItemInfo("entries.id"));
        sic.add(new SelectorItemInfo("entries.beginTime"));
        sic.add(new SelectorItemInfo("entries.endTime"));
        sic.add(new SelectorItemInfo("entries.leaveLength"));
        sic.add(new SelectorItemInfo("entries.type.id"));
        sic.add(new SelectorItemInfo("entries.type.name"));
        sic.add(new SelectorItemInfo("entries.type.number"));
        sic.add(new SelectorItemInfo("entries.type.unitType"));
        sic.add(new SelectorItemInfo("entries.type.decdigital"));
        sic.add(new SelectorItemInfo("entries.reason"));
        sic.add(new SelectorItemInfo("entries.remark"));
        sic.add(new SelectorItemInfo("entries.person.id"));
        sic.add(new SelectorItemInfo("entries.person.number"));
        sic.add(new SelectorItemInfo("entries.person.name"));
        return sic;
    }

    public IObjectPK runSubmit() throws Exception {
        this.verifyInputForYC();
        return ((ILeaveBill)this.getBizInterface()).submit2((CoreBaseInfo)this.editData);
    }

    public void actionLeaveQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionLeaveQuery_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"personId", (Object)this.personId);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(SelfLeaveQueryUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
    }

    protected void initSelfOnload() throws Exception {
    }

    protected void setAuditActionState() {
        super.setAuditActionState();
        boolean flag = this.editData.getBizState().getValue() == 0 || this.editData.getBizState().getValue() == -1;
        this.actionEdit.setEnabled(flag);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.editData.setApproveState((ApproveStateEnum)((Object)this.comboSubmitType.getSelectedItem()));
        String orgid = this.editData.getAdminOrg().getId().toString();
        String sql = "select \"B\".FToUnitID from T_ORG_Admin \"A\" left join T_ORG_UnitRelation \"B\" on \"A\".FID = \"B\".FFromUnitID where \"A\".FIsSealUp = 0 and ((\"B\".FFromUnitID = '" + orgid + "' and FTypeRelationID = '00000000-0000-0000-0000-0000000000100FE9F8B5'))";
        ISQLExecutor iSQL = SQLExecutorFactory.getRemoteInstance((String)sql.toString());
        IRowSet rowSet = iSQL.executeSQL();
        String hrOrgUnitId = null;
        while (rowSet.next()) {
            hrOrgUnitId = rowSet.getString(1);
        }
        if (hrOrgUnitId == null) {
            MsgBox.showInfo((Component)((Object)this), (String)"\u4f60\u6240\u5728\u7684\u884c\u653f\u7ec4\u7ec7\u672a\u59d4\u6258HR\u7ec4\u7ec7\uff0c\u4f60\u4e0d\u80fd\u8fdb\u884c\u8bf7\u5047\u7533\u8bf7\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\uff01");
            SysUtil.abort();
        }
        HROrgUnitInfo hROrgUnitInfo = HROrgUnitFactory.getRemoteInstance().getHROrgUnitInfo((IObjectPK)new ObjectUuidPK(hrOrgUnitId));
        this.editData.setHrOrgUnit(hROrgUnitInfo);
        super.actionSubmit_actionPerformed(e);
    }

    private void verifyInputForYC() throws EASBizException, BOSException, Exception {
        String HRO_ID = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
        if (HRParamUtil.getParamOfHR(null, (String)"Is_allow_leave", (String)HRO_ID) && this.lblPrompt.isVisible()) {
            String name = SysContext.getSysContext().getCurrentUserInfo().getPerson().getName();
            String personId = this.pInfo.getId().toString();
            BigDecimal b = HRTimeClientUtils.getYearHoliday(personId);
            String unitTypeString = TimeServerUtils.getTimeAttendanceType(null);
            if (b.compareTo(new BigDecimal("0.0")) == 0) {
                String msg = EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"69_LeaveBillEditUI");
                msg = msg.replaceAll(msg.substring(5, 6), unitTypeString);
                msg = name + msg;
                MsgBox.showInfo((Component)((Object)this), (String)msg);
                SysUtil.abort();
            }
            ArrayList<String> lstPersonID = new ArrayList<String>();
            lstPersonID.add(personId);
            Map map = LeaveDetailFactory.getRemoteInstance().getOnAuditVacation(lstPersonID);
            BigDecimal b1 = new BigDecimal("0.0");
            if (map.get(personId) != null) {
                b1 = new BigDecimal(map.get(personId).toString());
            }
            if (OprtState.EDIT.equals(this.getOprtState()) && !b1.equals(new BigDecimal("0.0")) && this.issubtract) {
                b1 = b1.subtract(this.LeaveLength);
            }
            BigDecimal b2 = new BigDecimal("0.0");
            if (this.txtLeaveLength.getBigDecimalValue() != null) {
                b2 = this.txtLeaveLength.getBigDecimalValue();
            }
            if (b.subtract(b1).subtract(b2).floatValue() < 0.0f) {
                String msg = EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"70_LeaveBillEditUI");
                msg = msg.replaceAll(msg.substring(3, 4), unitTypeString);
                msg = name + msg;
                MsgBox.showInfo((Component)((Object)this), (String)msg);
                SysUtil.abort();
            }
        }
    }

    protected void setTableCellEditor() throws Exception {
    }

    protected String getWFActionName() {
        return "ActionSubmit";
    }

    protected String getWFUIFuctionName() {
        return "com.kingdee.eas.hr.time.LeaveSelfBillBizFunction";
    }

    public boolean isPrepareActionSubmit() {
        return false;
    }

    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        String oldOprtState = this.getOprtState();
        if (this.actionAudit.isEnabled()) {
            this.setOprtState(OprtState.EDIT);
        }
        super.actionAttachment_actionPerformed(e);
        if (this.actionAudit.isEnabled()) {
            this.setOprtState(oldOprtState);
        }
    }

    private AdminOrgUnitInfo getAdminOrg() throws Exception {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        String userId = SysContext.getSysContext().getCurrentUserInfo().getPerson().getId().toString();
        fi.getFilterItems().add(new FilterItemInfo("person.id", (Object)userId));
        fi.getFilterItems().add(new FilterItemInfo("isPrimary", (Object)1));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("position.id"));
        sic.add(new SelectorItemInfo("position.name"));
        sic.add(new SelectorItemInfo("position.adminOrgUnit.id"));
        sic.add(new SelectorItemInfo("position.adminOrgUnit.name"));
        evi.setFilter(fi);
        evi.setSelector(sic);
        PositionMemberCollection pColl = PositionMemberFactory.getRemoteInstance().getPositionMemberCollection(evi);
        if (pColl.size() > 0) {
            return pColl.get(0).getPosition().getAdminOrgUnit();
        }
        EntityViewInfo evi1 = new EntityViewInfo();
        FilterInfo fi1 = new FilterInfo();
        fi1.getFilterItems().add(new FilterItemInfo("person.id", (Object)userId));
        SelectorItemCollection sic1 = new SelectorItemCollection();
        sic1.add(new SelectorItemInfo("id"));
        sic1.add(new SelectorItemInfo("gkAdmin.id"));
        sic1.add(new SelectorItemInfo("gkAdmin.name"));
        evi1.setFilter(fi1);
        evi1.setSelector(sic1);
        PersonPositionCollection psColl = PersonPositionFactory.getRemoteInstance().getPersonPositionCollection(evi1);
        if (psColl.size() > 0) {
            return psColl.get(0).getGkAdmin();
        }
        return null;
    }

    private String CurrCanUser() throws Exception {
        BigDecimal b = HRTimeClientUtils.getYearHoliday(this.pInfo.getId().toString());
        if (b.compareTo(new BigDecimal("0.0")) == 0) {
            return b.toString();
        }
        String HRO_ID = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
        if (HRParamUtil.getParamOfHR(null, (String)"Is_allow_leave", (String)HRO_ID)) {
            String personId = this.pInfo.getId().toString();
            ArrayList<String> lstPersonID = new ArrayList<String>();
            lstPersonID.add(personId);
            Map map = LeaveDetailFactory.getRemoteInstance().getOnAuditVacation(lstPersonID);
            BigDecimal b1 = new BigDecimal("0.0");
            if (map.get(personId) != null) {
                b1 = new BigDecimal(map.get(personId).toString());
            }
            if (OprtState.EDIT.equals(this.getOprtState()) && this.issubtract) {
                b1 = b1.subtract(this.LeaveLength);
            }
            return b + EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"71_LeaveBillEditUI") + b1.setScale(1);
        }
        return b.toString();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        int b;
        int a;
        super.verifyInput(e);
        BigDecimal LeaveLength = new BigDecimal("0.00");
        if (this.txtLeaveLength.getBigDecimalValue() != null) {
            LeaveLength = this.txtLeaveLength.getBigDecimalValue();
        }
        if (LeaveLength.floatValue() > 0.0f && this.lastUnit != null && this.lastUnit.floatValue() > 0.0f && (a = (int)(LeaveLength.floatValue() * 100.0f)) % (b = (int)(this.lastUnit.floatValue() * 100.0f)) != 0) {
            MsgBox.showInfo((String)(EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"72_LeaveBillSelfEditUI") + this.lastUnit.floatValue() + EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"65_HRTimeClientUtils")));
            this.txtLeaveLength.requestFocusInWindow();
            SysUtil.abort();
        }
    }

    protected void doBeforeSubmitForWF(CoreBaseInfo editData) throws Exception {
        super.doBeforeSubmitForWF(editData);
    }

    protected String getCurrentBillID() {
        if (this.editData != null && this.editData.getId() != null) {
            return this.editData.getId().toString();
        }
        return null;
    }

    protected String getCurrentBillNumber() {
        if (this.editData != null && this.editData.getNumber() != null) {
            return this.editData.getNumber().toString();
        }
        return null;
    }

    public boolean isShowWeiBoSideBar() throws BOSException, EASBizException {
        return this.isBOSTypeConfiged();
    }

    protected BOSObjectType getBOSObjectType() {
        if (this.editData != null) {
            return this.editData.getBOSType();
        }
        return null;
    }

    protected void doAfterSave(IObjectPK pk) throws Exception {
        super.doAfterSave(pk);
        if (super.isSave()) {
            this.feedToWeibo();
        }
    }

    private void feedToWeibo() throws BOSException, EASBizException {
        this.createFeed();
        WeiboBizUtil.updateBillDigest((String)this.getCurrentBillID());
    }

    protected void doAfterSubmit(IObjectPK pk) throws Exception {
        super.doAfterSubmit(pk);
        if (super.isSave()) {
            this.feedToWeibo();
        }
    }

    protected String getCurrentBillStatus() {
        String sta = "";
        if (super.isSave()) {
            sta = "\u5b8c\u6210";
        }
        return sta;
    }

    public void onShow() throws Exception {
        super.onShow();
        if (!this.isWeiBoEnabled()) {
            return;
        }
        if (this.isBOSTypeConfiged()) {
            this.btnCloudShare.setVisible(true);
            this.btnCloudShare.setIcon(FWResourceManager.getIcon((String)"tbtn_share.gif"));
        }
    }

    private IObjectValue getBizInfo4Wf() {
        try {
            IObjectValue copy = this.createCopy(this.editData);
            Enumeration e = this.editData.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                Object value = this.editData.get(key);
                if (value == null || value instanceof IObjectCollection) continue;
                copy.put(key, value);
            }
            return copy;
        }
        catch (Exception e) {
            return this.editData;
        }
    }

    private IObjectValue createCopy(CoreBillBaseInfo editData) throws Exception {
        IObjectValue copy = (IObjectValue)editData.getClass().newInstance();
        if (copy instanceof ICommonBOSType) {
            IMetaDataPK pk = ((ICommonBOSType)editData).getPK();
            ((ICommonBOSType)copy).setPK(pk);
            ((ICommonBOSType)copy).setBOSType(editData.getBOSType());
        }
        return copy;
    }
}

