/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.time.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.time.CheckStateEnum;
import com.kingdee.eas.hr.time.LeaveDetailCheckException;
import com.kingdee.eas.hr.time.client.AbstractLeaveCheckFilterUI;
import com.kingdee.eas.hr.time.client.TimeAttendanceUtils;
import com.kingdee.eas.hr.time.client.TimeUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class LeaveCheckFilterUI
extends AbstractLeaveCheckFilterUI {
    private static final long serialVersionUID = -61166L;
    private static final String RES = "com.kingdee.eas.hr.time.TimeResource";

    public void onLoad() throws Exception {
        super.onLoad();
        this.initF7();
    }

    private void initF7() {
        TimeAttendanceUtils.initF7Selector((IUIObject)this, this.prmpOrg);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("enableState", (Object)Boolean.FALSE));
        filter.setMaskString("#0 and #1");
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        this.prmptCmpPeriod.setEntityViewInfo(evi);
        this.comboState.addItems(CheckStateEnum.getEnumList().toArray());
        this.comboState.setSelectedIndex(0);
    }

    public CustomerParams getCustomerParams() {
        return TimeUtil.saveAllData(this);
    }

    public void setCustomerParams(CustomerParams cp) {
        TimeUtil.retriveAllData(cp, this);
    }

    public FilterInfo getFilterInfo() {
        boolean isRelateOrg = false;
        try {
            isRelateOrg = TimeUtil.getParamValue("AttendanceData_Relate_OrgUnit");
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
        AdminOrgUnitInfo orgInfo = (AdminOrgUnitInfo)this.prmpOrg.getValue();
        boolean isInclude = this.cbIncludeSubOrg.isSelected();
        Date sDate = (Date)this.pkBeginDate.getValue();
        Date eDate = (Date)this.pkEndDate.getValue();
        Calendar cal = Calendar.getInstance();
        cal.set(DateTimeUtils.getYear((Date)eDate), DateTimeUtils.getMonth((Date)eDate) - 1, DateTimeUtils.getDay((Date)eDate), 23, 59, 59);
        eDate = new Date(cal.getTimeInMillis() / 1000L * 1000L);
        CmpPeriodInfo cmpInfo = (CmpPeriodInfo)this.prmptCmpPeriod.getValue();
        Object state = this.comboState.getSelectedItem();
        String longNum = null;
        if (orgInfo != null) {
            longNum = orgInfo.getLongNumber();
        }
        if (!isRelateOrg) {
            FilterInfo fi;
            block23: {
                fi = new FilterInfo();
                if (sDate != null && eDate != null) {
                    fi.getFilterItems().add(new FilterItemInfo("startDateReal", (Object)eDate, CompareType.LESS_EQUALS));
                    fi.getFilterItems().add(new FilterItemInfo("endDateReal", (Object)sDate, CompareType.GREATER_EQUALS));
                } else if (sDate != null && eDate == null) {
                    fi.getFilterItems().add(new FilterItemInfo("startDateReal", (Object)sDate, CompareType.GREATER_EQUALS));
                } else if (sDate == null && eDate != null) {
                    fi.getFilterItems().add(new FilterItemInfo("endDateReal", (Object)eDate, CompareType.LESS_EQUALS));
                }
                if (cmpInfo != null) {
                    fi.getFilterItems().add(new FilterItemInfo("cmpPeriod.id", (Object)cmpInfo.getId().toString()));
                }
                if (state != null && state instanceof CheckStateEnum) {
                    CheckStateEnum checkSate = (CheckStateEnum)((Object)state);
                    fi.getFilterItems().add(new FilterItemInfo("checkState", (Object)checkSate.getValue()));
                }
                if (longNum != null) {
                    if (isInclude) {
                        FilterInfo orgFi = new FilterInfo();
                        orgFi.getFilterItems().add(new FilterItemInfo("adminOrgUnit.longNumber", (Object)longNum));
                        orgFi.getFilterItems().add(new FilterItemInfo("adminOrgUnit.longNumber", (Object)(longNum + "%"), CompareType.LIKE));
                        orgFi.setMaskString("#0 or #1");
                        try {
                            if (FilterUtility.hasFilterItem((FilterInfo)fi)) {
                                fi.mergeFilter(orgFi, "and");
                                break block23;
                            }
                            fi = orgFi;
                        }
                        catch (BOSException e) {
                            super.handUIException((Throwable)e);
                        }
                    } else {
                        fi.getFilterItems().add(new FilterItemInfo("adminOrgUnit.longNumber", (Object)longNum));
                    }
                }
            }
            if (FilterUtility.hasFilterItem((FilterInfo)fi)) {
                try {
                    fi.mergeFilter(TimeUtil.getAdminRangePersonFilter("person.id"), "AND");
                }
                catch (BOSException e) {
                    this.handUIException(e);
                }
            } else {
                fi = TimeUtil.getAdminRangePersonFilter("person.id");
            }
            return fi;
        }
        FilterInfo outRangeFi = new FilterInfo();
        try {
            outRangeFi = this.getOutOrgRangePersonFilter(longNum, isInclude, sDate, eDate, cmpInfo, state);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return outRangeFi;
    }

    public void clear() {
        this.prmpOrg.setValue(null);
        this.pkEndDate.setValue((Object)new Date());
        this.pkBeginDate.setValue((Object)DateTimeUtils.addMonth((Date)((Date)this.pkEndDate.getValue()), (int)-1));
        this.cbIncludeSubOrg.setSelected(false);
        this.prmptCmpPeriod.setValue(null);
        this.comboState.setSelectedIndex(0);
    }

    public boolean verify() {
        if (this.prmpOrg.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)new LeaveDetailCheckException(LeaveDetailCheckException.ORG_NOT_NULL).getMessage());
            this.prmpOrg.requestFocusInWindow();
            return false;
        }
        if (this.pkBeginDate.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)new LeaveDetailCheckException(LeaveDetailCheckException.BEGINDATE_NOT_NULL).getMessage());
            this.pkBeginDate.requestFocusInWindow();
            return false;
        }
        if (this.pkEndDate.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)new LeaveDetailCheckException(LeaveDetailCheckException.ENDDATE_NOT_NULL).getMessage());
            this.pkEndDate.requestFocusInWindow();
            return false;
        }
        return true;
    }

    public CheckStateEnum getState() {
        return (CheckStateEnum)((Object)this.comboState.getSelectedItem());
    }

    private FilterInfo getOutOrgRangePersonFilter(String orgLongNum, boolean isInclude, Date fromDate, Date toDate, CmpPeriodInfo cmpInfo, Object state) {
        FilterInfo fi = new FilterInfo();
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        String hrOrgUnitID = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        StringBuffer sql = new StringBuffer();
        sql.append(" select am.FId from t_hr_leaveDetail am ");
        sql.append(" left join t_org_admin org on am.FAdminOrgUnitId = org.FId ");
        sql.append(" where ");
        sql.append(" am.FAdminOrgUnitId in ");
        sql.append(" ( ");
        sql.append(" SELECT FFromUnitID FROM T_ORG_UnitRelation WHERE FToUnitID = ");
        sql.append("'").append(hrOrgUnitID).append("'");
        sql.append(" AND FTypeRelationID = '00000000-0000-0000-0000-0000000000100FE9F8B5'");
        sql.append(" AND FFromUnitID IN ");
        sql.append("(");
        sql.append(" SELECT FOrgID FROM T_PM_OrgRange ");
        sql.append(" WHERE FUserID = ");
        sql.append("'").append(userID).append("'");
        sql.append(" and FType = 20 ");
        sql.append(")");
        sql.append(")");
        if (orgLongNum != null) {
            if (isInclude) {
                sql.append(" and ");
                sql.append(" ( ");
                sql.append(" org.FLongNumber = '").append(orgLongNum).append("'");
                sql.append(" or org.FLongNumber like '").append(orgLongNum).append("%'");
                sql.append(" ) ");
            } else {
                sql.append(" and org.FLongNumber = '").append(orgLongNum).append("'");
            }
        }
        if (fromDate != null && toDate != null) {
            sql.append(" and am.FStartDateReal <= to_date('").append(format.format(toDate)).append("')");
            sql.append(" and am.FEndDateReal >= to_date('").append(format.format(fromDate)).append("')");
        } else if (fromDate != null && toDate == null) {
            sql.append(" and am.FStartDateReal <= to_date('").append(format.format(fromDate)).append("')");
        } else if (toDate != null && fromDate == null) {
            sql.append(" and am.FEndDateReal <= to_date('").append(format.format(toDate)).append("')");
        }
        if (cmpInfo != null) {
            sql.append(" and FCmpPeriodID ='").append(cmpInfo.getId().toString()).append("'");
        }
        if (state == null || state instanceof CheckStateEnum) {
            // empty if block
        }
        fi.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.INNER));
        return fi;
    }

    protected void pkBeginDate_dataChanged(DataChangeEvent e) throws Exception {
        this.checkFromToData();
    }

    protected void pkEndDate_dataChanged(DataChangeEvent e) throws Exception {
        this.checkFromToData();
    }

    void checkFromToData() {
        if (this.pkBeginDate.getValue() != null && this.pkEndDate.getValue() != null && DateTimeUtils.dayBefore((Date)((Date)this.pkEndDate.getValue()), (Date)((Date)this.pkBeginDate.getValue()))) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.time.TimeResource.DATE_STARBEFOREND"));
            this.pkBeginDate.setValue(this.pkEndDate.getValue());
        }
    }
}

