/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.time.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.BeforeActionEvent;
import com.kingdee.bos.ctrl.kdf.table.event.BeforeActionListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.client.PositionPromptBox2;
import com.kingdee.eas.basedata.org.client.f7.NewAdminByHROF7;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.base.client.util.HRClientUtil;
import com.kingdee.eas.hr.compensation.CmpPeriodInfo;
import com.kingdee.eas.hr.compensation.CmpSchemeInfo;
import com.kingdee.eas.hr.compensation.ItemDataTypeEnum;
import com.kingdee.eas.hr.emp.client.EmployeeClientUtils;
import com.kingdee.eas.hr.time.CheckStateEnum;
import com.kingdee.eas.hr.time.ILeaveDetail;
import com.kingdee.eas.hr.time.IYearVacationBalance;
import com.kingdee.eas.hr.time.LeaveDetailCollection;
import com.kingdee.eas.hr.time.LeaveDetailFactory;
import com.kingdee.eas.hr.time.LeaveDetailInfo;
import com.kingdee.eas.hr.time.YearVacationBalanceFactory;
import com.kingdee.eas.hr.time.client.AbstractLeaveDetailCheckListUI;
import com.kingdee.eas.hr.time.client.HRTimeClientUtils;
import com.kingdee.eas.hr.time.client.LeaveCheckFilterUI;
import com.kingdee.eas.hr.time.client.TimeAttendanceUtils;
import com.kingdee.eas.hr.time.client.TimeBaseClientUtils;
import com.kingdee.eas.hr.time.client.TimeUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class LeaveDetailCheckListUI
extends AbstractLeaveDetailCheckListUI {
    private static final long serialVersionUID = -61166L;
    private CheckStateEnum state = null;
    private Set changeList = new HashSet();
    private Object object = null;
    private CommonQueryDialog dialog;
    private static final String MACHINE = "machine";
    private static final String USER = "user";
    private String cmpSchemeF7URL = "com.kingdee.eas.hr.compensation.app.F7CmpSchemeQuery";
    private boolean isRelateOrg;
    private HROrgUnitInfo hrOrgUnitInfo = null;

    public void onLoad() throws Exception {
        HRClientUtil.checkCurrentHRUnitNotNull((CoreUI)this);
        this.initComboType();
        this.isRelateOrg = TimeUtil.getParamValue("AttendanceData_Relate_OrgUnit");
        super.onLoad();
        this.initTableCellEditor();
        this.initTableStyle();
        TimeUtil.setDisableColor(this.tblMain);
        this.refresh(null);
        this.tblMain.setBeforeAction(new BeforeActionListener(){

            public void beforeAction(BeforeActionEvent e) {
                if (e.getType() == 7 || e.getType() == 6 || e.getType() == 5) {
                    int[] indexs = KDTableUtil.getSelectedRows((KDTable)LeaveDetailCheckListUI.this.tblMain);
                    for (int i = 0; i < indexs.length; ++i) {
                        LeaveDetailCheckListUI.this.changeList.add(indexs[i]);
                    }
                }
            }
        });
        this.tblMain.setColumnMoveable(false);
        this.tblMain.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                int colIndex = e.getColIndex();
                int rowIndex = e.getRowIndex();
                if (e.getColIndex() == LeaveDetailCheckListUI.this.tblMain.getColumnIndex("position1.name") && LeaveDetailCheckListUI.this.tblMain.getCell(rowIndex, "adminOrgUnit1.name") != null) {
                    try {
                        LeaveDetailCheckListUI.this.tblAttendance_Changed(rowIndex, colIndex);
                    }
                    catch (Exception e1) {
                        LeaveDetailCheckListUI.this.handleException(e1);
                    }
                }
            }
        });
        TimeUtil.setKDTableUISort(this.tblMain);
    }

    private void tblAttendance_Changed(int rowIndex, int colIndex) throws BOSException {
        Object value = this.tblMain.getCell(rowIndex, "position1.name").getValue();
        Object adminOrgUnit = null;
        if (value instanceof PositionInfo) {
            adminOrgUnit = UIRuleUtil.getProperty((IObjectValue)((PositionInfo)value), (String)"adminOrgUnit");
        }
        if (adminOrgUnit != null) {
            this.tblMain.getCell(rowIndex, "adminOrgUnit1.name").setValue(adminOrgUnit);
        }
    }

    private void initComboType() {
        this.comboType.setActionCommand(MACHINE);
        this.comboType.addItems(CheckStateEnum.getEnumList().toArray());
        this.comboType.setActionCommand(USER);
    }

    private void initTableCellEditor() {
        this.tblMain.getColumn("startDateReg").setEditor(EmployeeClientUtils.getDateTimeCellEditor());
        this.tblMain.getColumn("endDateReg").setEditor(EmployeeClientUtils.getDateTimeCellEditor());
        this.tblMain.getColumn("startDateReal").setEditor(EmployeeClientUtils.getDateTimeCellEditor());
        this.tblMain.getColumn("endDateReal").setEditor(EmployeeClientUtils.getDateTimeCellEditor());
        this.tblMain.getColumn("startDateReg").getStyleAttributes().setNumberFormat(HRTimeClientUtils.getLongTimePatternStr());
        this.tblMain.getColumn("endDateReg").getStyleAttributes().setNumberFormat(HRTimeClientUtils.getLongTimePatternStr());
        this.tblMain.getColumn("startDateReal").getStyleAttributes().setNumberFormat(HRTimeClientUtils.getLongTimePatternStr());
        this.tblMain.getColumn("endDateReal").getStyleAttributes().setNumberFormat(HRTimeClientUtils.getLongTimePatternStr());
        this.tblMain.getColumn("createTime").getStyleAttributes().setNumberFormat(HRTimeClientUtils.getLongTimePatternStr());
        this.tblMain.getColumn("totalReg").setEditor(EmployeeClientUtils.getFloatCellEditor((Comparable)Float.valueOf("99999.99"), (int)2));
        this.tblMain.getColumn("totalReg").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("totalRegReal").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("comment").setEditor(EmployeeClientUtils.getTextAreaCellEditor((int)80));
        String hrOrgUnitId = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
        KDBizPromptBox kdBizPromptBoxCmp = new KDBizPromptBox();
        kdBizPromptBoxCmp.setQueryInfo("com.kingdee.eas.hr.compensation.app.F7CmpPeriodQuery");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)hrOrgUnitId));
        filter.getFilterItems().add(new FilterItemInfo("enableState", (Object)Boolean.FALSE));
        filter.setMaskString("#0 and #1");
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        kdBizPromptBoxCmp.setEntityViewInfo(evi);
        kdBizPromptBoxCmp.setDisplayFormat("$name$");
        kdBizPromptBoxCmp.setEditFormat("$number$");
        kdBizPromptBoxCmp.setCommitFormat("$name$");
        kdBizPromptBoxCmp.setEditable(true);
        this.tblMain.getColumn("yearOfLeave").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)kdBizPromptBoxCmp));
        this.tblMain.getColumn("position1.name").setEditor(this.getPositionF7Editor());
        this.tblMain.getColumn("adminOrgUnit1.name").setEditor(this.getAdminOrgUnitF7());
        this.tblMain.getColumn("attendancecmp").setEditor(this.getCmpSchemeF7());
    }

    public ICellEditor getPositionF7Editor() {
        KDBizPromptBox prmtPosition = new KDBizPromptBox();
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        hashMap.put("HRO_FILTER", Boolean.TRUE);
        PositionPromptBox2 pmtNew = new PositionPromptBox2((IUIObject)this, hashMap);
        prmtPosition.setSelector((KDPromptSelector)pmtNew);
        prmtPosition.setDisplayFormat("$name$");
        prmtPosition.setEditable(false);
        return new KDTDefaultCellEditor((IKDEditor)prmtPosition);
    }

    public ICellEditor getAdminOrgUnitF7() {
        NewAdminByHROF7 f7 = new NewAdminByHROF7();
        f7.setMultiSelect(false);
        KDBizPromptBox prmtAdminOrgUnit = new KDBizPromptBox();
        prmtAdminOrgUnit.setSelector((KDPromptSelector)f7);
        prmtAdminOrgUnit.setEnabledMultiSelection(false);
        prmtAdminOrgUnit.setDisplayFormat("$name$");
        prmtAdminOrgUnit.setEditable(false);
        return new KDTDefaultCellEditor((IKDEditor)prmtAdminOrgUnit);
    }

    public ICellEditor getCmpSchemeF7() {
        KDBizPromptBox prmtCmpScheme = new KDBizPromptBox();
        prmtCmpScheme.setQueryInfo(this.cmpSchemeF7URL);
        prmtCmpScheme.setEditable(false);
        prmtCmpScheme.setEditFormat("$name$");
        prmtCmpScheme.setDisplayFormat("$name$");
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfoCmpSch = new FilterInfo();
        filterInfoCmpSch.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)this.getHROrgUnit().getId().toString()));
        filterInfoCmpSch.getFilterItems().add(new FilterItemInfo("enable", (Object)1));
        filterInfoCmpSch.getFilterItems().add(new FilterItemInfo("enable", (Object)3));
        filterInfoCmpSch.getFilterItems().add(new FilterItemInfo("isDelete", (Object)"0"));
        filterInfoCmpSch.setMaskString("#0 and (#1 or #2) and #3");
        evi.setFilter(filterInfoCmpSch);
        prmtCmpScheme.setEntityViewInfo(evi);
        prmtCmpScheme.setEnabled(true);
        return new KDTDefaultCellEditor((IKDEditor)prmtCmpScheme);
    }

    private void initTableStyle() {
        this.tblMain.getStyleAttributes().setLocked(false);
        this.tblMain.getSelectManager().setSelectMode(15);
        this.tblMain.getColumn("refrence").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("checkState").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("person.name").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("person.number").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("adminOrgUnit.name").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("timeAttendance.name").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("timeAttendance.unitType").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("dataOfSource").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("createTime").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("startDateReg").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("endDateReg").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("totalReg").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("adminOrgUnit1.name").getStyleAttributes().setLocked(true);
    }

    protected void refresh(ActionEvent e) throws Exception {
        super.refresh(e);
        this.setLeaveDataDisplayFormat();
        if (!this.isRelateOrg) {
            this.tblMain.getColumn("position1.name").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("adminOrgUnit1.name").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("attendancecmp").getStyleAttributes().setHided(true);
        }
        if (MACHINE.equals(this.comboType.getActionCommand())) {
            return;
        }
        this.state = (CheckStateEnum)((Object)this.comboType.getSelectedItem());
        this.setCheckStateFilter();
        this.setActionState(this.state);
        this.setTableColLockState(this.state);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int[] rows = new int[this.changeList.size()];
        Iterator iterator = this.changeList.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            rows[index++] = (Integer)iterator.next();
        }
        if (!this.checkDate(rows)) {
            return;
        }
        int[] rows2 = this.getValidRows2(CheckStateEnum.UNCHECK);
        if (rows2.length < rows.length) {
            if (this.showConfirm("CONFIRM_SAVE_HAVE_INVALID")) {
                this.updateDatas(rows2);
                this.changeList.clear();
                this.showSuccess("SAVE_SUCCESS");
                this.refresh(e);
            }
        } else {
            this.updateDatas(rows);
            this.changeList.clear();
            this.showSuccess("SAVE_SUCCESS");
            this.refresh(e);
        }
    }

    private boolean checkDate(int[] rows) {
        IRow row = null;
        Date beginDate = null;
        Date endDate = null;
        Date beginDate2 = null;
        Date endDate2 = null;
        for (int i = 0; i < rows.length; ++i) {
            row = this.tblMain.getRow(rows[i]);
            if (row == null) continue;
            beginDate = (Date)row.getCell("startDateReg").getValue();
            endDate = (Date)row.getCell("endDateReg").getValue();
            if (beginDate != null && endDate != null && beginDate.getTime() > endDate.getTime()) {
                this.tblMain.getSelectManager().select(rows[i], this.tblMain.getColumnIndex("endDateReg"));
                this.showWarning("BEGINTIME_GREATE_ENDTIME");
                return false;
            }
            beginDate2 = (Date)row.getCell("startDateReal").getValue();
            endDate2 = (Date)row.getCell("endDateReal").getValue();
            if (beginDate2 != null && endDate2 != null && beginDate2.getTime() > endDate2.getTime()) {
                this.tblMain.getSelectManager().select(rows[i], this.tblMain.getColumnIndex("endDateReal"));
                this.showWarning("BEGINTIME_GREATE_ENDTIME");
                return false;
            }
            if (!this.isRelateOrg) continue;
            String psId = null;
            String orgId = null;
            Object obj1 = row.getCell("position1.id").getValue();
            if (obj1 != null) {
                psId = obj1.toString();
            }
            if ((obj1 = row.getCell("adminOrgUnit1.id").getValue()) == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"60_AttendanceManagerEditUI"));
                SysUtil.abort();
            }
            orgId = obj1.toString();
            if (psId == null || orgId == null) continue;
            String sql = "where id = '" + psId + "'" + "and adminOrgUnit.id ='" + orgId + "'";
            boolean isExist = false;
            try {
                isExist = PositionFactory.getRemoteInstance().exists(sql);
            }
            catch (Exception e) {
                super.handleException(e);
            }
            if (isExist) continue;
            MsgBox.showWarning((Component)((Object)this), (String)(EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"1_AttendanceManagerImportFacadeControllerBean") + (rows[i] + 1) + EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"73_LeaveDetailCheckListUI")));
            SysUtil.abort();
        }
        return true;
    }

    public void showWarning(String label) {
        MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)("com.kingdee.eas.hr.time.LeaveDetailCheckResource." + label)));
    }

    public boolean showConfirm(String label) {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)("com.kingdee.eas.hr.time.LeaveDetailCheckResource." + label))));
    }

    public void showSuccess(String label) {
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)("com.kingdee.eas.hr.time.LeaveDetailCheckResource." + label)));
    }

    private int[] getValidRows(CheckStateEnum state) {
        int[] rows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (rows.length == 0) {
            return rows;
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        IRow row = null;
        int size = rows.length;
        for (int i = 0; i < size; ++i) {
            row = this.tblMain.getRow(rows[i]);
            if (state.getValue() == 1) {
                if (!this.isValidRowForAntiAudit(row)) continue;
                list.add(rows[i]);
                continue;
            }
            if (!this.isValidRowForUpdateAndAudit(row)) continue;
            list.add(rows[i]);
        }
        int[] rows2 = new int[list.size()];
        int size2 = list.size();
        for (int i = 0; i < size2; ++i) {
            rows2[i] = (Integer)list.get(i);
        }
        return rows2;
    }

    private int[] getValidRows2(CheckStateEnum state) {
        int[] rows = new int[this.changeList.size()];
        Iterator iterator = this.changeList.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            rows[index++] = (Integer)iterator.next();
        }
        if (rows.length == 0) {
            return rows;
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        IRow row = null;
        int size = rows.length;
        for (int i = 0; i < size; ++i) {
            row = this.tblMain.getRow(rows[i]);
            if (state.getValue() == 1) {
                if (!this.isValidRowForAntiAudit(row)) continue;
                list.add(rows[i]);
                continue;
            }
            if (!this.isValidRowForUpdateAndAudit(row)) continue;
            list.add(rows[i]);
        }
        int[] rows2 = new int[list.size()];
        int size2 = list.size();
        for (int i = 0; i < size2; ++i) {
            rows2[i] = (Integer)list.get(i);
        }
        return rows2;
    }

    private void updateDatas(int[] rows) throws Exception {
        LeaveDetailCollection collection = new LeaveDetailCollection();
        LeaveDetailInfo info = null;
        int size = rows.length;
        for (int i = 0; i < size; ++i) {
            info = this.buildDetailByIRow(rows[i]);
            collection.add(info);
        }
        ((ILeaveDetail)this.getBizInterface()).batchUpdate(collection);
    }

    private LeaveDetailInfo buildDetailByIRow(int index) {
        if (index == -1) {
            return null;
        }
        IRow row = this.tblMain.getRow(index);
        LeaveDetailInfo info = new LeaveDetailInfo();
        info.setId(BOSUuid.read((String)row.getCell("id").getValue().toString()));
        if (row.getCell("totalReg").getValue() != null) {
            info.setTotalReg(TimeBaseClientUtils.getBigDecimalValueByCell(row.getCell("totalReg").getValue()));
        }
        info.setTotalRegReal(TimeBaseClientUtils.getBigDecimalValueByCell(row.getCell("totalRegReal").getValue()));
        if (row.getCell("startDateReg").getValue() != null) {
            info.setStartDateReg(this.getTimeStampByDate((Date)row.getCell("startDateReg").getValue()));
        }
        info.setStartDateReal(this.getTimeStampByDate((Date)row.getCell("startDateReal").getValue()));
        if (row.getCell("endDateReg").getValue() != null) {
            info.setEndDateReg(this.getTimeStampByDate((Date)row.getCell("endDateReg").getValue()));
        }
        info.setEndDateReal(this.getTimeStampByDate((Date)row.getCell("endDateReal").getValue()));
        info.setComment((String)row.getCell("comment").getValue());
        Object obj = row.getCell("yearOfLeave").getValue();
        if (obj != null && obj instanceof CmpPeriodInfo) {
            info.setCmpPeriod((CmpPeriodInfo)obj);
        } else if (obj instanceof String) {
            CmpPeriodInfo period = new CmpPeriodInfo();
            period.setId(BOSUuid.read((String)row.getCell("cmpPeriod.id").getValue().toString()));
            info.setCmpPeriod(period);
        } else {
            info.setCmpPeriod(null);
        }
        Object obj1 = row.getCell("position1.name").getValue();
        if (obj1 != null && obj1 instanceof PositionInfo) {
            info.setPosition((PositionInfo)obj1);
        } else if (obj1 instanceof String) {
            PositionInfo period = new PositionInfo();
            period.setId(BOSUuid.read((String)row.getCell("position1.id").getValue().toString()));
            info.setPosition(period);
        } else {
            info.setPosition(null);
        }
        Object obj2 = row.getCell("adminOrgUnit1.name").getValue();
        if (obj2 != null && obj2 instanceof AdminOrgUnitInfo) {
            info.setAdminOrgUnit((AdminOrgUnitInfo)obj2);
        } else if (obj2 instanceof String) {
            AdminOrgUnitInfo period = new AdminOrgUnitInfo();
            period.setId(BOSUuid.read((String)row.getCell("adminOrgUnit1.id").getValue().toString()));
            info.setAdminOrgUnit(period);
        } else {
            info.setAdminOrgUnit(null);
        }
        Object obj3 = row.getCell("attendancecmp").getValue();
        if (obj3 != null && obj3 instanceof CmpSchemeInfo) {
            info.setCmpScheme((CmpSchemeInfo)obj3);
        } else if (obj3 instanceof String) {
            CmpSchemeInfo period = new CmpSchemeInfo();
            period.setId(BOSUuid.read((String)row.getCell("attendancecmp.id").getValue().toString()));
            info.setCmpScheme(period);
        } else {
            info.setCmpScheme(null);
        }
        return info;
    }

    private Timestamp getTimeStampByDate(Date date) {
        if (date == null) {
            return null;
        }
        return new Timestamp(date.getTime());
    }

    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        int[] rows;
        this.tblMain.requestFocus();
        if (this.changeList.size() > 0) {
            if (this.showConfirm("comfirmSave")) {
                this.checkSelected();
                rows = new int[this.changeList.size()];
                Iterator iterator = this.changeList.iterator();
                int index = 0;
                while (iterator.hasNext()) {
                    rows[index++] = (Integer)iterator.next();
                }
                if (!this.checkDate(rows)) {
                    return;
                }
                int[] rows2 = this.getValidRows2(CheckStateEnum.UNCHECK);
                if (rows2.length < rows.length) {
                    if (this.showConfirm("CONFIRM_SAVE_HAVE_INVALID")) {
                        this.updateDatas(rows2);
                        this.changeList.clear();
                    }
                } else {
                    this.updateDatas(rows);
                    this.changeList.clear();
                }
            } else {
                this.changeList.clear();
            }
        }
        rows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        int[] rows2 = this.getValidRows(CheckStateEnum.UNCHECK);
        String[] failIds = null;
        if (rows.length == 0) {
            this.showWarning("NO_SELECT_ROW");
        } else if (rows2.length == 0) {
            this.showWarning("NO_VALID_ROW");
        } else if (rows2.length < rows.length) {
            if (this.showConfirm("CONFIRM_AUDIT_HAVE_INVALID")) {
                failIds = this.auditDatas(rows2);
                if (failIds == null || failIds.length == 0) {
                    this.showSuccess("AUDIT_SUCCESS");
                    this.refresh(e);
                } else if (failIds.length < rows2.length) {
                    this.showWarning("AUDIT_SUCCESS_EXISTS_NO_CMPPERIOD");
                    this.refresh(e);
                } else {
                    this.showWarning("AUDIT_FAIL_NO_CMPPERIOD");
                }
            }
        } else if (this.showConfirm("CONFIRM_AUDIT")) {
            failIds = this.auditDatas(rows);
            if (failIds == null || failIds.length == 0) {
                this.showSuccess("AUDIT_SUCCESS");
                this.refresh(e);
            } else if (failIds.length < rows.length) {
                this.showWarning("AUDIT_SUCCESS_EXISTS_NO_CMPPERIOD");
                this.refresh(e);
            } else {
                this.showWarning("AUDIT_FAIL_NO_CMPPERIOD");
            }
        }
    }

    public void actionAntiAudit_actionPerformed(ActionEvent e) throws Exception {
        int[] rows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        int[] rows2 = this.getValidRows(CheckStateEnum.UNCHECK);
        if (rows.length == 0) {
            this.showWarning("NO_SELECT_ROW");
        } else if (rows2.length == 0) {
            this.showWarning("NO_VALID_ROW");
        } else if (rows2.length < rows.length) {
            if (this.showConfirm("CONFIRM_ANTIAUDIT_HAVE_INVALID")) {
                this.antiAuditDatas(rows2);
                this.showSuccess("ANTIAUDIT_SUCCESS");
                this.refresh(e);
            }
        } else if (this.showConfirm("CONFIRM_ANTIAUDIT")) {
            this.antiAuditDatas(rows);
            this.showSuccess("ANTIAUDIT_SUCCESS");
            this.refresh(e);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.setButtonDefaultStyl(this.btnSave);
        this.btnCopyToColumn.setIcon(EASResource.getIcon((String)"imgTbtn_copytotier"));
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.btnAntiAudit.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnUnCheck.setIcon(EASResource.getIcon((String)"imgTbtn_ffreeze"));
        this.menuItemCopy.setIcon(EASResource.getIcon((String)"imgTbtn_copytotier"));
        this.menuItemAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.menuItemAntiAudit.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.menuItemSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.menuItemUnCheck.setIcon(EASResource.getIcon((String)"imgTbtn_ffreeze"));
    }

    private void setLeaveDataDisplayFormat() throws Exception {
        IRow row = null;
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.tblMain.getRow(i);
            int decDigital = (Integer)row.getCell("decDigital").getValue();
            int length = (Integer)row.getCell("length").getValue();
            int dataType = ((BizEnumValueInfo)row.getCell("dataType").getValue()).getInt();
            row.getCell("totalReg").getStyleAttributes().setNumberFormat("%r{0.00}10.2f");
            row.getCell("totalRegReal").getStyleAttributes().setNumberFormat(this.getFomatString(length, decDigital, ItemDataTypeEnum.getEnum((int)dataType)));
            row.getCell("totalReg").setEditor(TimeAttendanceUtils.getTheCellEditor(length, decDigital, ItemDataTypeEnum.getEnum((int)dataType)));
            row.getCell("totalRegReal").setEditor(TimeAttendanceUtils.getTheCellEditor(length, decDigital, ItemDataTypeEnum.getEnum((int)dataType)));
        }
    }

    protected void comboType_itemStateChanged(ItemEvent e) throws Exception {
        if (MACHINE.equals(this.comboType.getActionCommand())) {
            return;
        }
        this.state = (CheckStateEnum)((Object)this.comboType.getSelectedItem());
        this.setCheckStateFilter();
        this.refreshList();
        this.setActionState(this.state);
        this.setTableColLockState(this.state);
        this.setLeaveDataDisplayFormat();
    }

    private void setActionState(CheckStateEnum state) {
        boolean flag = state.getValue() == 1;
        this.actionAntiAudit.setEnabled(flag);
        this.actionSave.setEnabled(!flag);
        this.actionAudit.setEnabled(!flag);
        if (0 == state.getValue()) {
            this.actionUnCheck.setEnabled(false);
        } else {
            this.actionUnCheck.setEnabled(true);
        }
    }

    public void actionCopyToColumn_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopyToColumn_actionPerformed(e);
        KDTSelectBlock block = this.tblMain.getSelectManager().get();
        if (block != null) {
            int rowIndex = block.getTop();
            int colIndex = block.getLeft();
            if (this.tblMain.getColumn(colIndex).getStyleAttributes().isLocked()) {
                return;
            }
            if (rowIndex == -1) {
                return;
            }
            Object obj = this.tblMain.getRow(rowIndex).getCell(colIndex).getValue();
            int size = this.tblMain.getRowCount();
            for (int i = 0; i < size; ++i) {
                this.tblMain.getRow(i).getCell(colIndex).setValue(obj);
                this.changeList.add(i);
            }
            if (colIndex == this.tblMain.getColumn("yearOfLeave").getColumnIndex()) {
                Object obj2 = this.tblMain.getRow(rowIndex).getCell("cmpPeriod.id").getValue();
                int size2 = this.tblMain.getRowCount();
                for (int i = 0; i < size2; ++i) {
                    this.tblMain.getRow(i).getCell("cmpPeriod.id").setValue(obj2);
                }
            }
        }
    }

    private void setTableColLockState(CheckStateEnum state) {
        boolean flag = 1 == state.getValue();
        this.tblMain.getColumn("startDateReal").getStyleAttributes().setLocked(flag);
        this.tblMain.getColumn("endDateReal").getStyleAttributes().setLocked(flag);
        this.tblMain.getColumn("totalRegReal").getStyleAttributes().setLocked(flag);
        this.tblMain.getColumn("comment").getStyleAttributes().setLocked(flag);
        this.tblMain.getColumn("yearOfLeave").getStyleAttributes().setLocked(flag);
    }

    private ArrayList getNoNullColumns() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("totalRegReal");
        list.add("startDateReal");
        list.add("endDateReal");
        return list;
    }

    private boolean isValidRowForUpdateAndAudit(IRow row) {
        ArrayList list = this.getNoNullColumns();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            if (row != null) {
                if (row.getCell(list.get(i).toString()).getValue() != null) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private boolean isValidRowForAntiAudit(IRow row) {
        return (Boolean)row.getCell("refrence").getValue() == false;
    }

    private void antiAuditDatas(int[] rows) throws Exception {
        String[] ids = this.getSelectedPKs(rows);
        ((ILeaveDetail)this.getBizInterface()).batchAntiAudit(ids);
    }

    private void unCheckDatas(int[] rows) throws Exception {
        String[] ids = this.getSelectedPKs(rows);
        ((ILeaveDetail)this.getBizInterface()).batchUnCheck(ids);
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.dialog != null) {
            return this.dialog;
        }
        this.dialog = super.initCommonQueryDialog();
        try {
            this.dialog.addUserPanel((KDPanel)new LeaveCheckFilterUI());
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return this.dialog;
    }

    private void setCheckStateFilter() {
        if (this.mainQuery != null && this.mainQuery.getFilter() != null) {
            FilterItemCollection collection = this.mainQuery.getFilter().getFilterItems();
            FilterItemInfo info = null;
            boolean hasCheckStateProperty = false;
            int size = collection.size();
            for (int i = 0; i < size; ++i) {
                if (!"checkState".equals(collection.get(i).getPropertyName())) continue;
                info = collection.get(i);
                hasCheckStateProperty = true;
                break;
            }
            if (hasCheckStateProperty && info != null) {
                info.setCompareValue((Object)this.state.getValue());
            } else {
                String maskString = this.mainQuery.getFilter().getMaskString();
                info = new FilterItemInfo("checkState", (Object)this.state.getValue());
                collection.add(info);
                this.mainQuery.getFilter().setMaskString("(" + maskString + ") and (#" + String.valueOf(collection.size() - 1) + ")");
            }
        }
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return null;
    }

    private String[] auditDatas(int[] rows) throws Exception {
        List lstPerson = this.getSelectedPerIDs(rows);
        ((ILeaveDetail)this.getBizInterface()).batchCheckYVRule(lstPerson);
        String[] ids = this.getSelectedPKs(rows);
        String[] idss = ((ILeaveDetail)this.getBizInterface()).batchAudit(ids);
        if (lstPerson.size() > 0) {
            IYearVacationBalance iyvBalacne = YearVacationBalanceFactory.getRemoteInstance();
            int year = Calendar.getInstance().get(1);
            iyvBalacne.calculate(year, lstPerson, 4, new Date(), 4);
        }
        return idss;
    }

    private String[] getSelectedPKs(int[] rows) throws Exception {
        String[] ids = new String[rows.length];
        int size = rows.length;
        for (int i = 0; i < size; ++i) {
            ids[i] = this.tblMain.getRow(rows[i]).getCell("id").getValue().toString();
        }
        return ids;
    }

    private List getSelectedPerIDs(int[] rows) {
        ArrayList<String> lstPerson = new ArrayList<String>();
        int size = rows.length;
        for (int i = 0; i < size; ++i) {
            if (!this.tblMain.getRow(rows[i]).getCell("timeAttendance.id").getValue().toString().equals("00000000-0000-0000-0000-000000000008649E3405")) continue;
            lstPerson.add(this.tblMain.getRow(rows[i]).getCell("person.id").getValue().toString());
        }
        return lstPerson;
    }

    protected String[] getLocateNames() {
        return new String[]{"person.number", "person.name"};
    }

    protected ICoreBase getBizInterface() throws Exception {
        return LeaveDetailFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return null;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    protected void tblMain_editStarting(KDTEditEvent e) throws Exception {
        this.object = e.getOldValue();
    }

    protected void tblMain_editStopped(KDTEditEvent e) throws Exception {
        Object newObject = e.getValue();
        if (newObject != null && !newObject.equals(this.object)) {
            this.changeList.add(e.getRowIndex());
        } else if (newObject == null && this.object != null) {
            this.changeList.add(e.getRowIndex());
        }
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.confirmSave(e);
        super.actionQuery_actionPerformed(e);
        this.setCombStateByQuery();
        this.setActionState(this.state);
        this.setTableColLockState(this.state);
        this.setLeaveDataDisplayFormat();
    }

    private void setCombStateByQuery() {
        boolean match = false;
        if (this.dialog != null) {
            this.state = ((LeaveCheckFilterUI)this.dialog.getUserPanel(0)).getState();
        } else if (this.mainQuery != null && this.mainQuery.getFilter() != null) {
            FilterItemCollection collection = this.mainQuery.getFilter().getFilterItems();
            int size = collection.size();
            for (int i = 0; i < size; ++i) {
                if (!collection.get(i).getPropertyName().endsWith("checkState")) continue;
                match = true;
                if (Integer.parseInt(collection.get(i).getCompareValue().toString()) == 0) {
                    this.state = CheckStateEnum.UNCHECK;
                    break;
                }
                this.state = CheckStateEnum.CHECK;
                break;
            }
        }
        if (this.comboType.getItemCount() > 0) {
            this.comboType.setActionCommand(MACHINE);
            if (this.state != null) {
                this.comboType.setSelectedItem((Object)this.state);
            } else {
                this.comboType.setSelectedIndex(0);
                this.state = (CheckStateEnum)((Object)this.comboType.getSelectedItem());
            }
            this.comboType.setActionCommand(USER);
        }
        if (!match) {
            try {
                this.comboType_itemStateChanged(null);
            }
            catch (Exception ex) {
                super.handleException(ex);
            }
        }
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.confirmSave(e);
        super.actionRefresh_actionPerformed(e);
    }

    private void confirmSave(ActionEvent e) throws Exception {
        this.tblMain.requestFocus();
        if (this.changeList.size() > 0) {
            if (this.showConfirm("comfirmSave")) {
                this.actionSave_actionPerformed(e);
            } else {
                this.changeList.clear();
            }
        }
    }

    public void actionUnCheck_actionPerformed(ActionEvent e) throws Exception {
        int[] rows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        int[] rows2 = this.getValidRows(CheckStateEnum.UNCHECK);
        if (rows.length == 0) {
            this.showWarning("NO_SELECT_ROW");
        } else if (rows2.length == 0) {
            this.showWarning("NO_VALID_ROW");
        } else if (rows2.length < rows.length) {
            if (this.showConfirm("CONFIRM_ANTIAUDIT_HAVE_INVALID")) {
                this.unCheckDatas(rows2);
                this.showSuccess("ANTIAUDIT_SUCCESS");
                this.refresh(e);
            }
        } else if (this.showConfirm("CONFIRM_ANTIAUDIT")) {
            this.unCheckDatas(rows);
            this.showSuccess("ANTIAUDIT_SUCCESS");
            this.refresh(e);
        }
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    private HROrgUnitInfo getHROrgUnit() {
        if (this.hrOrgUnitInfo == null) {
            this.hrOrgUnitInfo = SysContext.getSysContext().getCurrentHRUnit();
        }
        return this.hrOrgUnitInfo;
    }

    protected void setThelper() {
        this.setQueryPreference(true);
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = super.getQueryExecutor(queryPK, viewInfo);
        exec.option().isAutoIgnoreZero = false;
        return exec;
    }

    public String getFomatString(int length, int pre, ItemDataTypeEnum dataType) {
        String formatString = null;
        if (dataType != null && dataType.getValue() == 40) {
            pre = 0;
        }
        String len = Integer.valueOf(length - pre).toString();
        StringBuffer dataFormat = new StringBuffer("%r-{###0");
        if (pre > 0) {
            dataFormat.append(".");
            for (int i = 0; i < pre; ++i) {
                dataFormat.append("0");
            }
        }
        dataFormat.append("}");
        formatString = dataFormat.toString() + len + "." + pre + "f";
        return formatString;
    }
}

