/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.time.client;

import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.emp.IUserPermission;
import com.kingdee.eas.hr.emp.UserPermissionCollection;
import com.kingdee.eas.hr.emp.UserPermissionFactory;
import com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox;
import com.kingdee.eas.hr.time.LeaveDetailCheckException;
import com.kingdee.eas.hr.time.client.AbstractLeaveHistoryQueryFilter2UI;
import com.kingdee.eas.hr.time.client.LeaveRegQueryPanelUI;
import com.kingdee.eas.hr.time.client.TimeAttendanceUtils;
import com.kingdee.eas.hr.time.client.TimeUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.util.Date;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class LeaveHistoryQueryFilter2UI
extends AbstractLeaveHistoryQueryFilter2UI {
    private static final long serialVersionUID = -61166L;
    private static final Logger logger = CoreUIObject.getLogger(LeaveRegQueryPanelUI.class);

    public Date getBeginDate() {
        Date date = (Date)this.pkBeginDate.getValue();
        return DateTimeUtils.truncateDate((Date)date);
    }

    public Date getEndDate() {
        Date date = (Date)this.pkEndDate.getValue();
        date = DateTimeUtils.truncateDate((Date)date);
        return DateTimeUtils.addSecond((Date)DateTimeUtils.addDay((Date)date, (long)1L), (long)-1L);
    }

    private void initF7() {
        TimeAttendanceUtils.initF7Selector((IUIObject)this, this.promptOrg);
        EmployeeMultiF7PromptBox mBox = new EmployeeMultiF7PromptBox((IUIObject)this);
        try {
            this.setF7Filter(mBox);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        mBox.setModal(true);
        mBox.setIsSingleSelect(true);
        mBox.showNoPositionPerson(true);
        mBox.showOnlyPayPerson(true);
        mBox.setUserOrgRangeFilter(true);
        mBox.setReturnPositionAndUnit(false);
        HashSet<BOSUuid> set = new HashSet<BOSUuid>();
        set.add(SysContext.getSysContext().getCurrentHRUnit().getId());
        mBox.setHROFilter(set);
        this.promptPerson.setSelector((KDPromptSelector)mBox);
        this.promptPerson.setEnabled(false);
        this.promptPerson.setEditable(false);
    }

    private void setF7Filter(EmployeeMultiF7PromptBox pmt) throws Exception {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)"1"));
        filter.getFilterItems().add(new FilterItemInfo("user", (Object)SysContext.getSysContext().getCurrentUserInfo().getId().toString()));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        IUserPermission iup = UserPermissionFactory.getRemoteInstance();
        UserPermissionCollection collection = iup.getUserPermissionCollection(viewInfo);
        String filterString = null;
        if (collection != null && collection.size() > 0) {
            filterString = collection.get(0).getFilter();
        }
        if (filterString == null) {
            return;
        }
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.emp.app", "EmpInfoQuery");
        IQueryExecutor iQe = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        filter = new FilterInfo(filterString);
        viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        viewInfo.setSelector(sic);
        iQe.setObjectView(viewInfo);
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)iQe.getSQL(), CompareType.INNER));
        pmt.setNopositionPersonFilter(filter);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initF7();
        this.pkBeginDate.setValue((Object)this.getMonthBeginDate());
        this.pkEndDate.setValue((Object)this.getMonthEndDate());
    }

    public boolean verify() {
        if (this.pkBeginDate.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)new LeaveDetailCheckException(LeaveDetailCheckException.BEGINDATE_NOT_NULL).getMessage());
            this.pkBeginDate.requestFocusInWindow();
            return false;
        }
        if (this.pkEndDate.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)new LeaveDetailCheckException(LeaveDetailCheckException.ENDDATE_NOT_NULL).getMessage());
            this.pkEndDate.requestFocusInWindow();
            return false;
        }
        return true;
    }

    private Date getMonthBeginDate() {
        Date date = new Date();
        int day = DateTimeUtils.getDay((Date)date);
        date = DateTimeUtils.addDay((Date)date, (long)(1 - day));
        return date;
    }

    private Date getMonthEndDate() {
        Date date = new Date();
        int day = DateTimeUtils.getDay((Date)date);
        Date beginDate = DateTimeUtils.addDay((Date)date, (long)(1 - day));
        date = DateTimeUtils.addMonth((Date)beginDate, (int)1);
        return DateTimeUtils.addDay((Date)date, (long)-1L);
    }

    protected void radioOrg_itemStateChanged(ItemEvent e) throws Exception {
        boolean flag = this.radioOrg.isSelected();
        this.promptOrg.setEnabled(flag);
        this.cbIncludeSubOrg.setEnabled(flag);
        this.promptPerson.setEnabled(!flag);
    }

    public void clear() {
        this.cbIncludeSubOrg.setSelected(false);
        this.promptOrg.setValue(null);
        this.promptPerson.setValue(null);
        this.pkBeginDate.setValue(null);
        this.pkEndDate.setValue(null);
    }

    public CustomerParams getCustomerParams() {
        return TimeUtil.saveAllData(this);
    }

    public void setCustomerParams(CustomerParams cp) {
        TimeUtil.retriveAllData(cp, this);
    }

    protected void pkBeginDate_dataChanged(DataChangeEvent e) throws Exception {
        this.checkFromToData();
    }

    protected void pkEndDate_dataChanged(DataChangeEvent e) throws Exception {
        this.checkFromToData();
    }

    void checkFromToData() {
        if (this.pkBeginDate.getValue() != null && this.pkEndDate.getValue() != null && DateTimeUtils.dayBefore((Date)((Date)this.pkEndDate.getValue()), (Date)((Date)this.pkBeginDate.getValue()))) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.time.TimeResource.DATE_STARBEFOREND"));
            this.pkBeginDate.setValue(this.pkEndDate.getValue());
        }
    }
}

