/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.time.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.hr.benefit.util.CommonQueryUtil;
import com.kingdee.eas.hr.time.TimeAttendanceCollection;
import com.kingdee.eas.hr.time.TimeAttendanceInfo;
import com.kingdee.eas.hr.time.client.AbstractLeaveHistoryQueryFilterUI;
import com.kingdee.eas.hr.time.client.HRTimeClientUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.swing.DefaultListModel;

public class LeaveHistoryQueryFilterUI
extends AbstractLeaveHistoryQueryFilterUI {
    private static final long serialVersionUID = -61166L;
    private boolean isFirstLoad = true;
    private boolean isLoadSchema = false;
    private TimeAttendanceCollection coll = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.isFirstLoad = this.getUIContext().get("isFirstLoad") == null;
        if (this.isFirstLoad) {
            this.firstLoad();
        } else if (!this.isLoadSchema) {
            Object[] leftItems = (Object[])this.getUIContext().get("leftItems");
            Object[] rightItems = (Object[])this.getUIContext().get("rightItems");
            this.lstLeft.removeAllElements();
            this.lstRight.removeAllElements();
            this.initHolidayItems();
            if (leftItems != null && rightItems != null) {
                this.lstLeft.removeAllElements();
                this.lstRight.removeAllElements();
                this.setItems(leftItems, this.lstLeft);
                this.setItems(rightItems, this.lstRight);
            }
        }
        this.isLoadSchema = false;
    }

    private void initHolidayItems() throws Exception {
        if (this.coll == null) {
            this.coll = HRTimeClientUtils.getSimpleLeaveItems();
        }
        DefaultListModel<TimeAttendanceInfo> model = new DefaultListModel<TimeAttendanceInfo>();
        int size = this.coll.size();
        for (int i = 0; i < size; ++i) {
            model.addElement(this.coll.get(i));
        }
        this.lstLeft.setModel(model);
    }

    protected void btnUp_actionPerformed(ActionEvent e) throws Exception {
        Object item = this.lstRight.getSelectedValue();
        if (item == null) {
            return;
        }
        int index = this.lstRight.getSelectedIndex();
        if (index == 0) {
            return;
        }
        Object item2 = this.lstRight.getElement(index - 1);
        this.lstRight.setElement(item2, index);
        this.lstRight.setElement(item, index - 1);
        this.lstRight.setSelectedIndex(index - 1);
    }

    protected void btnDown_actionPerformed(ActionEvent e) throws Exception {
        Object item = this.lstRight.getSelectedValue();
        if (item == null) {
            return;
        }
        int index = this.lstRight.getSelectedIndex();
        if (index == this.lstRight.getElementCount() - 1) {
            return;
        }
        Object item2 = this.lstRight.getElement(index + 1);
        this.lstRight.setElement(item2, index);
        this.lstRight.setElement(item, index + 1);
        this.lstRight.setSelectedIndex(index + 1);
    }

    protected void btnLeft_actionPerformed(ActionEvent e) throws Exception {
        Object[] items = this.lstRight.getSelectedValues();
        int[] rightIndics = this.lstRight.getSelectedIndices();
        if (items == null || items.length == 0) {
            return;
        }
        int size = items.length;
        for (int i = 0; i < size; ++i) {
            this.lstLeft.addElement(items[i]);
        }
        int[] indices = this.lstRight.getSelectedIndices();
        for (int i = indices.length - 1; i >= 0; --i) {
            this.lstRight.removeElementAt(indices[i]);
        }
        this.setSelectItem(this.lstRight, rightIndics[0]);
    }

    private void setSelectItem(KDList list, int beginIndex) {
        if (list.getElementCount() > 0 && list.getElementCount() > beginIndex) {
            list.setSelectedIndex(beginIndex);
        } else if (list.getElementCount() > 0 && list.getElementCount() <= beginIndex) {
            list.setSelectedIndex(beginIndex - 1);
        }
    }

    protected void btnRight_actionPerformed(ActionEvent e) throws Exception {
        Object[] items = this.lstLeft.getSelectedValues();
        int[] leftIndics = this.lstLeft.getSelectedIndices();
        if (items == null || items.length == 0) {
            return;
        }
        int size = items.length;
        for (int i = 0; i < size; ++i) {
            this.lstRight.addElement(items[i]);
        }
        int[] indices = this.lstLeft.getSelectedIndices();
        for (int i = indices.length - 1; i >= 0; --i) {
            this.lstLeft.removeElementAt(indices[i]);
        }
        this.setSelectItem(this.lstLeft, leftIndics[0]);
    }

    private Object[] getItems(KDList list) {
        int count = list.getElementCount();
        Object[] items = new Object[count];
        for (int i = 0; i < count; ++i) {
            items[i] = list.getElement(i);
        }
        return items;
    }

    public Object[] getLeftItems() {
        return this.getItems(this.lstLeft);
    }

    public Object[] getRightItems() {
        return this.getItems(this.lstRight);
    }

    private void firstLoad() throws Exception {
        this.initFilterItem();
    }

    private void initFilterItem() throws Exception {
        this.initHolidayItems();
        this.isFirstLoad = false;
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    public FilterInfo getFilterInfo() {
        return super.getFilterInfo();
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        String right = CommonQueryUtil.getStringFromArray((Object[])this.getRightItems());
        String left = CommonQueryUtil.getStringFromArray((Object[])this.getLeftItems());
        cp.addCustomerParam("right", right);
        int rightCount = this.lstRight.getElementCount();
        cp.putInt("listRightCount", rightCount);
        TimeAttendanceInfo timeAttendInfo = null;
        for (int i = 0; i < rightCount; ++i) {
            timeAttendInfo = (TimeAttendanceInfo)this.lstRight.getElement(i);
            cp.addCustomerParam("rightListCount" + i, timeAttendInfo.getNumber());
        }
        cp.addCustomerParam("left", left);
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        this.clear();
        if (cp == null) {
            return;
        }
        try {
            TimeAttendanceCollection infoCollect = CommonQueryUtil.getTimeColl((String)cp.getCustomerParam("right"));
            int listRightCount = cp.getInt("listRightCount");
            HashMap<String, Integer> defaultSelectMap = new HashMap<String, Integer>();
            for (int i = 0; i < listRightCount; ++i) {
                defaultSelectMap.put(cp.getCustomerParam("rightListCount" + i), i);
            }
            HashMap<Integer, TimeAttendanceInfo> tempMap = new HashMap<Integer, TimeAttendanceInfo>();
            for (int i = 0; i < infoCollect.size(); ++i) {
                if (!defaultSelectMap.containsKey(infoCollect.get(i).getNumber())) continue;
                Integer index = (Integer)defaultSelectMap.get(infoCollect.get(i).getNumber());
                tempMap.put(index, infoCollect.get(i));
            }
            ArrayList keyList = new ArrayList(tempMap.keySet());
            Collections.sort(keyList);
            this.lstRight.removeAllElements();
            for (int i = 0; i < keyList.size(); ++i) {
                this.lstRight.addElement(tempMap.get(keyList.get(i)));
            }
            if (keyList.size() == 0) {
                CommonQueryUtil.fillDataForList((KDList)this.lstRight, (IObjectCollection)CommonQueryUtil.getTimeColl((String)cp.getCustomerParam("right")));
            }
            CommonQueryUtil.fillDataForDelList((KDList)this.lstLeft, (IObjectCollection)CommonQueryUtil.getTimeColl((String)cp.getCustomerParam("right")));
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    private void setItems(Object[] items, KDList list) {
        list.removeAllElements();
        if (items == null) {
            return;
        }
        int size = items.length;
        for (int i = 0; i < size; ++i) {
            list.addElement(items[i]);
        }
    }

    protected void lstLeft_mouseClicked(MouseEvent e) throws Exception {
        super.lstLeft_mouseClicked(e);
        if (e.getClickCount() == 2) {
            Object[] items = this.lstLeft.getSelectedValues();
            int[] leftIndics = this.lstLeft.getSelectedIndices();
            if (items == null || items.length == 0) {
                return;
            }
            int size = items.length;
            for (int i = 0; i < size; ++i) {
                this.lstRight.addElement(items[i]);
            }
            int[] indices = this.lstLeft.getSelectedIndices();
            for (int i = indices.length - 1; i >= 0; --i) {
                this.lstLeft.removeElementAt(indices[i]);
            }
            this.setSelectItem(this.lstLeft, leftIndics[0]);
        }
    }

    protected void lstRight_mouseClicked(MouseEvent e) throws Exception {
        super.lstRight_mouseClicked(e);
        if (e.getClickCount() == 2) {
            Object[] items = this.lstRight.getSelectedValues();
            int[] rightIndics = this.lstRight.getSelectedIndices();
            if (items == null || items.length == 0) {
                return;
            }
            int size = items.length;
            for (int i = 0; i < size; ++i) {
                this.lstLeft.addElement(items[i]);
            }
            int[] indices = this.lstRight.getSelectedIndices();
            for (int i = indices.length - 1; i >= 0; --i) {
                this.lstRight.removeElementAt(indices[i]);
            }
            this.setSelectItem(this.lstRight, rightIndics[0]);
        }
    }

    public boolean verify() {
        if (this.lstRight.getElementCount() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.time.LeaveDetailCheckResource.SELECTED_LEAVE_ITEM_NULL"));
            return false;
        }
        return true;
    }

    protected void btnBottom_actionPerformed(ActionEvent e) throws Exception {
        Object item = this.lstRight.getSelectedValue();
        if (item == null) {
            return;
        }
        int count = this.lstRight.getElementCount();
        int index = this.lstRight.getSelectedIndex();
        Object item2 = null;
        for (int i = index; i < count - 1; ++i) {
            item2 = this.lstRight.getElement(i + 1);
            this.lstRight.setElement(item2, i);
        }
        this.lstRight.setElement(item, count - 1);
        this.lstRight.setSelectedIndex(count - 1);
    }

    protected void btnLeftAll_actionPerformed(ActionEvent e) throws Exception {
        int i;
        int itemCount = this.lstRight.getElementCount();
        if (itemCount == 0) {
            return;
        }
        Object[] items = new Object[itemCount];
        for (i = 0; i < itemCount; ++i) {
            items[i] = this.lstRight.getElement(i);
        }
        int size = items.length;
        for (i = 0; i < size; ++i) {
            this.lstLeft.addElement(items[i]);
        }
        int[] selected = this.lstRight.getSelectedIndices();
        this.lstLeft.setSelectedIndices(selected);
        this.lstRight.removeAllElements();
    }

    protected void btnRightAll_actionPerformed(ActionEvent e) throws Exception {
        int i;
        int itemCount = this.lstLeft.getElementCount();
        if (itemCount == 0) {
            return;
        }
        Object[] items = new Object[itemCount];
        for (i = 0; i < itemCount; ++i) {
            items[i] = this.lstLeft.getElement(i);
        }
        int size = items.length;
        for (i = 0; i < size; ++i) {
            this.lstRight.addElement(items[i]);
        }
        int[] selected = this.lstLeft.getSelectedIndices();
        this.lstRight.setSelectedIndices(selected);
        this.lstLeft.removeAllElements();
    }

    protected void btnTop_actionPerformed(ActionEvent e) throws Exception {
        Object item = this.lstRight.getSelectedValue();
        if (item == null) {
            return;
        }
        int index = this.lstRight.getSelectedIndex();
        Object item2 = null;
        for (int i = index - 1; i >= 0; --i) {
            item2 = this.lstRight.getElement(i);
            this.lstRight.setElement(item2, i + 1);
        }
        this.lstRight.setElement(item, 0);
        this.lstRight.setSelectedIndex(0);
    }

    public void clear() {
        super.clear();
        try {
            this.lstLeft.removeAllElements();
            this.lstRight.removeAllElements();
            this.initFilterItem();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.btnUp.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.btnDown.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.btnLeft.setIcon(EASResource.getIcon((String)"imgTbtn_move_left"));
        this.btnRight.setIcon(EASResource.getIcon((String)"imgTbtn_move_right"));
        this.btnLeftAll.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_left"));
        this.btnRightAll.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_right"));
        this.btnTop.setIcon(EASResource.getIcon((String)"imgTbtn_movetop1"));
        this.btnBottom.setIcon(EASResource.getIcon((String)"imgTbtn_movebottom"));
    }
}

