/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.time.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QueryPanelCollection;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.base.client.util.HRClientUtil;
import com.kingdee.eas.hr.compensation.util.HRReportUtils;
import com.kingdee.eas.hr.time.TimeAttendanceInfo;
import com.kingdee.eas.hr.time.client.AbstractLeaveHistoryQueryReportUI;
import com.kingdee.eas.hr.time.client.IProgTask;
import com.kingdee.eas.hr.time.client.LeaveHistoryQueryFilter2UI;
import com.kingdee.eas.hr.time.client.LeaveHistoryQueryFilterUI;
import com.kingdee.eas.hr.time.client.ProgDialog;
import com.kingdee.eas.hr.time.client.TimeUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class LeaveHistoryQueryReportUI
extends AbstractLeaveHistoryQueryReportUI {
    private static Logger logger = Logger.getLogger(LeaveHistoryQueryReportUI.class);
    private static final long serialVersionUID = -61166L;
    private Date beginDate;
    private Date endDate;
    private Object[] leftItems;
    private Object[] rightItems;
    private AdminOrgUnitInfo orgInfo;
    private PersonInfo personInfo;
    private Boolean isIncludeSubOrg;
    private static final int SUMUP_COL_WIDTH = 80;
    private FilterInfo filter = null;
    private boolean isFirstDefaultQuery = true;
    private CommonQueryDialog dialog = null;
    private boolean isForOrg = true;
    boolean isRelateOrg = false;
    private String commonFilter = null;
    private KDTSortManager sortManager = new KDTSortManager(this.tblMain);
    private static final int PERSONNUM_COL_WIDTH = 60;
    private static final int PERSONNAME_COL_WIDTH = 60;
    private static final int POSITION_COL_WIDTH = 60;
    private static final int ORG_COL_WIDTH = 100;

    public void onLoad() throws Exception {
        HRClientUtil.checkCurrentHRUnitNotNull((CoreUI)this);
        this.isRelateOrg = TimeUtil.getParamValue("AttendanceData_Relate_OrgUnit");
        super.onLoad();
        this.tblMain.checkParsed();
        this.loadFilterUI(false);
        int count = this.tblMain.getColumnCount();
        for (int i = 0; i < count; ++i) {
            this.tblMain.getColumn(i).setSortable(true);
        }
        this.sortManager.setSortAuto(true);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.setButtonDefaultStyl(this.btnQuery);
        this.setButtonDefaultStyl(this.btnRefresh);
        this.setButtonDefaultStyl(this.btnPrintPreview);
        this.setButtonDefaultStyl(this.btnPrint);
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.btnPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.menuItemPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.menuItemPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.menuItemRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.menuItemQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        if (this.dialog != null && this.getUIContext() != null && "report".equals(this.getUIContext().get("UIClassParam"))) {
            this.dialog.changeOwner((Component)((Object)this));
        }
        this.loadFilterUI(false);
    }

    public void loadFilterUI(boolean loaded) throws Exception {
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        String queryName = "";
        queryName = this.isRelateOrg ? "com.kingdee.eas.hr.time.app.LeaveDetailHistoryQuery" : "com.kingdee.eas.hr.time.app.LeaveHistoryQuery";
        if (this.isFirstDefaultQuery && iQuery.hasDefaultSolution(this.getMetaDataPK().getFullName(), queryName)) {
            QuerySolutionInfo solution = iQuery.getDefaultSolution(this.getMetaDataPK().getFullName(), queryName);
            QueryPanelCollection coll = solution.getQueryPanelInfo();
            CustomerParams cp = null;
            CustomerParams cp2 = null;
            int j = coll.size();
            for (int i = 0; i < j; ++i) {
                QueryPanelInfo qpInfo = coll.get(i);
                if ("com.kingdee.eas.hr.time.client.LeaveHistoryQueryFilterUI".equals(qpInfo.getPanelClassName())) {
                    cp2 = CustomerParams.getCustomerParams2((String)qpInfo.getCustomerParams());
                    continue;
                }
                if ("com.kingdee.eas.hr.time.client.LeaveHistoryQueryFilter2UI".equals(qpInfo.getPanelClassName())) {
                    cp = CustomerParams.getCustomerParams2((String)qpInfo.getCustomerParams());
                    continue;
                }
                this.commonFilter = qpInfo.getFilterInfo();
            }
            if (cp == null) {
                this.showFilterDialog();
            } else {
                LeaveHistoryQueryFilterUI filterUI = new LeaveHistoryQueryFilterUI();
                LeaveHistoryQueryFilter2UI filterUI2 = new LeaveHistoryQueryFilter2UI();
                if (cp2 != null && cp2.getCustomerParam("start") != null) {
                    filterUI2.setCustomerParams(cp2);
                    filterUI.setCustomerParams(cp);
                } else {
                    filterUI2.setCustomerParams(cp);
                    filterUI.setCustomerParams(cp2);
                }
                this.isForOrg = filterUI2.radioOrg.isSelected();
                this.orgInfo = (AdminOrgUnitInfo)filterUI2.promptOrg.getValue();
                if (this.orgInfo == null && cp.getCustomerParam("idpromptOrg") != null) {
                    this.orgInfo = new AdminOrgUnitInfo();
                    this.orgInfo.setId(BOSUuid.read((String)cp.getCustomerParam("idpromptOrg")));
                    this.orgInfo.setNumber(cp.getCustomerParam("numberpromptOrg"));
                    this.orgInfo.setLongNumber(cp.getCustomerParam("longNumberpromptOrg"));
                }
                this.personInfo = (PersonInfo)filterUI2.promptPerson.getValue();
                this.isIncludeSubOrg = true;
                if (this.isIncludeSubOrg == null) {
                    this.isIncludeSubOrg = Boolean.FALSE;
                }
                if (cp.getCustomerParam("pkBeginDate") != null && cp.getCustomerParam("pkEndDate") != null) {
                    this.beginDate = new Date(Long.valueOf(cp.getCustomerParam("pkBeginDate")) / 1000L * 1000L);
                    this.endDate = new Date(Long.valueOf(cp.getCustomerParam("pkEndDate")) / 1000L * 1000L);
                } else {
                    this.beginDate = filterUI2.getBeginDate();
                    this.endDate = filterUI2.getEndDate();
                }
                this.pkBeginDate.setValue((Object)this.beginDate);
                this.pkEndDate.setValue((Object)this.endDate);
                this.leftItems = filterUI.getLeftItems();
                this.rightItems = filterUI.getRightItems();
                this.filter = this.getMergeFilter();
                if (this.beginDate != null && this.endDate != null) {
                    logger.info((Object)"loadFilterUI initUI()");
                    this.initUI();
                }
            }
            this.isFirstDefaultQuery = false;
        } else {
            this.showFilterDialog();
        }
    }

    private void showFilterDialog() throws Exception {
        LeaveHistoryQueryFilterUI filterUI = null;
        LeaveHistoryQueryFilter2UI filterUI2 = null;
        if (this.dialog == null) {
            this.initCommonQueryDialog();
        }
        if (this.dialog.show()) {
            filterUI2 = (LeaveHistoryQueryFilter2UI)this.dialog.getUserPanel(1);
            filterUI = (LeaveHistoryQueryFilterUI)this.dialog.getUserPanel(0);
            this.isForOrg = filterUI2.radioOrg.isSelected();
            this.orgInfo = (AdminOrgUnitInfo)filterUI2.promptOrg.getValue();
            this.personInfo = (PersonInfo)filterUI2.promptPerson.getValue();
            this.isIncludeSubOrg = filterUI2.cbIncludeSubOrg.isSelected();
            if (this.isIncludeSubOrg == null) {
                this.isIncludeSubOrg = Boolean.FALSE;
            }
            this.beginDate = filterUI2.getBeginDate();
            this.endDate = filterUI2.getEndDate();
            this.pkBeginDate.setValue((Object)this.beginDate);
            this.pkEndDate.setValue((Object)this.endDate);
            this.leftItems = filterUI.getLeftItems();
            this.rightItems = filterUI.getRightItems();
            this.filter = this.getMergeFilter();
            if (this.beginDate != null && this.endDate != null) {
                logger.info((Object)"showFilterDialog initUI()");
                this.initUI();
            }
            this.dialog.getEntityViewInfoResult();
        } else {
            SysUtil.abort();
        }
    }

    private void initCommonQueryDialog() throws Exception {
        this.dialog = new CommonQueryDialog();
        LeaveHistoryQueryFilter2UI filterUI2 = new LeaveHistoryQueryFilter2UI();
        LeaveHistoryQueryFilterUI filterUI = new LeaveHistoryQueryFilterUI();
        if (this.getUIWindow() == null) {
            this.dialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
        } else {
            this.dialog.setOwner((Component)((Object)this));
        }
        filterUI2.getUIContext().put("beginDate", this.beginDate);
        filterUI2.getUIContext().put("endDate", this.endDate);
        filterUI2.getUIContext().put("adminOrgUnitInfo", this.orgInfo);
        filterUI2.getUIContext().put("personInfo", this.personInfo);
        filterUI2.getUIContext().put("isIncludeSubOrg", this.isIncludeSubOrg);
        filterUI2.getUIContext().put("isFirstLoad2", Boolean.TRUE);
        filterUI.getUIContext().put("leftItems", this.leftItems);
        filterUI.getUIContext().put("rightItems", this.rightItems);
        filterUI.getUIContext().put("isFirstLoad", Boolean.TRUE);
        this.dialog.setParentUIClassName(this.getMetaDataPK().getFullName());
        this.dialog.setShowFilter(true);
        this.dialog.setShowSorter(false);
        String commonQueryRes = "com.kingdee.eas.hr.time.TimeResource";
        this.dialog.setTitle(this.getUITitle() + " - " + EASResource.getString((String)commonQueryRes, (String)"CONDITION_QUERY"));
        this.dialog.setQueryObjectPK((IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.time.app.LeaveHistoryQuery"));
        filterUI2.setPanelName(filterUI2.getUITitle());
        this.dialog.addUserPanel((KDPanel)filterUI2);
        filterUI.setPanelName(filterUI.getUITitle());
        this.dialog.addUserPanel((KDPanel)filterUI);
    }

    private FilterInfo getMergeFilter() throws Exception {
        if (!this.isRelateOrg) {
            FilterInfo filter = new FilterInfo();
            if (this.beginDate != null && this.endDate != null) {
                filter.getFilterItems().add(new FilterItemInfo("startDateReal", (Object)this.endDate, CompareType.LESS_EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("endDateReal", (Object)this.beginDate, CompareType.GREATER_EQUALS));
            } else if (this.beginDate != null && this.endDate == null) {
                filter.getFilterItems().add(new FilterItemInfo("startDateReal", (Object)this.beginDate, CompareType.GREATER_EQUALS));
            } else if (this.beginDate == null && this.endDate != null) {
                filter.getFilterItems().add(new FilterItemInfo("endDateReal", (Object)this.endDate, CompareType.LESS_EQUALS));
            }
            HashSet<String> set = new HashSet<String>();
            int size = this.rightItems.length;
            for (int i = 0; i < size; ++i) {
                set.add(((TimeAttendanceInfo)this.rightItems[i]).getId().toString());
            }
            if (set.size() > 0) {
                filter.getFilterItems().add(new FilterItemInfo("timeAttendance.id", set, CompareType.INCLUDE));
            }
            if (this.personInfo != null && !this.isForOrg) {
                filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)this.personInfo.getId().toString()));
            }
            if (this.orgInfo != null && this.isForOrg) {
                if (this.isIncludeSubOrg.booleanValue()) {
                    FilterInfo orgFi = new FilterInfo();
                    orgFi.getFilterItems().add(new FilterItemInfo("adminOrgUnit.longNumber", (Object)this.orgInfo.getLongNumber()));
                    orgFi.getFilterItems().add(new FilterItemInfo("adminOrgUnit.longNumber", (Object)(this.orgInfo.getLongNumber() + "!%"), CompareType.LIKE));
                    orgFi.setMaskString("(#0 or #1)");
                    filter.mergeFilter(orgFi, "and");
                } else {
                    filter.getFilterItems().add(new FilterItemInfo("adminOrgUnit.longNumber", (Object)this.orgInfo.getLongNumber()));
                }
            }
            filter.mergeFilter(TimeUtil.getHRAndAdminRangeFilterInfo(null, "adminOrgUnit.id"), "AND");
            if (this.dialog != null && this.dialog.getEntityViewInfoResult() != null) {
                filter.mergeFilter(this.dialog.getEntityViewInfoResult().getFilter(), "AND");
            } else if (this.commonFilter != null) {
                FilterInfo comFilter = new FilterInfo(this.commonFilter);
                filter.mergeFilter(comFilter, "and");
            }
            return filter;
        }
        String longNum = null;
        String pId = null;
        if (this.orgInfo != null) {
            longNum = this.orgInfo.getLongNumber();
        }
        if (this.personInfo != null) {
            pId = this.personInfo.getId().toString();
        }
        FilterInfo outRangeFi = this.getOutOrgRangePersonFilter(longNum, pId, this.isIncludeSubOrg, this.beginDate, this.endDate);
        FilterInfo cFi = this.dialog.getCommonFilter();
        if (cFi != null && cFi.getFilterItems().size() > 0) {
            outRangeFi.mergeFilter(cFi, "and");
        }
        return outRangeFi;
    }

    private void initUI() throws Exception {
        IProgTask prog = new IProgTask(){

            public Object exec() throws Exception {
                LeaveHistoryQueryReportUI.this.clearTable();
                LeaveHistoryQueryReportUI.this.initTableColumn();
                LeaveHistoryQueryReportUI.this.initTableHeader();
                LeaveHistoryQueryReportUI.this.initDatas();
                return "";
            }

            public void afterExec(Object result) throws Exception {
            }
        };
        ProgDialog progDialog = null;
        Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
        progDialog = win instanceof Frame ? new ProgDialog((Frame)win) : (win instanceof Dialog ? new ProgDialog((Dialog)win) : new ProgDialog((Frame)this.getUIContext().get("OwnerWindow")));
        progDialog.setLongTimeTask(prog);
        progDialog.show();
        if (this.tblMain.getRowCount() > 0) {
            this.calculateTotalRow(true);
        }
    }

    private void clearTable() {
        this.tblMain.removeRows();
        this.tblMain.removeColumns();
    }

    private void initTableColumn() {
        IColumn col = null;
        col = this.tblMain.addColumn();
        col.setKey("person.id");
        col.getStyleAttributes().setHided(true);
        col = this.tblMain.addColumn();
        col.setKey("adminOrgUnit.name");
        col.setWidth(100);
        col = this.tblMain.addColumn();
        col.setKey("position.name");
        col.setWidth(60);
        col = this.tblMain.addColumn();
        col.setKey("person.number");
        col.setWidth(60);
        col = this.tblMain.addColumn();
        col.setKey("person.name");
        col.setWidth(60);
        col = this.tblMain.addColumn();
        col.setKey("EmployeeType.name");
        col.setWidth(100);
        if (this.rightItems != null && this.rightItems.length > 0) {
            TimeAttendanceInfo info = null;
            int size = this.rightItems.length;
            for (int i = 0; i < size; ++i) {
                info = (TimeAttendanceInfo)this.rightItems[i];
                col = this.tblMain.addColumn();
                col.setKey(info.getId().toString());
                col.setUserObject((Object)info);
                col.setWidth(80);
                col.getStyleAttributes().setNumberFormat("0.00");
                col.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            }
        }
    }

    private void initTableHeader() {
        IRow row = this.tblMain.addHeadRow();
        int size = this.tblMain.getColumnCount();
        for (int i = 0; i < size; ++i) {
            row.getCell(i).setValue((Object)this.getHeadCellValue(i));
        }
    }

    private String getCellValueByKey(String key) {
        if (key.equals("person.id")) {
            return "ID";
        }
        return EASResource.getString((String)("com.kingdee.eas.hr.time.LeaveDetailCheckResource." + key.replace('.', '_')));
    }

    private String getHeadCellValue(int index) {
        IColumn col = this.tblMain.getColumn(index);
        if (col.getUserObject() != null) {
            TimeAttendanceInfo info = (TimeAttendanceInfo)col.getUserObject();
            return info.getName() + "(" + (Object)((Object)info.getUnitType()) + ")";
        }
        return this.getCellValueByKey(col.getKey());
    }

    private void initDatas() throws Exception {
        MetaDataPK pk = this.isRelateOrg ? new MetaDataPK("com.kingdee.eas.hr.time.app.LeaveDetailHistoryQuery") : new MetaDataPK("com.kingdee.eas.hr.time.app.LeaveHistoryQuery");
        IQueryExecutor iqry = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)pk);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(this.filter);
        iqry.setObjectView(evi);
        IRowSet rows = iqry.executeQuery();
        HashMap<String, Integer> personIdMaps = new HashMap<String, Integer>();
        IRow row = null;
        ICell cell = null;
        String personId = null;
        int rowCount = 0;
        while (rows.next()) {
            personId = rows.getString("person.id") + rows.getString("position.id") + rows.getString("adminOrgUnit.id");
            if (personIdMaps.get(personId) != null) {
                row = this.tblMain.getRow(((Integer)personIdMaps.get(personId)).intValue());
            } else {
                row = this.tblMain.addRow();
                row.getCell("person.id").setValue((Object)personId);
                row.getCell("person.number").setValue((Object)rows.getString("person.number"));
                row.getCell("person.name").setValue((Object)rows.getString("person.name"));
                row.getCell("position.name").setValue((Object)rows.getString("position.name"));
                row.getCell("adminOrgUnit.name").setValue((Object)rows.getString("adminOrgUnit.name"));
                row.getCell("EmployeeType.name").setValue((Object)rows.getString("EmployeeType.name"));
                personIdMaps.put(personId, rowCount);
                ++rowCount;
            }
            if ((cell = row.getCell(rows.getString("timeAttendance.id"))) == null || cell.getValue() != null) continue;
            cell.setValue((Object)rows.getBigDecimal("totalRegReal"));
        }
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().print();
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().printPreview();
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        logger.info((Object)"in reresh initUI");
        this.initUI();
    }

    private FilterInfo getOutOrgRangePersonFilter(String orgLongNum, String pId, boolean isInclude, Date fromDate, Date toDate) {
        FilterInfo fi = new FilterInfo();
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        String hrOrgUnitID = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        StringBuffer sql = new StringBuffer();
        sql.append(" select am.FId from t_hr_leaveDetail am ");
        sql.append(" left join t_org_admin org on am.FAdminOrgUnitId = org.FId ");
        sql.append(" where ");
        sql.append(" am.FAdminOrgUnitId in ");
        sql.append(" ( ");
        sql.append(" SELECT FFromUnitID FROM T_ORG_UnitRelation WHERE FToUnitID = ");
        sql.append("'").append(hrOrgUnitID).append("'");
        sql.append(" AND FTypeRelationID = '00000000-0000-0000-0000-0000000000100FE9F8B5'");
        sql.append(" AND FFromUnitID IN ");
        sql.append("(");
        sql.append(" SELECT FOrgID FROM T_PM_OrgRange ");
        sql.append(" WHERE FUserID = ");
        sql.append("'").append(userID).append("'");
        sql.append(" and FType = 20 ");
        sql.append(")");
        sql.append(")");
        if (orgLongNum != null) {
            if (isInclude) {
                sql.append(" and( ");
                sql.append(" org.FLongNumber = '").append(orgLongNum).append("'");
                sql.append(" or ");
                sql.append(" org.FLongNumber like '").append(orgLongNum).append("!%'");
                sql.append(" ) ");
            } else {
                sql.append(" and org.FLongNumber = '").append(orgLongNum).append("'");
            }
        }
        if (pId != null) {
            sql.append(" and am.FPersonId = '").append(pId).append("'");
        }
        if (fromDate != null && toDate != null) {
            sql.append(" and am.FStartDateReal <= to_date('").append(format.format(toDate)).append("')");
            sql.append(" and am.FEndDateReal >= to_date('").append(format.format(fromDate)).append("')");
        } else if (fromDate != null && toDate == null) {
            sql.append(" and am.FStartDateReal >= to_date('").append(format.format(fromDate)).append("')");
        } else if (toDate != null && fromDate == null) {
            sql.append(" and am.FEndDateReal <= to_date('").append(format.format(toDate)).append("')");
        }
        sql.append(" and (am.FDataSource = '").append(20).append("' or am.FDataSource = '10')");
        sql.append(" and FCheckState = 1 ");
        fi.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.INNER));
        return fi;
    }

    protected KDTable getTableForPrintSetting() {
        return this.tblMain;
    }

    private void calculateTotalRow(boolean needAddRow) {
        int i;
        IRow totalRow = null;
        if (needAddRow) {
            totalRow = this.tblMain.addRow();
            totalRow.getStyleAttributes().setBackground(HRReportUtils.TOTAL_COLOR);
            if (totalRow.getCell("adminOrgUnit.name") != null) {
                totalRow.getCell("adminOrgUnit.name").setValue((Object)EASResource.getString((String)"com.kingdee.eas.hr.time.LeaveDetailCheckResource", (String)"totalValue"));
            }
        } else {
            return;
        }
        if (this.rightItems == null || this.rightItems.length == 0) {
            return;
        }
        double[] itemsValue = new double[this.rightItems.length];
        TimeAttendanceInfo info = null;
        IRow row = null;
        int rowCount = this.tblMain.getRowCount() - 1;
        for (i = 0; i < rowCount; ++i) {
            row = this.tblMain.getRow(i);
            int size = this.rightItems.length;
            for (int j = 0; j < size; ++j) {
                info = (TimeAttendanceInfo)this.rightItems[j];
                if (row.getCell(info.getId().toString()).getValue() == null) continue;
                int n = j;
                itemsValue[n] = itemsValue[n] + Double.parseDouble(row.getCell(info.getId().toString()).getValue().toString());
            }
        }
        int size = this.rightItems.length;
        for (i = 0; i < size; ++i) {
            info = (TimeAttendanceInfo)this.rightItems[i];
            totalRow.getCell(info.getId().toString()).setValue((Object)(itemsValue[i] + ""));
        }
        if (this.tblMain.getRowCount() > 2) {
            this.sortManager.setSortAuto(true);
            TimeUtil.enableTableHeadSortNotNeedSortManager(this.tblMain, 0, this.tblMain.getRowCount() - 2, this.sortManager);
            this.tblMain.setSortMange(this.sortManager);
        } else {
            this.sortManager.setSortAuto(false);
            this.tblMain.setSortMange(this.sortManager);
        }
    }
}

