/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.time.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.emp.IUserPermission;
import com.kingdee.eas.hr.emp.UserPermissionCollection;
import com.kingdee.eas.hr.emp.UserPermissionFactory;
import com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox;
import com.kingdee.eas.hr.time.client.AbstractLeaveRegQueryPanelUI;
import com.kingdee.eas.hr.time.client.LeaveRegUI;
import com.kingdee.eas.hr.time.client.TimeAttendanceUtils;
import com.kingdee.eas.hr.time.client.TimeUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ItemEvent;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class LeaveRegQueryPanelUI
extends AbstractLeaveRegQueryPanelUI {
    private static final long serialVersionUID = -61166L;
    private static final String ADMINORG = "AdminOrgUnit.longNumber";
    private static final String PERSON_ID = "PERSON.id";
    private static final Logger logger = CoreUIObject.getLogger(LeaveRegQueryPanelUI.class);
    private LeaveRegUI parentUI;

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.parentUI == null) {
            this.parentUI = new LeaveRegUI();
        }
        this.initF7();
    }

    public void initF7() {
        EmployeeMultiF7PromptBox mBox = new EmployeeMultiF7PromptBox((IUIObject)this);
        try {
            this.setF7Filter(mBox);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        mBox.setModal(true);
        mBox.setIsSingleSelect(false);
        mBox.showNoPositionPerson(true);
        mBox.setUserOrgRangeFilter(true);
        mBox.setReturnPositionAndUnit(false);
        mBox.setIsPluralityIsChooseContral(false);
        HashSet<BOSUuid> set = new HashSet<BOSUuid>();
        set.add(SysContext.getSysContext().getCurrentHRUnit().getId());
        mBox.setHROFilter(set);
        this.prmtPerson.setSelector((KDPromptSelector)mBox);
        this.prmtPerson.setEnabled(false);
        this.prmtPerson.setDisplayFormat("$name$");
        this.prmtPerson.setEnabledMultiSelection(true);
        this.prmtPerson.setEditable(false);
        this.prmtOrg.setQueryInfo("com.kingdee.eas.basedata.org.app.AdminOrgUnitQuery");
        this.prmtOrg.setCommitFormat("$number$");
        this.prmtOrg.setEditFormat("$number$");
        this.prmtOrg.setDisplayFormat("$name$");
        TimeAttendanceUtils.initF7Selector((IUIObject)this, this.prmtOrg);
        this.prmtOrg.setEditable(false);
    }

    private void setF7Filter(EmployeeMultiF7PromptBox pmt) throws Exception {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)"1"));
        filter.getFilterItems().add(new FilterItemInfo("user", (Object)SysContext.getSysContext().getCurrentUserInfo().getId().toString()));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        IUserPermission iup = UserPermissionFactory.getRemoteInstance();
        UserPermissionCollection collection = iup.getUserPermissionCollection(viewInfo);
        String filterString = null;
        if (collection != null && collection.size() > 0) {
            filterString = collection.get(0).getFilter();
        }
        if (filterString == null) {
            return;
        }
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.emp.app", "EmpInfoQuery");
        IQueryExecutor iQe = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        filter = new FilterInfo(filterString);
        viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        viewInfo.setSelector(sic);
        iQe.setObjectView(viewInfo);
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)iQe.getSQL(), CompareType.INNER));
        pmt.setNopositionPersonFilter(filter);
    }

    public void clear() {
        super.clear();
        this.radioOrg.setSelected(true);
        this.prmtOrg.setData(null);
        this.prmtOrg.setEnabled(true);
        this.chkHasLowLever.setEnabled(true);
        this.chkHasLowLever.setSelected(false);
        this.prmtPerson.setData(null);
        this.prmtPerson.setEnabled(false);
    }

    protected void radioPerson_itemStateChanged(ItemEvent e) throws Exception {
        boolean flag = this.radioPerson.isSelected();
        this.prmtOrg.setEnabled(!flag);
        this.chkHasLowLever.setEnabled(!flag);
        this.prmtPerson.setEnabled(flag);
        if (flag) {
            this.prmtOrg.setValue(null);
            this.chkHasLowLever.setSelected(false);
        } else {
            this.prmtPerson.setValue(null);
        }
    }

    public FilterInfo getFilterInfo() {
        this.filterInfo = new FilterInfo();
        boolean isRelateOrg = false;
        try {
            isRelateOrg = TimeUtil.getParamValue("AttendanceData_Relate_OrgUnit");
        }
        catch (Exception e) {
            super.handUIException((Throwable)e);
        }
        if (this.radioOrg.isSelected()) {
            AdminOrgUnitInfo orgUnit = (AdminOrgUnitInfo)this.prmtOrg.getData();
            String longNum = null;
            boolean isInclude = false;
            if (orgUnit != null) {
                longNum = orgUnit.getLongNumber();
                isInclude = this.chkHasLowLever.isSelected();
            } else {
                longNum = this.parentUI.getLongNum();
                isInclude = this.parentUI.isInclude();
            }
            if (longNum != null) {
                if (isInclude) {
                    FilterInfo orgFi = new FilterInfo();
                    orgFi.getFilterItems().add(new FilterItemInfo(ADMINORG, (Object)(longNum + "!%"), CompareType.LIKE));
                    orgFi.getFilterItems().add(new FilterItemInfo(ADMINORG, (Object)longNum));
                    orgFi.setMaskString("#0 or #1");
                    try {
                        this.filterInfo.mergeFilter(orgFi, "and");
                    }
                    catch (BOSException e) {
                        super.handUIException((Throwable)e);
                    }
                } else {
                    this.filterInfo.getFilterItems().add(new FilterItemInfo(ADMINORG, (Object)longNum));
                }
            }
            FilterInfo fi = TimeUtil.getAdminRangePersonFilter("person.id");
            try {
                this.filterInfo.mergeFilter(fi, "and");
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            Date sDate = this.parentUI.getStartDate();
            Date eDate = this.parentUI.getEndDate();
            Calendar c = Calendar.getInstance();
            if (sDate == null) {
                c.set(5, 1);
                c.set(11, 0);
                c.set(12, 0);
                c.set(14, 0);
                c.set(11, 0);
                c.set(12, 0);
                c.set(13, 0);
            } else {
                c.setTime(sDate);
                c.set(11, 0);
                c.set(12, 0);
                c.set(13, 0);
            }
            sDate = c.getTime();
            if (eDate == null) {
                eDate = new Date();
            }
            c.setTime(eDate);
            c.set(11, 23);
            c.set(12, 59);
            c.set(13, 59);
            eDate = c.getTime();
            if (longNum == null) {
                longNum = this.parentUI.getLongNum();
                isInclude = this.parentUI.isInclude();
            }
            if (isRelateOrg) {
                FilterInfo filter = this.getOutOrgRangePersonFilter(longNum, isInclude, sDate, eDate);
                try {
                    this.filterInfo.mergeFilter(filter, "or");
                }
                catch (BOSException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            }
        } else {
            Object obj = this.prmtPerson.getData();
            if (obj != null) {
                if (obj instanceof PersonInfo) {
                    PersonInfo person = (PersonInfo)obj;
                    if (person != null) {
                        this.filterInfo.getFilterItems().add(new FilterItemInfo(PERSON_ID, (Object)person.getId().toString()));
                    }
                } else {
                    Object[] array = (Object[])obj;
                    HashSet<String> set = new HashSet<String>();
                    for (int i = 0; i < array.length; ++i) {
                        set.add(((PersonInfo)array[i]).getId().toString());
                    }
                    this.filterInfo.getFilterItems().add(new FilterItemInfo(PERSON_ID, set, CompareType.INCLUDE));
                }
            }
            FilterInfo fi = TimeUtil.getAdminRangePersonFilter("person.id");
            try {
                this.filterInfo.mergeFilter(fi, "and");
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        return this.filterInfo;
    }

    public CustomerParams getCustomerParams() {
        return TimeUtil.saveAllData(this);
    }

    public void setCustomerParams(CustomerParams cp) {
        TimeUtil.retriveAllData(cp, this);
    }

    public boolean verify() {
        return true;
    }

    private FilterInfo getOutOrgRangePersonFilter(String orgLongNum, boolean isInclude, Date fromDate, Date toDate) {
        FilterInfo fi = new FilterInfo();
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        String hrOrgUnitID = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        StringBuffer sql = new StringBuffer();
        sql.append(" select distinct am.FPersonId from t_hr_leaveDetail am ");
        sql.append(" left join t_org_admin org on am.FAdminOrgUnitId = org.FId ");
        sql.append(" where ");
        sql.append(" am.FAdminOrgUnitId in ");
        sql.append(" ( ");
        sql.append(" SELECT FFromUnitID FROM T_ORG_UnitRelation WHERE FToUnitID = ");
        sql.append("'").append(hrOrgUnitID).append("'");
        sql.append(" AND FTypeRelationID = '00000000-0000-0000-0000-0000000000100FE9F8B5'");
        sql.append(" AND FFromUnitID IN ");
        sql.append("(");
        sql.append(" SELECT FOrgID FROM T_PM_OrgRange ");
        sql.append(" WHERE FUserID = ");
        sql.append("'").append(userID).append("'");
        sql.append(" and FType = 20 ");
        sql.append(")");
        sql.append(")");
        if (orgLongNum != null) {
            if (isInclude) {
                sql.append(" and ");
                sql.append(" ( ");
                sql.append(" org.FLongNumber ='").append(orgLongNum).append("'");
                sql.append(" or org.FLongNumber like '").append(orgLongNum).append("!%'");
                sql.append(" ) ");
            } else {
                sql.append(" and org.FLongNumber = '").append(orgLongNum).append("'");
            }
        }
        if (fromDate != null) {
            sql.append(" and am.FStartDateReal >= to_date('").append(format.format(fromDate)).append("')");
        }
        if (toDate != null) {
            sql.append(" and am.FEndDateReal <= to_date('").append(format.format(toDate)).append("')");
        }
        sql.append(" and am.FDataSource ='").append(20).append("'");
        ISQLExecutor exec = SQLExecutorFactory.getRemoteInstance((String)sql.toString());
        IRowSet rs = null;
        ArrayList<String> listIds = new ArrayList<String>();
        try {
            rs = exec.executeSQL();
        }
        catch (BOSException e) {
            super.handUIException((Throwable)e);
        }
        try {
            if (rs != null) {
                while (rs.next()) {
                    if (rs.getString(1) == null) continue;
                    listIds.add(rs.getString(1));
                }
            }
        }
        catch (SQLException e) {
            super.handUIException((Throwable)e);
        }
        if (listIds.size() > 0) {
            fi.getFilterItems().add(new FilterItemInfo("person.id", new HashSet(listIds), CompareType.INCLUDE));
        } else {
            listIds.add("");
            fi.getFilterItems().add(new FilterItemInfo("person.id", new HashSet(listIds), CompareType.INCLUDE));
        }
        return fi;
    }

    public LeaveRegUI getParentUI() {
        return this.parentUI;
    }

    public void setParentUI(LeaveRegUI parentUI) {
        this.parentUI = parentUI;
    }
}

