/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.time.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTimePicker;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.client.AttachmentUIContextInfo;
import com.kingdee.eas.base.attachment.common.AttachmentClientManager;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.PositionMemberInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.person.client.PersonPromptBox;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.hr.compensation.ItemDataTypeEnum;
import com.kingdee.eas.hr.emp.client.EmployeeClientUtils;
import com.kingdee.eas.hr.time.ApproveStateEnum;
import com.kingdee.eas.hr.time.BizStateEnum;
import com.kingdee.eas.hr.time.LeaveBillCollection;
import com.kingdee.eas.hr.time.LeaveBillEntryCollection;
import com.kingdee.eas.hr.time.LeaveBillEntryInfo;
import com.kingdee.eas.hr.time.LeaveBillFactory;
import com.kingdee.eas.hr.time.LeaveBillInfo;
import com.kingdee.eas.hr.time.LeaveDetailException;
import com.kingdee.eas.hr.time.LeaveReportBillEntryCollection;
import com.kingdee.eas.hr.time.LeaveReportBillEntryInfo;
import com.kingdee.eas.hr.time.LeaveReportBillFactory;
import com.kingdee.eas.hr.time.LeaveReportBillInfo;
import com.kingdee.eas.hr.time.TimeAttendanceCollection;
import com.kingdee.eas.hr.time.TimeAttendanceInfo;
import com.kingdee.eas.hr.time.client.AbstractLeaveReportBillEditUI;
import com.kingdee.eas.hr.time.client.HRTimeClientUtils;
import com.kingdee.eas.hr.time.client.LeaveBillEditUI;
import com.kingdee.eas.hr.time.client.SelfLeaveQueryUI;
import com.kingdee.eas.hr.time.client.TimeAttendanceUtils;
import com.kingdee.eas.hr.time.client.TimeBaseClientUtils;
import com.kingdee.eas.hr.time.client.TimeUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class LeaveReportBillEditUI
extends AbstractLeaveReportBillEditUI {
    private static final Logger logger = CoreUIObject.getLogger(LeaveReportBillEditUI.class);
    private LeaveBillInfo leaveInfo = null;

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        this.checkDate(this.kdtEntries);
    }

    public void initUIMenuBarLayout() {
        super.initUIMenuBarLayout();
        this.btnLeaveQuery.setIcon(EASResource.getIcon((String)"imgTbtn_showlist"));
        this.menuItemLeaveQuery.setIcon(EASResource.getIcon((String)"imgTbtn_showlist"));
    }

    protected ArrayList getNoNullColumns() {
        ArrayList<String> cols = new ArrayList<String>();
        cols.add("person");
        cols.add("beginDate");
        cols.add("beginTime");
        cols.add("endDate");
        cols.add("endTime");
        cols.add("type");
        cols.add("leaveLength");
        return cols;
    }

    protected IObjectValue createNewData() {
        LeaveReportBillInfo info = new LeaveReportBillInfo();
        info.setLeaveBill(this.leaveInfo);
        if (this.leaveInfo != null) {
            info.setNumber(this.leaveInfo.getNumber());
        }
        if (this.leaveInfo != null) {
            info.setPhone(this.leaveInfo.getPhone());
        }
        info.setIsMultiEntry(true);
        try {
            info.setApplyDate(DateTimeUtils.truncateDate((Date)TimeUtil.getServerTime()));
        }
        catch (BOSException e) {
            super.handleException((Exception)((Object)e));
        }
        if (this.leaveInfo != null) {
            info.setAdminOrg(this.leaveInfo.getAdminOrg());
        }
        LeaveReportBillEntryInfo entry = null;
        LeaveBillEntryCollection leaveColl = new LeaveBillEntryCollection();
        if (this.leaveInfo != null) {
            leaveColl = this.leaveInfo.getEntries();
        }
        LeaveBillEntryInfo leaveEntry = null;
        int size = leaveColl.size();
        for (int i = 0; i < size; ++i) {
            leaveEntry = leaveColl.get(i);
            entry = new LeaveReportBillEntryInfo();
            entry.setNumber(leaveEntry.getNumber());
            entry.setBeginTime(leaveEntry.getBeginTime());
            entry.setEndTime(leaveEntry.getEndTime());
            entry.setType(leaveEntry.getType());
            entry.setLeaveLength(leaveEntry.getLeaveLength());
            entry.setLeaveBillEntry(leaveEntry);
            entry.setPerson(leaveEntry.getPerson());
            info.getEntries().add(entry);
        }
        info.setHrOrgUnit(SysContext.getSysContext().getCurrentHRUnit());
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return LeaveReportBillFactory.getRemoteInstance();
    }

    protected void setTableCellEditor() throws Exception {
        HashMap<String, String> hash = new HashMap<String, String>();
        hash.put("All_Admins", "yes");
        this.kdtEntries.getColumn("person").setEditor(EmployeeClientUtils.getF7CellEditor((KDPromptSelector)new PersonPromptBox(hash)));
        KDDatePicker pkDate = new KDDatePicker();
        pkDate.setMilliSecondEnable(false);
        pkDate.setDateEnabled(true);
        pkDate.setTimeEnabled(true);
        pkDate.setEditable(true);
        this.kdtEntries.getColumn("beginDate").setEditor((ICellEditor)new KDTDefaultCellEditor(pkDate));
        this.kdtEntries.getColumn("beginDate").getStyleAttributes().setNumberFormat(HRTimeClientUtils.getLongTimePatternStr());
        this.kdtEntries.getColumn("beginTime").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)new KDTimePicker()));
        this.kdtEntries.getColumn("beginTime").getStyleAttributes().setNumberFormat(HRTimeClientUtils.getTimePatternStr());
        this.kdtEntries.getColumn("endDate").setEditor((ICellEditor)new KDTDefaultCellEditor(pkDate));
        this.kdtEntries.getColumn("endDate").getStyleAttributes().setNumberFormat(HRTimeClientUtils.getLongTimePatternStr());
        this.kdtEntries.getColumn("endTime").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)new KDTimePicker()));
        this.kdtEntries.getColumn("endTime").getStyleAttributes().setNumberFormat(HRTimeClientUtils.getTimePatternStr());
        this.kdtEntries.getColumn("leaveLength").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdtEntries.getColumn("leaveLength").getStyleAttributes().setNumberFormat(HRTimeClientUtils.getNumberFormatStr());
        TimeAttendanceCollection c = HRTimeClientUtils.getSimpleLeaveItems();
        DefaultComboBoxModel<TimeAttendanceInfo> model = new DefaultComboBoxModel<TimeAttendanceInfo>();
        int size = c.size();
        for (int i = 0; i < size; ++i) {
            model.addElement(c.get(i));
        }
        KDComboBox combo = new KDComboBox(model);
        combo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                try {
                    LeaveReportBillEditUI.this.cboContractType_itemStateChanged(e);
                }
                catch (Exception exc) {
                    LeaveReportBillEditUI.this.handUIException(exc);
                }
            }
        });
        this.kdtEntries.getColumn("type").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)combo));
        this.kdtEntries.getColumn("type").getStyleAttributes().setLocked(true);
        this.kdtEntries.getColumn("remark").setEditor(EmployeeClientUtils.getTextAreaCellEditor());
        this.kdtEntries.getColumn("reason").setEditor(EmployeeClientUtils.getTextAreaCellEditor());
        this.kdtEntries.getColumn("person").getStyleAttributes().setLocked(true);
    }

    void cboContractType_itemStateChanged(ItemEvent e) throws Exception {
        TimeAttendanceInfo info = (TimeAttendanceInfo)((KDComboBox)e.getSource()).getSelectedItem();
        if (info == null) {
            return;
        }
        IRow curRow = this.kdtEntries.getRow(KDTableUtil.getSelectedRow((KDTable)this.kdtEntries));
        curRow.getCell("unit").setValue((Object)info.getUnitType());
        curRow.getCell("leaveLength").setEditor(TimeAttendanceUtils.getTheCellEditor(info.getLength(), info.getDecDigital(), info.getDataType()));
        curRow.getCell("leaveLength").getStyleAttributes().setNumberFormat(TimeAttendanceUtils.getFomatString(info.getLength(), info.getDecDigital()));
    }

    private String getDeptByPerson(String personId) {
        try {
            PositionMemberInfo postRelInfo = TimeBaseClientUtils.getPersonMemberInfo(personId);
            if (postRelInfo != null && postRelInfo.getPosition() != null && postRelInfo.getPosition().getAdminOrgUnit() != null) {
                return postRelInfo.getPosition().getAdminOrgUnit().getName();
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return null;
    }

    public void loadEntries() throws Exception {
    }

    public void loadFields() {
        super.loadFields();
        this.pInfo = this.editData.getProposer();
        if (this.editData.getEntries() != null) {
            this.kdtEntries.removeRows();
            LeaveReportBillEntryInfo info = null;
            IRow row = null;
            int size = this.editData.getEntries().size();
            for (int i = 0; i < size; ++i) {
                info = this.editData.getEntries().get(i);
                row = this.kdtEntries.addRow();
                row.getCell("id").setValue((Object)info.getId());
                row.getCell("person").setValue((Object)info.getPerson());
                row.getCell("dept").setValue(null);
                row.getCell("type").setValue((Object)info.getType());
                row.getCell("beginDate").setValue((Object)info.getBeginTime());
                row.getCell("beginTime").setValue((Object)info.getBeginTime());
                row.getCell("endDate").setValue((Object)info.getEndTime());
                row.getCell("endTime").setValue((Object)info.getEndTime());
                row.getCell("leaveLength").setValue((Object)info.getLeaveLength());
                row.getCell("unit").setValue((Object)info.getType().getUnitType());
                row.getCell("decDigital").setValue((Object)info.getType().getDecDigital());
                row.getCell("length").setValue((Object)info.getType().getLength());
                row.getCell("dataType").setValue((Object)info.getType().getDataType());
                row.getCell("reason").setValue((Object)info.getReason());
                row.getCell("remark").setValue((Object)info.getRemark());
                row.getCell("leaveEntryid").setValue((Object)info.getLeaveBillEntry());
                this.pInfo = info.getPerson();
                if (this.pInfo == null || this.pInfo.getId() == null) continue;
                String personId = this.pInfo.getId().toString();
                row.getCell("dept").setValue((Object)this.getDeptByPerson(personId));
            }
        }
        try {
            LeaveBillEditUI.setLeaveLengthStyle(this.kdtEntries);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        super.setAuditActionState();
    }

    public static void setLeaveLengthStyle(KDTable tbl) throws Exception {
        IRow curRow = null;
        int size = tbl.getRowCount();
        for (int i = 0; i < size; ++i) {
            curRow = tbl.getRow(i);
            ItemDataTypeEnum dataType = (ItemDataTypeEnum)curRow.getCell("dataType").getValue();
            Integer length = (Integer)curRow.getCell("length").getValue();
            Integer decDigital = (Integer)curRow.getCell("decDigital").getValue();
            if (dataType == null || length == null || decDigital == null) continue;
            curRow.getCell("leaveLength").setEditor(TimeAttendanceUtils.getTheCellEditor(length, decDigital, dataType));
            curRow.getCell("leaveLength").getStyleAttributes().setNumberFormat(TimeAttendanceUtils.getFomatString(length, decDigital));
        }
    }

    public void storeFields() {
        super.storeFields();
        if (this.editData.getProposer() == null) {
            this.editData.setProposer(this.pInfo);
        }
        this.editData.setApproveState((ApproveStateEnum)((Object)this.comboSubmitType.getSelectedItem()));
        LeaveReportBillEntryInfo info = null;
        LeaveReportBillEntryCollection c = new LeaveReportBillEntryCollection();
        IRow row = null;
        int size = this.kdtEntries.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.kdtEntries.getRow(i);
            info = this.editData.getEntries().get(i);
            if (row.getCell("id").getValue() != null) {
                info.setId((BOSUuid)row.getCell("id").getValue());
            }
            info.setPerson((PersonInfo)row.getCell("person").getValue());
            info.setLeaveBillEntry((LeaveBillEntryInfo)row.getCell("leaveEntryid").getValue());
            info.setType((TimeAttendanceInfo)row.getCell("type").getValue());
            info.setBeginTime(HRTimeClientUtils.getDateTime(row.getCell("beginDate").getValue()));
            info.setEndTime(HRTimeClientUtils.getDateTime(row.getCell("endDate").getValue()));
            info.setLeaveLength(new BigDecimal(row.getCell("leaveLength").getValue().toString()));
            info.setReason((String)row.getCell("reason").getValue());
            info.setRemark((String)row.getCell("remark").getValue());
            c.add(info);
        }
        this.editData.setIsMultiEntry(true);
        if (this.editData.getApproveState().getValue() == 0) {
            this.editData.setExtendedProperty("ignoreWorkflow", "true");
        }
    }

    protected void kdtEntries_editStopped(KDTEditEvent e) throws Exception {
        TimeAttendanceInfo type;
        PersonInfo pInfo = null;
        IRow row = null;
        int colIndex = e.getColIndex();
        row = this.kdtEntries.getRow(e.getRowIndex());
        if (colIndex == this.kdtEntries.getColumn("person").getColumnIndex() && (pInfo = (PersonInfo)e.getValue()) != null && pInfo.getId() != null) {
            String personId = pInfo.getId().toString();
            row.getCell("dept").setValue((Object)this.getDeptByPerson(personId));
        }
        if (colIndex == this.kdtEntries.getColumn("type").getColumnIndex() && (type = (TimeAttendanceInfo)e.getValue()) != null) {
            row.getCell("unit").setValue((Object)type.getUnitType().getAlias());
            row.getCell("leaveLength").getStyleAttributes().setNumberFormat(HRTimeClientUtils.getDecimalFormatStr(type.getDecDigital()));
        }
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("adminOrg.id"));
        sic.add(new SelectorItemInfo("adminOrg.name"));
        sic.add(new SelectorItemInfo("adminOrg.number"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("proposer.name"));
        sic.add(new SelectorItemInfo("proposer.id"));
        sic.add(new SelectorItemInfo("proposer.number"));
        sic.add(new SelectorItemInfo("dept"));
        sic.add(new SelectorItemInfo("phone"));
        sic.add(new SelectorItemInfo("applyDate"));
        sic.add(new SelectorItemInfo("isMultiEntry"));
        sic.add(new SelectorItemInfo("bizState"));
        sic.add(new SelectorItemInfo("approveState"));
        sic.add(new SelectorItemInfo("submitState"));
        sic.add(new SelectorItemInfo("leaveBill.id"));
        sic.add(new SelectorItemInfo("leaveBill.number"));
        sic.add(new SelectorItemInfo("leaveBill.proposer.name"));
        sic.add(new SelectorItemInfo("leaveBill.proposer.id"));
        sic.add(new SelectorItemInfo("leaveBill.proposer.number"));
        sic.add(new SelectorItemInfo("leaveBill.dept"));
        sic.add(new SelectorItemInfo("leaveBill.phone"));
        sic.add(new SelectorItemInfo("leaveBill.applyDate"));
        sic.add(new SelectorItemInfo("leaveBill.isMultiEntry"));
        sic.add(new SelectorItemInfo("leaveBill.bizState"));
        sic.add(new SelectorItemInfo("entries.id"));
        sic.add(new SelectorItemInfo("entries.beginTime"));
        sic.add(new SelectorItemInfo("entries.endTime"));
        sic.add(new SelectorItemInfo("entries.leaveLength"));
        sic.add(new SelectorItemInfo("entries.type.id"));
        sic.add(new SelectorItemInfo("entries.type.name"));
        sic.add(new SelectorItemInfo("entries.type.number"));
        sic.add(new SelectorItemInfo("entries.type.unitType"));
        sic.add(new SelectorItemInfo("entries.type.decdigital"));
        sic.add(new SelectorItemInfo("entries.type.dataType"));
        sic.add(new SelectorItemInfo("entries.type.lastUnit"));
        sic.add(new SelectorItemInfo("entries.reason"));
        sic.add(new SelectorItemInfo("entries.remark"));
        sic.add(new SelectorItemInfo("entries.person.id"));
        sic.add(new SelectorItemInfo("entries.person.number"));
        sic.add(new SelectorItemInfo("entries.person.name"));
        sic.add(new SelectorItemInfo("entries.leaveBillEntry.id"));
        sic.add(new SelectorItemInfo("entries.leaveBillEntry.beginTime"));
        sic.add(new SelectorItemInfo("entries.leaveBillEntry.endTime"));
        sic.add(new SelectorItemInfo("entries.leaveBillEntry.leaveLength"));
        sic.add(new SelectorItemInfo("entries.leaveBillEntry.type.id"));
        sic.add(new SelectorItemInfo("entries.leaveBillEntry.type.name"));
        sic.add(new SelectorItemInfo("entries.leaveBillEntry.type.number"));
        sic.add(new SelectorItemInfo("entries.leaveBillEntry.type.length"));
        sic.add(new SelectorItemInfo("entries.leaveBillEntry.reason"));
        sic.add(new SelectorItemInfo("entries.leaveBillEntry.remark"));
        sic.add(new SelectorItemInfo("entries.leaveBillEntry.person.id"));
        sic.add(new SelectorItemInfo("entries.leaveBillEntry.person.number"));
        sic.add(new SelectorItemInfo("entries.leaveBillEntry.person.name"));
        return sic;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.menuItemPerson.setIcon(EASResource.getIcon((String)"imgTbtn_unforbidPerm"));
        this.menuItemPerson.setEnabled(true);
        this.menuItemWorkflowG.setIcon(EASResource.getIcon((String)"imgTbtn_flowchart"));
        this.menuItemWorkflowG.setEnabled(true);
        this.btnRemove.setVisible(false);
        this.menuItemCopySelect.setIcon(this.btnCopy.getIcon());
    }

    private void setLeaveInfo(String id) throws Exception {
        String oql = "select adminOrg.id, adminOrg.name, adminOrg.number, number, proposer.name, proposer.id, proposer.number, dept, phone, applyDate, isMultiEntry, bizState, isMultiEntry, entries.id, entries.beginTime, entries.endTime, entries.leaveLength, entries.type.id, entries.type.name, entries.type.number, entries.type.unitType, entries.type.decdigital, entries.type.length, entries.type.dataType, entries.type.lastUnit, entries.reason, entries.remark, entries.person.id, entries.person.number, entries.person.name where id = '" + id + "'";
        LeaveBillCollection c = LeaveBillFactory.getRemoteInstance().getLeaveBillCollection(oql);
        if (c.size() > 0) {
            this.leaveInfo = c.get(0);
        }
    }

    public void onLoad() throws Exception {
        String leaveBillId = (String)this.getUIContext().get("leaveBillId");
        if (leaveBillId != null) {
            this.setLeaveInfo(leaveBillId);
        }
        super.onLoad();
        this.txtNumber.setEnabled(false);
        this.menuItemEdit.setVisible(false);
        this.actionEdit.setEnabled(false);
        this.btnEdit.setEnabled(false);
        this.btnEdit.setVisible(false);
        if (OprtState.EDIT.equals(this.getOprtState())) {
            if (ApproveStateEnum.DIRECT.equals((Object)this.editData.getApproveState())) {
                if (BizStateEnum.TEMP.equals((Object)this.editData.getBizState())) {
                    this.actionSave.setEnabled(true);
                    this.actionSubmit.setEnabled(true);
                } else if (BizStateEnum.EDIT.equals((Object)this.editData.getBizState())) {
                    this.actionSave.setEnabled(false);
                    this.actionSubmit.setEnabled(true);
                }
            } else if (BizStateEnum.TEMP.equals((Object)this.editData.getBizState())) {
                this.actionSave.setEnabled(true);
                this.actionSubmit.setEnabled(true);
            }
        }
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.btnCopy.setEnabled(false);
            this.menuItemCopy.setEnabled(false);
            this.actionCopy.setEnabled(false);
            this.actionSave.setEnabled(false);
            this.actionSubmit.setEnabled(false);
        }
        if ("FINDVIEW".equals(this.getOprtState())) {
            this.txtPhoneNumber.setEnabled(false);
            this.actionSave.setEnabled(false);
            this.actionSubmit.setEnabled(false);
        }
        this.btnAttachment.setVisible(true);
        this.actionAttachment.setEnabled(true);
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            String HRO_ID;
            IParamControl iParam = ParamControlFactory.getRemoteInstance();
            String val = iParam.getParamValue((IObjectPK)new ObjectUuidPK(HRO_ID = SysContext.getSysContext().getCurrentHRUnit().getId().toString()), "XJ001");
            if ("true".equals(val)) {
                this.comboSubmitType.setSelectedItem((Object)ApproveStateEnum.WORKFLOW);
            } else {
                this.comboSubmitType.setSelectedItem((Object)ApproveStateEnum.DIRECT);
            }
        }
    }

    public void actionLeaveQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionLeaveQuery_actionPerformed(e);
        Object obj = HRTimeClientUtils.getSelectedCellValue(this.kdtEntries, "person");
        if (obj == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        } else {
            String personId = ((PersonInfo)obj).getId().toString();
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"personId", (Object)personId);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(SelfLeaveQueryUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
        }
    }

    protected String getWFActionName() {
        return "ActionSubmit";
    }

    protected String getWFUIFuctionName() {
        return "com.kingdee.eas.hr.time.LeaveRptBillBizFuction";
    }

    protected void applyDefaultValue(IObjectValue vo) {
    }

    protected String getEditUIName() {
        return null;
    }

    protected OrgType getMainBizOrgType() {
        return null;
    }

    protected String getTDFileName() {
        return null;
    }

    protected IMetaDataPK getTDQueryPK() {
        return null;
    }

    protected void recycleNumberByOrg(IObjectValue editData, String orgType, String number) {
    }

    protected void removeByPK(IObjectPK pk) throws Exception {
    }

    protected void setAutoNumberByOrg(String orgType) {
    }

    protected void setFieldsNull(AbstractObjectValue arg0) {
    }

    protected void setOrgF7(KDBizPromptBox f7, OrgType orgType) throws Exception {
    }

    public boolean isPrepareInit() {
        return true;
    }

    public IUIActionPostman prepareInit() {
        IUIActionPostman postman = super.prepareInit();
        RequestContext req = new RequestContext();
        String leaveBillId = (String)this.getUIContext().get("leaveBillId");
        req.put("leaveBillId", (Object)leaveBillId);
        postman.setRequestContext((Serializable)req);
        return postman;
    }

    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        AttachmentUIContextInfo info;
        String oldOprtState = this.getOprtState();
        if (this.actionAudit.isEnabled()) {
            this.setOprtState(OprtState.EDIT);
        }
        AttachmentClientManager acm = AttachmentManagerFactory.getClientManager();
        boolean isEdit = false;
        if (OprtState.EDIT.equals(this.getOprtState()) || OprtState.ADDNEW.equals(this.getOprtState())) {
            isEdit = true;
        }
        if ((info = this.getAttacheInfo()) == null) {
            info = new AttachmentUIContextInfo();
        }
        if (info.getBoID() == null || info.getBoID().trim().equals("")) {
            String boID = this.getID();
            if (boID == null) {
                return;
            }
            info.setBoID(boID);
        }
        info.setEdit(isEdit);
        String multi = (String)this.getUIContext().get("MultiapproveAttachment");
        if (multi != null && multi.equals("true")) {
            acm.showAttachmentListUIByBoIDNoAlready((Object)this, info);
        } else {
            acm.showAttachmentListUIByBoID((Object)this, info);
        }
        if (this.actionAudit.isEnabled()) {
            this.setOprtState(oldOprtState);
        }
    }

    protected final String getID() {
        if (this.editData == null) {
            return null;
        }
        String boID = this.editData.getLeaveBill().getId() != null ? this.editData.getLeaveBill().getId().toString() : null;
        return boID;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.editData.setApproveState((ApproveStateEnum)((Object)this.comboSubmitType.getSelectedItem()));
        super.actionSubmit_actionPerformed(e);
    }

    public void checkDate(KDTable tbl) throws Exception {
        int rowCount = tbl.getRowCount();
        Date beginDate = null;
        Date endDate = null;
        IRow row = null;
        int colIndex = tbl.getColumn("endDate").getColumnIndex();
        TimeAttendanceInfo timeAttendanceInfo = null;
        BigDecimal LeaveLength = new BigDecimal("0.0");
        BigDecimal lastUnit = new BigDecimal("0.00");
        for (int i = 0; i < rowCount; ++i) {
            int b;
            int a;
            row = tbl.getRow(i);
            beginDate = (Date)row.getCell("beginDate").getValue();
            endDate = (Date)row.getCell("endDate").getValue();
            if (beginDate.getTime() > endDate.getTime()) {
                tbl.getSelectManager().select(i, colIndex);
                throw new LeaveDetailException(LeaveDetailException.DATEERROR);
            }
            timeAttendanceInfo = (TimeAttendanceInfo)row.getCell("type").getValue();
            if (timeAttendanceInfo != null) {
                lastUnit = timeAttendanceInfo.getLastUnit();
            }
            if (row.getCell("leaveLength").getValue() != null && !row.getCell("leaveLength").getValue().toString().trim().equals("")) {
                LeaveLength = new BigDecimal(row.getCell("leaveLength").getValue().toString());
            }
            if (LeaveLength.floatValue() > 0.0f && lastUnit != null && lastUnit.floatValue() > 0.0f && (a = (int)(LeaveLength.floatValue() * 100.0f)) % (b = (int)(lastUnit.floatValue() * 100.0f)) != 0) {
                MsgBox.showInfo((String)(EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"1_AttendanceManagerImportFacadeControllerBean") + (i + 1) + EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"64_HRTimeClientUtils") + lastUnit.floatValue() + EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"65_HRTimeClientUtils")));
                SysUtil.abort();
            }
            if (!(LeaveLength.floatValue() < 0.0f)) continue;
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"DAYNUM"));
            SysUtil.abort();
        }
    }
}

