/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.time.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.hr.time.IYearVacationBalance;
import com.kingdee.eas.hr.time.LeaveReportBillFactory;
import com.kingdee.eas.hr.time.YearVacationBalanceFactory;
import com.kingdee.eas.hr.time.client.AbstractLeaveReportBillListUI;
import com.kingdee.eas.hr.time.client.HRTimeClientUtils;
import com.kingdee.eas.hr.time.client.LeaveReportBillEditUI;
import com.kingdee.eas.hr.time.client.LeaveReportBillSelfEditUI;
import com.kingdee.eas.hr.time.client.SelfLeaveQueryUI;
import com.kingdee.eas.hr.time.client.TimeUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class LeaveReportBillListUI
extends AbstractLeaveReportBillListUI {
    private static final Logger logger = CoreUIObject.getLogger(LeaveReportBillListUI.class);
    private boolean isSelf = false;

    public void actionLeaveQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionLeaveQuery_actionPerformed(e);
        this.checkSelected();
        String personId = (String)this.getCellValue("person.id");
        if (personId == null) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"personId", (Object)personId);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(SelfLeaveQueryUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
    }

    public String[] getMergeColumnKeys() {
        return new String[]{"id", "number", "proposer.name", "dept", "applyDate", "bizState", "phone", "isMultiEntry"};
    }

    protected boolean isAllowDefaultSolutionNull() {
        return true;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return LeaveReportBillFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        if (this.isAddNew) {
            if (this.isSelf) {
                return LeaveReportBillSelfEditUI.class.getName();
            }
            return LeaveReportBillEditUI.class.getName();
        }
        Boolean isMulti = (Boolean)this.getCellValue("isMultiEntry");
        if (isMulti == null) {
            if (this.isSelf) {
                return LeaveReportBillSelfEditUI.class.getName();
            }
            return LeaveReportBillEditUI.class.getName();
        }
        if (isMulti.booleanValue()) {
            return LeaveReportBillEditUI.class.getName();
        }
        return LeaveReportBillSelfEditUI.class.getName();
    }

    private void getUIState() {
        Object obj = this.getUIContext().get("isSelf");
        this.isSelf = obj == null ? true : (Boolean)obj;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        this.getUIState();
        if (this.isSelf) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("proposer.id", (Object)this.personId.toString()));
            filter.getFilterItems().add(new FilterItemInfo("isMultiEntry", (Object)Boolean.FALSE));
            filter.getFilterItems().add(new FilterItemInfo("HROrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId().toString()));
            return filter;
        }
        return TimeUtil.getHRAndAdminRangeFilterInfo("HROrgUnit.id", "adminOrg.id");
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.getUIState();
        this.tblMain.getColumn("entries.beginTime").getStyleAttributes().setNumberFormat(HRTimeClientUtils.getLongTimePatternStr());
        this.tblMain.getColumn("entries.endTime").getStyleAttributes().setNumberFormat(HRTimeClientUtils.getLongTimePatternStr());
        this.tblMain.getColumn("entries.leaveLength").getStyleAttributes().setNumberFormat("%r{0.00}10.2f");
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionAddNew.setVisible(false);
        this.btnLeaveQuery.setIcon(EASResource.getIcon((String)"imgTbtn_showlist"));
        this.menuItemAudit.setIcon(EASResource.getIcon((String)"imgTbtn_audit"));
        this.menuItemAudit.setEnabled(true);
        this.menuItemAuditResult.setIcon(EASResource.getIcon((String)"imgTbtn_multapproveresult"));
        this.menuItemAuditResult.setEnabled(true);
        this.menuItemWorkflowG.setIcon(EASResource.getIcon((String)"imgTbtn_flowchart"));
        this.menuItemWorkflowG.setEnabled(true);
        if (this.isSelf) {
            this.actionAudit.setEnabled(false);
            this.btnAudit.setVisible(false);
            this.menuAudit.setVisible(false);
        }
        this.menuAudit.setVisible(false);
    }

    protected void setEditAction() throws Exception {
        super.setEditAction();
    }

    protected boolean isEditable() throws Exception {
        boolean value = true;
        BizEnumValueInfo state = (BizEnumValueInfo)this.getCellValue("bizState");
        if (state == null) {
            value = true;
        } else if (state.getInt() != 0 && state.getInt() != -1) {
            value = false;
            return value;
        }
        String proposerId = (String)this.getCellValue("proposer.id");
        Boolean isMulti = (Boolean)this.getCellValue("isMultiEntry");
        if (proposerId == null) {
            value = true;
        } else if (isMulti != null && !isMulti.booleanValue()) {
            value = proposerId.equals(this.personId.toString());
        }
        return value;
    }

    private boolean isSelfBill() {
        boolean value = false;
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock != null && selectBlock.getTop() != -1) {
            int rowIndex = selectBlock.getTop();
            IRow row = this.tblMain.getRow(rowIndex);
            String personId = (String)row.getCell("proposer.id").getValue();
            value = personId.equals(this.personId.toString());
        }
        return value;
    }

    private boolean isValidReportState() {
        boolean value = false;
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock != null && selectBlock.getTop() != -1) {
            int rowIndex = selectBlock.getTop();
            IRow row = this.tblMain.getRow(rowIndex);
            BizEnumValueInfo enumInfo = (BizEnumValueInfo)row.getCell("bizState").getValue();
            int state = Integer.parseInt(enumInfo.getValue().toString());
            value = state == 0 || state == -1;
        }
        return value;
    }

    private void tbl_select() throws Exception {
        if (this.isSelfBill() && this.isValidReportState()) {
            this.actionEdit.setEnabled(true);
            this.actionRemove.setEnabled(true);
        } else {
            this.actionEdit.setEnabled(false);
            this.actionRemove.setEnabled(false);
        }
    }

    protected void setAuditAction() throws Exception {
        if (this.isSelf) {
            this.actionAudit.setEnabled(false);
        } else {
            super.setAuditAction();
        }
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        if (this.isSelf) {
            uiContext.put((Object)"isSelf", (Object)Boolean.TRUE);
        } else {
            uiContext.put((Object)"isSelf", (Object)Boolean.FALSE);
        }
    }

    public IUIActionPostman prepareInit() {
        this.getUIState();
        IUIActionPostman postMan = super.prepareInit();
        RequestContext req = (RequestContext)postMan.getRequestContext();
        req.put("isSelf", (Object)this.isSelf);
        postMan.setRequestContext((Serializable)req);
        return postMan;
    }

    public boolean isPrepareInit() {
        return true;
    }

    public boolean isPrepareActionQuery() {
        return true;
    }

    public boolean isPrepareActionRefresh() {
        return true;
    }

    public boolean isPrepareActionAudit() {
        return false;
    }

    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        int[] rows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        super.actionAudit_actionPerformed(e);
        List lstPerson = this.getSelectedPerIDs(rows);
        if (lstPerson.size() > 0) {
            IYearVacationBalance iyvBalacne = YearVacationBalanceFactory.getRemoteInstance();
            int year = Calendar.getInstance().get(1);
            iyvBalacne.calculate(year, lstPerson, 4, new Date(), 4);
        }
    }

    private List getSelectedPerIDs(int[] rows) {
        ArrayList<String> lstPerson = new ArrayList<String>();
        int size = rows.length;
        for (int i = 0; i < size; ++i) {
            if (!this.tblMain.getRow(rows[i]).getCell("type.name").getValue().toString().equals(EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"68_LeaveBillAllListUI"))) continue;
            lstPerson.add(this.tblMain.getRow(rows[i]).getCell("person.id").getValue().toString());
        }
        return lstPerson;
    }

    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
        try {
            String entries_leaveLength = "entries.leaveLength";
            ResultSetMetaData rsMd = rowSet.getMetaData();
            HashSet<String> colSet = new HashSet<String>();
            for (int i = 1; i <= rsMd.getColumnCount(); ++i) {
                colSet.add(rsMd.getColumnName(i));
            }
            if (colSet.contains(entries_leaveLength)) {
                while (rowSet.next()) {
                    String leaveValue = rowSet.getString(entries_leaveLength);
                    if (leaveValue != null && !"".equals(leaveValue)) continue;
                    rowSet.updateObject(entries_leaveLength, (Object)"0");
                }
            }
        }
        catch (SQLException e) {
            this.handUIException(e);
        }
    }
}

