/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.time.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.client.AttachmentUIContextInfo;
import com.kingdee.eas.base.attachment.common.AttachmentClientManager;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.affair.HRAffairState;
import com.kingdee.eas.hr.time.ApproveStateEnum;
import com.kingdee.eas.hr.time.BizStateEnum;
import com.kingdee.eas.hr.time.ILeaveReportBill;
import com.kingdee.eas.hr.time.LeaveBillCollection;
import com.kingdee.eas.hr.time.LeaveBillEntryInfo;
import com.kingdee.eas.hr.time.LeaveBillFactory;
import com.kingdee.eas.hr.time.LeaveBillInfo;
import com.kingdee.eas.hr.time.LeaveDetailException;
import com.kingdee.eas.hr.time.LeaveReportBillEntryInfo;
import com.kingdee.eas.hr.time.LeaveReportBillFactory;
import com.kingdee.eas.hr.time.LeaveReportBillInfo;
import com.kingdee.eas.hr.time.TimeAttendanceCollection;
import com.kingdee.eas.hr.time.TimeAttendanceInfo;
import com.kingdee.eas.hr.time.client.AbstractLeaveReportBillSelfEditUI;
import com.kingdee.eas.hr.time.client.HRTimeClientUtils;
import com.kingdee.eas.hr.time.client.SelfLeaveQueryUI;
import com.kingdee.eas.hr.time.client.TimeUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import org.apache.log4j.Logger;

public class LeaveReportBillSelfEditUI
extends AbstractLeaveReportBillSelfEditUI {
    private static final Logger logger = CoreUIObject.getLogger(LeaveReportBillSelfEditUI.class);
    private LeaveBillInfo leaveInfo = null;
    private BigDecimal lastUnit = new BigDecimal("0.00");
    protected BOSUuid entryId = null;

    protected void lockUIForViewStatus() {
        super.lockUIForViewStatus();
        this.pkBeginDate2.setEnabled(false);
        this.pkEndDate2.setEnabled(false);
        this.pkBeginTime2.setEnabled(false);
        this.pkEndTime2.setEnabled(false);
        this.comboType2.setEnabled(false);
        this.txtReason2.setEnabled(false);
        this.txtRemark2.setEnabled(false);
        this.pkBeginDate2.setRequired(false);
        this.pkEndDate2.setRequired(false);
        this.txtReason2.setRequired(false);
        this.txtLeaveLength2.setRequired(false);
        this.txtLeaveLength2.setEnabled(false);
    }

    public void initUIMenuBarLayout() {
        super.initUIMenuBarLayout();
        this.btnLeaveQuery.setIcon(EASResource.getIcon((String)"imgTbtn_showlist"));
        this.menuItemWorkflowG.setIcon(EASResource.getIcon((String)"imgTbtn_flowchart"));
        this.menuItemWorkflowG.setEnabled(true);
        this.btnCopySelect.setEnabled(false);
        this.btnCopySelect.setVisible(false);
    }

    public void actionLeaveQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionLeaveQuery_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"personId", (Object)this.personId);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(SelfLeaveQueryUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
    }

    public void loadFields() {
        super.loadFields();
        if (this.editData.getEntries() != null && this.editData.getEntries().size() > 0) {
            LeaveReportBillEntryInfo info2 = this.editData.getEntries().get(0);
            LeaveBillEntryInfo info = info2.getLeaveBillEntry();
            Date beginDate = new Date(info.getBeginTime().getTime());
            Date endDate = new Date(info.getEndTime().getTime());
            this.pkBeginDate.setValue((Object)beginDate);
            this.pkBeginTime.setValue((Object)beginDate);
            this.pkEndDate.setValue((Object)endDate);
            this.pkEndTime.setValue((Object)endDate);
            this.txtReason.setText(info.getReason());
            this.txtRemark.setText(info.getRemark());
            this.txtLeaveLength.setValue((Object)info.getLeaveLength());
            TimeAttendanceInfo tInfo = null;
            boolean flag = true;
            int size = this.comboType.getItemCount();
            for (int i = 0; i < size; ++i) {
                tInfo = (TimeAttendanceInfo)this.comboType.getItemAt(i);
                if (!info.getType().getId().toString().equals(tInfo.getId().toString())) continue;
                this.comboType.setSelectedIndex(i);
                this.lblUnit.setText(tInfo.getUnitType().getAlias());
                this.txtLeaveLength.setMinimumNumber((Number)new BigDecimal("0.00"));
                this.txtLeaveLength.setMaximumNumber((Number)new BigDecimal("99999.99"));
                this.txtLeaveLength.setPrecision(tInfo.getDecDigital());
                flag = false;
                break;
            }
            if (this.getOprtState() != OprtState.ADDNEW && flag) {
                this.comboType.addItem((Object)info.getType());
                this.comboType.setSelectedIndex(this.comboType.getItemCount() - 1);
                this.lblUnit.setText(tInfo.getUnitType().getAlias());
                this.txtLeaveLength.setMinimumNumber((Number)new BigDecimal("0.00"));
                this.txtLeaveLength.setMaximumNumber((Number)new BigDecimal("99999.99"));
                this.txtLeaveLength.setPrecision(info.getType().getDecDigital());
            }
            this.pInfo = info.getPerson();
            this.personId = this.pInfo.getId();
            this.entryId = info.getId();
            Date beginDate2 = new Date(info2.getBeginTime().getTime());
            Date endDate2 = new Date(info2.getEndTime().getTime());
            this.pkBeginDate2.setValue((Object)beginDate2);
            this.pkBeginTime2.setValue((Object)beginDate2);
            this.pkEndDate2.setValue((Object)endDate2);
            this.pkEndTime2.setValue((Object)endDate2);
            this.txtReason2.setText(info2.getReason());
            this.txtRemark2.setText(info2.getRemark());
            this.txtPhoneNumber.setText(this.editData.getPhone());
            this.txtLeaveLength2.setValue((Object)info2.getLeaveLength());
            TimeAttendanceInfo tInfo2 = null;
            int size2 = this.comboType2.getItemCount();
            for (int i = 0; i < size2; ++i) {
                tInfo2 = (TimeAttendanceInfo)this.comboType2.getItemAt(i);
                if (!info2.getType().getId().toString().equals(tInfo2.getId().toString())) continue;
                this.comboType2.setSelectedIndex(i);
                this.txtLeaveLength2.setMinimumNumber((Number)new BigDecimal("0.00"));
                this.txtLeaveLength2.setMaximumNumber((Number)new BigDecimal("99999.99"));
                this.txtLeaveLength2.setPrecision(tInfo2.getDecDigital());
                break;
            }
            if (this.getOprtState() != OprtState.ADDNEW && flag) {
                this.comboType2.addItem((Object)info2.getType());
                this.comboType2.setSelectedIndex(this.comboType2.getItemCount() - 1);
                this.txtLeaveLength.setMinimumNumber((Number)new BigDecimal("0.00"));
                this.txtLeaveLength.setMaximumNumber((Number)new BigDecimal("99999.99"));
                this.txtLeaveLength.setPrecision(info2.getType().getDecDigital());
            }
            super.setAuditActionState();
        }
    }

    public void storeFields() {
        super.storeFields();
        LeaveReportBillEntryInfo info = null;
        this.editData.setApproveState((ApproveStateEnum)((Object)this.comboSubmitType.getSelectedItem()));
        if (this.editData.getEntries() != null && this.editData.getEntries().size() > 0) {
            info = this.editData.getEntries().get(0);
        } else {
            info = new LeaveReportBillEntryInfo();
            this.editData.getEntries().add(info);
        }
        info.setBeginTime(HRTimeClientUtils.getTime(this.pkBeginDate2, this.pkBeginTime2));
        info.setEndTime(HRTimeClientUtils.getTime(this.pkEndDate2, this.pkEndTime2));
        info.setType((TimeAttendanceInfo)this.comboType2.getSelectedItem());
        info.setReason(this.txtReason2.getText());
        info.setRemark(this.txtRemark2.getText());
        info.setLeaveLength(this.txtLeaveLength2.getBigDecimalValue());
        info.setLeaveBillEntry(this.leaveInfo.getEntries().get(0));
        if (this.entryId != null) {
            info.setId(this.entryId);
        }
        info.setPerson(this.pInfo);
        this.editData.setProposer(this.pInfo);
        this.editData.setIsMultiEntry(false);
        if (this.editData.getApproveState().getValue() == 0) {
            this.editData.setExtendedProperty("ignoreWorkflow", "true");
        }
        if (this.txtPhoneNumber.getText() != null) {
            this.editData.setPhone(this.txtPhoneNumber.getText().trim());
        } else {
            this.editData.setPhone(null);
        }
    }

    protected void comboType_itemStateChanged(ItemEvent e) throws Exception {
        Object obj = e.getItem();
        if (obj == null) {
            this.lblUnit.setText(null);
        } else {
            TimeAttendanceInfo info = (TimeAttendanceInfo)obj;
            this.lblUnit.setText(info.getUnitType().getAlias());
        }
    }

    protected void comboType2_itemStateChanged(ItemEvent e) throws Exception {
        Object obj = e.getItem();
        if (obj == null) {
            this.lblUnit2.setText(null);
        } else {
            TimeAttendanceInfo info = (TimeAttendanceInfo)obj;
            this.lblUnit2.setText(info.getUnitType().getAlias());
            this.lastUnit = info.getLastUnit();
        }
    }

    protected BOSObjectType getBillBOSType() {
        return new LeaveReportBillInfo().getBOSType();
    }

    protected IObjectValue createNewData() {
        LeaveReportBillInfo info = new LeaveReportBillInfo();
        info.setNumber(this.leaveInfo.getNumber());
        info.setPhone(this.leaveInfo.getPhone());
        info.setLeaveBill(this.leaveInfo);
        info.setIsMultiEntry(false);
        try {
            info.setApplyDate(DateTimeUtils.truncateDate((Date)TimeUtil.getServerTime()));
        }
        catch (BOSException e) {
            super.handleException((Exception)((Object)e));
        }
        LeaveReportBillEntryInfo entry = new LeaveReportBillEntryInfo();
        LeaveBillEntryInfo leaveEntry = this.leaveInfo.getEntries().get(0);
        if (leaveEntry != null) {
            entry.setBeginTime(leaveEntry.getBeginTime());
            entry.setEndTime(leaveEntry.getEndTime());
            entry.setType(leaveEntry.getType());
            entry.setLeaveLength(leaveEntry.getLeaveLength());
            entry.setLeaveBillEntry(leaveEntry);
            entry.setPerson(leaveEntry.getPerson());
            entry.setId(leaveEntry.getId());
        }
        info.setAdminOrg(this.leaveInfo.getAdminOrg());
        info.getEntries().add(entry);
        info.setHrOrgUnit(SysContext.getSysContext().getCurrentHRUnit());
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return LeaveReportBillFactory.getRemoteInstance();
    }

    private void setLeaveInfo(String id) throws Exception {
        String oql = "select adminOrg.id, adminOrg.name, adminOrg.number, number, proposer.name, proposer.id, proposer.number, dept, phone, applyDate, isMultiEntry, bizState, isMultiEntry, entries.id, entries.beginTime, entries.endTime, entries.leaveLength, entries.type.id, entries.type.name, entries.type.number, entries.type.unitType, entries.type.decdigital, entries.type.length, entries.type.dataType, entries.reason, entries.remark, entries.person.id, entries.person.number, entries.person.name where id = '" + id + "'";
        LeaveBillCollection c = LeaveBillFactory.getRemoteInstance().getLeaveBillCollection(oql);
        if (c.size() > 0) {
            this.leaveInfo = c.get(0);
        }
    }

    private void initTypeCombo() throws Exception {
        TimeAttendanceCollection c = HRTimeClientUtils.getSimpleLeaveItems();
        DefaultComboBoxModel<TimeAttendanceInfo> model = new DefaultComboBoxModel<TimeAttendanceInfo>();
        int size = c.size();
        for (int i = 0; i < size; ++i) {
            model.addElement(c.get(i));
        }
        this.comboType.setModel(model);
        this.comboType.setSelectedIndex(-1);
        this.lblUnit.setText(null);
        this.comboType2.setModel(model);
        this.comboType2.setSelectedIndex(-1);
        this.lblUnit2.setText(null);
    }

    public void onLoad() throws Exception {
        boolean isSelf;
        this.initTypeCombo();
        String leaveBillId = (String)this.getUIContext().get("leaveBillId");
        if (leaveBillId == null) {
            String id = null;
            if (this.getUIContext().get("ID") != null) {
                id = this.getUIContext().get("ID").toString();
            }
            leaveBillId = ((LeaveBillInfo)this.getBizInterface().getValue("select leaveBill.id where id = '" + id + "'").get("leaveBill")).getId().toString();
        }
        this.setLeaveInfo(leaveBillId);
        super.onLoad();
        this.comboType2.setEnabled(false);
        this.txtNumber.setEnabled(false);
        this.lblReason.setEnabled(true);
        this.lblRemark.setEnabled(true);
        this.txtReason2.setRequired(false);
        this.menuItemEdit.setVisible(false);
        if (this.getUIContext().get("isSelf") != null && (isSelf = ((Boolean)this.getUIContext().get("isSelf")).booleanValue())) {
            this.actionAudit.setEnabled(false);
            this.btnAudit.setVisible(false);
        }
        this.actionEdit.setEnabled(false);
        this.btnEdit.setEnabled(false);
        this.btnEdit.setVisible(false);
        this.btnAttachment.setVisible(true);
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            String HRO_ID;
            IParamControl iParam = ParamControlFactory.getRemoteInstance();
            String val = iParam.getParamValue((IObjectPK)new ObjectUuidPK(HRO_ID = SysContext.getSysContext().getCurrentHRUnit().getId().toString()), "XJ001");
            if ("true".equals(val)) {
                this.comboSubmitType.setSelectedItem((Object)ApproveStateEnum.WORKFLOW);
            } else {
                this.comboSubmitType.setSelectedItem((Object)ApproveStateEnum.DIRECT);
            }
        } else if (OprtState.EDIT.equals(this.getOprtState())) {
            if (ApproveStateEnum.DIRECT.equals((Object)this.editData.getApproveState())) {
                if (BizStateEnum.TEMP.equals((Object)this.editData.getBizState())) {
                    this.actionSave.setEnabled(true);
                    this.actionSubmit.setEnabled(true);
                } else if (BizStateEnum.EDIT.equals((Object)this.editData.getBizState())) {
                    this.actionSave.setEnabled(false);
                    this.actionSubmit.setEnabled(true);
                }
            } else if (BizStateEnum.TEMP.equals((Object)this.editData.getBizState())) {
                this.actionSave.setEnabled(true);
                this.actionSubmit.setEnabled(true);
            }
        } else if (OprtState.VIEW.equals(this.getOprtState())) {
            this.actionSave.setEnabled(false);
            this.actionSubmit.setEnabled(false);
            this.actionRemove.setEnabled(false);
        } else {
            this.actionSave.setEnabled(false);
            this.actionSubmit.setEnabled(false);
        }
        if (OprtState.EDIT.equals(this.getOprtState())) {
            if (ApproveStateEnum.DIRECT.equals((Object)this.editData.getApproveState())) {
                if (HRAffairState.TEMP.equals((Object)this.editData.getBizState())) {
                    this.actionSave.setEnabled(true);
                    this.actionSubmit.setEnabled(true);
                } else if (HRAffairState.EDIT.equals((Object)this.editData.getBizState())) {
                    this.actionSave.setEnabled(false);
                    this.actionSubmit.setEnabled(true);
                }
            } else if (HRAffairState.TEMP.equals((Object)this.editData.getBizState())) {
                this.actionSave.setEnabled(true);
                this.actionSubmit.setEnabled(true);
            }
        }
    }

    protected void setAuditActionState() {
        super.setAuditActionState();
        if (this.editData.getApproveState().getValue() == 1) {
            this.btnAudit.setEnabled(false);
            this.menuItemAudit.setEnabled(false);
            this.actionAudit.setEnabled(false);
        }
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("adminOrg.id"));
        sic.add(new SelectorItemInfo("adminOrg.name"));
        sic.add(new SelectorItemInfo("adminOrg.number"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("proposer.name"));
        sic.add(new SelectorItemInfo("proposer.id"));
        sic.add(new SelectorItemInfo("proposer.number"));
        sic.add(new SelectorItemInfo("dept"));
        sic.add(new SelectorItemInfo("phone"));
        sic.add(new SelectorItemInfo("applyDate"));
        sic.add(new SelectorItemInfo("isMultiEntry"));
        sic.add(new SelectorItemInfo("bizState"));
        sic.add(new SelectorItemInfo("approveState"));
        sic.add(new SelectorItemInfo("submitState"));
        sic.add(new SelectorItemInfo("leaveBill.id"));
        sic.add(new SelectorItemInfo("leaveBill.number"));
        sic.add(new SelectorItemInfo("leaveBill.proposer.name"));
        sic.add(new SelectorItemInfo("leaveBill.proposer.id"));
        sic.add(new SelectorItemInfo("leaveBill.proposer.number"));
        sic.add(new SelectorItemInfo("leaveBill.dept"));
        sic.add(new SelectorItemInfo("leaveBill.phone"));
        sic.add(new SelectorItemInfo("leaveBill.applyDate"));
        sic.add(new SelectorItemInfo("leaveBill.isMultiEntry"));
        sic.add(new SelectorItemInfo("leaveBill.bizState"));
        sic.add(new SelectorItemInfo("entries.id"));
        sic.add(new SelectorItemInfo("entries.beginTime"));
        sic.add(new SelectorItemInfo("entries.endTime"));
        sic.add(new SelectorItemInfo("entries.leaveLength"));
        sic.add(new SelectorItemInfo("entries.type.id"));
        sic.add(new SelectorItemInfo("entries.type.name"));
        sic.add(new SelectorItemInfo("entries.type.number"));
        sic.add(new SelectorItemInfo("entries.type.unitType"));
        sic.add(new SelectorItemInfo("entries.type.decdigital"));
        sic.add(new SelectorItemInfo("entries.type.dataType"));
        sic.add(new SelectorItemInfo("entries.reason"));
        sic.add(new SelectorItemInfo("entries.remark"));
        sic.add(new SelectorItemInfo("entries.person.id"));
        sic.add(new SelectorItemInfo("entries.person.number"));
        sic.add(new SelectorItemInfo("entries.person.name"));
        sic.add(new SelectorItemInfo("entries.leaveBillEntry.id"));
        sic.add(new SelectorItemInfo("entries.leaveBillEntry.beginTime"));
        sic.add(new SelectorItemInfo("entries.leaveBillEntry.endTime"));
        sic.add(new SelectorItemInfo("entries.leaveBillEntry.leaveLength"));
        sic.add(new SelectorItemInfo("entries.leaveBillEntry.type.id"));
        sic.add(new SelectorItemInfo("entries.leaveBillEntry.type.name"));
        sic.add(new SelectorItemInfo("entries.leaveBillEntry.type.number"));
        sic.add(new SelectorItemInfo("entries.leaveBillEntry.reason"));
        sic.add(new SelectorItemInfo("entries.leaveBillEntry.remark"));
        sic.add(new SelectorItemInfo("entries.leaveBillEntry.person.id"));
        sic.add(new SelectorItemInfo("entries.leaveBillEntry.person.number"));
        sic.add(new SelectorItemInfo("entries.leaveBillEntry.person.name"));
        return sic;
    }

    public IObjectPK runSubmit() throws Exception {
        return ((ILeaveReportBill)this.getBizInterface()).submit2((CoreBaseInfo)this.editData);
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        Timestamp beginDate = HRTimeClientUtils.getTime(this.pkBeginDate2, this.pkBeginTime2);
        Timestamp endDate = HRTimeClientUtils.getTime(this.pkEndDate2, this.pkEndTime2);
        if (((Date)beginDate).getTime() > ((Date)endDate).getTime()) {
            this.pkEndDate2.requestFocusInWindow();
            throw new LeaveDetailException(LeaveDetailException.DATEERROR);
        }
    }

    protected String getWFActionName() {
        return "ActionSubmit";
    }

    protected String getWFUIFuctionName() {
        return "com.kingdee.eas.hr.time.LeaveRptSelfBillBizFunction";
    }

    protected void setTableCellEditor() throws Exception {
    }

    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        AttachmentUIContextInfo info;
        AttachmentClientManager acm = AttachmentManagerFactory.getClientManager();
        boolean isEdit = false;
        if (OprtState.EDIT.equals(this.getOprtState()) || OprtState.ADDNEW.equals(this.getOprtState())) {
            isEdit = true;
        }
        if ((info = this.getAttacheInfo()) == null) {
            info = new AttachmentUIContextInfo();
        }
        if (info.getBoID() == null || info.getBoID().trim().equals("")) {
            String boID = this.getID();
            if (boID == null) {
                return;
            }
            info.setBoID(boID);
        }
        info.setEdit(isEdit);
        String multi = (String)this.getUIContext().get("MultiapproveAttachment");
        if (multi != null && multi.equals("true")) {
            acm.showAttachmentListUIByBoIDNoAlready((Object)this, info);
        } else {
            acm.showAttachmentListUIByBoID((Object)this, info);
        }
    }

    protected final String getID() {
        if (this.editData == null) {
            return null;
        }
        String boID = this.editData.getLeaveBill().getId() != null ? this.editData.getLeaveBill().getId().toString() : null;
        return boID;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.editData.setApproveState((ApproveStateEnum)((Object)this.comboSubmitType.getSelectedItem()));
        super.actionSubmit_actionPerformed(e);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        int b;
        int a;
        super.verifyInput(e);
        BigDecimal LeaveLength = new BigDecimal("0.00");
        if (this.txtLeaveLength2.getBigDecimalValue() != null) {
            LeaveLength = this.txtLeaveLength2.getBigDecimalValue();
        }
        if (LeaveLength.floatValue() > 0.0f && this.lastUnit != null && this.lastUnit.floatValue() > 0.0f && (a = (int)(LeaveLength.floatValue() * 100.0f)) % (b = (int)(this.lastUnit.floatValue() * 100.0f)) != 0) {
            MsgBox.showInfo((String)(EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"72_LeaveBillSelfEditUI") + this.lastUnit.floatValue() + EASResource.getString((String)"com.kingdee.eas.hr.time.TIMEAutoGenerateResource", (String)"65_HRTimeClientUtils")));
            SysUtil.abort();
        }
    }

    protected void doBeforeSubmitForWF(CoreBaseInfo editData) throws Exception {
        super.doBeforeSubmitForWF(editData);
    }
}

