/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.time.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.time.ILeaveAndAttendanceReport;
import com.kingdee.eas.hr.time.LeaveAndAttendanceReportFactory;
import com.kingdee.eas.hr.time.UnitTypeEnum;
import com.kingdee.eas.hr.time.client.AbstractMyAttendanceForRptUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.Date;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class MyAttendanceForRptUI
extends AbstractMyAttendanceForRptUI {
    private static final Logger logger = CoreUIObject.getLogger(MyAttendanceForRptUI.class);
    private static final String strResource = "com.kingdee.eas.hr.time.TimeAttendanceReportResource.";

    public void onLoad() throws Exception {
        super.onLoad();
        this.mergeTable();
        this.loadDataTable();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnQuery.setVisible(false);
        this.initStatDateTime();
    }

    private void initStatDateTime() {
        Date startDate = this.kDDateStart.getSqlDate();
        Date endDate = this.kDDateEnd.getSqlDate();
        startDate.setDate(1);
        endDate.setDate(DateTimeUtils.daysOfMonth((int)startDate.getYear(), (int)(endDate.getMonth() + 1)));
        this.kDDateStart.setValue((Object)startDate);
        this.kDDateEnd.setValue((Object)endDate);
    }

    private void loadDataTable() throws EASBizException, BOSException, SQLException {
        ILeaveAndAttendanceReport iLar = LeaveAndAttendanceReportFactory.getRemoteInstance();
        IRowSet rowSet = iLar.getMyLeaveAndAttendanceRpt(null, this.kDDateStart.getSqlDate(), this.kDDateEnd.getSqlDate());
        IRow iRow = null;
        ICell cell = null;
        while (rowSet.next()) {
            iRow = this.tblMain.addRow();
            cell = iRow.getCell("attendCatalog.name");
            cell.setValue((Object)rowSet.getString("attendCatalog.name"));
            cell = iRow.getCell("attendance.name");
            cell.setValue((Object)rowSet.getString("attendance.name"));
            cell = iRow.getCell("attendance.unitType");
            cell.setValue((Object)UnitTypeEnum.getEnum(Integer.parseInt(rowSet.getString("attendance.unitType"))));
            cell = iRow.getCell("totalValue");
            cell.setValue((Object)rowSet.getString("totalValue"));
        }
        this.tblMain.setRowCount(rowSet.size());
        this.tblMain.gerGroupManager().group();
    }

    protected void mergeTable() {
        this.tblMain.checkParsed();
        this.tblMain.setEditable(false);
        this.tblMain.removeRows();
        this.tblMain.gerGroupManager().setGroup(true);
        this.tblMain.getColumn("attendCatalog.name").setGroup(true);
        this.tblMain.getColumn("attendCatalog.name").setMergeable(true);
        this.tblMain.getColumn("attendCatalog.name").setWidth(240);
        this.tblMain.getColumn("attendance.name").setGroup(true);
        this.tblMain.getColumn("attendance.name").setMergeable(true);
        this.tblMain.getColumn("attendance.name").setWidth(200);
        this.tblMain.getColumn("attendance.unitType").setGroup(true);
        this.tblMain.getColumn("attendance.unitType").setMergeable(true);
        this.tblMain.getColumn("attendance.unitType").setWidth(200);
        this.tblMain.getColumn("totalValue").setWidth(200);
    }

    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        if (DateTimeUtils.dayAfter((java.util.Date)this.kDDateStart.getSqlDate(), (java.util.Date)this.kDDateEnd.getSqlDate())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.time.TimeAttendanceReportResource.DATESCOPEERROR"));
            SysUtil.abort();
        } else {
            this.mergeTable();
            this.loadDataTable();
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        int colIndex;
        if (e.getClickCount() == 2) {
            return;
        }
        if (e.getType() == 0 && ((colIndex = e.getColIndex()) == this.tblMain.getColumnIndex("attendanceManager.totalValue") || colIndex == this.tblMain.getColumnIndex("name") || colIndex == this.tblMain.getColumnIndex("unitType"))) {
            return;
        }
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"attendCatalog.name", "attendance.name"};
        return locateNames;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected String getEditUIName() {
        return null;
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.mergeTable();
        this.loadDataTable();
    }

    protected String getKeyFieldName() {
        return "attendance.name";
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return this.getDefaultCUFilter(true);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }
}

