/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.time.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.time.AttendanceManagerFacadeFactory;
import com.kingdee.eas.hr.time.AttendanceManagerFactory;
import com.kingdee.eas.hr.time.IAttendanceManagerFacade;
import com.kingdee.eas.hr.time.ITimeAttendance;
import com.kingdee.eas.hr.time.LeaveDetailException;
import com.kingdee.eas.hr.time.TimeAttendanceCollection;
import com.kingdee.eas.hr.time.TimeAttendanceFactory;
import com.kingdee.eas.hr.time.TimeAttendanceInfo;
import com.kingdee.eas.hr.time.client.AbstractMyAttendanceListUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class MyAttendanceListUI
extends AbstractMyAttendanceListUI {
    private static final Logger logger = CoreUIObject.getLogger(MyAttendanceListUI.class);
    private static String ID = "id";
    private static String ATT = "timeAttendance";
    private static String UNIT = "unitType";
    private static String TOTAL = "totalValue";
    private String personId = null;
    private String strSQL = "";
    private ArrayList arrList = null;

    public void loadFields() {
        super.loadFields();
    }

    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        this.initTableProperty();
        this.initStaticCell();
        this.setTheDate();
        this.personId = this.getCurrPerson();
        this.loadDataTable();
    }

    public String getCurrPerson() {
        String person = null;
        person = SysContext.getSysContext().getCurrentUserInfo() != null ? SysContext.getSysContext().getCurrentUserInfo().getPerson().getId().toString() : null;
        return person;
    }

    private void initTableProperty() {
        this.tblMain.checkParsed();
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        this.tblMain.getSelectManager().setSelectMode(2);
    }

    public void initStaticCell() throws BOSException {
        this.addDisplayRow();
        KDTMergeManager mm = this.tblMain.getMergeManager();
        int counts = this.tblMain.getRowCount();
        for (int i = 0; i < counts; ++i) {
            if (i % 2 != 0) continue;
            mm.mergeBlock(i, 1, i + 1, 1, 4);
        }
    }

    public void addDisplayRow() throws BOSException {
        KDTMergeManager mm = this.tblMain.getHeadMergeManager();
        String strTimesKey = null;
        String strTypeKey = null;
        if (this.arrList == null || this.arrList.size() == 0) {
            ITimeAttendance iTime = TimeAttendanceFactory.getRemoteInstance();
            TimeAttendanceCollection timeInfos = iTime.getTimeAttendanceCollection("Select * Where (attendCatalog.id='00000000-0000-0000-0000-000000000001BE0D0183' or attendCatalog.id='00000000-0000-0000-0000-000000000003BE0D0183') and enable = 1 and (hrOrgUnit.id = '" + SysContext.getSysContext().getCurrentHRUnit().getId().toString() + "'" + " or cu.id ='" + "11111111-1111-1111-1111-111111111111CCE7AED4".toString() + "')");
            this.tblMain.removeRows();
            for (int j = 0; j < timeInfos.size(); ++j) {
                this.addRow(mm, timeInfos.get(j), strTimesKey, strTypeKey, j);
                this.strSQL = j == timeInfos.size() - 1 ? this.strSQL + "'" + timeInfos.get(j).getId().toString() + "'" : this.strSQL + "'" + timeInfos.get(j).getId().toString() + "'" + ",";
            }
        } else {
            int arrSize = this.arrList.size();
            this.tblMain.removeRows();
            for (int i = 0; i < arrSize; ++i) {
                this.addRow(mm, (TimeAttendanceInfo)this.arrList.get(i), strTimesKey, strTypeKey, i);
                this.strSQL = i == arrSize - 1 ? this.strSQL + "'" + ((TimeAttendanceInfo)this.arrList.get(i)).getId().toString() + "'" : this.strSQL + "'" + ((TimeAttendanceInfo)this.arrList.get(i)).getId().toString() + "'" + ",";
            }
        }
    }

    void addRow(KDTMergeManager mm, TimeAttendanceInfo info, String strTimesKey, String strTypeKey, int i) {
        strTimesKey = "Times@" + info.getId().toString();
        strTypeKey = "Type@" + info.getId().toString();
        IRow iRowTimes = this.tblMain.addRow();
        IRow iRowType = this.tblMain.addRow();
        iRowTimes.getStyleAttributes().setLocked(true);
        iRowType.getStyleAttributes().setLocked(true);
        iRowTimes.getCell(ID).setValue((Object)strTimesKey);
        iRowType.getCell(ID).setValue((Object)strTypeKey);
        iRowTimes.getCell(ATT).setValue((Object)info.getName());
        iRowType.getCell(ATT).setValue((Object)info.getName());
        iRowTimes.getCell(UNIT).setValue((Object)EASResource.getString((String)"com.kingdee.eas.hr.time.TimeResource.TIMES"));
        iRowType.getCell(UNIT).setValue((Object)info.getUnitType());
        iRowType.getCell(TOTAL).getStyleAttributes().setNumberFormat("0.00");
    }

    public void loadDataTable() throws EASBizException, BOSException {
        if (!StringUtils.isEmpty((String)this.strSQL)) {
            String strSQLWhere = " Where fattendanceid in( " + this.strSQL + " ) and " + this.getFiletInfo();
            IAttendanceManagerFacade iFacade = AttendanceManagerFacadeFactory.getRemoteInstance();
            HashMap map = iFacade.getAttendanceManagerRowSet(strSQLWhere);
            int rowCounts = this.tblMain.getRowCount();
            for (int i = 0; i < rowCounts; ++i) {
                String strMap = this.personId + "@" + this.tblMain.getRow(i).getCell(ID).getValue().toString();
                this.tblMain.getRow(i).getCell(TOTAL).setValue(map.get(strMap));
            }
        }
    }

    public String getFiletInfo() {
        StringBuffer filterInfo = new StringBuffer();
        Date beginDate = null;
        Date endDate = null;
        beginDate = this.pkBeginDate.getValue() == null ? this.getSqlDate(new java.util.Date()) : this.pkBeginDate.getSqlDate();
        endDate = this.pkEndDate.getValue() == null ? this.getSqlDate(new java.util.Date()) : this.pkEndDate.getSqlDate();
        filterInfo.append("FStartDate >= {ts '");
        filterInfo.append(beginDate);
        filterInfo.append("'} and ");
        filterInfo.append("FEndDate <= {ts '");
        filterInfo.append(endDate);
        filterInfo.append("'} and FCheckState=1 ");
        if (this.personId != null) {
            filterInfo.append(" and ");
            filterInfo.append(" FPersonID = '");
            filterInfo.append(this.personId);
            filterInfo.append("'");
        }
        return filterInfo.toString();
    }

    public void setTheDate() {
        java.util.Date date = new java.util.Date();
        java.util.Date theDate = null;
        Object beginDate = null;
        Object endDate = null;
        int dayOfMonth = DateTimeUtils.daysOfMonth((int)DateTimeUtils.getYear((java.util.Date)date), (int)DateTimeUtils.getMonth((java.util.Date)date));
        theDate = new java.util.Date(date.getYear(), date.getMonth(), 1);
        this.pkBeginDate.setValue((Object)theDate);
        theDate = new java.util.Date(date.getYear(), date.getMonth(), dayOfMonth);
        this.pkEndDate.setValue((Object)theDate);
    }

    private void verifyDate() throws Exception {
        java.util.Date startDate = this.pkBeginDate.getSqlDate();
        java.util.Date endDate = this.pkEndDate.getSqlDate();
        if (startDate == null) {
            startDate = new java.util.Date();
        }
        if (endDate == null) {
            endDate = new java.util.Date();
        }
        if (DateTimeUtils.dayBefore((java.util.Date)endDate, (java.util.Date)startDate)) {
            this.setTheDate();
            throw new LeaveDetailException(LeaveDetailException.DATEERROR);
        }
    }

    public Date getSqlDate(java.util.Date date) {
        Date sqlDate = null;
        if (date != null) {
            sqlDate = new Date(date.getTime());
        }
        return sqlDate;
    }

    protected void pkBeginDate_dataChanged(DataChangeEvent e) throws Exception {
        this.verifyDate();
        this.loadDataTable();
        super.pkBeginDate_dataChanged(e);
    }

    protected void pkEndDate_dataChanged(DataChangeEvent e) throws Exception {
        this.verifyDate();
        this.loadDataTable();
        super.pkEndDate_dataChanged(e);
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    protected void menuItemImportData_actionPerformed(ActionEvent e) throws Exception {
        super.menuItemImportData_actionPerformed(e);
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
    }

    public void actionLocate_actionPerformed(ActionEvent e) throws Exception {
        super.actionLocate_actionPerformed(e);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        super.actionImportData_actionPerformed(e);
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return AttendanceManagerFactory.getRemoteInstance();
    }
}

