/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.time.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.TextRender;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.compensation.util.HRUtils;
import com.kingdee.eas.hr.time.ILeaveAndAttendanceReport;
import com.kingdee.eas.hr.time.ILeaveDetail;
import com.kingdee.eas.hr.time.LeaveAndAttendanceReportFactory;
import com.kingdee.eas.hr.time.LeaveDetailException;
import com.kingdee.eas.hr.time.LeaveDetailFactory;
import com.kingdee.eas.hr.time.LeaveDetailInfo;
import com.kingdee.eas.hr.time.UnitTypeEnum;
import com.kingdee.eas.hr.time.client.AbstractMyLeaveListUI;
import com.kingdee.eas.hr.time.util.TimeServerUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.LocaleUtils;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class MyLeaveListUI
extends AbstractMyLeaveListUI {
    private static final Logger logger = CoreUIObject.getLogger(MyLeaveListUI.class);
    protected static final TextRender render = new TextRender();
    public String localString;
    private static String ID = "id";
    private static String TOTALREG = "totalReg";
    private static String TOTALREGREAL = "totalRegReal";
    private static String NAME = "timeAttendance.name";
    private static String UNIT = "timeAttendance.unitType";
    private static String SD = "startDateReg";
    private static String ED = "endDateReg";
    private static String SDR = "startDateReal";
    private static String EDR = "endDateReal";
    private static int S_LONG = 50;
    private static int M_LONG = 70;
    private static int L_LONG = 110;
    private String personId = null;
    private String formatStrDate = "yyyy/MM/dd HH:mm";
    private String leaveDetailResourceBasicURL = "com.kingdee.eas.hr.time.LeaveDetailResource";

    public void loadFields() {
        super.loadFields();
    }

    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        this.personId = this.getCurrPerson();
        this.initTableProperty();
        this.initEditorForKDTable();
        this.setTheDate();
        this.tblMain.removeRows();
        this.getLeaveColl();
        this.initText();
        this.loadDataFromWorkFlow(this.pkBeginDate.getSqlDate(), this.pkEndDate.getSqlDate(), this.personId);
    }

    private void loadDataFromWorkFlow(Date bd, Date ed, String personID) throws Exception {
        IRow iRow = null;
        IRowSet iRowSet = null;
        ILeaveAndAttendanceReport iLeaveAndAttendanceReport = LeaveAndAttendanceReportFactory.getRemoteInstance();
        iRowSet = iLeaveAndAttendanceReport.getDataRows(personID, bd, ed);
        if (iRowSet != null) {
            while (iRowSet.next()) {
                iRow = this.tblMain.addRow();
                iRow.getCell(NAME).setValue((Object)iRowSet.getString("hrtype.name"));
                iRow.getCell(UNIT).setValue((Object)iRowSet.getInt("hrtype.unittype"));
                iRow.getCell(SD).setValue((Object)iRowSet.getString("begintime"));
                iRow.getCell(ED).setValue((Object)iRowSet.getString("endtime"));
                if (iRowSet.getString("leavelength") != null) {
                    iRow.getCell(TOTALREG).setValue((Object)iRowSet.getString("leavelength"));
                }
                if (iRowSet.getString("lpbillentry.begintime") != null) {
                    iRow.getCell(SDR).setValue((Object)iRowSet.getString("lpbillentry.begintime"));
                }
                if (iRowSet.getString("lpbillentry.endtime") != null) {
                    iRow.getCell(EDR).setValue((Object)iRowSet.getString("lpbillentry.endtime"));
                }
                if (iRowSet.getString("lpbillentry.leavelength") != null) {
                    iRow.getCell(TOTALREGREAL).setValue((Object)iRowSet.getString("lpbillentry.leavelength"));
                }
                this.setRenderForPayState();
            }
        }
    }

    public String getCurrPerson() {
        String person = null;
        person = SysContext.getSysContext().getCurrentUserInfo() != null ? SysContext.getSysContext().getCurrentUserInfo().getPerson().getId().toString() : null;
        return person;
    }

    private void initTableProperty() {
        this.tblMain.checkParsed();
    }

    public void setTheDate() {
        Date date = new Date();
        Date theDate = null;
        int dayOfMonth = DateTimeUtils.daysOfMonth((int)DateTimeUtils.getYear((Date)date), (int)DateTimeUtils.getMonth((Date)date));
        theDate = new Date(date.getYear(), date.getMonth(), 1);
        this.pkBeginDate.setValue((Object)theDate);
        theDate = new Date(date.getYear(), date.getMonth(), dayOfMonth);
        this.pkEndDate.setValue((Object)theDate);
    }

    public EntityViewInfo getTheFilteInfo() {
        Date beginDate = null;
        Date endDate = null;
        Timestamp bDate = null;
        Timestamp eDate = null;
        FilterInfo filterInfo = new FilterInfo();
        beginDate = this.pkBeginDate.getValue() == null ? new Date() : this.pkBeginDate.getSqlDate();
        endDate = this.pkEndDate.getValue() == null ? new Date() : this.pkEndDate.getSqlDate();
        bDate = new Timestamp(DateTimeUtils.truncateDate((Date)DateTimeUtils.addSecond((Date)DateTimeUtils.addDay((Date)DateTimeUtils.truncateDate((Date)beginDate), (long)0L), (long)1L)).getTime());
        eDate = new Timestamp(DateTimeUtils.addSecond((Date)DateTimeUtils.addDay((Date)DateTimeUtils.truncateDate((Date)endDate), (long)1L), (long)-1L).getTime());
        this.mainQuery = new EntityViewInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("startDateReal", (Object)bDate, CompareType.GREATER_EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("endDateReal", (Object)eDate, CompareType.LESS_EQUALS));
        if (this.personId != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)this.personId, CompareType.EQUALS));
        }
        SelectorItemCollection sic = this.mainQuery.getSelector();
        sic.add(new SelectorItemInfo(ID));
        sic.add(new SelectorItemInfo(TOTALREG));
        sic.add(new SelectorItemInfo(TOTALREGREAL));
        sic.add(new SelectorItemInfo(SD));
        sic.add(new SelectorItemInfo(ED));
        sic.add(new SelectorItemInfo(SDR));
        sic.add(new SelectorItemInfo(EDR));
        sic.add(new SelectorItemInfo("timeAttendance.name"));
        sic.add(new SelectorItemInfo("timeAttendance.unitType"));
        this.mainQuery.setFilter(filterInfo);
        return this.mainQuery;
    }

    private void initEditorForKDTable() throws BOSException {
        this.tblMain.checkParsed();
        this.tblMain.getColumn(TOTALREGREAL).getStyleAttributes().setHided(false);
        KDFormattedTextField txtFormat = new KDFormattedTextField(1);
        txtFormat.setHorizontalAlignment(4);
        this.tblMain.getColumn(TOTALREG).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtFormat));
        this.tblMain.getColumn(TOTALREG).getStyleAttributes().setNumberFormat("%r{0.00}f");
        this.tblMain.getColumn(TOTALREGREAL).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtFormat));
        this.tblMain.getColumn(TOTALREGREAL).getStyleAttributes().setNumberFormat("%r{0.00}f");
        this.tblMain.getColumn(NAME).setWidth(M_LONG);
        this.tblMain.getColumn(UNIT).setWidth(S_LONG);
        this.tblMain.getColumn(SD).setWidth(L_LONG);
        this.tblMain.getColumn(ED).setWidth(L_LONG);
        this.tblMain.getColumn(TOTALREG).setWidth(M_LONG);
        this.tblMain.getColumn(SDR).setWidth(L_LONG);
        this.tblMain.getColumn(EDR).setWidth(L_LONG);
        this.tblMain.getColumn(TOTALREGREAL).setWidth(M_LONG);
        this.tblMain.getColumn(SD).getStyleAttributes().setNumberFormat(this.formatStrDate);
        this.tblMain.getColumn(ED).getStyleAttributes().setNumberFormat(this.formatStrDate);
        this.tblMain.getColumn(SDR).getStyleAttributes().setNumberFormat(this.formatStrDate);
        this.tblMain.getColumn(EDR).getStyleAttributes().setNumberFormat(this.formatStrDate);
    }

    public void initText() throws Exception {
        String used = null;
        String total = "";
        String rest = "";
        Date date = new Date();
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.personId);
        int year = DateTimeUtils.getYear((Date)date);
        ILeaveDetail leave = (ILeaveDetail)this.getBizInterface();
        Map map = leave.getUsedVacation(list, null, year, 1, date);
        DecimalFormat nf = (DecimalFormat)DecimalFormat.getInstance();
        nf.applyPattern("##.##");
        used = map.get(this.personId) == null ? String.valueOf(0) : nf.format(Double.parseDouble((String)map.get(this.personId)));
        Map mapValue = HRUtils.getYearVacation((int)year, (String)this.personId);
        total = mapValue.get("FCurrQuantity") != null ? nf.format(Double.parseDouble(mapValue.get("FCurrQuantity").toString())) : "0";
        rest = mapValue.get("FCurrAvailable") != null ? nf.format(Double.parseDouble(mapValue.get("FCurrAvailable").toString())) : "0";
        StringBuffer yearBalance = new StringBuffer();
        yearBalance.append(EASResource.getString((String)this.leaveDetailResourceBasicURL, (String)"YEAR"));
        yearBalance.append(total);
        yearBalance.append(EASResource.getString((String)this.leaveDetailResourceBasicURL, (String)"UNIT"));
        yearBalance.append("            ");
        yearBalance.append(EASResource.getString((String)this.leaveDetailResourceBasicURL, (String)"USEDYEAR"));
        yearBalance.append(used);
        yearBalance.append(EASResource.getString((String)this.leaveDetailResourceBasicURL, (String)"UNIT"));
        yearBalance.append("            ");
        yearBalance.append(EASResource.getString((String)this.leaveDetailResourceBasicURL, (String)"RESTYEAR"));
        yearBalance.append(rest);
        yearBalance.append(EASResource.getString((String)this.leaveDetailResourceBasicURL, (String)"UNIT"));
        this.txtBalance.setText(yearBalance.toString());
        String unitTypeString = TimeServerUtils.getTimeAttendanceType(null);
        String msg = yearBalance.toString().replaceAll("\u5929", unitTypeString);
        this.txtBalance.setText(msg);
    }

    public void loadTableRow(LeaveDetailInfo leaveDetailInfo, IRow detailRow) {
        detailRow.getCell("id").setValue((Object)leaveDetailInfo.getId());
        if (leaveDetailInfo.getTimeAttendance() != null) {
            detailRow.getCell(NAME).setValue((Object)leaveDetailInfo.getTimeAttendance().getName());
        }
        if (leaveDetailInfo.getTimeAttendance() == null) {
            detailRow.getCell(UNIT).setValue(null);
        } else {
            detailRow.getCell(UNIT).setValue((Object)leaveDetailInfo.getTimeAttendance().getUnitType().getValue());
        }
        if (leaveDetailInfo.getTotalRegReal() != null) {
            detailRow.getCell(TOTALREGREAL).setValue((Object)leaveDetailInfo.getTotalRegReal());
        }
        if (leaveDetailInfo.getStartDateReal() != null) {
            detailRow.getCell(SDR).setValue((Object)leaveDetailInfo.getStartDateReal());
        }
        if (leaveDetailInfo.getEndDateReal() != null) {
            detailRow.getCell(EDR).setValue((Object)leaveDetailInfo.getEndDateReal());
        }
        if (leaveDetailInfo.getStartDateReg() != null) {
            detailRow.getCell(SD).setValue((Object)leaveDetailInfo.getStartDateReg());
        }
        if (leaveDetailInfo.getEndDateReg() != null) {
            detailRow.getCell(ED).setValue((Object)leaveDetailInfo.getEndDateReg());
        }
        if (leaveDetailInfo.getTotalReg() != null) {
            detailRow.getCell(TOTALREG).setValue((Object)leaveDetailInfo.getTotalReg());
        }
    }

    public void getLeaveColl() {
        this.getTheFilteInfo();
        this.tblMain.removeRows();
    }

    private void verifyDate() throws Exception {
        Date startDate = this.pkBeginDate.getSqlDate();
        Date endDate = this.pkEndDate.getSqlDate();
        if (startDate == null) {
            startDate = new Date();
        }
        if (endDate == null) {
            endDate = new Date();
        }
        if (DateTimeUtils.dayBefore((Date)endDate, (Date)startDate)) {
            this.setTheDate();
            throw new LeaveDetailException(LeaveDetailException.DATEERROR);
        }
    }

    protected void pkBeginDate_dataChanged(DataChangeEvent e) throws Exception {
        this.verifyDate();
        this.initEditorForKDTable();
        this.tblMain.removeRows();
        this.getLeaveColl();
        this.loadDataFromWorkFlow(this.pkBeginDate.getSqlDate(), this.pkEndDate.getSqlDate(), this.personId);
    }

    protected void pkEndDate_dataChanged(DataChangeEvent e) throws Exception {
        this.verifyDate();
        this.initEditorForKDTable();
        this.tblMain.removeRows();
        this.getLeaveColl();
        this.loadDataFromWorkFlow(this.pkBeginDate.getSqlDate(), this.pkEndDate.getSqlDate(), this.personId);
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    protected void menuItemImportData_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionLocate_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return LeaveDetailFactory.getRemoteInstance();
    }

    public String getLocal(Context ctx) {
        this.localString = "_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        return this.localString;
    }

    private void setRenderForPayState() throws Exception {
        this.tblMain.getColumn(UNIT).setRenderer(new IBasicRender(){

            public void draw(Graphics graphics, Shape clip, Object object, Style cellStyle) {
                if (object == null) {
                    return;
                }
                if (object instanceof Integer) {
                    int enumValue = Integer.parseInt(object.toString());
                    UnitTypeEnum uEnum = UnitTypeEnum.getEnum(enumValue);
                    render.draw(graphics, clip, uEnum.toString(), cellStyle);
                } else {
                    render.draw(graphics, clip, object.toString(), cellStyle);
                }
            }
        });
    }
}

