/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.time.client;

import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.hr.time.client.AbstractPerfViewAttendDataFilterUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.log4j.Logger;

public class PerfViewAttendDataFilterUI
extends AbstractPerfViewAttendDataFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(PerfViewAttendDataFilterUI.class);

    public void storeFields() {
        super.storeFields();
    }

    public FilterInfo getFilterInfo() {
        FilterInfo fi = new FilterInfo();
        return fi;
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        cp.putDate("start", (Date)this.datePickerFrom.getValue());
        cp.putDate("end", (Date)this.datePickerTo.getValue());
        cp.addCustomerParam("SQLFilter", this.getFilterSQL());
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        this.datePickerFrom.setValue((Object)cp.getDate("start"));
        this.datePickerTo.setValue((Object)cp.getDate("end"));
    }

    public boolean verify() {
        if (this.datePickerFrom.getValue() != null && this.datePickerTo.getValue() != null && DateTimeUtils.dayBefore((Date)((Date)this.datePickerTo.getValue()), (Date)((Date)this.datePickerFrom.getValue()))) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.time.TimeResource.STARTDATE_MUST_ENDDATE"));
            return false;
        }
        return true;
    }

    public void clear() {
        Date date = new Date();
        GregorianCalendar cal = new GregorianCalendar(DateTimeUtils.getYear((Date)date), DateTimeUtils.getMonth((Date)date) - 2, 1);
        this.datePickerFrom.setValue((Object)cal.getTime());
        this.datePickerTo.setValue((Object)this.getMonthEndDate());
    }

    public void initLayout() {
        super.initLayout();
        Date date = new Date();
        GregorianCalendar cal = new GregorianCalendar(DateTimeUtils.getYear((Date)date), DateTimeUtils.getMonth((Date)date) - 2, 1);
        this.datePickerFrom.setValue((Object)cal.getTime());
        this.datePickerTo.setValue((Object)this.getMonthEndDate());
    }

    private Date getMonthEndDate() {
        Date date = new Date();
        int day = DateTimeUtils.getDay((Date)date);
        Date beginDate = DateTimeUtils.addDay((Date)date, (long)(1 - day));
        date = DateTimeUtils.addMonth((Date)beginDate, (int)0);
        return DateTimeUtils.addDay((Date)date, (long)-1L);
    }

    public String getFilterSQL() {
        String strSql = "";
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        if (this.datePickerFrom.getValue() != null && this.datePickerTo.getValue() != null) {
            Date toDate = (Date)this.datePickerTo.getValue();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(toDate);
            calendar.add(5, 1);
            strSql = "FStartDate>={ts '" + format.format((Date)this.datePickerFrom.getValue()) + "'}  and  FEndDate<{ts '" + format.format(calendar.getTime()) + "'}";
        } else if (this.datePickerFrom.getValue() != null && this.datePickerTo.getValue() == null) {
            strSql = "FStartDate>={ts '" + format.format((Date)this.datePickerFrom.getValue()) + "'} ";
        } else if (this.datePickerFrom.getValue() == null && this.datePickerTo.getValue() != null) {
            Date toDate = (Date)this.datePickerTo.getValue();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(toDate);
            calendar.add(5, 1);
            strSql = "  FEndDate<{ts '" + format.format(calendar.getTime()) + "'}";
        }
        return strSql;
    }

    public Date getStartDate() {
        return (Date)this.datePickerFrom.getValue();
    }

    public Date getEndDate() {
        return (Date)this.datePickerTo.getValue();
    }
}

