/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.time.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.hr.emp.client.EmployeeClientUtils;
import com.kingdee.eas.hr.time.client.AbstractSelfLeaveQueryUI;
import com.kingdee.eas.hr.time.client.HRTimeClientUtils;
import com.kingdee.eas.hr.time.client.SelfLeaveQueryFilterUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.Map;

public class SelfLeaveQueryUI
extends AbstractSelfLeaveQueryUI {
    private static final long serialVersionUID = -61166L;
    private String personId = null;
    private Date beginDate = HRTimeClientUtils.getThisYearBeginDate();
    private Date endDate = HRTimeClientUtils.getThisYearEndDate();

    public IRowSet getLeaveSumupRows() throws Exception {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("checkState", (Object)1));
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)this.personId));
        filter.getFilterItems().add(new FilterItemInfo("startDateReal", (Object)HRTimeClientUtils.getBeginTime(this.beginDate), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("endDateReal", (Object)HRTimeClientUtils.getEndTime(this.endDate), CompareType.LESS_EQUALS));
        filter.setMaskString("#0 and #1 and #2 and #3");
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        MetaDataPK pk = new MetaDataPK("com.kingdee.eas.hr.time.app.SelfLeaveQuery");
        IQueryExecutor iqry = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)pk);
        iqry.option().isAutoTranslateEnum = true;
        iqry.setObjectView(evi);
        return iqry.executeQuery();
    }

    private void setTableColumnStyle() {
        this.tblMain.getColumn("beginDate").getStyleAttributes().setNumberFormat(EmployeeClientUtils.getDateFormatStr());
        this.tblMain.getColumn("endDate").getStyleAttributes().setNumberFormat(EmployeeClientUtils.getDateFormatStr());
        this.tblMain.getColumn("totalRegReal").getStyleAttributes().setNumberFormat("0.00");
    }

    public void loadTableRows() throws Exception {
        this.tblMain.removeRows();
        IRowSet datas = this.getLeaveSumupRows();
        IRow row = null;
        while (datas.next()) {
            row = this.tblMain.addRow();
            row.getCell("beginDate").setValue((Object)this.beginDate);
            row.getCell("endDate").setValue((Object)this.endDate);
            row.getCell("person.name").setValue((Object)datas.getString("person.name"));
            row.getCell("timeAttendance.name").setValue((Object)datas.getString("timeAttendance.name"));
            row.getCell("timeAttendance.unitType").setValue((Object)datas.getString("timeAttendance.unitType"));
            row.getCell("totalRegReal").setValue((Object)datas.getBigDecimal("totalRegReal"));
        }
        datas.close();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.getUIContext().get("personId") == null) {
            // empty if block
        }
        this.personId = this.getUIContext().get("personId").toString();
        this.tblMain.checkParsed();
        this.setTableColumnStyle();
        this.loadTableRows();
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"beginDate", (Object)this.beginDate);
        uiContext.put((Object)"endDate", (Object)this.endDate);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(SelfLeaveQueryFilterUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        SelfLeaveQueryFilterUI ui = (SelfLeaveQueryFilterUI)uiWindow.getUIObject();
        if (!ui.isCancel) {
            this.beginDate = DateTimeUtils.truncateDate((Date)((Date)ui.pkBeginDate.getValue()));
            this.endDate = DateTimeUtils.truncateDate((Date)((Date)ui.pkEndDate.getValue()));
            this.loadTableRows();
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.setButtonDefaultStyl(this.btnQuery);
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
    }
}

